/*
 * Decompiled with CFR 0.152.
 */
package org.HdrHistogram;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.util.zip.DataFormatException;
import org.HdrHistogram.AbstractHistogram;
import org.HdrHistogram.EncodableHistogram;
import org.HdrHistogram.Histogram;
import org.HdrHistogram.HistogramIterationValue;

public class DoubleHistogram
extends EncodableHistogram
implements Serializable {
    static final double highestAllowedValueEver;
    long configuredHighestToLowestValueRatio;
    double currentLowestValueInAutoRange;
    double currentHighestValueLimitInAutoRange;
    AbstractHistogram integerValuesHistogram;
    double doubleToIntegerValueConversionRatio;
    double integerToDoubleValueConversionRatio;
    private static final long serialVersionUID = 42L;
    private static final int DHIST_encodingCookie = 208802892;
    private static final int DHIST_compressedEncodingCookie = 208802893;

    public DoubleHistogram(long highestToLowestValueRatio, int numberOfSignificantValueDigits) {
        this(highestToLowestValueRatio, numberOfSignificantValueDigits, Histogram.class);
    }

    public DoubleHistogram(long highestToLowestValueRatio, int numberOfSignificantValueDigits, Class<? extends AbstractHistogram> internalCountsHistogramClass) {
        this(highestToLowestValueRatio, numberOfSignificantValueDigits, internalCountsHistogramClass, null);
    }

    private DoubleHistogram(long highestToLowestValueRatio, int numberOfSignificantValueDigits, Class<? extends AbstractHistogram> internalCountsHistogramClass, AbstractHistogram internalCountsHistogram) {
        this(highestToLowestValueRatio, numberOfSignificantValueDigits, internalCountsHistogramClass, internalCountsHistogram, false);
    }

    private DoubleHistogram(long highestToLowestValueRatio, int numberOfSignificantValueDigits, Class<? extends AbstractHistogram> internalCountsHistogramClass, AbstractHistogram internalCountsHistogram, boolean mimicInternalModel) {
        try {
            double initialLowestValueInAutoRange;
            AbstractHistogram valuesHistogram;
            if (highestToLowestValueRatio < 2L) {
                throw new IllegalArgumentException("highestToLowestValueRatio must be > 2");
            }
            if ((double)highestToLowestValueRatio * Math.pow(10.0, numberOfSignificantValueDigits) > 1.152921504606847E18) {
                throw new IllegalArgumentException("highestToLowestValueRatio * (10^numberOfSignificantValueDigits) must be <= (1L << 60)");
            }
            long integerValueRange = this.deriveIntegerValueRange(highestToLowestValueRatio, numberOfSignificantValueDigits);
            if (internalCountsHistogram == null) {
                Constructor<? extends AbstractHistogram> histogramConstructor = internalCountsHistogramClass.getConstructor(Long.TYPE, Long.TYPE, Integer.TYPE);
                valuesHistogram = histogramConstructor.newInstance(1L, integerValueRange - 1L, numberOfSignificantValueDigits);
                initialLowestValueInAutoRange = Math.pow(2.0, 800.0);
            } else if (mimicInternalModel) {
                Constructor<? extends AbstractHistogram> histogramConstructor = internalCountsHistogramClass.getConstructor(internalCountsHistogramClass);
                valuesHistogram = histogramConstructor.newInstance(internalCountsHistogram);
                initialLowestValueInAutoRange = Math.pow(2.0, 800.0);
            } else {
                if (internalCountsHistogram.getLowestDiscernibleValue() != 1L || internalCountsHistogram.getHighestTrackableValue() != integerValueRange - 1L || internalCountsHistogram.getNumberOfSignificantValueDigits() != numberOfSignificantValueDigits) {
                    throw new IllegalStateException("integer values histogram does not match stated parameters.");
                }
                valuesHistogram = internalCountsHistogram;
                initialLowestValueInAutoRange = internalCountsHistogram.getIntegerToDoubleValueConversionRatio() * (double)internalCountsHistogram.subBucketHalfCount;
            }
            this.init(highestToLowestValueRatio, initialLowestValueInAutoRange, valuesHistogram);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalArgumentException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalArgumentException(ex);
        }
        catch (InstantiationException ex) {
            throw new IllegalArgumentException(ex);
        }
        catch (InvocationTargetException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public DoubleHistogram(DoubleHistogram source) {
        this(source.configuredHighestToLowestValueRatio, source.getNumberOfSignificantValueDigits(), source.integerValuesHistogram.getClass(), source.integerValuesHistogram, true);
    }

    private void init(long configuredHighestToLowestValueRatio, double lowestTrackableUnitValue, AbstractHistogram integerValuesHistogram) {
        this.configuredHighestToLowestValueRatio = configuredHighestToLowestValueRatio;
        this.integerValuesHistogram = integerValuesHistogram;
        long internalHighestToLowestValueRatio = this.deriveInternalHighestToLowestValueRatio(configuredHighestToLowestValueRatio);
        this.setTrackableValueRange(lowestTrackableUnitValue, lowestTrackableUnitValue * (double)internalHighestToLowestValueRatio);
    }

    private void setTrackableValueRange(double lowestValueInAutoRange, double highestValueInAutoRange) {
        this.currentLowestValueInAutoRange = lowestValueInAutoRange;
        this.currentHighestValueLimitInAutoRange = highestValueInAutoRange;
        this.integerToDoubleValueConversionRatio = lowestValueInAutoRange / (double)this.getLowestTackingIntegerValue();
        this.doubleToIntegerValueConversionRatio = 1.0 / this.integerToDoubleValueConversionRatio;
        this.integerValuesHistogram.setIntegerToDoubleValueConversionRatio(this.integerToDoubleValueConversionRatio);
    }

    public void recordValue(double value) throws ArrayIndexOutOfBoundsException {
        this.recordSingleValue(value);
    }

    public void recordValueWithCount(double value, long count) throws ArrayIndexOutOfBoundsException {
        this.recordCountAtValue(count, value);
    }

    public void recordValueWithExpectedInterval(double value, double expectedIntervalBetweenValueSamples) throws ArrayIndexOutOfBoundsException {
        this.recordValueWithCountAndExpectedInterval(value, 1L, expectedIntervalBetweenValueSamples);
    }

    private void recordCountAtValue(long count, double value) throws ArrayIndexOutOfBoundsException {
        if (value < this.currentLowestValueInAutoRange || value > this.currentHighestValueLimitInAutoRange) {
            this.autoAdjustRangeForValue(value);
        }
        long integerValue = (long)(value * this.doubleToIntegerValueConversionRatio);
        this.integerValuesHistogram.recordValueWithCount(integerValue, count);
    }

    private void recordSingleValue(double value) throws ArrayIndexOutOfBoundsException {
        if (value < this.currentLowestValueInAutoRange || value >= this.currentHighestValueLimitInAutoRange) {
            this.autoAdjustRangeForValue(value);
        }
        long integerValue = (long)(value * this.doubleToIntegerValueConversionRatio);
        this.integerValuesHistogram.recordValue(integerValue);
    }

    private void recordValueWithCountAndExpectedInterval(double value, long count, double expectedIntervalBetweenValueSamples) throws ArrayIndexOutOfBoundsException {
        this.recordCountAtValue(count, value);
        if (expectedIntervalBetweenValueSamples <= 0.0) {
            return;
        }
        for (double missingValue = value - expectedIntervalBetweenValueSamples; missingValue >= expectedIntervalBetweenValueSamples; missingValue -= expectedIntervalBetweenValueSamples) {
            this.recordCountAtValue(count, missingValue);
        }
    }

    private void autoAdjustRangeForValue(double value) {
        if (value == 0.0) {
            return;
        }
        if (value < this.currentLowestValueInAutoRange) {
            if (value < 0.0) {
                throw new ArrayIndexOutOfBoundsException("Negative values cannot be recorded");
            }
            do {
                int shiftAmount = this.findCappedContainingBinaryOrderOfMagnitude(Math.ceil(this.currentLowestValueInAutoRange / value) - 1.0);
                this.shiftCoveredRangeToTheRight(shiftAmount);
            } while (value < this.currentLowestValueInAutoRange);
        } else if (value >= this.currentHighestValueLimitInAutoRange) {
            if (value > highestAllowedValueEver) {
                throw new ArrayIndexOutOfBoundsException("Values above " + highestAllowedValueEver + " cannot be recorded");
            }
            do {
                int shiftAmount = this.findCappedContainingBinaryOrderOfMagnitude(Math.ceil((value + Math.ulp(value)) / this.currentHighestValueLimitInAutoRange) - 1.0);
                this.shiftCoveredRangeToTheLeft(shiftAmount);
            } while (value >= this.currentHighestValueLimitInAutoRange);
        }
    }

    private void shiftCoveredRangeToTheRight(int numberOfBinaryOrdersOfMagnitude) {
        if (this.getTotalCount() > this.integerValuesHistogram.getCountAtIndex(0)) {
            this.integerValuesHistogram.shiftValuesLeft(numberOfBinaryOrdersOfMagnitude);
        }
        double shiftMultiplier = 1.0 / (double)(1L << numberOfBinaryOrdersOfMagnitude);
        this.setTrackableValueRange(this.currentLowestValueInAutoRange * shiftMultiplier, this.currentHighestValueLimitInAutoRange * shiftMultiplier);
    }

    private void shiftCoveredRangeToTheLeft(int numberOfBinaryOrdersOfMagnitude) {
        if (this.getTotalCount() > this.integerValuesHistogram.getCountAtIndex(0)) {
            this.integerValuesHistogram.shiftValuesRight(numberOfBinaryOrdersOfMagnitude);
        }
        double shiftMultiplier = 1.0 * (double)(1L << numberOfBinaryOrdersOfMagnitude);
        this.setTrackableValueRange(this.currentLowestValueInAutoRange * shiftMultiplier, this.currentHighestValueLimitInAutoRange * shiftMultiplier);
    }

    public void reset() {
        this.integerValuesHistogram.clearCounts();
    }

    public DoubleHistogram copy() {
        DoubleHistogram targetHistogram = new DoubleHistogram(this.configuredHighestToLowestValueRatio, this.getNumberOfSignificantValueDigits());
        targetHistogram.setTrackableValueRange(this.currentLowestValueInAutoRange, this.currentHighestValueLimitInAutoRange);
        this.integerValuesHistogram.copyInto(targetHistogram.integerValuesHistogram);
        return targetHistogram;
    }

    public DoubleHistogram copyCorrectedForCoordinatedOmission(double expectedIntervalBetweenValueSamples) {
        DoubleHistogram targetHistogram = new DoubleHistogram(this.configuredHighestToLowestValueRatio, this.getNumberOfSignificantValueDigits());
        targetHistogram.setTrackableValueRange(this.currentLowestValueInAutoRange, this.currentHighestValueLimitInAutoRange);
        targetHistogram.addWhileCorrectingForCoordinatedOmission(this, expectedIntervalBetweenValueSamples);
        return targetHistogram;
    }

    public void copyInto(DoubleHistogram targetHistogram) {
        targetHistogram.reset();
        targetHistogram.add(this);
        targetHistogram.setStartTimeStamp(this.integerValuesHistogram.startTimeStampMsec);
        targetHistogram.setEndTimeStamp(this.integerValuesHistogram.endTimeStampMsec);
    }

    public void copyIntoCorrectedForCoordinatedOmission(DoubleHistogram targetHistogram, double expectedIntervalBetweenValueSamples) {
        targetHistogram.reset();
        targetHistogram.addWhileCorrectingForCoordinatedOmission(this, expectedIntervalBetweenValueSamples);
        targetHistogram.setStartTimeStamp(this.integerValuesHistogram.startTimeStampMsec);
        targetHistogram.setEndTimeStamp(this.integerValuesHistogram.endTimeStampMsec);
    }

    public void add(DoubleHistogram fromHistogram) throws ArrayIndexOutOfBoundsException {
        int arrayLength = fromHistogram.integerValuesHistogram.countsArrayLength;
        AbstractHistogram fromIntegerHistogram = fromHistogram.integerValuesHistogram;
        for (int i = 0; i < arrayLength; ++i) {
            long count = fromIntegerHistogram.getCountAtIndex(i);
            if (count <= 0L) continue;
            this.recordValueWithCount((double)fromIntegerHistogram.valueFromIndex(i) * fromHistogram.integerToDoubleValueConversionRatio, count);
        }
    }

    public void addWhileCorrectingForCoordinatedOmission(DoubleHistogram fromHistogram, double expectedIntervalBetweenValueSamples) {
        DoubleHistogram toHistogram = this;
        for (HistogramIterationValue v : fromHistogram.integerValuesHistogram.recordedValues()) {
            toHistogram.recordValueWithCountAndExpectedInterval((double)v.getValueIteratedTo() * this.integerToDoubleValueConversionRatio, v.getCountAtValueIteratedTo(), expectedIntervalBetweenValueSamples);
        }
    }

    public void subtract(DoubleHistogram otherHistogram) {
        int arrayLength = otherHistogram.integerValuesHistogram.countsArrayLength;
        AbstractHistogram otherIntegerHistogram = otherHistogram.integerValuesHistogram;
        for (int i = 0; i < arrayLength; ++i) {
            long otherCount = otherIntegerHistogram.getCountAtIndex(i);
            if (otherCount <= 0L) continue;
            double otherValue = (double)otherIntegerHistogram.valueFromIndex(i) * otherHistogram.integerToDoubleValueConversionRatio;
            if (this.getCountAtValue(otherValue) < otherCount) {
                throw new IllegalArgumentException("otherHistogram count (" + otherCount + ") at value " + otherValue + " is larger than this one's (" + this.getCountAtValue(otherValue) + ")");
            }
            this.recordValueWithCount(otherValue, -otherCount);
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DoubleHistogram)) {
            return false;
        }
        DoubleHistogram that = (DoubleHistogram)other;
        if (this.currentLowestValueInAutoRange != that.currentLowestValueInAutoRange || this.currentHighestValueLimitInAutoRange != that.currentHighestValueLimitInAutoRange || this.getNumberOfSignificantValueDigits() != that.getNumberOfSignificantValueDigits()) {
            return false;
        }
        if (this.integerValuesHistogram.countsArrayLength != that.integerValuesHistogram.countsArrayLength) {
            return false;
        }
        if (this.getTotalCount() != that.getTotalCount()) {
            return false;
        }
        for (int i = 0; i < this.integerValuesHistogram.countsArrayLength; ++i) {
            if (this.integerValuesHistogram.getCountAtIndex(i) == that.integerValuesHistogram.getCountAtIndex(i)) continue;
            return false;
        }
        return true;
    }

    public long getTotalCount() {
        return this.integerValuesHistogram.getTotalCount();
    }

    double getCurrentLowestTrackableNonZeroValue() {
        return this.currentLowestValueInAutoRange;
    }

    double getCurrentHighestTrackableValue() {
        return this.currentHighestValueLimitInAutoRange;
    }

    public double getIntegerToDoubleValueConversionRatio() {
        return this.integerToDoubleValueConversionRatio;
    }

    public int getNumberOfSignificantValueDigits() {
        return this.integerValuesHistogram.numberOfSignificantValueDigits;
    }

    public long getHighestToLowestValueRatio() {
        return this.configuredHighestToLowestValueRatio;
    }

    public double sizeOfEquivalentValueRange(double value) {
        return (double)this.integerValuesHistogram.sizeOfEquivalentValueRange((long)(value * this.doubleToIntegerValueConversionRatio)) * this.integerToDoubleValueConversionRatio;
    }

    public double lowestEquivalentValue(double value) {
        return (double)this.integerValuesHistogram.lowestEquivalentValue((long)(value * this.doubleToIntegerValueConversionRatio)) * this.integerToDoubleValueConversionRatio;
    }

    public double highestEquivalentValue(double value) {
        double nextNonEquivalentValue = this.nextNonEquivalentValue(value);
        double highestEquivalentValue = nextNonEquivalentValue - 2.0 * Math.ulp(nextNonEquivalentValue);
        while (highestEquivalentValue + Math.ulp(highestEquivalentValue) < nextNonEquivalentValue) {
            highestEquivalentValue += Math.ulp(highestEquivalentValue);
        }
        return highestEquivalentValue;
    }

    public double medianEquivalentValue(double value) {
        return (double)this.integerValuesHistogram.medianEquivalentValue((long)(value * this.doubleToIntegerValueConversionRatio)) * this.integerToDoubleValueConversionRatio;
    }

    public double nextNonEquivalentValue(double value) {
        return (double)this.integerValuesHistogram.nextNonEquivalentValue((long)(value * this.doubleToIntegerValueConversionRatio)) * this.integerToDoubleValueConversionRatio;
    }

    public boolean valuesAreEquivalent(double value1, double value2) {
        return this.lowestEquivalentValue(value1) == this.lowestEquivalentValue(value2);
    }

    public int getEstimatedFootprintInBytes() {
        return this.integerValuesHistogram._getEstimatedFootprintInBytes();
    }

    @Override
    public long getStartTimeStamp() {
        return this.integerValuesHistogram.startTimeStampMsec;
    }

    @Override
    public void setStartTimeStamp(long timeStampMsec) {
        this.integerValuesHistogram.startTimeStampMsec = timeStampMsec;
    }

    @Override
    public long getEndTimeStamp() {
        return this.integerValuesHistogram.endTimeStampMsec;
    }

    @Override
    public void setEndTimeStamp(long timeStampMsec) {
        this.integerValuesHistogram.endTimeStampMsec = timeStampMsec;
    }

    public double getMinValue() {
        return (double)this.integerValuesHistogram.getMinValue() * this.integerToDoubleValueConversionRatio;
    }

    public double getMaxValue() {
        return (double)this.integerValuesHistogram.getMaxValue() * this.integerToDoubleValueConversionRatio;
    }

    @Override
    public double getMaxValueAsDouble() {
        return this.getMaxValue();
    }

    public double getMean() {
        return this.integerValuesHistogram.getMean() * this.integerToDoubleValueConversionRatio;
    }

    public double getStdDeviation() {
        return this.integerValuesHistogram.getStdDeviation() * this.integerToDoubleValueConversionRatio;
    }

    public double getValueAtPercentile(double percentile) {
        return (double)this.integerValuesHistogram.getValueAtPercentile(percentile) * this.integerToDoubleValueConversionRatio;
    }

    public double getPercentileAtOrBelowValue(double value) {
        return this.integerValuesHistogram.getPercentileAtOrBelowValue((long)(value * this.doubleToIntegerValueConversionRatio)) * this.integerToDoubleValueConversionRatio;
    }

    public double getCountBetweenValues(double lowValue, double highValue) throws ArrayIndexOutOfBoundsException {
        return (double)this.integerValuesHistogram.getCountBetweenValues((long)(lowValue * this.doubleToIntegerValueConversionRatio), (long)(highValue * this.doubleToIntegerValueConversionRatio)) * this.integerToDoubleValueConversionRatio;
    }

    public long getCountAtValue(double value) throws ArrayIndexOutOfBoundsException {
        return this.integerValuesHistogram.getCountAtValue((long)(value * this.doubleToIntegerValueConversionRatio));
    }

    public AbstractHistogram.Percentiles percentiles(int percentileTicksPerHalfDistance) {
        this.integerValuesHistogram.setIntegerToDoubleValueConversionRatio(this.integerToDoubleValueConversionRatio);
        return this.integerValuesHistogram.percentiles(percentileTicksPerHalfDistance);
    }

    public AbstractHistogram.LinearBucketValues linearBucketValues(double valueUnitsPerBucket) {
        this.integerValuesHistogram.setIntegerToDoubleValueConversionRatio(this.integerToDoubleValueConversionRatio);
        return this.integerValuesHistogram.linearBucketValues((long)(valueUnitsPerBucket * this.doubleToIntegerValueConversionRatio));
    }

    public AbstractHistogram.LogarithmicBucketValues logarithmicBucketValues(double valueUnitsInFirstBucket, double logBase) {
        this.integerValuesHistogram.setIntegerToDoubleValueConversionRatio(this.integerToDoubleValueConversionRatio);
        return this.integerValuesHistogram.logarithmicBucketValues((long)(valueUnitsInFirstBucket * this.doubleToIntegerValueConversionRatio), logBase);
    }

    public AbstractHistogram.RecordedValues recordedValues() {
        this.integerValuesHistogram.setIntegerToDoubleValueConversionRatio(this.integerToDoubleValueConversionRatio);
        return this.integerValuesHistogram.recordedValues();
    }

    public AbstractHistogram.AllValues allValues() {
        this.integerValuesHistogram.setIntegerToDoubleValueConversionRatio(this.integerToDoubleValueConversionRatio);
        AbstractHistogram.AllValues allValues = this.integerValuesHistogram.allValues();
        return allValues;
    }

    public void outputPercentileDistribution(PrintStream printStream, Double outputValueUnitScalingRatio) {
        this.outputPercentileDistribution(printStream, 5, outputValueUnitScalingRatio);
    }

    public void outputPercentileDistribution(PrintStream printStream, int percentileTicksPerHalfDistance, Double outputValueUnitScalingRatio) {
        this.outputPercentileDistribution(printStream, percentileTicksPerHalfDistance, outputValueUnitScalingRatio, false);
    }

    public void outputPercentileDistribution(PrintStream printStream, int percentileTicksPerHalfDistance, Double outputValueUnitScalingRatio, boolean useCsvFormat) {
        this.integerValuesHistogram.outputPercentileDistribution(printStream, percentileTicksPerHalfDistance, outputValueUnitScalingRatio * this.integerToDoubleValueConversionRatio, useCsvFormat);
    }

    private void writeObject(ObjectOutputStream o) throws IOException {
        o.writeLong(this.configuredHighestToLowestValueRatio);
        o.writeDouble(this.currentLowestValueInAutoRange);
        o.writeObject(this.integerValuesHistogram);
    }

    private void readObject(ObjectInputStream o) throws IOException, ClassNotFoundException {
        long configuredHighestToLowestValueRatio = o.readLong();
        double lowestValueInAutoRange = o.readDouble();
        AbstractHistogram integerValuesHistogram = (AbstractHistogram)o.readObject();
        this.init(configuredHighestToLowestValueRatio, lowestValueInAutoRange, integerValuesHistogram);
    }

    @Override
    public int getNeededByteBufferCapacity() {
        return this.integerValuesHistogram.getNeededByteBufferCapacity();
    }

    private int getNeededByteBufferCapacity(int relevantLength) {
        return this.integerValuesHistogram.getNeededByteBufferCapacity(relevantLength);
    }

    private void fillCountsArrayFromBuffer(ByteBuffer buffer, int length) {
        this.integerValuesHistogram.fillCountsArrayFromBuffer(buffer, length);
    }

    private void fillBufferFromCountsArray(ByteBuffer buffer, int length) {
        this.integerValuesHistogram.fillBufferFromCountsArray(buffer, length);
    }

    static boolean isDoubleHistogramCookie(int cookie) {
        return cookie == 208802892 || cookie == 208802893;
    }

    public synchronized int encodeIntoByteBuffer(ByteBuffer buffer) {
        long maxValue = this.integerValuesHistogram.getMaxValue();
        int relevantLength = this.integerValuesHistogram.getLengthForNumberOfBuckets(this.integerValuesHistogram.getBucketsNeededToCoverValue(maxValue));
        if (buffer.capacity() < this.getNeededByteBufferCapacity(relevantLength)) {
            throw new ArrayIndexOutOfBoundsException("buffer does not have capacity for" + this.getNeededByteBufferCapacity(relevantLength) + " bytes");
        }
        buffer.putInt(208802892);
        buffer.putInt(this.getNumberOfSignificantValueDigits());
        buffer.putLong(this.configuredHighestToLowestValueRatio);
        return this.integerValuesHistogram.encodeIntoByteBuffer(buffer) + 16;
    }

    @Override
    public synchronized int encodeIntoCompressedByteBuffer(ByteBuffer targetBuffer, int compressionLevel) {
        targetBuffer.putInt(208802893);
        targetBuffer.putInt(this.getNumberOfSignificantValueDigits());
        targetBuffer.putLong(this.configuredHighestToLowestValueRatio);
        return this.integerValuesHistogram.encodeIntoCompressedByteBuffer(targetBuffer, compressionLevel) + 16;
    }

    public int encodeIntoCompressedByteBuffer(ByteBuffer targetBuffer) {
        return this.encodeIntoCompressedByteBuffer(targetBuffer, -1);
    }

    static DoubleHistogram constructHistogramFromBuffer(int cookie, ByteBuffer buffer, Class<? extends AbstractHistogram> histogramClass, long minBarForHighestToLowestValueRatio) throws DataFormatException {
        AbstractHistogram valuesHistogram;
        int numberOfSignificantValueDigits = buffer.getInt();
        long configuredHighestToLowestValueRatio = buffer.getLong();
        if (cookie == 208802892) {
            valuesHistogram = AbstractHistogram.decodeFromByteBuffer(buffer, histogramClass, minBarForHighestToLowestValueRatio);
        } else if (cookie == 208802893) {
            valuesHistogram = AbstractHistogram.decodeFromCompressedByteBuffer(buffer, histogramClass, minBarForHighestToLowestValueRatio);
        } else {
            throw new IllegalStateException("The buffer does not contain a DoubleHistogram");
        }
        DoubleHistogram histogram = new DoubleHistogram(configuredHighestToLowestValueRatio, numberOfSignificantValueDigits, histogramClass, valuesHistogram);
        return histogram;
    }

    public static DoubleHistogram decodeFromByteBuffer(ByteBuffer buffer, long minBarForHighestToLowestValueRatio) {
        return DoubleHistogram.decodeFromByteBuffer(buffer, Histogram.class, minBarForHighestToLowestValueRatio);
    }

    public static DoubleHistogram decodeFromByteBuffer(ByteBuffer buffer, Class<? extends AbstractHistogram> internalCountsHistogramClass, long minBarForHighestToLowestValueRatio) {
        try {
            int cookie = buffer.getInt();
            if (cookie != 208802892) {
                throw new IllegalArgumentException("The buffer does not contain a DoubleHistogram");
            }
            DoubleHistogram histogram = DoubleHistogram.constructHistogramFromBuffer(cookie, buffer, internalCountsHistogramClass, minBarForHighestToLowestValueRatio);
            return histogram;
        }
        catch (DataFormatException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static DoubleHistogram decodeFromCompressedByteBuffer(ByteBuffer buffer, long minBarForHighestToLowestValueRatio) throws DataFormatException {
        return DoubleHistogram.decodeFromCompressedByteBuffer(buffer, Histogram.class, minBarForHighestToLowestValueRatio);
    }

    public static DoubleHistogram decodeFromCompressedByteBuffer(ByteBuffer buffer, Class<? extends AbstractHistogram> internalCountsHistogramClass, long minBarForHighestToLowestValueRatio) throws DataFormatException {
        int cookie = buffer.getInt();
        if (cookie != 208802893) {
            throw new IllegalArgumentException("The buffer does not contain a compressed DoubleHistogram");
        }
        DoubleHistogram histogram = DoubleHistogram.constructHistogramFromBuffer(cookie, buffer, internalCountsHistogramClass, minBarForHighestToLowestValueRatio);
        return histogram;
    }

    private long deriveInternalHighestToLowestValueRatio(long externalHighestToLowestValueRatio) {
        long internalHighestToLowestValueRatio = 1L << this.findContainingBinaryOrderOfMagnitude(externalHighestToLowestValueRatio) + 1;
        return internalHighestToLowestValueRatio;
    }

    private long deriveIntegerValueRange(long externalHighestToLowestValueRatio, int numberOfSignificantValueDigits) {
        long internalHighestToLowestValueRatio = this.deriveInternalHighestToLowestValueRatio(externalHighestToLowestValueRatio);
        long lowestTackingIntegerValue = AbstractHistogram.numberOfSubbuckets(numberOfSignificantValueDigits) / 2;
        long integerValueRange = lowestTackingIntegerValue * internalHighestToLowestValueRatio;
        return integerValueRange;
    }

    private long getLowestTackingIntegerValue() {
        return this.integerValuesHistogram.subBucketHalfCount;
    }

    private int findContainingBinaryOrderOfMagnitude(double doubleNumber) {
        long longNumber = (long)Math.ceil(doubleNumber);
        int pow2ceiling = 64 - Long.numberOfLeadingZeros(longNumber);
        return pow2ceiling;
    }

    private int findCappedContainingBinaryOrderOfMagnitude(double doubleNumber) {
        if (doubleNumber > (double)this.configuredHighestToLowestValueRatio) {
            return (int)(Math.log(this.configuredHighestToLowestValueRatio) / Math.log(2.0));
        }
        if (doubleNumber > Math.pow(2.0, 50.0)) {
            return 50;
        }
        return this.findContainingBinaryOrderOfMagnitude(doubleNumber);
    }

    static {
        double value;
        for (value = 1.0; value < 4.4942328371557893E307; value *= 2.0) {
        }
        highestAllowedValueEver = value;
    }
}

