/*
 * Copyright 2011 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.google.gwt.dev.util.log.dashboard;

import com.google.gwt.dev.shell.DevModeSession;

/**
 * Sends information to a dashboard service. The dashboard service collects
 * information from GWT runtime and compiler instrumentation.
 *
 * @deprecated Use JFR streaming events instead, or raise an issue to request a new API for this.
 */
@Deprecated
public interface DashboardNotifier {

  /**
   * Notifies the dashboard of a new top-level event starting.
   */
  void devModeEventBegin();

  /**
   * Notifies the dashboard of a top-level event ending.
   */
  void devModeEventEnd(DevModeSession session, String eventType, long startTimeNanos,
      long durationNanos);

  /**
   * Notifies the dashboard of a new session starting.
   */
  void devModeSessionBegin(DevModeSession session);

  /**
   * Notifies the dashboard of a session ending.
   */
  void devModeSessionEnd(DevModeSession session);

  // TODO(jhumphries) Add instrumentation for compiles and GWT tests, too

}
