/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.benchmark.gc;

import com.beust.jcommander.Parameter;
import com.sun.management.GarbageCollectorMXBean;
import java.io.IOException;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;

public class YoungGCPauseBenchmark {
    private Random random = new Random(0L);
    private Map<Integer, Object>[] maps;
    @Parameter(names={"-es", "--entry-size"}, description="Memory size of entry")
    int entrySize = -1;
    @Parameter(names={"-h", "--head-room"}, description="Reserved portion of old space in MiB")
    int headRoom = 256;
    @Parameter(names={"-m", "--data-mode"}, description="Type of garbage data")
    DataMode mode = DataMode.STRING;
    @Parameter(names={"-l", "--string-len"}, description="Average length of string")
    int stringLen = 64;
    @Parameter(names={"-d", "--dry-mode"}, description="After filling old space, test will stop dirting old space. This mode should exclude dirty page scanning from measurement.")
    boolean dryMode = false;
    @Parameter(names={"--max-time"}, description="Benchmark time limit (sec)")
    int maxTime = 60;
    @Parameter(names={"--max-old"}, description="Number of old collections to benchmark")
    int maxOld = -1;
    @Parameter(names={"--max-young"}, description="Number of young collections to benchmark")
    int maxYoung = -1;
    @Parameter(names={"--min-time"}, description="Minimum benchmark time limit (sec)")
    int minTime = -1;
    @Parameter(names={"--min-old"}, description="Minimum number of old collections to measure")
    int minOld = -1;
    @Parameter(names={"--min-young"}, description="Minimum number of young collections to measure")
    int minYoung = -1;
    @Parameter(names={"-r", "--overide-rate"}, description="Chance that new object would be put to the map (otherwise existing would be reiserted)")
    double overrideRate = 0.1;
    @Parameter(names={"-e", "--print-events"}, description="Print GC events to console")
    boolean printEvents = false;
    private int count;
    private GarbageCollectorMXBean oldGcMBean;
    private java.lang.management.GarbageCollectorMXBean youngGcMBean;
    private MemoryPoolMXBean oldMemPool;
    private double activeOverrideRate = 1.1;
    private static char[] STRING_TEMPLATE;
    private static List<String> OLD_POOLS;
    private static List<String> CONC_MODE;
    private boolean concurentMode;

    private int align(int size, int al) {
        return size + al - 1 & ~(al - 1);
    }

    public TestResult benchmark() throws IOException {
        STRING_TEMPLATE = new char[this.stringLen];
        if (this.mode == DataMode.CONST) {
            this.overrideRate = 1.1;
        }
        System.out.println("Java: " + System.getProperty("java.version") + " VM: " + System.getProperty("java.vm.version"));
        System.out.println("Data model: " + Integer.getInteger("sun.arch.data.model"));
        long tenuredSize = Runtime.getRuntime().maxMemory();
        this.concurentMode = false;
        for (MemoryPoolMXBean memoryPoolMXBean : ManagementFactory.getMemoryPoolMXBeans()) {
            if (CONC_MODE.contains(memoryPoolMXBean.getName())) {
                this.concurentMode = true;
            }
            if (!OLD_POOLS.contains(memoryPoolMXBean.getName())) continue;
            tenuredSize = memoryPoolMXBean.getUsage().getMax();
            if (tenuredSize < 0L) {
                tenuredSize = memoryPoolMXBean.getUsage().getCommitted();
            }
            System.out.println("Exact old space size is " + tenuredSize + " bytes");
            this.oldMemPool = memoryPoolMXBean;
            break;
        }
        block1: for (java.lang.management.GarbageCollectorMXBean garbageCollectorMXBean : ManagementFactory.getGarbageCollectorMXBeans()) {
            for (String pool : garbageCollectorMXBean.getMemoryPoolNames()) {
                if (!OLD_POOLS.contains(pool)) continue;
                this.oldGcMBean = (GarbageCollectorMXBean)garbageCollectorMXBean;
                continue block1;
            }
            this.youngGcMBean = garbageCollectorMXBean;
        }
        boolean entrySizeAdjust = false;
        if (this.entrySize <= 0) {
            entrySizeAdjust = true;
            System.out.println("Estimating entry memory footprint ...");
            System.gc();
            long l = this.getOldSpaceUsed();
            int testSize = 100000;
            this.initMaps(testSize);
            while (this.size() < testSize) {
                this.populateMap(this.concurentMode, testSize);
            }
            System.gc();
            long footPrint = this.getOldSpaceUsed() - l;
            this.entrySize = this.align((int)(footPrint / (long)testSize), 32);
            System.out.println("Entry footprint: " + this.entrySize);
            this.maps = null;
        }
        System.gc();
        long l = this.getOldSpaceUsed();
        long freeTenured = tenuredSize - this.getOldSpaceUsed();
        this.calculateCount(freeTenured);
        if (this.concurentMode) {
            System.out.println("Concurent mode is enabled");
            System.out.println("Available old space: " + (freeTenured >> 20) + "MiB");
        } else {
            System.out.println("Available old space: " + (freeTenured >> 20) + "MiB (-" + this.headRoom + " MiB)");
        }
        if (this.count < 0) {
            System.out.println("Heap size is too small, increase heap size or reduce headroom");
            return null;
        }
        System.out.println("Young space collector: " + this.youngGcMBean.getName());
        System.out.println("Old space collector: " + this.oldGcMBean.getName());
        System.out.println("Populating - " + this.count);
        this.initMaps(this.count);
        int n = 0;
        if (entrySizeAdjust) {
            int targetSize = 4 * this.count / 5;
            while (this.size() < targetSize) {
                this.populateMap(this.concurentMode, this.count);
                ++n;
            }
            System.gc();
            System.gc();
            long footPrint = this.getOldSpaceUsed() - l;
            this.entrySize = this.align((int)(footPrint / (long)this.size()), 32);
            System.out.println("Adjusted entry footprint: " + this.entrySize);
            this.calculateCount(freeTenured);
        }
        while (this.size() < this.count) {
            this.populateMap(this.concurentMode, this.count);
            ++n;
        }
        if (this.concurentMode) {
            while (--n > 0) {
                this.processMap(false);
            }
        }
        if (!this.oldGcMBean.getName().startsWith("G1") && this.oldGcMBean != null) {
            long c = this.oldGcMBean.getCollectionCount();
            while (c == this.oldGcMBean.getCollectionCount()) {
                this.processMap(false);
            }
        }
        System.out.println("Size: " + this.size());
        if (!this.dryMode) {
            System.out.println("Processing ... ");
        } else {
            System.out.println("Processing ... (DRY MODE ENABLED)");
        }
        StringBuffer sb = new StringBuffer();
        sb.append("Limits:");
        if (this.maxTime > 0) {
            sb.append(" ").append(this.maxTime + " sec");
        }
        if (this.maxOld > 0) {
            sb.append(" ").append(this.maxOld + " old collections");
        }
        if (this.maxYoung > 0) {
            sb.append(" ").append(this.maxYoung + " young collections");
        }
        System.out.println(sb.toString());
        this.activeOverrideRate = this.overrideRate;
        YoungGcTimeTracker tracker = new YoungGcTimeTracker();
        tracker.init();
        long startTime = System.currentTimeMillis();
        long oldC = this.oldGcMBean.getCollectionCount();
        long youngC = this.youngGcMBean.getCollectionCount();
        do {
            this.processMap(this.dryMode);
            tracker.probe();
        } while (!(this.maxOld > 0 && this.oldGcMBean.getCollectionCount() - oldC > (long)this.maxOld || this.maxYoung > 0 && this.youngGcMBean.getCollectionCount() - youngC > (long)this.maxYoung) && (this.maxTime <= 0 || System.currentTimeMillis() <= startTime + TimeUnit.SECONDS.toMillis(this.maxTime)));
        System.out.println("Benchmark complete");
        return tracker.result();
    }

    private long getOldSpaceUsed() {
        long usage = this.oldMemPool.getUsage().getUsed();
        if (usage < 0L) {
            return this.oldGcMBean.getLastGcInfo().getMemoryUsageAfterGc().get(this.oldMemPool.getName()).getUsed();
        }
        return usage;
    }

    private void calculateCount(long tenuredSize) {
        this.count = (int)((tenuredSize - (long)(this.headRoom << 20)) / (long)this.entrySize);
        if (this.concurentMode) {
            this.count /= 2;
        }
    }

    private void initMaps(int entryCount) {
        this.maps = new Map[(entryCount + 200000 - 1) / 200000];
        for (int i = 0; i != this.maps.length; ++i) {
            this.maps[i] = new HashMap<Integer, Object>(976);
        }
    }

    private void processMap(boolean dry) {
        boolean remove = (double)this.size() > 1.01 * (double)this.count;
        for (int i = 0; i != 1000; ++i) {
            if (remove && this.random.nextBoolean()) {
                if (dry) {
                    this.dryRemoveRandom(this.count);
                    continue;
                }
                this.removeRandom(this.count);
                continue;
            }
            if (dry) {
                this.dryPutRandom(this.count);
                continue;
            }
            this.putRandom(this.count);
        }
    }

    private void populateMap(boolean concurentMode, int count) {
        for (int i = 0; i != 1000; ++i) {
            this.putRandom(count);
            if (!(concurentMode & this.random.nextInt(10) > 7)) continue;
            this.removeRandom(count);
        }
    }

    private int size() {
        int size = 0;
        for (Map<Integer, Object> map : this.maps) {
            size += map.size();
        }
        return size;
    }

    private Object newObject() {
        switch (this.mode) {
            case STRING: {
                return new String(STRING_TEMPLATE);
            }
            case INT: {
                return new Integer(this.random.nextInt());
            }
            case LONG: {
                return new Long(this.random.nextInt());
            }
            case CONST: {
                return this;
            }
        }
        return null;
    }

    private void putRandom(int count) {
        int key = this.random.nextInt(2 * count);
        if (Math.abs(this.random.nextDouble()) < this.activeOverrideRate) {
            Object val = this.newObject();
            this.maps[key % this.maps.length].put(new Integer(key), val);
        } else {
            Integer ik = new Integer(key);
            Object v = this.maps[key % this.maps.length].get(ik);
            if (v != null) {
                this.maps[key % this.maps.length].put(ik, v);
            }
        }
    }

    private void dryPutRandom(int count) {
        int key = this.random.nextInt(2 * count);
        Object val = this.newObject();
        val.equals(this.maps[key % this.maps.length].get(key));
    }

    private void removeRandom(int count) {
        int key = this.random.nextInt(2 * count);
        this.maps[key % this.maps.length].remove(key);
    }

    private void dryRemoveRandom(int count) {
        int key = this.random.nextInt(2 * count);
        this.maps[key % this.maps.length].get(key);
    }

    static {
        OLD_POOLS = Arrays.asList("Tenured Gen", "PS Old Gen", "CMS Old Gen", "G1 Old Gen", "Old Space");
        CONC_MODE = Arrays.asList("CMS Old Gen", "G1 Old Gen");
    }

    public static class TestResult
    implements Serializable {
        private static final long serialVersionUID = 20130518L;
        public long totalTime;
        public double totalSquareTime;
        public long youngGcCount;

        public double getAverage() {
            double avg = (double)this.totalTime / (double)this.youngGcCount;
            return avg;
        }

        public double getStdDev() {
            double avg = (double)this.totalTime / (double)this.youngGcCount;
            double stdDev = Math.sqrt(this.totalSquareTime / (double)this.youngGcCount - avg * avg);
            return stdDev;
        }

        public String toString() {
            double avg = (double)this.totalTime / (double)this.youngGcCount;
            double stdDev = Math.sqrt(this.totalSquareTime / (double)this.youngGcCount - avg * avg);
            return String.format("%f [%f] ms", avg, stdDev);
        }
    }

    private class YoungGcTimeTracker {
        private long totalTime = 0L;
        private long evenCount = 0L;
        private double squareTotal = 0.0;
        private long lastTime;
        private long lastYoungCount;
        private long lastOldCount;

        private YoungGcTimeTracker() {
        }

        public void init() {
            long yt;
            long ogc;
            long ygc;
            do {
                ygc = YoungGCPauseBenchmark.this.youngGcMBean.getCollectionCount();
                ogc = YoungGCPauseBenchmark.this.oldGcMBean.getCollectionCount();
                yt = YoungGCPauseBenchmark.this.youngGcMBean.getCollectionTime();
            } while (YoungGCPauseBenchmark.this.youngGcMBean.getCollectionCount() != ygc && YoungGCPauseBenchmark.this.oldGcMBean.getCollectionCount() != ogc);
            this.lastTime = yt;
            this.lastYoungCount = ygc;
            this.lastOldCount = ogc;
        }

        public void probe() {
            block4: {
                long yt;
                long ogc;
                long ygc;
                do {
                    if ((ygc = YoungGCPauseBenchmark.this.youngGcMBean.getCollectionCount()) == this.lastYoungCount) {
                        return;
                    }
                    ogc = YoungGCPauseBenchmark.this.oldGcMBean.getCollectionCount();
                    yt = YoungGCPauseBenchmark.this.youngGcMBean.getCollectionTime();
                } while (YoungGCPauseBenchmark.this.youngGcMBean.getCollectionCount() != ygc && YoungGCPauseBenchmark.this.oldGcMBean.getCollectionCount() != ogc);
                long ycd = ygc - this.lastYoungCount;
                long ocd = ogc - this.lastOldCount;
                long td = yt - this.lastTime;
                this.lastYoungCount = ygc;
                this.lastOldCount = ogc;
                this.lastTime = yt;
                if (!YoungGCPauseBenchmark.this.concurentMode && ocd > 0L) {
                    ycd -= ocd;
                }
                if (ycd <= 0L) break block4;
                this.totalTime += td;
                this.evenCount += ycd;
                double avg = (double)td / (double)ycd;
                this.squareTotal += (double)ycd * avg * avg;
                if (YoungGCPauseBenchmark.this.printEvents) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Young GC (" + ycd + " events), total time: " + td + "ms, (Old events: " + ogc + ")");
                    System.out.println(sb);
                }
            }
        }

        public TestResult result() {
            TestResult result = new TestResult();
            result.totalSquareTime = this.squareTotal;
            result.totalTime = this.totalTime;
            result.youngGcCount = this.evenCount;
            return result;
        }
    }

    public static enum DataMode {
        STRING,
        LONG,
        INT,
        CONST;

    }
}

