/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.util.formating;

import java.text.SimpleDateFormat;

public class Formats {
    public static final String ZERO_LEAD_DECIMAL_6 = "%06d";
    public static final String DATE_STAMP = "%1$tFT%1$tT.%1$tL%1$tz";
    public static final String FILE_DATE_STAMP = "%1$tY%1$tm%1$td-%1$tH%1$tM%1$tS";
    public static final String TIME_STAMP = "%1$tT.%1$tL";

    public static final String toTimestamp(long millis) {
        return String.format(TIME_STAMP, millis);
    }

    public static final String toDatestamp(long millis) {
        return String.format(DATE_STAMP, millis);
    }

    public static final String toFileDatestamp(long millis) {
        return String.format(FILE_DATE_STAMP, millis);
    }

    public static final String currentDatestamp() {
        return Formats.toDatestamp(System.currentTimeMillis());
    }

    public static final String currentFileDatestamp() {
        return Formats.toFileDatestamp(System.currentTimeMillis());
    }

    public static final String toMemorySize(long n) {
        if (n < 10240L) {
            return String.valueOf(n);
        }
        if (n < 0xA00000L) {
            return String.valueOf(n >> 10) + "k";
        }
        if (n < 0x280000000L) {
            return String.valueOf(n >> 20) + "m";
        }
        return String.valueOf(n >> 30) + "g";
    }

    public static void main(String[] args) {
        System.out.println("DATE_STAMP: " + String.format(DATE_STAMP, System.currentTimeMillis()));
        System.out.println("FILE_DATE_STAMP: " + String.format(FILE_DATE_STAMP, System.currentTimeMillis()));
        System.out.println("ZERO_LEAD_DECIMAL_6: " + String.format(ZERO_LEAD_DECIMAL_6, 1234));
        System.out.println(String.format("[%-6s]", "x"));
        System.out.println(String.format("[%.2f]", 0.1));
        System.out.println("SimpleDataFormat: " + new SimpleDateFormat("yyyy.MM.dd_HH:mm:ss").format(System.currentTimeMillis()));
    }
}

