/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.util.formating;

import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;

public class TextTable {
    public static final Comparator<String> NUM_CMP = new NumberCmp();
    private List<String[]> rows = new ArrayList<String[]>();
    private int colCount;

    public static String formatCsv(TextTable table) {
        StringWriter writer = new StringWriter();
        try {
            table.formatCsv(writer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return writer.toString();
    }

    public static String formatASCII(TextTable table) {
        return table.formatTextTable(Integer.MAX_VALUE);
    }

    public void transpone() {
        int rc = this.rows.size();
        int cc = this.colCount;
        ArrayList<String[]> nrows = new ArrayList<String[]>();
        for (int i = 0; i != cc; ++i) {
            String[] nrow = new String[cc];
            int j = 0;
            while (j != rc) {
                nrow[j] = this.rows.get(j)[i];
                ++i;
            }
            nrows.add(nrow);
        }
        this.rows = nrows;
        this.colCount = rc;
    }

    public void addRow(String ... row) {
        this.addRow(row, false);
    }

    public void addRow(List<String> row) {
        this.addRow(row.toArray(new String[row.size()]), false);
    }

    public void addRow(List<String> row, boolean autoGrow) {
        this.addRow(row.toArray(new String[row.size()]), autoGrow);
    }

    public void addRow(String[] row, boolean autoGrow) {
        if (this.rows.size() == 0) {
            this.colCount = row.length;
        }
        if (row.length > this.colCount) {
            if (autoGrow) {
                this.extendRows(row.length);
            } else {
                throw new IllegalArgumentException("Row is longer than table");
            }
        }
        this.rows.add(Arrays.copyOf(row, this.colCount));
    }

    private void extendRows(int length) {
        for (int i = 0; i != this.rows.size(); ++i) {
            this.rows.set(i, (String[])Arrays.copyOf((Object[])this.rows.get(i), length));
        }
        this.colCount = length;
    }

    public void addColumnRight(List<String> col) {
        this.addColumnRight(col.toArray(new String[col.size()]));
    }

    public void addColumnRight(String ... col) {
        if (col.length > this.rows.size()) {
            if (this.rows.size() > 0) {
                throw new IllegalArgumentException("Column is taller than table");
            }
            for (String c : col) {
                this.rows.add(new String[]{c});
            }
        }
        ++this.colCount;
        for (int i = 0; i != this.rows.size(); ++i) {
            String[] row = this.rows.get(i);
            row = Arrays.copyOf(row, this.colCount);
            if (col.length > i) {
                row[this.colCount - 1] = col[i];
            }
            this.rows.set(i, row);
        }
    }

    public void addColumnLeft(List<String> col) {
        this.addColumnLeft(col.toArray(new String[col.size()]));
    }

    public void addColumnLeft(String ... col) {
        if (col.length > this.rows.size()) {
            if (this.rows.size() > 0) {
                throw new IllegalArgumentException("Column is taller than table");
            }
            for (String c : col) {
                this.rows.add(new String[]{c});
            }
        }
        ++this.colCount;
        for (int i = 0; i != this.rows.size(); ++i) {
            String[] row = this.rows.get(i);
            String[] nrow = new String[this.colCount];
            System.arraycopy(row, 0, nrow, 1, row.length);
            if (col.length > i) {
                nrow[0] = col[i];
            }
            this.rows.set(i, nrow);
        }
    }

    public String[] getRow(int row) {
        return this.rows.get(row);
    }

    public String[] getCol(int col) {
        Object[] cc = new String[this.rows.size()];
        if (col >= 0) {
            for (int i = 0; i != cc.length; ++i) {
                String[] row = this.rows.get(i);
                cc[i] = row != null && row.length <= col ? "" : row[col];
            }
        } else {
            Arrays.fill(cc, "");
        }
        return cc;
    }

    public void removeColumn(int col) {
        ListIterator<String[]> li = this.rows.listIterator();
        while (li.hasNext()) {
            String[] row = li.next();
            if (row.length < col) continue;
            String[] nrow = new String[row.length - 1];
            System.arraycopy(row, 0, nrow, 0, col);
            System.arraycopy(row, col + 1, nrow, col, nrow.length - col);
            li.set(nrow);
        }
    }

    public int rowCount() {
        return this.rows.size();
    }

    public void sort(int col, boolean exludeHeader, boolean descOrder, Comparator<String> cmp) {
        RowCmp rowcmp = new RowCmp(col, descOrder, cmp);
        if (exludeHeader) {
            Collections.sort(this.rows.subList(1, this.rows.size()), rowcmp);
        } else {
            Collections.sort(this.rows, rowcmp);
        }
    }

    public void formatCsv(Appendable out) throws IOException {
        for (String[] row : this.rows) {
            for (int i = 0; i != row.length; ++i) {
                if (i > 0) {
                    out.append(",");
                }
                this.formatCell(out, row[i]);
            }
            out.append("\n");
        }
    }

    private void formatCell(Appendable out, String row) throws IOException {
        if (row == null || row.length() == 0) {
            return;
        }
        if (this.isCsvSafe(row)) {
            out.append(row);
        } else {
            out.append('\"');
            for (int i = 0; i != row.length(); ++i) {
                char c = row.charAt(i);
                if (c == '\"') {
                    out.append("\"\"");
                    continue;
                }
                if (c == '\n') {
                    out.append(' ');
                    continue;
                }
                out.append(c);
            }
            out.append('\"');
        }
    }

    private boolean isCsvSafe(String row) {
        for (int i = 0; i != row.length(); ++i) {
            char ch = row.charAt(i);
            if (Character.isJavaIdentifierPart(ch) || "._-".indexOf(ch) >= 0) continue;
            return false;
        }
        return true;
    }

    public String formatTextTable(int maxCellWidth) {
        return this.formatTable(this.rows, maxCellWidth, true);
    }

    public String formatTextTableUnbordered(int maxCellWidth) {
        return this.formatTable(this.rows, maxCellWidth, false);
    }

    private String formatTable(List<String[]> content, int maxCell, boolean table) {
        int[] width = new int[content.get(0).length];
        for (String[] row : content) {
            for (int i = 0; i != row.length; ++i) {
                width[i] = Math.min(Math.max(width[i], this.measureCell(row[i])), maxCell);
            }
        }
        StringBuilder sb = new StringBuilder();
        boolean header = table;
        for (String[] row : content) {
            for (int i = 0; i != width.length; ++i) {
                this.renderCell(sb, row[i], width[i]);
                if (!table) continue;
                sb.append('|');
            }
            if (table) {
                sb.setLength(sb.length() - 1);
            }
            TextTable.trimTail(sb);
            sb.append('\n');
            if (!header) continue;
            header = false;
            for (int n : width) {
                for (int i = 0; i != n; ++i) {
                    sb.append('-');
                }
                sb.append('+');
            }
            sb.setLength(sb.length() - 1);
            TextTable.trimTail(sb);
            sb.append('\n');
        }
        return sb.toString();
    }

    protected int measureCell(String cell) {
        if (cell == null) {
            return 0;
        }
        int len = 0;
        for (int i = 0; i != cell.length(); ++i) {
            if (cell.charAt(i) == '\t') continue;
            ++len;
        }
        return len;
    }

    protected void renderCell(StringBuilder sb, String rawCell, int width) {
        String cell = rawCell == null ? "" : rawCell;
        int tabs = 0;
        for (int i = 0; i != cell.length(); ++i) {
            if (cell.charAt(i) != '\t') continue;
            ++tabs;
        }
        if (cell.length() - tabs > width) {
            int n = width - 3;
            for (int i = 0; i != cell.length(); ++i) {
                if (cell.charAt(i) == '\t') continue;
                sb.append(cell.charAt(i));
                if (0 == --n) break;
            }
            sb.append("...");
        } else if (tabs == 0) {
            sb.append(cell);
            for (int s = 0; s != width - cell.length(); ++s) {
                sb.append(' ');
            }
        } else {
            int gap = width - cell.length() + tabs;
            for (int i = 0; i != cell.length(); ++i) {
                if (cell.charAt(i) == '\t') {
                    int fill = (gap + tabs - 1) / tabs;
                    for (int j = 0; j != fill; ++j) {
                        sb.append(' ');
                    }
                    gap -= fill;
                    --tabs;
                    continue;
                }
                sb.append(cell.charAt(i));
            }
        }
    }

    private static void trimTail(StringBuilder sb) {
        while (sb.length() > 0 && sb.charAt(sb.length() - 1) == ' ') {
            sb.setLength(sb.length() - 1);
        }
    }

    private static class NumberCmp
    implements Comparator<String> {
        private NumberCmp() {
        }

        @Override
        public int compare(String o1, String o2) {
            if (o1.length() == 0 || o2.length() == 0) {
                return o1.compareTo(o2);
            }
            try {
                Double v1 = Double.parseDouble(o1);
                Double v2 = Double.parseDouble(o2);
                return v1.compareTo(v2);
            }
            catch (NumberFormatException e) {
                return o1.compareTo(o2);
            }
        }
    }

    private static class RowCmp
    implements Comparator<String[]> {
        private final int col;
        private final Comparator<String> cmp;
        private final boolean descOrder;

        public RowCmp(int col, boolean descOrder, Comparator<String> cmp) {
            this.col = col;
            this.cmp = cmp;
            this.descOrder = descOrder;
        }

        @Override
        public int compare(String[] o1, String[] o2) {
            String s1 = o1[this.col];
            String s2 = o2[this.col];
            if (this.cmp == null) {
                return (this.descOrder ? -1 : 1) * s1.compareTo(s2);
            }
            return (this.descOrder ? -1 : 1) * this.cmp.compare(s1, s2);
        }
    }
}

