/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.lab.jvm.attach;

import org.gridkit.lab.jvm.attach.StackTraceElementParser;

public class SimpleStackParser
implements StackTraceElementParser {
    protected static final String NATIVE_METHOD = "Native Method";
    protected static final String UNKNOWN_SOURCE = "Unknown Source";
    protected static final int NO_LINE_NUMBER = 0;
    protected static final int NO_SOURCE = -1;
    protected static final int NATIVE = -2;
    private final boolean suppress;

    public SimpleStackParser(boolean suppressErrors) {
        this.suppress = suppressErrors;
    }

    @Override
    public StackTraceElement paser(CharSequence line) {
        char ch;
        char ch2;
        StringBuilder sb = new StringBuilder(line.length());
        int dot1 = -1;
        int dot2 = -1;
        int n = 0;
        while ((ch2 = line.charAt(n)) != '(') {
            if (ch2 == '.') {
                dot2 = dot1;
                dot1 = n;
            }
            sb.append(ch2);
            if (++n < line.length()) continue;
            if (this.suppress) {
                return null;
            }
            throw new IllegalArgumentException("Cannot parse [" + line + "]");
        }
        if (dot1 == -1) {
            if (this.suppress) {
                return null;
            }
            throw new IllegalArgumentException("Cannot parse [" + line + "]");
        }
        String pref = null;
        String cn = null;
        String mn = null;
        if (dot2 != -1) {
            pref = sb.substring(0, dot2);
            cn = sb.substring(dot2 + 1, dot1);
            mn = sb.substring(dot1 + 1);
        } else {
            cn = sb.substring(0, dot1);
            mn = sb.substring(dot1 + 1);
        }
        sb.setLength(0);
        int col = -1;
        int off = ++n;
        while ((ch = line.charAt(n)) != ')') {
            if (ch == ':') {
                col = n - off;
            }
            sb.append(ch);
            if (++n < line.length()) continue;
            if (this.suppress) {
                return null;
            }
            throw new IllegalArgumentException("Cannot parse [" + line + "]");
        }
        String file = null;
        int lnum = -1;
        if (col != -1) {
            file = sb.substring(0, col);
            try {
                lnum = Integer.parseInt(sb.substring(col + 1));
            }
            catch (NumberFormatException e) {
                if (this.suppress) {
                    return null;
                }
                throw new IllegalArgumentException("Number format exception '" + e.getMessage() + "' parsing [" + line + "]");
            }
        } else {
            file = sb.toString();
            if (file.equals(NATIVE_METHOD)) {
                file = null;
                lnum = -2;
            } else if (file.equals(UNKNOWN_SOURCE)) {
                file = null;
            }
        }
        return new StackTraceElement(pref + "." + cn, mn, file, lnum);
    }
}

