/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.sjk.test.console;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PatternMatcher {
    private final List<String> lines = new ArrayList<String>();
    private final PatternNode pattern;
    private final Map<LineMatcherNode, boolean[]> matchCache = new HashMap<LineMatcherNode, boolean[]>();

    public PatternMatcher(PatternNode pattern) {
        this.pattern = pattern;
    }

    public List<String> lines() {
        return this.lines;
    }

    public boolean matchWhole(String text) {
        int[] matches;
        this.matchCache.clear();
        this.lines.clear();
        String[] lines = text.split("\n");
        this.lines.addAll(Arrays.asList(lines));
        for (int m : matches = this.match(0, this.pattern)) {
            if (m != this.lines.size()) continue;
            return true;
        }
        return false;
    }

    public int matchStart(String text) {
        this.matchCache.clear();
        this.lines.clear();
        String[] lines = text.split("\n");
        this.lines.addAll(Arrays.asList(lines));
        int[] matches = this.match(0, this.pattern);
        return matches.length > 0 ? this.min(matches) : -1;
    }

    public String reportMatchProblems() {
        StringBuilder sb = new StringBuilder();
        for (LineMatcherNode node : this.matchCache.keySet()) {
            boolean[] cached = this.matchCache.get(node);
            boolean matched = false;
            for (int n = 0; n < cached.length; n += 2) {
                if (!cached[n] || !cached[n + 1]) continue;
                matched = true;
                break;
            }
            if (matched) continue;
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append("Matcher is never matched: " + node);
        }
        int lastMatched = -1;
        for (int n = 0; n < this.lines.size(); ++n) {
            if (!this.hasAnyMatches(n)) continue;
            lastMatched = n;
        }
        if (lastMatched + 1 < this.lines.size()) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append("Next unmatched line: " + this.lines.get(lastMatched + 1));
        }
        return sb.toString();
    }

    private boolean hasAnyMatches(int n) {
        for (boolean[] cached : this.matchCache.values()) {
            if (cached == null || !cached[2 * n] || !cached[2 * n + 1]) continue;
            return true;
        }
        return false;
    }

    private int min(int[] matches) {
        int min = matches[0];
        for (int i = 1; i < matches.length; ++i) {
            min = Math.min(min, matches[i]);
        }
        return min;
    }

    private int[] match(int offset, PatternNode pattern) {
        if (pattern instanceof LineMatcherNode) {
            return this.matchLineMatcher(offset, (LineMatcherNode)pattern);
        }
        if (pattern instanceof AnyLinesNode) {
            AnyLinesNode any = (AnyLinesNode)pattern;
            int maxMatches = this.lines.size() - offset + 1;
            if (any.maxMatches > 0) {
                maxMatches = Math.min(maxMatches, any.maxMatches);
            }
            if (any.minMatches > 0) {
                maxMatches -= any.minMatches;
            }
            if (maxMatches < 1) {
                return new int[0];
            }
            int[] matches = new int[this.lines.size() - offset + 1];
            for (int n = 0; n != matches.length; ++n) {
                matches[n] = this.lines.size() - n + any.minMatches;
            }
            return matches;
        }
        if (pattern instanceof SequenceNode) {
            return this.matchSequence(offset, (SequenceNode)pattern);
        }
        if (pattern instanceof AlternativesNode) {
            return this.matchAlternatives(offset, (AlternativesNode)pattern);
        }
        throw new IllegalArgumentException("Unlnown node: " + pattern);
    }

    private int[] matchLineMatcher(int offset, LineMatcherNode node) {
        if (this.matchLine(offset, node)) {
            return new int[]{offset + 1};
        }
        return new int[0];
    }

    private int[] matchSequence(int offset, SequenceNode node) {
        return this.matchSequence(offset, node, 0);
    }

    private int[] matchSequence(int offset, SequenceNode node, int seqOffs) {
        if (node.nodes.length == seqOffs) {
            return new int[]{offset};
        }
        PatternNode element = node.nodes[seqOffs];
        int[] imatches = this.match(offset, element);
        int[] list = new int[16];
        int mc = 0;
        for (int m : imatches) {
            int[] f = this.matchSequence(m, node, seqOffs + 1);
            int ns = mc + f.length;
            if (ns > list.length) {
                list = Arrays.copyOf(list, ns + 16);
            }
            System.arraycopy(f, 0, list, mc, f.length);
            mc = ns;
        }
        return Arrays.copyOf(list, mc);
    }

    private int[] matchAlternatives(int offset, AlternativesNode node) {
        int[] list = new int[16];
        int mc = 0;
        for (PatternNode alt : node.nodes) {
            int[] match = this.match(offset, alt);
            if (match.length <= 0) continue;
            int ns = mc + match.length;
            if (list.length < ns) {
                list = Arrays.copyOf(list, ns + 16);
            }
            System.arraycopy(match, 0, list, mc, match.length);
            mc = ns;
        }
        return Arrays.copyOf(list, mc);
    }

    private boolean matchLine(int idx, LineMatcherNode node) {
        if (idx >= this.lines.size()) {
            return false;
        }
        boolean[] cache = this.matchCache.get(node);
        if (cache == null) {
            cache = new boolean[2 * this.lines.size()];
            this.matchCache.put(node, cache);
        }
        if (cache[2 * idx]) {
            return cache[2 * idx + 1];
        }
        boolean match = node.match(this.lines.get(idx));
        cache[2 * idx] = true;
        cache[2 * idx + 1] = match;
        return match;
    }

    public static class MatchExact
    extends LineMatcherNode {
        private final String line;

        public MatchExact(String line) {
            this.line = line;
        }

        @Override
        public boolean match(String line) {
            return this.line.equals(line);
        }

        public String toString() {
            return "Exact[" + this.line + "]";
        }
    }

    public static class AlternativesNode
    extends PatternNode {
        private final PatternNode[] nodes;

        public AlternativesNode(PatternNode ... nodes) {
            this.nodes = nodes;
        }

        public AlternativesNode append(PatternNode node) {
            PatternNode[] nn = Arrays.copyOf(this.nodes, this.nodes.length + 1);
            nn[nn.length - 1] = node;
            return new AlternativesNode(nn);
        }

        public String toString() {
            return "ALT" + Arrays.toString(this.nodes);
        }
    }

    public static class SequenceNode
    extends PatternNode {
        private final PatternNode[] nodes;

        public SequenceNode(PatternNode ... nodes) {
            this.nodes = nodes;
        }

        public SequenceNode append(PatternNode node) {
            PatternNode[] nn = Arrays.copyOf(this.nodes, this.nodes.length + 1);
            nn[nn.length - 1] = node;
            return new SequenceNode(nn);
        }

        public String toString() {
            return "SEQ" + Arrays.toString(this.nodes);
        }
    }

    public static class AnyLinesNode
    extends PatternNode {
        private int minMatches;
        private int maxMatches;

        public AnyLinesNode() {
            this.minMatches = 0;
            this.maxMatches = -1;
        }

        public AnyLinesNode(int minMatches, int maxMatches) {
            this.minMatches = minMatches;
            this.maxMatches = maxMatches;
        }

        public String toString() {
            return this.minMatches == 0 && this.maxMatches == -1 ? "ANY" : "ANY[" + (this.minMatches > 0 ? "min=" + this.maxMatches : (this.maxMatches > 0 ? "," : "")) + (this.maxMatches > 0 ? "max=" + this.maxMatches : "") + "]";
        }
    }

    public static class MatcherNode
    extends LineMatcherNode {
        private final LineMatcher matcher;

        public MatcherNode(LineMatcher matcher) {
            this.matcher = matcher;
        }

        @Override
        public boolean match(String line) {
            return this.matcher.match(line);
        }

        public String toString() {
            return this.matcher.toString();
        }
    }

    public static abstract class LineMatcherNode
    extends PatternNode
    implements LineMatcher {
    }

    public static abstract class PatternNode {
    }

    public static interface LineMatcher {
        public boolean match(String var1);
    }
}

