/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.sjk.test.console;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gridkit.sjk.test.console.PatternMatcher;
import org.junit.Assert;

public class ConsoleTracker {
    final boolean err;
    ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    PrintStream orig;
    List<ConsoleMatcher> matchers = new ArrayList<ConsoleMatcher>();

    public static ConsoleTracker out() {
        return new ConsoleTracker(false);
    }

    public static ConsoleTracker err() {
        return new ConsoleTracker(true);
    }

    ConsoleTracker(boolean err) {
        this.err = err;
    }

    public void init() {
        this.orig = this.err ? System.err : System.out;
        PrintStream tee = new PrintStream(new TeeOutputStream(this.orig, this.buffer));
        if (this.err) {
            System.setErr(tee);
        } else {
            System.setOut(tee);
        }
    }

    public void complete() {
        this.verify();
        if (this.err) {
            System.setErr(this.orig);
        } else {
            System.setOut(this.orig);
        }
    }

    public void verify() {
        if (this.err) {
            System.err.flush();
        } else {
            System.out.flush();
        }
        if (this.matchers.isEmpty()) {
            return;
        }
        ConsoleMatcher[] cms = this.matchers.toArray(new ConsoleMatcher[0]);
        this.matchers.clear();
        String text = this.getText();
        this.buffer.reset();
        PatternMatcher.PatternNode node = this.compile(cms);
        PatternMatcher matcher = new PatternMatcher(node);
        int ln = matcher.matchStart(text);
        if (ln < 0) {
            Assert.fail((String)"Console content does not match");
        }
        List<String> lines = matcher.lines();
        for (int i = ln; i < lines.size(); ++i) {
            try {
                this.buffer.write((lines.get(i) + "\n").getBytes());
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private PatternMatcher.PatternNode compile(ConsoleMatcher[] cms) {
        PatternMatcher.PatternNode[] nodes = new PatternMatcher.PatternNode[cms.length];
        for (int i = 0; i != cms.length; ++i) {
            nodes[i] = cms[i].getMatcherNode();
        }
        return new PatternMatcher.SequenceNode(nodes);
    }

    private String getText() {
        String text = new String(this.buffer.toByteArray());
        text = text.replace("\r\n", "\n");
        return text;
    }

    public ConsoleTracker skip() {
        this.matchers.add(new SkipMatcher());
        return this;
    }

    public ConsoleTracker skip(int lines) {
        for (int i = 0; i != lines; ++i) {
            this.lineEx(".*", new String[0]);
        }
        return this;
    }

    public ConsoleTracker line(String exact) {
        this.matchers.add(new LineMatcher(Pattern.quote(exact), new String[0]));
        return this;
    }

    public ConsoleTracker lineStarts(String starts) {
        return this.lineStartsEx(Pattern.quote(starts), new String[0]);
    }

    public ConsoleTracker lineStartsEx(String starts, String ... vars) {
        String pattern = starts + ".*";
        Pattern.compile(pattern);
        this.matchers.add(new LineMatcher(pattern, vars));
        return this;
    }

    public ConsoleTracker lineContains(String ... substrings) {
        if (substrings.length == 0) {
            throw new IllegalArgumentException("At least one string is required");
        }
        if (substrings.length == 1) {
            return this.lineContainsEx(".*" + Pattern.quote(substrings[0]) + ".*", new String[0]);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("(?:.*(?:");
        for (String ss : substrings) {
            sb.append(Pattern.quote(ss)).append("|");
        }
        sb.setLength(sb.length() - 1);
        sb.append(").*){" + substrings.length + "}");
        return this.lineContainsEx(sb.toString(), new String[0]);
    }

    public ConsoleTracker lineContainsEx(String substring, String ... vars) {
        String pattern = substring;
        Pattern.compile(pattern);
        this.matchers.add(new LineMatcher(pattern, vars));
        return this;
    }

    public ConsoleTracker lineEx(String pattern, String ... vars) {
        Pattern.compile(pattern);
        this.matchers.add(new LineMatcher(pattern, vars));
        return this;
    }

    public String toString() {
        return this.getText();
    }

    private static class TeeOutputStream
    extends OutputStream {
        private final OutputStream a;
        private final OutputStream b;

        public TeeOutputStream(OutputStream a, OutputStream b) {
            this.a = a;
            this.b = b;
        }

        @Override
        public void write(int d) throws IOException {
            this.a.write(d);
            this.b.write(d);
        }

        @Override
        public void write(byte[] d) throws IOException {
            this.a.write(d);
            this.b.write(d);
        }

        @Override
        public void write(byte[] d, int off, int len) throws IOException {
            this.a.write(d, off, len);
            this.b.write(d, off, len);
        }

        @Override
        public void flush() throws IOException {
            this.a.flush();
            this.b.flush();
        }
    }

    private class LineMatcher
    extends ConsoleMatcher {
        private final String pattern;
        private final String[] placeholders;

        public LineMatcher(String pattern, String[] placeholders) {
            this.pattern = pattern;
            this.placeholders = placeholders;
        }

        @Override
        public String getLineMatcher() {
            return this.pattern + "\\n";
        }

        @Override
        public PatternMatcher.PatternNode getMatcherNode() {
            return new PatternMatcher.LineMatcherNode(){

                @Override
                public boolean match(String line) {
                    Matcher m = Pattern.compile(LineMatcher.this.pattern).matcher(line);
                    if (!m.matches()) {
                        return false;
                    }
                    if (LineMatcher.this.placeholders != null) {
                        ArrayList<String> missmatches = new ArrayList<String>();
                        for (int i = 0; i != LineMatcher.this.placeholders.length; ++i) {
                            if (LineMatcher.this.placeholders[i] == null || LineMatcher.this.placeholders[i].equals(m.group(i + 1))) continue;
                            missmatches.add(LineMatcher.this.placeholders[i] + " <> " + m.group(i + 1));
                        }
                        if (!missmatches.isEmpty()) {
                            return false;
                        }
                    }
                    return true;
                }

                public String toString() {
                    return "\"" + LineMatcher.this.pattern + "\"";
                }
            };
        }

        @Override
        public void verifyMatch(String match) {
            if (match.endsWith("\r\n")) {
                match = match.substring(0, match.length() - 2);
            } else if (match.endsWith("\n") || match.endsWith("\r")) {
                match = match.substring(0, match.length() - 1);
            }
            Matcher m = Pattern.compile(this.pattern).matcher(match);
            if (!m.matches()) {
                Assert.fail((String)("Line does not match\nExpect: " + this.pattern + "\nLine: " + match));
            }
            if (this.placeholders != null) {
                ArrayList<String> missmatches = new ArrayList<String>();
                for (int i = 0; i != this.placeholders.length; ++i) {
                    if (this.placeholders[i] == null || this.placeholders[i].equals(m.group(i + 1))) continue;
                    missmatches.add(this.placeholders[i] + " <> " + m.group(i + 1));
                }
                if (!missmatches.isEmpty()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Line placeholders missmatch");
                    for (String mm : missmatches) {
                        sb.append("\n").append(mm);
                    }
                    Assert.fail((String)sb.toString());
                }
            }
        }
    }

    private class SkipMatcher
    extends ConsoleMatcher {
        private SkipMatcher() {
        }

        @Override
        public String getLineMatcher() {
            return "([^\\n]*\\n)*";
        }

        @Override
        public PatternMatcher.PatternNode getMatcherNode() {
            return new PatternMatcher.AnyLinesNode();
        }

        @Override
        public void verifyMatch(String match) {
        }
    }

    private abstract class ConsoleMatcher {
        private ConsoleMatcher() {
        }

        public abstract String getLineMatcher();

        public abstract PatternMatcher.PatternNode getMatcherNode();

        public abstract void verifyMatch(String var1);
    }
}

