/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.stacktrace;

public class StackFrame
implements CharSequence {
    private static final String NATIVE_METHOD = "Native Method";
    private static final String UNKNOWN_SOURCE = "Unknown Source";
    private static final int NO_LINE_NUMBER = 0;
    private static final int NO_SOURCE = -1;
    private static final int NATIVE = -2;
    private static final int[] PO10 = new int[]{1, 10, 100, 1000, 10000, 100000};
    private final String classPrefix;
    private final String className;
    private String fqcn = null;
    private final String methodName;
    private final String fileName;
    private final int lineNumber;
    private final short textLen;
    private final short lineNumberDigits;
    private final int hash;

    public StackFrame(StackTraceElement ste) {
        this(null, ste.getClassName(), ste.getMethodName(), ste.getFileName(), ste.getLineNumber());
    }

    public StackFrame(String classPrefix, String className, String methodName, String fileName, int lineNumber) {
        String string = this.classPrefix = "".equals(classPrefix) ? null : classPrefix;
        if (className == null) {
            throw new NullPointerException("Class name cannot be null");
        }
        this.className = className;
        this.methodName = methodName;
        this.fileName = lineNumber == -2 ? null : fileName;
        this.lineNumber = lineNumber;
        this.lineNumberDigits = lineNumber == -2 ? (short)-2 : (fileName == null ? (short)-1 : (lineNumber == -1 ? (short)0 : (short)String.valueOf(lineNumber).length()));
        int len = this.calcLen();
        if (len > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Frame is too big");
        }
        this.textLen = (short)len;
        this.hash = this.toString().hashCode();
    }

    private int calcLen() {
        int len = this.classPrefix == null ? 0 : this.classPrefix.length() + 1;
        len += this.className.length();
        len += this.methodName.length() + 1;
        ++len;
        switch (this.lineNumberDigits) {
            case 0: {
                len += this.fileName.length();
                break;
            }
            case -1: {
                len += UNKNOWN_SOURCE.length();
                break;
            }
            case -2: {
                len += NATIVE_METHOD.length();
                break;
            }
            default: {
                len += this.fileName.length() + 1 + this.lineNumberDigits;
            }
        }
        return ++len;
    }

    public String getClassName() {
        if (this.fqcn == null) {
            this.fqcn = this.classPrefix == null ? this.className : this.classPrefix + "." + this.className;
        }
        return this.fqcn;
    }

    String getClassPrefix() {
        return this.classPrefix;
    }

    String getShortClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getSourceFile() {
        return this.fileName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public StackFrame internSymbols() {
        String fn;
        String cp = this.classPrefix == null ? null : this.classPrefix.intern();
        String cn = this.className.intern();
        String mn = this.methodName.intern();
        String string = fn = this.fileName == null ? null : this.fileName.intern();
        if (cp != this.classPrefix || cn != this.className || mn != this.methodName || fn != this.fileName) {
            return new StackFrame(cp, cn, mn, fn, this.lineNumber);
        }
        return this;
    }

    @Override
    public int length() {
        return this.textLen;
    }

    @Override
    public char charAt(int index) {
        int mn;
        int cn;
        int pref;
        if (index > this.textLen - 1) {
            throw new IndexOutOfBoundsException();
        }
        if (index == this.textLen - 1) {
            return ')';
        }
        int n = pref = this.classPrefix == null ? 0 : this.classPrefix.length();
        if (pref > 0) {
            if (index < pref) {
                return this.classPrefix.charAt(index);
            }
            if (index == pref) {
                return '.';
            }
            ++pref;
        }
        if (index < (cn = pref + this.className.length())) {
            return this.className.charAt(index - pref);
        }
        if (index == cn) {
            return '.';
        }
        if (index < (mn = ++cn + this.methodName.length())) {
            return this.methodName.charAt(index - cn);
        }
        if (index == mn) {
            return '(';
        }
        ++mn;
        switch (this.lineNumberDigits) {
            case 0: {
                return this.fileName.charAt(index - mn);
            }
            case -1: {
                return UNKNOWN_SOURCE.charAt(index - mn);
            }
            case -2: {
                return NATIVE_METHOD.charAt(index - mn);
            }
        }
        int fn = mn + this.fileName.length();
        if (index < fn) {
            return this.fileName.charAt(index - mn);
        }
        if (index == fn) {
            return ':';
        }
        int d = this.lineNumberDigits - (index - fn);
        int p = PO10[d];
        return (char)(48 + this.lineNumber / p % 10);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        if (start > this.textLen || end > this.textLen) {
            throw new IndexOutOfBoundsException();
        }
        if (start > end) {
            throw new IllegalArgumentException();
        }
        return new Subsequence(this, start, end - start);
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StackFrame other = (StackFrame)obj;
        if (this.textLen != other.textLen || this.hash != other.hash) {
            return false;
        }
        if (this.fileName == null ? other.fileName != null : !this.fileName.equals(other.fileName)) {
            return false;
        }
        if (this.lineNumber != other.lineNumber) {
            return false;
        }
        if (this.methodName == null ? other.methodName != null : !this.methodName.equals(other.methodName)) {
            return false;
        }
        if (this.classPrefix != null && other.classPrefix != null) {
            if (!this.classPrefix.equals(other.classPrefix)) {
                return false;
            }
            if (!this.className.equals(other.className)) {
                return false;
            }
        } else if (this.classPrefix == null && other.classPrefix == null ? !this.className.equals(other.className) : (this.classPrefix == null ? !this.className.startsWith(other.classPrefix) || !this.className.endsWith(other.className) || this.className.charAt(other.classPrefix.length()) != '.' : !other.className.startsWith(this.classPrefix) || !other.className.endsWith(this.className) || other.className.charAt(this.classPrefix.length()) != '.')) {
            return false;
        }
        return true;
    }

    public StackTraceElement toStackTraceElement() {
        String cn = this.classPrefix == null ? this.className : this.classPrefix + '.' + this.className;
        return new StackTraceElement(cn, this.methodName, this.fileName, this.lineNumber);
    }

    @Override
    public String toString() {
        return StackFrame.toString(this);
    }

    private static String toString(CharSequence seq) {
        char[] buf = new char[seq.length()];
        for (int i = 0; i != buf.length; ++i) {
            buf[i] = seq.charAt(i);
        }
        return new String(buf);
    }

    public static StackFrame parseTrace(String line) {
        char ch;
        char ch2;
        StringBuilder sb = new StringBuilder(line.length());
        int dot1 = -1;
        int dot2 = -1;
        int n = 0;
        while ((ch2 = line.charAt(n)) != '(') {
            if (ch2 == '.') {
                dot2 = dot1;
                dot1 = n;
            }
            sb.append(ch2);
            if (++n < line.length()) continue;
            throw new IllegalArgumentException("Cannot parse [" + line + "]");
        }
        if (dot1 == -1) {
            throw new IllegalArgumentException("Cannot parse [" + line + "]");
        }
        String pref = null;
        String cn = null;
        String mn = null;
        if (dot2 != -1) {
            pref = sb.substring(0, dot2);
            cn = sb.substring(dot2 + 1, dot1);
            mn = sb.substring(dot1 + 1);
        } else {
            cn = sb.substring(0, dot1);
            mn = sb.substring(dot1 + 1);
        }
        sb.setLength(0);
        int col = -1;
        int off = ++n;
        while ((ch = line.charAt(n)) != ')') {
            if (ch == ':') {
                col = n - off;
            }
            sb.append(ch);
            if (++n < line.length()) continue;
            throw new IllegalArgumentException("Cannot parse [" + line + "]");
        }
        String file = null;
        int lnum = -1;
        if (col != -1) {
            file = sb.substring(0, col);
            try {
                lnum = Integer.parseInt(sb.substring(col + 1));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Number format exception '" + e.getMessage() + "' parsing [" + line + "]");
            }
        } else {
            file = sb.toString();
            if (file.equals(NATIVE_METHOD)) {
                file = null;
                lnum = -2;
            } else if (file.equals(UNKNOWN_SOURCE)) {
                file = null;
            }
        }
        return new StackFrame(pref, cn, mn, file, lnum);
    }

    private static class Subsequence
    implements CharSequence {
        private CharSequence seq;
        private int offs;
        private int len;

        public Subsequence(CharSequence seq, int offs, int len) {
            this.seq = seq;
            this.offs = offs;
            this.len = len;
        }

        @Override
        public int length() {
            return this.len;
        }

        @Override
        public char charAt(int index) {
            if (index >= this.len) {
                throw new IndexOutOfBoundsException();
            }
            return this.seq.charAt(this.offs + index);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            if (start > this.len || end > this.len) {
                throw new IndexOutOfBoundsException();
            }
            if (start > end) {
                throw new IllegalArgumentException();
            }
            return new Subsequence(this.seq, this.offs + start, end - start);
        }

        @Override
        public String toString() {
            return StackFrame.toString(this);
        }
    }
}

