/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.stacktrace.codec.json;

import org.gridkit.jvmtool.codec.stacktrace.ThreadSnapshotEventPojo;
import org.gridkit.jvmtool.event.GenericEvent;
import org.gridkit.jvmtool.stacktrace.StackFrameArray;
import org.gridkit.jvmtool.stacktrace.StackFrameList;
import org.gridkit.jvmtool.stacktrace.codec.json.JfrEventParser;
import org.gridkit.jvmtool.stacktrace.codec.json.JfrHelper;
import org.gridkit.jvmtool.stacktrace.codec.json.JsonStreamHandler;
import org.gridkit.jvmtool.stacktrace.codec.json.StackTraceHandler;
import org.gridkit.jvmtool.stacktrace.codec.json.ThreadInfoHandler;

class JfrNativeMethodSampleHandler
implements JsonStreamHandler.JsonObjectHandler {
    public static final String TYPE_ID = "jdk.NativeMethodSample";
    private final JfrEventParser parser;
    private GenericEvent event = new GenericEvent();
    private StackFrameList threadTrace;
    private ThreadInfoHandler threadInfo = new ThreadInfoHandler(){

        @Override
        protected void onComplete() {
            if (this.javaName != null) {
                JfrNativeMethodSampleHandler.this.event.tags().put("thread.javaName", this.javaName);
            }
            if (this.javaThreadId > 0L) {
                JfrNativeMethodSampleHandler.this.event.counters().set("thread.javaId", this.javaThreadId);
            }
        }
    };
    private StackTraceHandler stackTrace = new StackTraceHandler(){

        @Override
        protected void onComplete() {
            JfrNativeMethodSampleHandler.this.threadTrace = new StackFrameArray(this.frames);
        }
    };

    public JfrNativeMethodSampleHandler(JfrEventParser parser) {
        this.parser = parser;
    }

    @Override
    public void onScalarFieldValue(String fieldName, Object val) {
        if ("startTime".equals(fieldName)) {
            JfrHelper.setTimestamp(this.event, val);
        } else if ("state".equals(fieldName)) {
            JfrHelper.setThreadState(this.event, val);
        }
    }

    @Override
    public JsonStreamHandler.JsonEntityHandler onEntityField(String fieldName) {
        if ("sampledThread".equals(fieldName)) {
            return this.threadInfo;
        }
        if ("stackTrace".equals(fieldName)) {
            return this.stackTrace;
        }
        return JsonStreamHandler.NULL_HANDLER;
    }

    @Override
    public void onObjectComplete() {
        this.event.tags().put("jfr.typeId", TYPE_ID);
        ThreadSnapshotEventPojo cevent = new ThreadSnapshotEventPojo();
        cevent.loadFromRawEvent(this.event);
        cevent.stackTrace(this.threadTrace);
        this.parser.push(cevent);
        this.event = new GenericEvent();
        this.threadTrace = null;
    }
}

