/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.cmd;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.ParametersDelegate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServerConnection;
import org.gridkit.jvmtool.GlobHelper;
import org.gridkit.jvmtool.JmxConnectionInfo;
import org.gridkit.jvmtool.MBeanCpuUsageReporter;
import org.gridkit.jvmtool.PerfCounterGcCpuUsageMonitor;
import org.gridkit.jvmtool.PerfCounterSafePointMonitor;
import org.gridkit.jvmtool.cli.CommandLauncher;
import org.gridkit.jvmtool.cli.TimeIntervalConverter;

public class ThreadTopCmd
implements CommandLauncher.CmdRef {
    @Override
    public String getCommandName() {
        return "ttop";
    }

    @Override
    public Runnable newCommand(CommandLauncher host) {
        return new TTop(host);
    }

    @Parameters(commandDescription="[Thread Top] Displays threads from JVM process")
    public static class TTop
    implements Runnable {
        @ParametersDelegate
        private CommandLauncher host;
        @Parameter(names={"-ri", "--report-interval"}, converter=TimeIntervalConverter.class, description="Interval between CPU usage reports")
        private long reportIntervalMS = TimeUnit.SECONDS.toMillis(10L);
        @Parameter(names={"-si", "--sampler-interval"}, converter=TimeIntervalConverter.class, description="Interval between polling MBeans")
        private long samplerIntervalMS = 500L;
        @Parameter(names={"-n", "--top-number"}, description="Number of threads to show")
        private int topNumber = 20;
        @Parameter(names={"-o", "--order"}, variableArity=true, description="Sort order. Value tags: CPU, USER, SYS, ALLOC, NAME")
        private List<String> sortOrder = new ArrayList<String>(Arrays.asList("CPU"));
        @Parameter(names={"-f", "--filter"}, description="Wild card expression to filter threads by name")
        private String threadFilter;
        @ParametersDelegate
        private JmxConnectionInfo connInfo;

        public TTop(CommandLauncher host) {
            this.host = host;
            this.connInfo = new JmxConnectionInfo(host);
        }

        @Override
        public void run() {
            try {
                MBeanServerConnection mserver = this.connInfo.getMServer();
                MBeanCpuUsageReporter tmon = new MBeanCpuUsageReporter(mserver);
                if (this.connInfo.getPID() != null) {
                    try {
                        PerfCounterSafePointMonitor sm;
                        long pid = this.connInfo.getPID();
                        PerfCounterGcCpuUsageMonitor pm = new PerfCounterGcCpuUsageMonitor(pid);
                        if (pm.isAvailable()) {
                            tmon.setGcCpuUsageMonitor(pm);
                        }
                        if ((sm = new PerfCounterSafePointMonitor(pid)).isAvailable()) {
                            tmon.setSafePointMonitor(sm);
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                tmon.setTopLimit(this.topNumber);
                if (this.threadFilter != null) {
                    tmon.setThreadFilter(GlobHelper.translate(this.threadFilter, "\u0000"));
                }
                if (this.sortOrder != null) {
                    Collections.reverse(this.sortOrder);
                    for (String tag : this.sortOrder) {
                        if ("SYS".equals(tag)) {
                            tmon.sortBySysCpu();
                            continue;
                        }
                        if ("USER".equals(tag)) {
                            tmon.sortByUserCpu();
                            continue;
                        }
                        if ("CPU".equals(tag)) {
                            tmon.sortByTotalCpu();
                            continue;
                        }
                        if ("ALLOC".equals(tag)) {
                            tmon.sortByAllocRate();
                            continue;
                        }
                        if ("NAME".equals(tag)) {
                            tmon.sortByThreadName();
                            continue;
                        }
                        this.host.failAndPrintUsage("Invalid order option '" + tag + "'");
                    }
                }
                long deadline = System.currentTimeMillis() + Math.min(this.reportIntervalMS, 10L * this.samplerIntervalMS);
                tmon.report();
                System.out.println("Monitoring threads ...");
                while (true) {
                    if (System.currentTimeMillis() < deadline) {
                        Thread.sleep(this.samplerIntervalMS);
                        tmon.probe();
                        continue;
                    }
                    deadline += this.reportIntervalMS;
                    System.out.println();
                    System.out.println(tmon.report());
                    System.out.println();
                    if (System.in.available() > 0) break;
                }
                return;
            }
            catch (Exception e) {
                this.host.fail("Unexpected error: " + e.toString(), e);
                return;
            }
        }
    }
}

