/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.cmd;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.ParametersDelegate;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.gridkit.jvmtool.CategorizerParser;
import org.gridkit.jvmtool.StackHisto;
import org.gridkit.jvmtool.ThreadDumpSource;
import org.gridkit.jvmtool.cli.CommandLauncher;
import org.gridkit.jvmtool.codec.stacktrace.ThreadSnapshotEvent;
import org.gridkit.jvmtool.event.EventReader;
import org.gridkit.jvmtool.stacktrace.StackFrame;
import org.gridkit.jvmtool.stacktrace.StackFrameList;
import org.gridkit.jvmtool.stacktrace.analytics.CachingFilterFactory;
import org.gridkit.jvmtool.stacktrace.analytics.ParserException;
import org.gridkit.jvmtool.stacktrace.analytics.SimpleCategorizer;
import org.gridkit.jvmtool.stacktrace.analytics.ThreadDumpAggregatorFactory;
import org.gridkit.jvmtool.stacktrace.analytics.ThreadSnapshotCategorizer;
import org.gridkit.jvmtool.stacktrace.analytics.ThreadSnapshotFilter;
import org.gridkit.jvmtool.stacktrace.analytics.ThreadSplitAggregator;
import org.gridkit.jvmtool.stacktrace.analytics.TraceFilterPredicateParser;
import org.gridkit.jvmtool.stacktrace.analytics.flame.FlameGraphGenerator;
import org.gridkit.jvmtool.stacktrace.analytics.flame.RainbowColorPicker;
import org.gridkit.util.formating.Formats;
import org.gridkit.util.formating.TextTable;

public class StackSampleAnalyzerCmd
implements CommandLauncher.CmdRef {
    @Override
    public String getCommandName() {
        return "ssa";
    }

    @Override
    public Runnable newCommand(CommandLauncher host) {
        return new SSA(host);
    }

    static class DateFormater
    implements SummaryFormater {
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy.MM.dd_HH:mm:ss");

        public DateFormater(TimeZone tz) {
            this.fmt.setTimeZone(tz);
        }

        @Override
        public String toString(Object summary) {
            if (summary instanceof Long) {
                return this.fmt.format(summary);
            }
            return "";
        }
    }

    static class MemRateFormater
    implements SummaryFormater {
        MemRateFormater() {
        }

        @Override
        public String toString(Object summary) {
            double d;
            if (summary instanceof Number && !Double.isNaN(d = ((Number)summary).doubleValue())) {
                return Formats.toMemorySize((long)d) + "/s";
            }
            return "";
        }
    }

    static class PercentFormater
    implements SummaryFormater {
        PercentFormater() {
        }

        @Override
        public String toString(Object summary) {
            double d;
            if (summary instanceof Number && !Double.isNaN(d = ((Number)summary).doubleValue())) {
                return String.format("\t%.1f%%", 100.0 * d);
            }
            return "";
        }
    }

    static class DecimalFormater
    implements SummaryFormater {
        int n;

        public DecimalFormater(int n) {
            this.n = n;
        }

        @Override
        public String toString(Object summary) {
            if (summary instanceof Long) {
                return "\t" + summary;
            }
            if (summary instanceof Number) {
                return "\t" + String.format("%." + this.n + "f", ((Number)summary).doubleValue());
            }
            return "";
        }
    }

    static class RightFormater
    implements SummaryFormater {
        RightFormater() {
        }

        @Override
        public String toString(Object summary) {
            return "\t" + String.valueOf(summary);
        }
    }

    static class DefaultFormater
    implements SummaryFormater {
        DefaultFormater() {
        }

        @Override
        public String toString(Object summary) {
            return String.valueOf(summary);
        }
    }

    static interface SummaryFormater {
        public String toString(Object var1);
    }

    @Parameters(commandDescription="[Stack Sample Analyzer] Analyzing stack trace dumps")
    public static class SSA
    implements Runnable {
        @ParametersDelegate
        private final CommandLauncher host;
        @ParametersDelegate
        private final ThreadDumpSource dumpSource;
        @Parameter(names={"-cf", "--categorizer-file"}, required=false, description="Path to file with stack trace categorization definition")
        private String categorizerFile = null;
        @Parameter(names={"-nc", "--named-class"}, required=false, variableArity=true, description="May be used with some commands to define name stack trace classes\nUse <name>=<filter expression> notation")
        private List<String> namedClasses = new ArrayList<String>();
        @Parameter(names={"-tz", "--time-zone"}, required=false, description="Time zone used for timestamps")
        private String timeZone = "UTC";
        @Parameter(names={"-co", "--csv-output"}, required=false, description="Output data in CSV format")
        private boolean csvOutput = false;
        private List<SsaCmd> allCommands = new ArrayList<SsaCmd>();
        @ParametersDelegate
        private SsaCmd print = new PrintCmd();
        @ParametersDelegate
        private SsaCmd histo = new HistoCmd();
        @ParametersDelegate
        private SsaCmd flame = new FlameCmd();
        @ParametersDelegate
        private SsaCmd csummary = new CategorizeCmd();
        @ParametersDelegate
        private SsaCmd threadInfo = new ThreadInfoCmd();
        @ParametersDelegate
        private SsaCmd help = new HelpCmd();
        ThreadSnapshotCategorizer categorizer;

        public SSA(CommandLauncher host) {
            this.host = host;
            this.dumpSource = new ThreadDumpSource(host);
        }

        @Override
        public void run() {
            try {
                ArrayList<SsaCmd> action = new ArrayList<SsaCmd>();
                for (SsaCmd cmd : this.allCommands) {
                    if (!cmd.isSelected()) continue;
                    action.add(cmd);
                }
                if (action.isEmpty() || action.size() > 1) {
                    this.host.failAndPrintUsage("You should choose one of " + this.allCommands);
                }
                this.dumpSource.setTimeZone(this.timeZone());
                if (this.categorizerFile != null) {
                    if (!this.namedClasses.isEmpty()) {
                        this.host.failAndPrintUsage("You eigther should specify categorizer (-cf) or named classed (-nc)");
                    }
                    try {
                        FileReader csource = new FileReader(this.categorizerFile);
                        SimpleCategorizer sc = new SimpleCategorizer();
                        CachingFilterFactory cff = new CachingFilterFactory();
                        CategorizerParser.loadCategories(csource, sc, false, cff);
                        this.categorizer = sc;
                    }
                    catch (ParserException e) {
                        throw this.host.fail("Failed to parse filter expression at [" + e.getOffset() + "] : " + e.getMessage(), e.getParseText());
                    }
                }
                ((Runnable)action.get(0)).run();
            }
            catch (Exception e) {
                this.host.fail(e.toString(), e);
            }
        }

        TimeZone timeZone() {
            return TimeZone.getTimeZone(this.timeZone);
        }

        Map<String, ThreadSnapshotFilter> getNamedClasses() {
            if (this.namedClasses.isEmpty()) {
                return new HashMap<String, ThreadSnapshotFilter>();
            }
            CachingFilterFactory factory = new CachingFilterFactory();
            LinkedHashMap<String, ThreadSnapshotFilter> classes = new LinkedHashMap<String, ThreadSnapshotFilter>();
            for (String nc : this.namedClasses) {
                int n = nc.indexOf(61);
                if (n < 0) {
                    throw this.host.fail("Cannot parse named class", "[" + nc + "]", "Required format NAME=FILTER_EXPRESSION");
                }
                String name = nc.substring(0, n);
                String filter = nc.substring(n + 1);
                if (classes.containsKey(name)) {
                    throw this.host.fail("Duplicated class name [" + name + "]");
                }
                try {
                    ThreadSnapshotFilter tf = TraceFilterPredicateParser.parseFilter(filter, factory);
                    classes.put(name, tf);
                }
                catch (ParserException e) {
                    throw this.host.fail("Cannot parse named class", "[" + nc + "]", e.getMessage());
                }
            }
            return classes;
        }

        ThreadSnapshotFilter parseFilter(String filter) {
            CachingFilterFactory factory = new CachingFilterFactory();
            ThreadSnapshotFilter tf = TraceFilterPredicateParser.parseFilter(filter, factory);
            return tf;
        }

        EventReader<ThreadSnapshotEvent> getFilteredReader() {
            return this.dumpSource.getFilteredReader();
        }

        EventReader<ThreadSnapshotEvent> getUnclassifiedReader() {
            return this.dumpSource.getUnclassifiedReader();
        }

        public class HelpCmd
        extends SsaCmd {
            @Parameter(names={"--ssa-help"}, description="Additional information about SSA")
            boolean run;

            @Override
            public boolean isSelected() {
                return this.run;
            }

            @Override
            public void run() {
                try {
                    int n;
                    InputStream is = this.getClass().getResourceAsStream("ssa-help.md");
                    if (is == null) {
                        System.out.println("Failed to load help");
                        return;
                    }
                    System.out.println();
                    byte[] buf = new byte[4096];
                    while ((n = is.read(buf)) >= 0) {
                        System.out.write(buf, 0, n);
                    }
                    System.out.println();
                }
                catch (IOException e) {
                    System.out.println("Failed to load help");
                }
            }

            public String toString() {
                return "--ssa-help";
            }
        }

        class ThreadInfoCmd
        extends SsaCmd {
            @Parameter(names={"--thread-info"}, description="Per thread info summary")
            boolean run;
            @Parameter(names={"-si", "--summary-info"}, variableArity=true, description="List of summaries")
            List<String> summaryInfo;
            List<String> summaryNames;
            List<ThreadDumpAggregatorFactory> summaries;
            List<SummaryFormater> summaryFormaters;

            ThreadInfoCmd() {
                this.summaryNames = new ArrayList<String>();
                this.summaries = new ArrayList<ThreadDumpAggregatorFactory>();
                this.summaryFormaters = new ArrayList<SummaryFormater>();
            }

            @Override
            public boolean isSelected() {
                return this.run;
            }

            void add(String name, ThreadDumpAggregatorFactory summary) {
                this.add(name, summary, new DefaultFormater());
            }

            void add(String name, ThreadDumpAggregatorFactory summary, SummaryFormater formater) {
                this.summaryNames.add(name + " ");
                this.summaries.add(summary);
                this.summaryFormaters.add(formater);
            }

            @Override
            public void run() {
                try {
                    if (this.summaryInfo == null || this.summaryInfo.isEmpty()) {
                        this.add("Name", ThreadDumpAggregatorFactory.COMMON.name());
                        this.add("Count", ThreadDumpAggregatorFactory.COMMON.count(), new RightFormater());
                        this.add("On CPU", ThreadDumpAggregatorFactory.COMMON.cpu(), new PercentFormater());
                        this.add("Alloc ", ThreadDumpAggregatorFactory.COMMON.alloc(), new MemRateFormater());
                        this.add("RUNNABLE", ThreadDumpAggregatorFactory.COMMON.threadState(Thread.State.RUNNABLE), new PercentFormater());
                        this.add("Native", ThreadDumpAggregatorFactory.COMMON.inNative(), new PercentFormater());
                    } else {
                        for (String si : this.summaryInfo) {
                            this.addSummary(si);
                        }
                    }
                    ThreadSplitAggregator threadAgg = new ThreadSplitAggregator(this.summaries.toArray(new ThreadDumpAggregatorFactory[0]));
                    EventReader<ThreadSnapshotEvent> reader = SSA.this.getFilteredReader();
                    for (ThreadSnapshotEvent e : reader) {
                        threadAgg.feed(e);
                    }
                    TextTable tt = new TextTable();
                    tt.addRow(this.summaryNames);
                    int n = 0;
                    for (Object[] row : threadAgg.report()) {
                        ++n;
                        String[] frow = new String[this.summaries.size()];
                        for (int i = 0; i != this.summaries.size(); ++i) {
                            SummaryFormater sf = this.summaryFormaters.get(i);
                            frow[i] = sf.toString(row[i + 2]) + " ";
                        }
                        tt.addRow(frow);
                    }
                    if (n > 0) {
                        if (SSA.this.csvOutput) {
                            System.out.println(TextTable.formatCsv(tt));
                        } else {
                            System.out.println(tt.formatTextTableUnbordered(80));
                        }
                    } else {
                        System.out.println("No data");
                    }
                }
                catch (Exception e) {
                    SSA.this.host.fail(e.toString(), e);
                }
            }

            private void addSummary(String si) {
                if ("NAME".equals(si = si.trim())) {
                    this.add("Name", ThreadDumpAggregatorFactory.COMMON.name());
                }
                if (si.startsWith("NAME") && si.indexOf(61) < 0) {
                    int n = Integer.valueOf(si.substring(4));
                    this.add("Name", ThreadDumpAggregatorFactory.COMMON.name(n));
                } else if ("COUNT".equals(si)) {
                    this.add("Count", ThreadDumpAggregatorFactory.COMMON.count(), new RightFormater());
                } else if ("TSMIN".equals(si)) {
                    this.add("First time", ThreadDumpAggregatorFactory.COMMON.minTimestamp(), new DateFormater(SSA.this.timeZone()));
                } else if ("TSMAX".equals(si)) {
                    this.add("Last time", ThreadDumpAggregatorFactory.COMMON.maxTimestamp(), new DateFormater(SSA.this.timeZone()));
                } else if ("CPU".equals(si)) {
                    this.add("On CPU", ThreadDumpAggregatorFactory.COMMON.cpu(), new PercentFormater());
                } else if ("ALLOC".equals(si)) {
                    this.add("Alloc ", ThreadDumpAggregatorFactory.COMMON.alloc(), new MemRateFormater());
                } else if (si.startsWith("S:")) {
                    Thread.State st = Thread.State.valueOf(si.substring(2));
                    this.add(st.toString(), ThreadDumpAggregatorFactory.COMMON.threadState(st), new PercentFormater());
                } else if ("NATIVE".equals(si)) {
                    this.add("Native", ThreadDumpAggregatorFactory.COMMON.inNative(), new PercentFormater());
                } else if (Pattern.matches(".*=.*", si)) {
                    String[] p = si.split("[=]");
                    if (p.length != 2) {
                        this.badSummary(si);
                    }
                    ThreadSnapshotFilter ts = SSA.this.parseFilter(p[1]);
                    this.add(p[0], ThreadDumpAggregatorFactory.COMMON.threadFilter(ts), new PercentFormater());
                } else if ("FREQ".equals(si)) {
                    this.add("Freq.", ThreadDumpAggregatorFactory.COMMON.frequency(), new DecimalFormater(1));
                } else if ("FREQ_HM".equals(si)) {
                    this.add("Freq. (1/HM)", ThreadDumpAggregatorFactory.COMMON.frequencyHM(), new DecimalFormater(1));
                } else if ("GAP_CHM".equals(si)) {
                    this.add("Gap CHM", ThreadDumpAggregatorFactory.COMMON.periodCHM(), new DecimalFormater(3));
                } else {
                    this.badSummary(si);
                }
            }

            private void badSummary(String si) {
                SSA.this.host.fail("Unknown summary '" + si + "'", "Allowed summaries are", "  NAME", "  NAME<len>", "  COUNT", "  TSMIN", "  TSMAX", "  CPU", "  ALLOC", "  NATIVE", "  FREQ", "  FREQ_HM", "  GAP_CHM", "  S:[RUNNABLE|BLOCKED|WAITING|TIMED_WAITING]", "  <name>=<filter expression>");
            }

            public String toString() {
                return "--categorize";
            }
        }

        class CategorizeCmd
        extends SsaCmd {
            @Parameter(names={"--categorize"}, description="Print summary for provided categorization")
            boolean run;

            CategorizeCmd() {
            }

            @Override
            public boolean isSelected() {
                return this.run;
            }

            @Override
            public void run() {
                try {
                    ThreadSnapshotCategorizer cat = SSA.this.categorizer;
                    if (SSA.this.categorizer == null && !SSA.this.namedClasses.isEmpty()) {
                        SimpleCategorizer sc = new SimpleCategorizer();
                        Map<String, ThreadSnapshotFilter> nf = SSA.this.getNamedClasses();
                        for (String fn : nf.keySet()) {
                            sc.addCategory(fn, nf.get(fn));
                        }
                        cat = sc;
                    }
                    if (cat == null) {
                        throw SSA.this.host.fail("Neigther -cf nor -nc. Eigther of them is required.");
                    }
                    ArrayList<String> bucketNames = new ArrayList<String>(cat.getCategories());
                    long[] counters = new long[bucketNames.size()];
                    long total = 0L;
                    EventReader<ThreadSnapshotEvent> reader = SSA.this.getUnclassifiedReader();
                    for (ThreadSnapshotEvent e : reader) {
                        String cl = cat.categorize(e);
                        if (cl == null) continue;
                        ++total;
                        int n = bucketNames.indexOf(cl);
                        counters[n] = counters[n] + 1L;
                    }
                    TextTable tt = new TextTable();
                    String tab = SSA.this.csvOutput ? "" : "\t ";
                    tt.addRow("Total samples", tab + total, tab + "100.00%");
                    for (int i = 0; i != counters.length; ++i) {
                        tt.addRow((String)bucketNames.get(i), tab + counters[i], tab + (counters[i] == 0L ? "0.00%" : String.format("%.2f%%", Float.valueOf(100.0f * (float)counters[i] / (float)total))));
                    }
                    if (SSA.this.csvOutput) {
                        System.out.println(TextTable.formatCsv(tt));
                    } else {
                        System.out.println(tt.formatTextTableUnbordered(Integer.MAX_VALUE));
                    }
                }
                catch (Exception e) {
                    SSA.this.host.fail(e.toString(), e);
                }
            }

            public String toString() {
                return "--categorize";
            }
        }

        class FlameCmd
        extends SsaCmd {
            @Parameter(names={"--flame"}, description="Export flame graph to SVG format")
            boolean run;
            @Parameter(names={"--title"}, description="Flame graph title")
            String title;
            @Parameter(names={"--width"}, description="Flame graph width in pixels")
            int width;
            @Parameter(names={"-rc", "--rainbow"}, variableArity=true, description="List of filters for rainbow coloring")
            List<String> rainbow;

            FlameCmd() {
                this.title = "Flame Graph";
                this.width = 1200;
            }

            @Override
            public boolean isSelected() {
                return this.run;
            }

            @Override
            public void run() {
                try {
                    FlameGraphGenerator fg = new FlameGraphGenerator();
                    if (this.rainbow != null && this.rainbow.size() > 0) {
                        ThreadSnapshotFilter[] filters = new ThreadSnapshotFilter[this.rainbow.size()];
                        CachingFilterFactory factory = new CachingFilterFactory();
                        for (int i = 0; i != this.rainbow.size(); ++i) {
                            filters[i] = TraceFilterPredicateParser.parseFilter(this.rainbow.get(i), factory);
                        }
                        fg.setColorPicker(new RainbowColorPicker(filters));
                    }
                    EventReader<ThreadSnapshotEvent> reader = SSA.this.getFilteredReader();
                    int n = 0;
                    for (ThreadSnapshotEvent e : reader) {
                        StackFrameList trace = e.stackTrace();
                        fg.feed(trace);
                        ++n;
                    }
                    if (n > 0) {
                        OutputStreamWriter w = new OutputStreamWriter(System.out);
                        fg.renderSVG(this.title, this.width, w);
                        ((Writer)w).flush();
                    } else {
                        System.out.println("No data");
                    }
                }
                catch (Exception e) {
                    SSA.this.host.fail(e.toString(), e);
                }
            }

            public String toString() {
                return "--histo";
            }
        }

        class HistoCmd
        extends SsaCmd {
            @Parameter(names={"--histo"}, description="Print frame histogram")
            boolean run;

            HistoCmd() {
            }

            @Override
            public boolean isSelected() {
                return this.run;
            }

            @Override
            public void run() {
                try {
                    StackHisto histo = new StackHisto();
                    for (Map.Entry<String, ThreadSnapshotFilter> entry : SSA.this.getNamedClasses().entrySet()) {
                        histo.addCondition(entry.getKey(), entry.getValue());
                    }
                    EventReader<ThreadSnapshotEvent> reader = SSA.this.getFilteredReader();
                    int n = 0;
                    for (ThreadSnapshotEvent e : reader) {
                        StackFrameList trace = e.stackTrace();
                        histo.feed(trace);
                        ++n;
                    }
                    if (n > 0) {
                        if (SSA.this.csvOutput) {
                            System.out.println(histo.formatHistoToCSV());
                        } else {
                            System.out.println(histo.formatHisto());
                        }
                    } else {
                        System.out.println("No data");
                    }
                }
                catch (Exception e) {
                    SSA.this.host.fail(e.toString(), e);
                }
            }

            public String toString() {
                return "--histo";
            }
        }

        class PrintCmd
        extends SsaCmd {
            @Parameter(names={"--print"}, description="Print traces from file")
            boolean run;

            PrintCmd() {
            }

            @Override
            public boolean isSelected() {
                return this.run;
            }

            @Override
            public void run() {
                try {
                    EventReader<ThreadSnapshotEvent> reader = SSA.this.getFilteredReader();
                    SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
                    fmt.setTimeZone(SSA.this.timeZone());
                    StringBuilder threadHeader = new StringBuilder();
                    StringBuilder stackFrameBuffer = new StringBuilder();
                    for (ThreadSnapshotEvent e : reader) {
                        String timestamp = fmt.format(e.timestamp());
                        threadHeader.append("Thread [").append(e.threadId()).append("] ");
                        if (e.threadState() != null) {
                            threadHeader.append((Object)e.threadState()).append(' ');
                        }
                        threadHeader.append("at ").append(timestamp);
                        if (e.threadName() != null) {
                            threadHeader.append(" - ").append(e.threadName());
                        }
                        System.out.println(threadHeader);
                        StackFrameList trace = e.stackTrace();
                        for (StackFrame frame : trace) {
                            frame.toString(stackFrameBuffer);
                            System.out.println(stackFrameBuffer);
                            stackFrameBuffer.setLength(0);
                        }
                        System.out.println();
                        threadHeader.setLength(0);
                    }
                }
                catch (Exception e) {
                    SSA.this.host.fail(e.toString(), e);
                }
            }

            public String toString() {
                return "--print";
            }
        }

        abstract class SsaCmd
        implements Runnable {
            public SsaCmd() {
                SSA.this.allCommands.add(this);
            }

            public abstract boolean isSelected();
        }
    }
}

