/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.nps.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.gridkit.jvmtool.stacktrace.StackFrame;
import org.netbeans.lib.profiler.results.CCTNode;
import org.netbeans.lib.profiler.results.cpu.CPUResultsSnapshot;
import org.netbeans.lib.profiler.results.cpu.PrestimeCPUCCTNode;

class NpsDumpTree {
    private final CPUResultsSnapshot snapshot;
    private StackFrame[] frameCache = new StackFrame[256];
    private long gcd = 0L;
    List<Node> globalList = new ArrayList<Node>();

    public NpsDumpTree(CPUResultsSnapshot snapshot) {
        this.snapshot = snapshot;
        PrestimeCPUCCTNode root = snapshot.getRootNode(0);
        this.makeTree(null, root);
        this.initSelfTime();
        this.quantize();
    }

    private void initSelfTime() {
        for (Node n : this.globalList) {
            long tt = n.time;
            for (Node cn : n.children) {
                tt -= cn.time;
            }
            n.selfTime = tt;
            this.gcd = this.gcd(this.gcd, tt);
        }
    }

    private void quantize() {
        for (Node n : this.globalList) {
            n.vsampleSelfCount = n.selfTime / this.gcd;
        }
    }

    private long gcd(long a, long b) {
        if (a == 0L) {
            return b;
        }
        if (b == 0L) {
            return a;
        }
        if (a > b) {
            return this.gcd(b, a % b);
        }
        return this.gcd(a, b % a);
    }

    private void makeTree(Node parent, PrestimeCPUCCTNode node) {
        block6: {
            Node tnode;
            StackFrame frame;
            block5: {
                if (node.isSelfTimeNode()) {
                    return;
                }
                frame = this.frame(node.getMethodId());
                if (frame != null) break block5;
                for (CCTNode cnode : node.getChildren()) {
                    this.makeTree(null, (PrestimeCPUCCTNode)cnode);
                }
                break block6;
            }
            if (parent == null) {
                tnode = new Node(frame);
                tnode.threadId = ((PrestimeCPUCCTNode)node.getParent()).getThreadId();
            } else {
                tnode = new Node(parent, frame);
            }
            this.globalList.add(tnode);
            tnode.time = (long)(262144.0 * (0.01 * (double)node.getTotalTime0InPerCent()));
            if (node.getChildren() == null) break block6;
            for (CCTNode cnode : node.getChildren()) {
                this.makeTree(tnode, (PrestimeCPUCCTNode)cnode);
            }
        }
    }

    private StackFrame frame(int id) {
        if (id == 0) {
            return null;
        }
        if (this.frameCache.length <= id) {
            this.frameCache = Arrays.copyOf(this.frameCache, Math.max(2 * this.frameCache.length, id + 1));
        }
        if (this.frameCache[id] == null) {
            StackFrame sf;
            String[] mi = this.snapshot.getMethodClassNameAndSig(id, 0);
            String cn = mi[0];
            String m = mi[1];
            boolean ntv = false;
            if (m.endsWith("[native]")) {
                ntv = true;
                m = m.substring(0, m.length() - "[native]".length());
            }
            this.frameCache[id] = sf = new StackFrame("", cn, m, null, ntv ? -2 : -1);
        }
        return this.frameCache[id];
    }

    static class Node {
        StackFrame[] path;
        int threadId;
        long time;
        long selfTime;
        long vsampleSelfCount;
        List<Node> children = new ArrayList<Node>();

        public Node(StackFrame path) {
            this.path = new StackFrame[]{path};
        }

        public Node(Node parent, StackFrame path) {
            this.path = new StackFrame[parent.path.length + 1];
            this.path[0] = path;
            System.arraycopy(parent.path, 0, this.path, 1, parent.path.length);
            this.threadId = parent.threadId;
            parent.children.add(this);
        }
    }
}

