/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.stacktrace.analytics;

import org.gridkit.jvmtool.stacktrace.ThreadSnapshot;
import org.gridkit.jvmtool.stacktrace.analytics.ThreadDumpAggregator;
import org.gridkit.jvmtool.stacktrace.analytics.ThreadDumpAggregatorFactory;
import org.gridkit.jvmtool.stacktrace.analytics.ThreadSnapshotFilter;
import org.gridkit.jvmtool.stacktrace.analytics.WeigthCalculator;

class FilterAggregatorFactory
implements ThreadDumpAggregator,
ThreadDumpAggregatorFactory {
    private final ThreadSnapshotFilter filter;
    private final WeigthCalculator calc;
    private long total;
    private long matched;

    public FilterAggregatorFactory(ThreadSnapshotFilter filter, WeigthCalculator calc) {
        this.filter = filter;
        this.calc = calc;
    }

    @Override
    public ThreadDumpAggregator newInstance() {
        return new FilterAggregatorFactory(this.filter, this.calc);
    }

    @Override
    public void aggregate(ThreadSnapshot threadInfo) {
        long w = this.calc.getWeigth(threadInfo);
        this.total += w;
        if (this.filter.evaluate(threadInfo)) {
            this.matched += w;
        }
    }

    @Override
    public Object info() {
        return (double)this.matched / (double)this.total;
    }
}

