/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.cmd;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParametersDelegate;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.lang.reflect.Array;
import java.rmi.UnmarshalException;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeMBeanException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;
import org.gridkit.jvmtool.JmxConnectionInfo;
import org.gridkit.jvmtool.cli.CommandLauncher;
import org.gridkit.jvmtool.jackson.JsonGenerator;
import org.gridkit.jvmtool.jackson.JsonMiniFactory;

public class MxDumpCmd
implements CommandLauncher.CmdRef {
    public String getCommandName() {
        return "mxdump";
    }

    public Runnable newCommand(CommandLauncher host) {
        return new MxDump(host);
    }

    public static class MxDump
    implements Runnable {
        @ParametersDelegate
        private CommandLauncher host;
        @Parameter(names={"-q", "--query"}, description="Query to filter MBeans")
        private String query;
        @ParametersDelegate
        private JmxConnectionInfo conn;

        public MxDump(CommandLauncher host) {
            this.host = host;
            this.conn = new JmxConnectionInfo(host);
        }

        @Override
        public void run() {
            try {
                ObjectName q = null;
                if (this.query != null) {
                    q = new ObjectName(this.query);
                }
                MBeanServerConnection jmx = this.conn.getMServer();
                JsonGenerator jg = JsonMiniFactory.createJsonGenerator(new OutputStreamWriter(System.out));
                jg.useDefaultPrettyPrinter();
                jg.writeStartObject();
                MxDump.listBeans(q, jg, jmx);
                jg.writeEndObject();
                jg.flush();
                System.out.println();
                System.out.flush();
            }
            catch (Exception e) {
                this.host.fail(new String[]{e.toString()});
            }
        }

        private static void listBeans(ObjectName query, JsonGenerator jg, MBeanServerConnection mBeanServer) throws Exception {
            Set<ObjectName> names = null;
            names = mBeanServer.queryNames(query, null);
            jg.writeArrayFieldStart("beans");
            for (ObjectName oname : names) {
                String code = "";
                MBeanInfo minfo = mBeanServer.getMBeanInfo(oname);
                code = minfo.getClassName();
                String prs = "";
                if ("org.apache.commons.modeler.BaseModelMBean".equals(code)) {
                    prs = "modelerType";
                    code = (String)mBeanServer.getAttribute(oname, prs);
                }
                jg.writeStartObject();
                jg.writeStringField("name", oname.toString());
                jg.writeStringField("modelerType", code);
                MBeanAttributeInfo[] attrs = minfo.getAttributes();
                for (int i = 0; i < attrs.length; ++i) {
                    MxDump.writeAttribute(mBeanServer, jg, oname, attrs[i]);
                }
                jg.writeEndObject();
            }
            jg.writeEndArray();
        }

        private static void writeAttribute(MBeanServerConnection mBeanServer, JsonGenerator jg, ObjectName oname, MBeanAttributeInfo attr) throws IOException {
            if (!attr.isReadable()) {
                return;
            }
            String attName = attr.getName();
            if ("modelerType".equals(attName)) {
                return;
            }
            if (attName.indexOf("=") >= 0 || attName.indexOf(":") >= 0 || attName.indexOf(" ") >= 0) {
                return;
            }
            Object value = null;
            try {
                value = mBeanServer.getAttribute(oname, attName);
            }
            catch (AttributeNotFoundException e) {
                return;
            }
            catch (MBeanException e) {
                MxDump.error("getting attribute " + attName + " of " + oname + " threw an exception", e);
                return;
            }
            catch (RuntimeMBeanException e) {
                if (!(e.getCause() instanceof UnsupportedOperationException)) {
                    MxDump.error("getting attribute " + attName + " of " + oname + " threw " + "an exception", e);
                }
                return;
            }
            catch (RuntimeException e) {
                MxDump.error("getting attribute " + attName + " of " + oname + " threw an exception", e);
                return;
            }
            catch (ReflectionException e) {
                MxDump.error("getting attribute " + attName + " of " + oname + " threw an exception", e);
                return;
            }
            catch (UnmarshalException e) {
                MxDump.error("getting attribute " + attName + " of " + oname + " threw an exception", e);
                return;
            }
            catch (InstanceNotFoundException e) {
                return;
            }
            MxDump.writeAttribute(jg, attName, value);
        }

        private static void error(String string, Throwable e) {
            System.err.print(string);
            e.printStackTrace(System.err);
        }

        private static void writeAttribute(JsonGenerator jg, String attName, Object value) throws IOException {
            jg.writeFieldName(attName);
            MxDump.writeObject(jg, value);
        }

        private static void writeObject(JsonGenerator jg, Object value) throws IOException {
            if (value == null) {
                jg.writeNull();
            } else {
                Class<?> c = value.getClass();
                if (c.isArray()) {
                    jg.writeStartArray();
                    int len = Array.getLength(value);
                    for (int j = 0; j < len; ++j) {
                        Object item = Array.get(value, j);
                        MxDump.writeObject(jg, item);
                    }
                    jg.writeEndArray();
                } else if (value instanceof Number) {
                    Number n = (Number)value;
                    jg.writeNumber(n.toString());
                } else if (value instanceof Boolean) {
                    Boolean b = (Boolean)value;
                    jg.writeBoolean(b);
                } else if (value instanceof CompositeData) {
                    CompositeData cds = (CompositeData)value;
                    CompositeType comp = cds.getCompositeType();
                    Set<String> keys = comp.keySet();
                    jg.writeStartObject();
                    for (String key : keys) {
                        MxDump.writeAttribute(jg, key, cds.get(key));
                    }
                    jg.writeEndObject();
                } else if (value instanceof TabularData) {
                    TabularData tds = (TabularData)value;
                    jg.writeStartArray();
                    for (Object entry : tds.values()) {
                        MxDump.writeObject(jg, entry);
                    }
                    jg.writeEndArray();
                } else {
                    jg.writeString(value.toString());
                }
            }
        }
    }
}

