/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.taglib;

import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.web.taglib.GrailsTag;
import org.codehaus.groovy.grails.web.taglib.GrailsTagRegistry;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.util.Assert;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.support.RequestContextUtils;
import org.springframework.web.util.UrlPathHelper;

public abstract class RequestContextTag
implements GrailsTag {
    protected Writer out;
    protected Map attributes = new HashMap();
    protected ServletRequest request;
    protected String contextPath;
    protected UrlPathHelper urlPathHelper = new UrlPathHelper();
    protected GrailsTagRegistry registry;
    private boolean init;
    protected BeanWrapper bean;
    protected ServletContext servletContext;
    protected ServletResponse response;
    protected WebApplicationContext applicationContext;
    protected GrailsApplication grailsApplication;
    private String name;

    protected RequestContextTag(String name) {
        this.name = name;
        this.bean = new BeanWrapperImpl((Object)this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void init(Map context) {
        Assert.notNull((Object)context, (String)"Argument 'context' cannot be null");
        this.out = (Writer)context.get("out");
        this.request = (ServletRequest)context.get("request");
        this.servletContext = (ServletContext)context.get("application");
        this.response = (ServletResponse)context.get("response");
        this.applicationContext = RequestContextUtils.getWebApplicationContext((ServletRequest)this.request, (ServletContext)this.servletContext);
        this.grailsApplication = (GrailsApplication)this.applicationContext.getBean("grailsApplication");
        this.attributes = context.get("attributes") == null ? new HashMap() : (Map)context.get("attributes");
        this.contextPath = this.urlPathHelper.getContextPath((HttpServletRequest)this.request);
        this.init = true;
    }

    @Override
    public void setAttribute(String name, Object value) {
        if (this.bean.isWritableProperty(name)) {
            this.bean.setPropertyValue(name, value);
        } else {
            this.attributes.put(name, value);
        }
    }

    public GrailsTagRegistry getRegistry() {
        return this.registry;
    }

    @Override
    public void setWriter(Writer w) {
        this.out = w;
    }

    @Override
    public void setAttributes(Map attributes) {
        this.attributes = attributes;
    }

    @Override
    public final void doStartTag() {
        Assert.state((boolean)this.init, (String)"Tag not initialised called 'init' first");
        this.doStartTagInternal();
    }

    protected abstract void doStartTagInternal();

    protected abstract void doEndTagInternal();

    @Override
    public final void doEndTag() {
        Assert.state((boolean)this.init, (String)"Tag not initialised called 'init' first");
        this.doEndTagInternal();
    }
}

