/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.servlet.mvc;

import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.web.binding.DataBindingUtils;
import org.codehaus.groovy.grails.web.binding.StructuredDateEditor;
import org.codehaus.groovy.grails.web.binding.bindingsource.DataBindingSourceRegistry;
import org.codehaus.groovy.grails.web.mime.MimeType;
import org.codehaus.groovy.grails.web.mime.MimeTypeResolver;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsWebRequest;
import org.codehaus.groovy.grails.web.servlet.mvc.exceptions.ControllerExecutionException;
import org.codehaus.groovy.grails.web.util.TypeConvertingMap;
import org.codehaus.groovy.grails.web.util.WebUtils;
import org.grails.databinding.DataBindingSource;
import org.grails.databinding.SimpleMapDataBindingSource;
import org.springframework.context.ApplicationContext;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.web.multipart.MultipartHttpServletRequest;

public class GrailsParameterMap
extends TypeConvertingMap
implements Cloneable {
    private static final Log LOG = LogFactory.getLog(GrailsParameterMap.class);
    private static final Map<String, String> CACHED_DATE_FORMATS = new ConcurrentHashMap<String, String>();
    private final HttpServletRequest request;
    public static final String REQUEST_BODY_PARSED = "org.codehaus.groovy.grails.web.REQUEST_BODY_PARSED";
    public static final Object[] EMPTY_ARGS = new Object[0];
    private final Map nestedDateMap = new LinkedHashMap();

    public GrailsParameterMap(Map values, HttpServletRequest request) {
        this.request = request;
        this.wrappedMap.putAll(values);
    }

    public GrailsParameterMap(HttpServletRequest request) {
        String contentType;
        this.request = request;
        LinkedHashMap<String, Object> requestMap = new LinkedHashMap<String, Object>(request.getParameterMap());
        if (requestMap.isEmpty() && "PUT".equals(request.getMethod()) && request.getAttribute(REQUEST_BODY_PARSED) == null && "application/x-www-form-urlencoded".equals(contentType = request.getContentType())) {
            try {
                String contents = IOUtils.toString((Reader)request.getReader());
                request.setAttribute(REQUEST_BODY_PARSED, (Object)true);
                requestMap.putAll(WebUtils.fromQueryString(contents));
            }
            catch (Exception e) {
                LOG.error((Object)"Error processing form encoded PUT request", (Throwable)e);
            }
        }
        if (request instanceof MultipartHttpServletRequest) {
            Map fileMap = ((MultipartHttpServletRequest)request).getFileMap();
            for (Map.Entry entry : fileMap.entrySet()) {
                requestMap.put((String)entry.getKey(), entry.getValue());
            }
        }
        this.updateNestedKeys(requestMap);
    }

    DataBindingSource toBindingSource(Class targetType) {
        GrailsWebRequest webRequest = GrailsWebRequest.lookup(this.request);
        ApplicationContext context = webRequest.getApplicationContext();
        DataBindingSourceRegistry dataBindingSourceRegistry = null;
        if (context.containsBean("dataBindingSourceRegistry")) {
            dataBindingSourceRegistry = (DataBindingSourceRegistry)context.getBean("dataBindingSourceRegistry", DataBindingSourceRegistry.class);
        }
        MimeTypeResolver mimeTypeResolver = null;
        if (context.containsBean("mimeTypeResolver")) {
            mimeTypeResolver = (MimeTypeResolver)context.getBean("mimeTypeResolver", MimeTypeResolver.class);
        }
        MimeType mimeType = DataBindingUtils.resolveMimeType(this, mimeTypeResolver);
        return dataBindingSourceRegistry != null ? dataBindingSourceRegistry.createDataBindingSource(mimeType, targetType, this) : new SimpleMapDataBindingSource((Map)this);
    }

    void updateNestedKeys(Map keys) {
        for (Object keyObject : keys.keySet()) {
            String key = (String)keyObject;
            Object paramValue = this.getParameterValue(keys, key);
            this.wrappedMap.put(key, paramValue);
            this.processNestedKeys(keys, key, key, this.wrappedMap);
        }
    }

    @Override
    public Object clone() {
        if (this.wrappedMap.isEmpty()) {
            return new GrailsParameterMap(new LinkedHashMap(), this.request);
        }
        LinkedHashMap clonedMap = new LinkedHashMap(this.wrappedMap);
        for (Map.Entry entry : clonedMap.entrySet()) {
            if (!(entry.getValue() instanceof GrailsParameterMap)) continue;
            entry.setValue(((GrailsParameterMap)entry.getValue()).clone());
        }
        return new GrailsParameterMap(clonedMap, this.request);
    }

    public void addParametersFrom(GrailsParameterMap otherMap) {
        this.wrappedMap.putAll((GrailsParameterMap)otherMap.clone());
    }

    private Object getParameterValue(Map requestMap, String key) {
        Object paramValue = requestMap.get(key);
        if (paramValue instanceof String[] && ((String[])paramValue).length == 1) {
            paramValue = ((String[])paramValue)[0];
        }
        return paramValue;
    }

    private void processNestedKeys(Map requestMap, String key, String nestedKey, Map nestedLevel) {
        Object prefixValue;
        int nestedIndex = nestedKey.indexOf(46);
        if (nestedIndex == -1) {
            return;
        }
        String nestedPrefix = nestedKey.substring(0, nestedIndex);
        boolean prefixedByUnderscore = false;
        if (nestedPrefix.startsWith("_")) {
            prefixedByUnderscore = true;
            nestedPrefix = nestedPrefix.substring(1);
        }
        if ((prefixValue = nestedLevel.get(nestedPrefix)) == null) {
            prefixValue = new GrailsParameterMap(new LinkedHashMap(), this.request);
            nestedLevel.put(nestedPrefix, prefixValue);
        }
        if (!(prefixValue instanceof Map)) {
            return;
        }
        Map nestedMap = (Map)prefixValue;
        if (nestedIndex < nestedKey.length() - 1) {
            String remainderOfKey = nestedKey.substring(nestedIndex + 1, nestedKey.length());
            if (prefixedByUnderscore) {
                remainderOfKey = '_' + remainderOfKey;
            }
            nestedMap.put(remainderOfKey, this.getParameterValue(requestMap, key));
            if (!(nestedMap instanceof GrailsParameterMap) && remainderOfKey.indexOf(46) > -1) {
                this.processNestedKeys(requestMap, remainderOfKey, remainderOfKey, nestedMap);
            }
        }
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    @Override
    public Object get(Object key) {
        Object returnValue = null;
        if (this.nestedDateMap.containsKey(key)) {
            returnValue = this.nestedDateMap.get(key);
        } else {
            returnValue = this.wrappedMap.get(key);
            if (returnValue instanceof String[]) {
                String[] valueArray = returnValue;
                returnValue = valueArray.length == 1 ? valueArray[0] : valueArray;
            }
        }
        if ("date.struct".equals(returnValue)) {
            returnValue = this.lazyEvaluateDateParam(key);
            this.nestedDateMap.put(key, returnValue);
        }
        return returnValue;
    }

    private Date lazyEvaluateDateParam(Object key) {
        LinkedHashMap dateParams = new LinkedHashMap();
        for (Object entryObj : this.entrySet()) {
            String prefix;
            String paramName;
            Map.Entry entry = (Map.Entry)entryObj;
            Object entryKey = entry.getKey();
            if (!(entryKey instanceof String) || !(paramName = (String)entryKey).startsWith(prefix = key + "_")) continue;
            dateParams.put(paramName.substring(prefix.length(), paramName.length()), entry.getValue());
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S", LocaleContextHolder.getLocale());
        StructuredDateEditor editor = new StructuredDateEditor(dateFormat, true);
        try {
            return (Date)editor.assemble(Date.class, dateParams);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Override
    public Object put(Object key, Object value) {
        String keyString;
        if (value instanceof CharSequence) {
            value = value.toString();
        }
        if (key instanceof CharSequence) {
            key = key.toString();
        }
        if (this.nestedDateMap.containsKey(key)) {
            this.nestedDateMap.remove(key);
        }
        Object returnValue = this.wrappedMap.put(key, value);
        if (key instanceof String && (keyString = (String)key).indexOf(".") > -1) {
            this.processNestedKeys(this, keyString, keyString, this.wrappedMap);
        }
        return returnValue;
    }

    @Override
    public Object remove(Object key) {
        this.nestedDateMap.remove(key);
        return this.wrappedMap.remove(key);
    }

    @Override
    public void putAll(Map map) {
        Iterator i$ = map.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry entryObj;
            Map.Entry entry = entryObj = i$.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Date getDate(String name) {
        String format;
        Date date = super.getDate(name);
        if (date == null && (format = this.lookupFormat(name)) != null) {
            return this.getDate(name, format);
        }
        return date;
    }

    private String lookupFormat(String name) {
        ApplicationContext messageSource;
        GrailsWebRequest webRequest;
        String format = CACHED_DATE_FORMATS.get(name);
        if (format == null && (webRequest = GrailsWebRequest.lookup(this.request)) != null && (messageSource = webRequest.getApplicationContext()) != null && (format = messageSource.getMessage("date." + name + ".format", EMPTY_ARGS, webRequest.getLocale())) != null) {
            CACHED_DATE_FORMATS.put(name, format);
        }
        return format;
    }

    public String toQueryString() {
        String encoding = this.request.getCharacterEncoding();
        try {
            return WebUtils.toQueryString(this, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new ControllerExecutionException("Unable to convert parameter map [" + this + "] to a query string: " + e.getMessage(), e);
        }
    }

    public Object getIdentifier() {
        return this.get("id");
    }
}

