/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.servlet;

import grails.util.Environment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsControllerClass;
import org.codehaus.groovy.grails.plugins.support.aware.GrailsApplicationAware;
import org.codehaus.groovy.grails.web.servlet.GrailsUrlPathHelper;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsWebRequest;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.request.WebRequestInterceptor;
import org.springframework.web.servlet.HandlerExecutionChain;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.handler.AbstractHandlerMapping;
import org.springframework.web.servlet.handler.WebRequestHandlerInterceptorAdapter;
import org.springframework.web.servlet.mvc.Controller;
import org.springframework.web.util.UrlPathHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrailsControllerHandlerMapping
extends AbstractHandlerMapping
implements GrailsApplicationAware {
    public static final String MAIN_CONTROLLER_BEAN = "mainSimpleController";
    private GrailsApplication grailsApplication;
    private UrlPathHelper urlHelper = new GrailsUrlPathHelper();

    protected Object getHandlerInternal(HttpServletRequest request) throws Exception {
        String uri = this.urlHelper.getPathWithinApplication(request);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Looking up Grails controller for URI [" + uri + "]"));
        }
        Object controllerAttribute = null;
        GrailsWebRequest webRequest = (GrailsWebRequest)request.getAttribute("org.codehaus.groovy.grails.WEB_REQUEST");
        if (webRequest != null) {
            controllerAttribute = webRequest.getAttribute("org.codehaus.groovy.grails.GRAILS_CONTROLLER_CLASS", 0);
            String matchedUri = (String)webRequest.getAttribute("org.codehaus.groovy.grails.GRAILS_CONTROLLER_CLASS_MATCHED_URI", 0);
            if (matchedUri == null || !matchedUri.equals(uri)) {
                controllerAttribute = null;
            }
        }
        GrailsControllerClass controllerClass = controllerAttribute instanceof GrailsControllerClass ? (GrailsControllerClass)controllerAttribute : (GrailsControllerClass)this.grailsApplication.getArtefactForFeature("Controller", (Object)uri);
        return this.getHandlerForControllerClass(controllerClass, request);
    }

    protected Object getHandlerForControllerClass(GrailsControllerClass controllerClass, HttpServletRequest request) {
        if (controllerClass != null) {
            try {
                return this.getWebApplicationContext().getBean(MAIN_CONTROLLER_BEAN, Controller.class);
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                // empty catch block
            }
        }
        return null;
    }

    protected final HandlerExecutionChain getHandlerExecutionChain(Object handler, HttpServletRequest request) {
        if (handler instanceof HandlerExecutionChain) {
            HandlerExecutionChain chain = (HandlerExecutionChain)handler;
            chain.addInterceptors(this.lookupInterceptors(this.getWebApplicationContext()));
            return chain;
        }
        return new HandlerExecutionChain(handler, this.lookupInterceptors(this.getWebApplicationContext()));
    }

    protected void extendInterceptors(List interceptors) {
        this.setInterceptors(this.establishInterceptors(this.getWebApplicationContext(), interceptors));
    }

    protected HandlerInterceptor[] lookupInterceptors(WebApplicationContext applicationContext) {
        if (Environment.getCurrent() == Environment.DEVELOPMENT) {
            return this.establishInterceptors(applicationContext);
        }
        return this.getAdaptedInterceptors();
    }

    protected HandlerInterceptor[] establishInterceptors(WebApplicationContext webContext) {
        return this.establishInterceptors(webContext, Collections.emptyList());
    }

    protected HandlerInterceptor[] establishInterceptors(WebApplicationContext webContext, List<?> previousInterceptors) {
        WebRequestInterceptor interceptor;
        String[] interceptorNames = webContext.getBeanNamesForType(HandlerInterceptor.class);
        String[] webRequestInterceptors = webContext.getBeanNamesForType(WebRequestInterceptor.class);
        ArrayList<Object> interceptors = new ArrayList<Object>();
        for (String webRequestInterceptor : webRequestInterceptors) {
            interceptor = (WebRequestInterceptor)webContext.getBean(webRequestInterceptor, WebRequestInterceptor.class);
            if (previousInterceptors.contains(interceptor)) continue;
            interceptors.add(new WebRequestHandlerInterceptorAdapter(interceptor));
        }
        for (String interceptorName : interceptorNames) {
            interceptor = (HandlerInterceptor)webContext.getBean(interceptorName, HandlerInterceptor.class);
            if (previousInterceptors.contains(interceptor)) continue;
            interceptors.add(interceptor);
        }
        return interceptors.toArray(new HandlerInterceptor[interceptors.size()]);
    }

    public void setGrailsApplication(GrailsApplication grailsApplication) {
        this.grailsApplication = grailsApplication;
    }
}

