/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.binding;

import grails.util.Environment;
import grails.util.GrailsNameUtils;
import grails.validation.DeferredBindingActions;
import groovy.lang.GroovyObject;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import groovy.lang.MetaClassRegistry;
import groovy.lang.MetaProperty;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Currency;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TimeZone;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.AnnotationDomainClassArtefactHandler;
import org.codehaus.groovy.grails.commons.DomainClassArtefactHandler;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsClassUtils;
import org.codehaus.groovy.grails.commons.GrailsDomainClass;
import org.codehaus.groovy.grails.commons.GrailsDomainClassProperty;
import org.codehaus.groovy.grails.commons.GrailsDomainConfigurationUtil;
import org.codehaus.groovy.grails.commons.GrailsMetaClassUtils;
import org.codehaus.groovy.grails.validation.ConstrainedProperty;
import org.codehaus.groovy.grails.web.binding.BindEventListener;
import org.codehaus.groovy.grails.web.binding.CompositeEditor;
import org.codehaus.groovy.grails.web.binding.CurrencyEditor;
import org.codehaus.groovy.grails.web.binding.ListOrderedSet;
import org.codehaus.groovy.grails.web.binding.StructuredDateEditor;
import org.codehaus.groovy.grails.web.binding.StructuredPropertyEditor;
import org.codehaus.groovy.grails.web.binding.TimeZoneEditor;
import org.codehaus.groovy.grails.web.binding.UriEditor;
import org.codehaus.groovy.grails.web.json.JSONObject;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsParameterMap;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsWebRequest;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.MetaClassHelper;
import org.codehaus.groovy.runtime.metaclass.ThreadManagedMetaBeanProperty;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.ConfigurablePropertyAccessor;
import org.springframework.beans.InvalidPropertyException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyAccessorUtils;
import org.springframework.beans.PropertyEditorRegistrar;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.TypeMismatchException;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.beans.propertyeditors.CustomNumberEditor;
import org.springframework.beans.propertyeditors.LocaleEditor;
import org.springframework.context.ApplicationContext;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.bind.ServletRequestParameterPropertyValues;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.support.ByteArrayMultipartFileEditor;
import org.springframework.web.multipart.support.StringMultipartFileEditor;
import org.springframework.web.servlet.support.RequestContextUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrailsDataBinder
extends ServletRequestDataBinder {
    private static final String BIND_EVENT_LISTENERS = "org.codehaus.groovy.grails.BIND_EVENT_LISTENERS";
    private static final String PROPERTY_EDITOR_REGISTRARS = "org.codehaus.groovy.grails.PROPERTY_EDITOR_REGISTRARS";
    private static final Log LOG = LogFactory.getLog(GrailsDataBinder.class);
    private static final String JSON_DATE_FORMAT = "yyyy-MM-dd'T'hh:mm:ss'Z'";
    protected BeanWrapper bean;
    public static final String[] GROOVY_DISALLOWED = new String[]{"metaClass", "properties"};
    public static final String[] DOMAINCLASS_DISALLOWED = new String[]{"id", "version"};
    public static final String[] GROOVY_DOMAINCLASS_DISALLOWED = new String[]{"metaClass", "properties", "id", "version"};
    public static final String NULL_ASSOCIATION = "null";
    private static final String PREFIX_SEPERATOR = ".";
    private static final String[] ALL_OTHER_FIELDS_ALLOWED_BY_DEFAULT = new String[0];
    private static final String CONSTRAINTS_PROPERTY = "constraints";
    private static final String BLANK = "";
    private static final String STRUCTURED_PROPERTY_SEPERATOR = "_";
    private static final char PATH_SEPARATOR = '.';
    private static final String IDENTIFIER_SUFFIX = ".id";
    private List<String> transients = Collections.emptyList();
    public static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss.S";
    private GrailsDomainClass domainClass;
    private GrailsApplication grailsApplication;

    public GrailsDataBinder(Object target, String objectName) {
        super(target, objectName);
        this.setAutoGrowNestedPaths(false);
        this.bean = (BeanWrapper)((BeanPropertyBindingResult)super.getBindingResult()).getPropertyAccessor();
        Object tmpTransients = GrailsClassUtils.getStaticPropertyValue((Class)this.bean.getWrappedClass(), (String)"transients");
        if (tmpTransients instanceof List) {
            this.transients = (List)tmpTransients;
        }
        this.setDisallowedFields(GROOVY_DISALLOWED);
        this.setAllowedFields(ALL_OTHER_FIELDS_ALLOWED_BY_DEFAULT);
        this.setIgnoreInvalidFields(true);
    }

    private static void registerCustomEditors(ServletContext servletContext, PropertyEditorRegistry registry) {
        if (servletContext == null) {
            return;
        }
        WebApplicationContext context = WebApplicationContextUtils.getWebApplicationContext((ServletContext)servletContext);
        if (context == null) {
            return;
        }
        Map editors = (Map)servletContext.getAttribute(PROPERTY_EDITOR_REGISTRARS);
        if (editors == null) {
            editors = context.getBeansOfType(PropertyEditorRegistrar.class);
            if (!Environment.isDevelopmentMode()) {
                servletContext.setAttribute(PROPERTY_EDITOR_REGISTRARS, (Object)editors);
            }
        }
        for (PropertyEditorRegistrar editorRegistrar : editors.values()) {
            editorRegistrar.registerCustomEditors(registry);
        }
    }

    public static GrailsDataBinder createBinder(Object target, String objectName, HttpServletRequest request) {
        GrailsDataBinder binder = GrailsDataBinder.createBinder(target, objectName);
        GrailsWebRequest webRequest = GrailsWebRequest.lookup(request);
        GrailsDataBinder.initializeFromWebRequest(binder, webRequest);
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        GrailsDataBinder.registerCustomEditors(webRequest, (PropertyEditorRegistry)binder, locale);
        return binder;
    }

    private static void initializeFromWebRequest(GrailsDataBinder binder, GrailsWebRequest webRequest) {
        if (webRequest == null) {
            return;
        }
        GrailsApplication grailsApplication = webRequest.getAttributes().getGrailsApplication();
        binder.setGrailsApplication(grailsApplication);
    }

    private void setGrailsApplication(GrailsApplication grailsApplication) {
        this.grailsApplication = grailsApplication;
        String[] disallowed = new String[]{};
        Object target = this.getTarget();
        if (grailsApplication != null && grailsApplication.isArtefactOfType("Domain", target.getClass())) {
            disallowed = target instanceof GroovyObject ? GROOVY_DOMAINCLASS_DISALLOWED : DOMAINCLASS_DISALLOWED;
            this.domainClass = (GrailsDomainClass)grailsApplication.getArtefact("Domain", target.getClass().getName());
        } else if (target instanceof GroovyObject) {
            disallowed = GROOVY_DISALLOWED;
        }
        this.setDisallowedFields(disallowed);
    }

    public static void registerCustomEditors(GrailsWebRequest grailsWebRequest, PropertyEditorRegistry registry, Locale locale) {
        NumberFormat floatFormat = NumberFormat.getInstance(locale);
        NumberFormat integerFormat = NumberFormat.getIntegerInstance(locale);
        SimpleDateFormat dateFormat = new SimpleDateFormat(DEFAULT_DATE_FORMAT, locale);
        registry.registerCustomEditor(Date.class, (PropertyEditor)new CustomDateEditor((DateFormat)dateFormat, true));
        registry.registerCustomEditor(BigDecimal.class, (PropertyEditor)new CustomNumberEditor(BigDecimal.class, floatFormat, true));
        registry.registerCustomEditor(BigInteger.class, (PropertyEditor)new CustomNumberEditor(BigInteger.class, floatFormat, true));
        registry.registerCustomEditor(Double.class, (PropertyEditor)new CustomNumberEditor(Double.class, floatFormat, true));
        registry.registerCustomEditor(Double.TYPE, (PropertyEditor)new CustomNumberEditor(Double.class, floatFormat, true));
        registry.registerCustomEditor(Float.class, (PropertyEditor)new CustomNumberEditor(Float.class, floatFormat, true));
        registry.registerCustomEditor(Float.TYPE, (PropertyEditor)new CustomNumberEditor(Float.class, floatFormat, true));
        registry.registerCustomEditor(Long.class, (PropertyEditor)new CustomNumberEditor(Long.class, integerFormat, true));
        registry.registerCustomEditor(Long.TYPE, (PropertyEditor)new CustomNumberEditor(Long.class, integerFormat, true));
        registry.registerCustomEditor(Integer.class, (PropertyEditor)new CustomNumberEditor(Integer.class, integerFormat, true));
        registry.registerCustomEditor(Integer.TYPE, (PropertyEditor)new CustomNumberEditor(Integer.class, integerFormat, true));
        registry.registerCustomEditor(Short.class, (PropertyEditor)new CustomNumberEditor(Short.class, integerFormat, true));
        registry.registerCustomEditor(Short.TYPE, (PropertyEditor)new CustomNumberEditor(Short.class, integerFormat, true));
        registry.registerCustomEditor(Date.class, (PropertyEditor)new CompositeEditor(new PropertyEditor[]{new StructuredDateEditor(dateFormat, true), new CustomDateEditor((DateFormat)new SimpleDateFormat(JSON_DATE_FORMAT), true)}));
        registry.registerCustomEditor(Calendar.class, (PropertyEditor)((Object)new StructuredDateEditor(dateFormat, true)));
        ServletContext servletContext = grailsWebRequest != null ? grailsWebRequest.getServletContext() : null;
        GrailsDataBinder.registerCustomEditors(servletContext, registry);
    }

    public static GrailsDataBinder createBinder(Object target, String objectName) {
        GrailsDataBinder binder = new GrailsDataBinder(target, objectName);
        binder.registerCustomEditor(byte[].class, (PropertyEditor)new ByteArrayMultipartFileEditor());
        binder.registerCustomEditor(String.class, (PropertyEditor)new StringMultipartFileEditor());
        binder.registerCustomEditor(Currency.class, new CurrencyEditor());
        binder.registerCustomEditor(Locale.class, (PropertyEditor)new LocaleEditor());
        binder.registerCustomEditor(TimeZone.class, new TimeZoneEditor());
        binder.registerCustomEditor(URI.class, new UriEditor());
        GrailsWebRequest webRequest = GrailsWebRequest.lookup();
        if (webRequest == null) {
            GrailsDataBinder.registerCustomEditors(null, (PropertyEditorRegistry)binder);
        } else {
            GrailsDataBinder.initializeFromWebRequest(binder, webRequest);
            Locale locale = RequestContextUtils.getLocale((HttpServletRequest)webRequest.getCurrentRequest());
            GrailsDataBinder.registerCustomEditors(webRequest, (PropertyEditorRegistry)binder, locale);
        }
        return binder;
    }

    public void bind(PropertyValues propertyValues) {
        this.bind(propertyValues, null);
    }

    public void bind(GrailsParameterMap params) {
        this.bind(params, null);
    }

    public void bind(GrailsParameterMap params, String prefix) {
        Object o;
        Map paramsMap = params;
        if (prefix != null && (o = params.get(prefix)) instanceof Map) {
            paramsMap = (Map)o;
        }
        this.bindWithRequestAndPropertyValues((ServletRequest)params.getRequest(), new MutablePropertyValues(paramsMap));
    }

    public void bind(PropertyValues propertyValues, String prefix) {
        PropertyValues values = this.filterPropertyValues(propertyValues, prefix);
        if (propertyValues instanceof MutablePropertyValues) {
            MutablePropertyValues mutablePropertyValues = (MutablePropertyValues)propertyValues;
            this.preProcessMutablePropertyValues(mutablePropertyValues);
        }
        super.bind(values);
    }

    public void bind(ServletRequest request) {
        this.bind(request, null);
    }

    public void bind(ServletRequest request, String prefix) {
        ServletRequestParameterPropertyValues mpvs = prefix != null ? new ServletRequestParameterPropertyValues(request, prefix, PREFIX_SEPERATOR) : new ServletRequestParameterPropertyValues(request);
        this.bindWithRequestAndPropertyValues(request, (MutablePropertyValues)mpvs);
    }

    private void bindWithRequestAndPropertyValues(ServletRequest request, MutablePropertyValues mpvs) {
        ApplicationContext applicationContext;
        GrailsWebRequest webRequest = GrailsWebRequest.lookup((HttpServletRequest)request);
        if (webRequest != null && (applicationContext = webRequest.getApplicationContext()) != null) {
            ServletContext servletContext = webRequest.getServletContext();
            Map bindEventListenerMap = (Map)servletContext.getAttribute(BIND_EVENT_LISTENERS);
            if (bindEventListenerMap == null) {
                bindEventListenerMap = applicationContext.getBeansOfType(BindEventListener.class);
                if (!Environment.isDevelopmentMode()) {
                    servletContext.setAttribute(BIND_EVENT_LISTENERS, (Object)bindEventListenerMap);
                }
            }
            for (BindEventListener bindEventListener : bindEventListenerMap.values()) {
                bindEventListener.doBind(this.getTarget(), mpvs, this.getTypeConverter());
            }
        }
        this.preProcessMutablePropertyValues(mpvs);
        if (request instanceof MultipartHttpServletRequest) {
            MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
            this.bindMultipart((Map)multipartRequest.getMultiFileMap(), mpvs);
        }
        this.doBind(mpvs);
    }

    private void preProcessMutablePropertyValues(MutablePropertyValues mpvs) {
        this.autoCreateIfPossible(mpvs);
        this.checkStructuredProperties(mpvs);
        this.bindAssociations(mpvs);
    }

    protected void doBind(MutablePropertyValues mpvs) {
        this.filterNestedParameterMaps(mpvs);
        this.filterBlankValuesWhenTargetIsNullable(mpvs);
        super.doBind(mpvs);
    }

    private void filterBlankValuesWhenTargetIsNullable(MutablePropertyValues mpvs) {
        PropertyValue[] valueArray;
        Object target = this.getTarget();
        Map constrainedProperties = this.resolveConstrainedProperties(target, this.domainClass);
        if (constrainedProperties == null) {
            return;
        }
        for (PropertyValue propertyValue : valueArray = mpvs.getPropertyValues()) {
            ConstrainedProperty cp;
            if (!BLANK.equals(propertyValue.getValue()) || !this.shouldNullifyBlankString(propertyValue, cp = this.getConstrainedPropertyForPropertyValue(constrainedProperties, propertyValue))) continue;
            propertyValue.setConvertedValue(null);
        }
    }

    private ConstrainedProperty getConstrainedPropertyForPropertyValue(Map constrainedProperties, PropertyValue propertyValue) {
        String propertyName = propertyValue.getName();
        if (propertyName.indexOf(46) > -1) {
            Map nestedConstrainedProperties;
            String[] propertyNames = propertyName.split("\\.");
            Object target = this.getTarget();
            Object value = this.getPropertyValueForPath(target, propertyNames);
            if (value != null && (nestedConstrainedProperties = this.resolveConstrainedProperties(value)) != null) {
                return (ConstrainedProperty)nestedConstrainedProperties.get(propertyNames[propertyNames.length - 1]);
            }
            return null;
        }
        return (ConstrainedProperty)constrainedProperties.get(propertyName);
    }

    private Map resolveConstrainedProperties(Object object) {
        return this.resolveConstrainedProperties(object, this.grailsApplication != null ? (GrailsDomainClass)this.grailsApplication.getArtefact("Domain", object.getClass().getName()) : null);
    }

    private Map resolveConstrainedProperties(Object object, GrailsDomainClass dc) {
        Map constrainedProperties = null;
        if (dc != null) {
            constrainedProperties = dc.getConstrainedProperties();
        } else {
            Object constrainedPropsObj;
            MetaClass mc = GroovySystem.getMetaClassRegistry().getMetaClass(object.getClass());
            MetaProperty metaProp = mc.getMetaProperty(CONSTRAINTS_PROPERTY);
            if (metaProp != null && (constrainedPropsObj = this.getMetaPropertyValue(metaProp, object)) instanceof Map) {
                constrainedProperties = (Map)constrainedPropsObj;
            }
        }
        return constrainedProperties;
    }

    private Object getMetaPropertyValue(MetaProperty metaProperty, Object delegate) {
        if (metaProperty instanceof ThreadManagedMetaBeanProperty) {
            return ((ThreadManagedMetaBeanProperty)metaProperty).getGetter().invoke(delegate, MetaClassHelper.EMPTY_ARRAY);
        }
        return metaProperty.getProperty(delegate);
    }

    private Object getPropertyValueForPath(Object target, String[] propertyNames) {
        BeanWrapperImpl wrapper = new BeanWrapperImpl(target);
        Object obj = target;
        for (int i = 0; i < propertyNames.length - 1; ++i) {
            String propertyName = propertyNames[i];
            if (!wrapper.isReadableProperty(propertyName)) continue;
            obj = wrapper.getPropertyValue(propertyName);
            if (obj == null) break;
            wrapper = new BeanWrapperImpl(obj);
        }
        return obj;
    }

    private boolean shouldNullifyBlankString(PropertyValue propertyValue, ConstrainedProperty cp) {
        return cp != null && cp.isNullable() && BLANK.equals(propertyValue.getValue());
    }

    private void filterNestedParameterMaps(MutablePropertyValues mpvs) {
        for (PropertyValue pv : mpvs.getPropertyValues()) {
            Object value = pv.getValue();
            if (JSONObject.NULL.getClass().isInstance(value)) {
                mpvs.removePropertyValue(pv);
            }
            if (this.isCandidateForBinding(pv)) continue;
            mpvs.removePropertyValue(pv);
        }
    }

    private boolean isCandidateForBinding(PropertyValue pv) {
        boolean isCandidate = true;
        Object value = pv.getValue();
        if (value instanceof GrailsParameterMap || value instanceof JSONObject) {
            isCandidate = false;
        } else if (value instanceof Map) {
            Class<?> propertyType;
            isCandidate = false;
            String propertyName = pv.getName();
            PropertyDescriptor property = BeanUtils.getPropertyDescriptor(this.getTarget().getClass(), (String)propertyName);
            if (property != null && (propertyType = property.getPropertyType()).isAssignableFrom(value.getClass())) {
                isCandidate = true;
            }
        }
        return isCandidate;
    }

    private PropertyValues filterPropertyValues(PropertyValues propertyValues, String prefix) {
        if (prefix == null || prefix.length() == 0) {
            return propertyValues;
        }
        PropertyValue[] valueArray = propertyValues.getPropertyValues();
        MutablePropertyValues newValues = new MutablePropertyValues();
        for (PropertyValue propertyValue : valueArray) {
            String prefixWithDot;
            String name = propertyValue.getName();
            if (!name.startsWith(prefixWithDot = prefix + PREFIX_SEPERATOR)) continue;
            name = name.substring(prefixWithDot.length(), name.length());
            newValues.addPropertyValue(name, propertyValue.getValue());
        }
        return newValues;
    }

    protected void autoCreateIfPossible(MutablePropertyValues mpvs) {
        PropertyValue[] pvs;
        for (PropertyValue pv : pvs = mpvs.getPropertyValues()) {
            String propertyName = pv.getName();
            if (!this.isAllowed(propertyName)) continue;
            if (propertyName.indexOf(46) > -1) {
                String name;
                Object created;
                String[] propertyNames = propertyName.split("\\.");
                BeanWrapper currentBean = this.bean;
                String[] arr$ = propertyNames;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$ && (created = this.autoCreatePropertyIfPossible(currentBean, name = arr$[i$], pv.getValue())) != null; ++i$) {
                    currentBean = new BeanWrapperImpl(created);
                }
                continue;
            }
            this.autoCreatePropertyIfPossible(this.bean, propertyName, pv.getValue());
        }
    }

    protected boolean isAllowed(String field) {
        int i = field.indexOf(91);
        if (i > -1) {
            field = field.substring(0, i);
        }
        return super.isAllowed(field);
    }

    private Object autoCreatePropertyIfPossible(BeanWrapper wrapper, String propertyName, Object propertyValue) {
        propertyName = PropertyAccessorUtils.canonicalPropertyName((String)propertyName);
        int currentKeyStart = propertyName.indexOf(91);
        int currentKeyEnd = propertyName.indexOf(93);
        String propertyNameWithIndex = propertyName;
        if (currentKeyStart > -1) {
            propertyName = propertyName.substring(0, currentKeyStart);
        }
        Class type = wrapper.getPropertyType(propertyName);
        Object val = wrapper.isReadableProperty(propertyName) ? wrapper.getPropertyValue(propertyName) : null;
        LOG.debug((Object)("Checking if auto-create is possible for property [" + propertyName + "] and type [" + type + "]"));
        if (type != null && val == null && (this.isDomainClass(type) || this.isEmbedded(wrapper, propertyName))) {
            if (!this.shouldPropertyValueSkipAutoCreate(propertyValue) && this.isNullAndWritableProperty((ConfigurablePropertyAccessor)wrapper, propertyName)) {
                Object created;
                if (this.isDomainClass(type)) {
                    Object created2 = this.autoInstantiateDomainInstance(type);
                    if (created2 != null) {
                        val = created2;
                        wrapper.setPropertyValue(propertyName, created2);
                    }
                } else if (this.isEmbedded(wrapper, propertyName) && (created = this.autoInstantiateEmbeddedInstance(type)) != null) {
                    val = created;
                    wrapper.setPropertyValue(propertyName, created);
                }
            }
        } else {
            Object beanInstance = wrapper.getWrappedInstance();
            if (type != null && Collection.class.isAssignableFrom(type)) {
                Collection c = null;
                Class<?> referencedType = this.getReferencedTypeForCollection(propertyName, beanInstance);
                if (this.isNullAndWritableProperty((ConfigurablePropertyAccessor)wrapper, propertyName)) {
                    c = this.decorateCollectionForDomainAssociation(GrailsClassUtils.createConcreteCollection((Class)type), referencedType);
                } else if (wrapper.isReadableProperty(propertyName)) {
                    c = this.decorateCollectionForDomainAssociation((Collection)wrapper.getPropertyValue(propertyName), referencedType);
                }
                if (wrapper.isWritableProperty(propertyName) && c != null) {
                    wrapper.setPropertyValue(propertyName, (Object)c);
                }
                val = c;
                if (c != null && currentKeyStart > -1 && currentKeyEnd > -1) {
                    String indexString = propertyNameWithIndex.substring(currentKeyStart + 1, currentKeyEnd);
                    int index = Integer.parseInt(indexString);
                    Object instance = this.findIndexedValue(c, index);
                    if (instance != null) {
                        val = instance;
                    } else if (this.isDomainClass(referencedType) && (instance = this.autoInstantiateDomainInstance(referencedType)) != null) {
                        val = instance;
                        if (index == c.size()) {
                            this.addAssociationToTarget(propertyName, beanInstance, instance);
                        } else if (index > c.size()) {
                            while (index > c.size()) {
                                this.addAssociationToTarget(propertyName, beanInstance, this.autoInstantiateDomainInstance(referencedType));
                            }
                            this.addAssociationToTarget(propertyName, beanInstance, instance);
                        }
                    }
                }
            } else if (type != null && Map.class.isAssignableFrom(type)) {
                Map<String, Object> map;
                if (this.isNullAndWritableProperty((ConfigurablePropertyAccessor)wrapper, propertyName)) {
                    map = new HashMap();
                    wrapper.setPropertyValue(propertyName, map);
                } else {
                    map = (Map)wrapper.getPropertyValue(propertyName);
                }
                val = map;
                wrapper.setPropertyValue(propertyName, val);
                if (currentKeyStart > -1 && currentKeyEnd > -1) {
                    String indexString = propertyNameWithIndex.substring(currentKeyStart + 1, currentKeyEnd);
                    Class<?> referencedType = this.getReferencedTypeForCollection(propertyName, beanInstance);
                    if (this.isDomainClass(referencedType)) {
                        Object domainInstance;
                        val = domainInstance = this.autoInstantiateDomainInstance(referencedType);
                        map.put(indexString, domainInstance);
                    }
                }
            }
        }
        return val;
    }

    private boolean isDomainClass(Class<?> clazz) {
        return DomainClassArtefactHandler.isDomainClass(clazz) || AnnotationDomainClassArtefactHandler.isJPADomainClass(clazz);
    }

    private boolean isEmbedded(BeanWrapper wrapper, String propertyName) {
        Object embedded = GrailsClassUtils.getStaticPropertyValue((Class)wrapper.getWrappedClass(), (String)"embedded");
        return embedded instanceof List && ((List)embedded).contains(propertyName);
    }

    private boolean shouldPropertyValueSkipAutoCreate(Object propertyValue) {
        return propertyValue instanceof Map || propertyValue instanceof String && StringUtils.isBlank((String)((String)propertyValue));
    }

    private Collection decorateCollectionForDomainAssociation(Collection c, Class referencedType) {
        if (this.canDecorateWithListOrderedSet(c, referencedType)) {
            c = ListOrderedSet.decorate((Set)c);
        }
        return c;
    }

    private boolean canDecorateWithListOrderedSet(Collection c, Class referencedType) {
        return c instanceof Set && !(c instanceof ListOrderedSet) && !(c instanceof SortedSet) && this.isDomainClass(referencedType);
    }

    private Object findIndexedValue(Collection c, int index) {
        if (c instanceof List) {
            try {
                return ((List)c).get(index);
            }
            catch (IndexOutOfBoundsException ignored) {
            }
        } else {
            int j = 0;
            for (Object o : c) {
                if (++j != index) continue;
                return o;
            }
        }
        return null;
    }

    private Object autoInstantiateDomainInstance(Class<?> type) {
        Object created = null;
        try {
            MetaClass mc = GroovySystem.getMetaClassRegistry().getMetaClass(type);
            if (mc != null) {
                created = mc.invokeStaticMethod(type, "create", new Object[0]);
            }
        }
        catch (MissingMethodException mme) {
            LOG.warn((Object)"Unable to auto-create type, 'create' method not found");
        }
        catch (GroovyRuntimeException gre) {
            LOG.warn((Object)("Unable to auto-create type, Groovy Runtime error: " + gre.getMessage()), (Throwable)gre);
        }
        return created;
    }

    private Object autoInstantiateEmbeddedInstance(Class<?> type) {
        Object created = null;
        try {
            created = type.newInstance();
        }
        catch (InstantiationException e) {
            LOG.error((Object)String.format("Unable to auto-create type %s, %s thrown in constructor", type, e.getClass()));
        }
        catch (IllegalAccessException e) {
            LOG.error((Object)String.format("Unable to auto-create type %s, cannot access constructor", type));
        }
        return created;
    }

    private boolean isNullAndWritableProperty(ConfigurablePropertyAccessor accessor, String propertyName) {
        return accessor.isWritableProperty(propertyName) && accessor.isReadableProperty(propertyName) && accessor.getPropertyValue(propertyName) == null;
    }

    protected void bindAssociations(MutablePropertyValues mpvs) {
        for (PropertyValue pv : mpvs.getPropertyValues()) {
            Class<?> type;
            String propertyName;
            String propertyNameToCheck = propertyName = pv.getName();
            int i = propertyName.indexOf(46);
            if (i > -1) {
                propertyNameToCheck = propertyName.substring(0, i);
            }
            if (!this.isAllowed(propertyNameToCheck)) continue;
            if (propertyName.endsWith(IDENTIFIER_SUFFIX)) {
                GrailsDomainClassProperty otherSide;
                GrailsDomainClassProperty property;
                if (!this.isAllowed(propertyName = propertyName.substring(0, propertyName.length() - 3)) || !this.isReadableAndPersistent(propertyName) || !this.bean.isWritableProperty(propertyName)) continue;
                if (NULL_ASSOCIATION.equals(pv.getValue())) {
                    this.bean.setPropertyValue(propertyName, null);
                    mpvs.removePropertyValue(pv);
                    continue;
                }
                type = this.getPropertyTypeForPath(propertyName);
                final Object persisted = this.getPersistentInstance(type, pv.getValue());
                if (persisted == null) continue;
                this.bean.setPropertyValue(propertyName, persisted);
                if (this.domainClass == null || (property = this.domainClass.getPersistentProperty(propertyName)) == null || (otherSide = property.getOtherSide()) == null || !List.class.isAssignableFrom(otherSide.getType()) || property.isOptional()) continue;
                DeferredBindingActions.addBindingAction((Runnable)new Runnable(){

                    public void run() {
                        Collection collection;
                        if (otherSide.isOneToMany() && (collection = (Collection)GrailsMetaClassUtils.getPropertyIfExists((Object)persisted, (String)otherSide.getName(), Collection.class)) != null && !collection.contains(GrailsDataBinder.this.getTarget())) {
                            String methodName = "addTo" + GrailsNameUtils.getClassName((String)otherSide.getName());
                            GrailsMetaClassUtils.invokeMethodIfExists((Object)persisted, (String)methodName, (Object[])new Object[]{GrailsDataBinder.this.getTarget()});
                        }
                    }
                });
                continue;
            }
            if (!this.isReadableAndPersistent(propertyName) || (type = this.getPropertyTypeForPath(propertyName)) == null || !Collection.class.isAssignableFrom(type)) continue;
            this.bindCollectionAssociation(mpvs, pv);
        }
    }

    private Class<?> getPropertyTypeForPath(String propertyName) {
        Class<?> type = this.bean.getPropertyType(propertyName);
        if (type == null) {
            Object target = this.bean.getWrappedInstance();
            String path = propertyName.replaceAll("\\[.+?\\]", BLANK);
            if (path.indexOf(46) > -1) {
                String nestedProp = StringUtils.substringBeforeLast((String)propertyName, (String)PREFIX_SEPERATOR);
                target = this.bean.getPropertyValue(nestedProp);
                path = StringUtils.substringAfterLast((String)path, (String)PREFIX_SEPERATOR);
            }
            if (target != null) {
                type = this.getReferencedTypeForCollection(path, target);
            }
        }
        return type;
    }

    private boolean isReadableAndPersistent(String propertyName) {
        return this.bean.isReadableProperty(propertyName) && !this.transients.contains(propertyName);
    }

    private Object getPersistentInstance(Class<?> type, Object id) {
        Object persisted;
        try {
            persisted = InvokerHelper.invokeStaticMethod(type, (String)"get", (Object)id);
        }
        catch (MissingMethodException e) {
            return null;
        }
        catch (IllegalStateException e) {
            return null;
        }
        return persisted;
    }

    private void bindCollectionAssociation(MutablePropertyValues mpvs, PropertyValue pv) {
        boolean isArray;
        Object v = pv.getValue();
        boolean bl = isArray = v != null && v.getClass().isArray();
        if (!isArray && !(v instanceof String)) {
            return;
        }
        Collection collection = (Collection)this.bean.getPropertyValue(pv.getName());
        collection.clear();
        Class<?> associatedType = this.getReferencedTypeForCollection(pv.getName(), this.getTarget());
        PropertyEditor propertyEditor = this.findCustomEditor(collection.getClass(), pv.getName());
        if (propertyEditor == null) {
            if (this.isDomainAssociation(associatedType)) {
                if (isArray) {
                    Object[] identifiers;
                    for (Object id : identifiers = (Object[])v) {
                        if (id == null) continue;
                        this.associateObjectForId(pv, id, associatedType);
                    }
                    mpvs.removePropertyValue(pv);
                } else if (v instanceof String) {
                    this.associateObjectForId(pv, v, associatedType);
                    mpvs.removePropertyValue(pv);
                }
            } else if (GrailsDomainConfigurationUtil.isBasicType(associatedType)) {
                Object[] values = null;
                if (isArray) {
                    values = (Object[])v;
                } else if (v instanceof String) {
                    values = new String[]{(String)v};
                }
                if (values != null) {
                    List list = collection instanceof List ? (List)collection : null;
                    for (int i = 0; i < values.length; ++i) {
                        Object value = values[i];
                        try {
                            Object newValue = this.getTypeConverter().convertIfNecessary(value, associatedType);
                            if (list != null) {
                                if (i > list.size() - 1) {
                                    list.add(i, newValue);
                                    continue;
                                }
                                list.set(i, newValue);
                                continue;
                            }
                            collection.add(newValue);
                            continue;
                        }
                        catch (TypeMismatchException e) {
                            // empty catch block
                        }
                    }
                    mpvs.removePropertyValue(pv);
                }
            }
        }
    }

    private void associateObjectForId(PropertyValue pv, Object id, Class<?> associatedType) {
        Object target = this.getTarget();
        Object obj = this.getPersistentInstance(associatedType, id);
        this.addAssociationToTarget(pv.getName(), target, obj);
    }

    private boolean isDomainAssociation(Class<?> associatedType) {
        return associatedType != null && this.isDomainClass(associatedType);
    }

    private void addAssociationToTarget(String name, Object target, Object obj) {
        if (obj == null) {
            return;
        }
        MetaClassRegistry reg = GroovySystem.getMetaClassRegistry();
        MetaClass mc = reg.getMetaClass(target.getClass());
        String addMethodName = "addTo" + GrailsNameUtils.getClassNameRepresentation((String)name);
        mc.invokeMethod(target, addMethodName, obj);
    }

    private Class<?> getReferencedTypeForCollection(String name, Object target) {
        GrailsDomainClassProperty domainProperty;
        GrailsDomainClass dc;
        if (this.grailsApplication != null && (dc = (GrailsDomainClass)this.grailsApplication.getArtefact("Domain", target.getClass().getName())) != null && (domainProperty = dc.getPersistentProperty(name)) != null) {
            return domainProperty.getReferencedPropertyType();
        }
        return null;
    }

    private String getNameOf(PropertyValue propertyValue) {
        String name = propertyValue.getName();
        if (name.indexOf(STRUCTURED_PROPERTY_SEPERATOR) == -1) {
            return name;
        }
        return name.substring(0, name.indexOf(STRUCTURED_PROPERTY_SEPERATOR));
    }

    private boolean isStructured(PropertyValue propertyValue) {
        String name = propertyValue.getName();
        return name.indexOf(STRUCTURED_PROPERTY_SEPERATOR) != -1;
    }

    private void checkStructuredProperties(MutablePropertyValues propertyValues) {
        HashMap<String, PropertyValue> valuesByName = new HashMap<String, PropertyValue>();
        ArrayList<String> valueNames = new ArrayList<String>();
        this.mapPropertyValues(propertyValues.getPropertyValues(), valuesByName, valueNames);
        while (!valueNames.isEmpty()) {
            String propertyName;
            Class type;
            String name = (String)valueNames.remove(0);
            PropertyValue propertyValue = (PropertyValue)valuesByName.get(name);
            if (!this.isStructured(propertyValue) || (type = this.bean.getPropertyType(propertyName = this.getNameOf(propertyValue))) == null) continue;
            PropertyEditor editor = this.findCustomEditor(type, propertyName);
            if (editor instanceof CompositeEditor) {
                CompositeEditor composite = (CompositeEditor)editor;
                List<PropertyEditor> propertyEditors = composite.getPropertyEditors();
                for (PropertyEditor propertyEditor : propertyEditors) {
                    if (null == propertyEditor || !StructuredPropertyEditor.class.isAssignableFrom(propertyEditor.getClass())) continue;
                    StructuredPropertyEditor structuredEditor = (StructuredPropertyEditor)((Object)propertyEditor);
                    this.processStructuredProperty(structuredEditor, propertyName, type, valueNames, propertyValues);
                }
                continue;
            }
            if (null == editor || !StructuredPropertyEditor.class.isAssignableFrom(editor.getClass())) continue;
            StructuredPropertyEditor structuredEditor = (StructuredPropertyEditor)((Object)editor);
            this.processStructuredProperty(structuredEditor, propertyName, type, valueNames, propertyValues);
        }
    }

    private void processStructuredProperty(StructuredPropertyEditor structuredEditor, String propertyName, Class<?> type, List<String> valueNames, MutablePropertyValues propertyValues) {
        List requiredFields = structuredEditor.getRequiredFields();
        ArrayList fields = new ArrayList();
        fields.addAll(requiredFields);
        fields.addAll(structuredEditor.getOptionalFields());
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        try {
            PropertyValue partialStructValue;
            String firstRequiredField = null;
            for (String field : fields) {
                String fullName = propertyName + STRUCTURED_PROPERTY_SEPERATOR + field;
                valueNames.remove(fullName);
                if (firstRequiredField != null) continue;
                partialStructValue = propertyValues.getPropertyValue(fullName);
                if (partialStructValue == null) {
                    if (!requiredFields.contains(field)) continue;
                    firstRequiredField = field;
                    continue;
                }
                fieldValues.put(field, this.getStringValue(partialStructValue));
            }
            propertyValues.removePropertyValue(propertyName);
            if (firstRequiredField != null) {
                throw new MissingPropertyException("Required structured property is missing [" + firstRequiredField + "]");
            }
            try {
                Object value = structuredEditor.assemble(type, fieldValues);
                for (String field : fields) {
                    partialStructValue = propertyValues.getPropertyValue(propertyName + STRUCTURED_PROPERTY_SEPERATOR + field);
                    if (null == partialStructValue) continue;
                    partialStructValue.setConvertedValue((Object)this.getStringValue(partialStructValue));
                }
                propertyValues.addPropertyValue(new PropertyValue(propertyName, value));
            }
            catch (IllegalArgumentException e) {
                LOG.warn((Object)("Unable to parse structured date from request for date [" + propertyName + "]"), (Throwable)e);
            }
        }
        catch (InvalidPropertyException ignored) {
            // empty catch block
        }
    }

    private void mapPropertyValues(PropertyValue[] pvs, Map<String, PropertyValue> valuesByName, List<String> valueNames) {
        for (PropertyValue pv : pvs) {
            String propertyName = pv.getName();
            if (!this.isAllowed(propertyName)) continue;
            valuesByName.put(propertyName, pv);
            valueNames.add(propertyName);
        }
    }

    private String getStringValue(PropertyValue yearProperty) {
        Object value = yearProperty.getValue();
        if (value == null) {
            return null;
        }
        if (value.getClass().isArray()) {
            return ((String[])value)[0];
        }
        return (String)value;
    }

    protected void checkFieldMarkers(MutablePropertyValues mpvs) {
        PropertyValue[] pvArray;
        if (this.getFieldMarkerPrefix() == null) {
            return;
        }
        String fieldMarkerPrefix = this.getFieldMarkerPrefix();
        for (PropertyValue pv : pvArray = mpvs.getPropertyValues()) {
            if (!this.propertyStartsWithFieldMarkerPrefix(pv, fieldMarkerPrefix)) continue;
            String field = this.stripFieldMarkerPrefix(pv.getName(), fieldMarkerPrefix);
            if (this.getPropertyAccessor().isWritableProperty(field) && !mpvs.contains(field)) {
                Class fieldType = this.getPropertyAccessor().getPropertyType(field);
                mpvs.add(field, this.getEmptyValue(field, fieldType));
            }
            mpvs.removePropertyValue(pv);
        }
    }

    private boolean propertyStartsWithFieldMarkerPrefix(PropertyValue pv, String fieldMarkerPrefix) {
        String propertyName = pv.getName().indexOf(46) > -1 ? StringUtils.substringAfterLast((String)pv.getName(), (String)PREFIX_SEPERATOR) : pv.getName();
        return propertyName.startsWith(fieldMarkerPrefix);
    }

    private String stripFieldMarkerPrefix(String path, String fieldMarkerPrefix) {
        Object[] pathElements = StringUtils.split((String)path, (char)'.');
        for (int i = 0; i < pathElements.length; ++i) {
            if (!pathElements[i].startsWith(fieldMarkerPrefix)) continue;
            pathElements[i] = ((String)pathElements[i]).substring(fieldMarkerPrefix.length());
        }
        return StringUtils.join((Object[])pathElements, (char)'.');
    }
}

