/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.pages.discovery;

import grails.util.GrailsNameUtils;
import javax.servlet.http.HttpServletRequest;
import org.codehaus.groovy.grails.io.support.GrailsResourceUtils;
import org.codehaus.groovy.grails.web.pages.DefaultGroovyPagesUriService;
import org.codehaus.groovy.grails.web.pages.GroovyPageBinding;
import org.codehaus.groovy.grails.web.pages.GroovyPagesUriService;
import org.codehaus.groovy.grails.web.pages.discovery.DefaultGroovyPageLocator;
import org.codehaus.groovy.grails.web.pages.discovery.GroovyPageScriptSource;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsWebRequest;

public class GrailsConventionGroovyPageLocator
extends DefaultGroovyPageLocator {
    private static final char DOT = '.';
    private GroovyPagesUriService uriService = new DefaultGroovyPagesUriService();

    public GroovyPageScriptSource findViewByPath(String uri) {
        return uri == null ? null : this.findPage(this.uriService.getAbsoluteViewURI(uri));
    }

    public GroovyPageScriptSource findView(String controllerName, String viewName) {
        String viewNameWithFormat = GrailsConventionGroovyPageLocator.resolveViewFormat(viewName);
        GroovyPageScriptSource scriptSource = this.findPage(this.uriService.getViewURI(controllerName, viewNameWithFormat));
        if (scriptSource == null) {
            scriptSource = this.findPage(this.uriService.getViewURI(controllerName, viewName));
        }
        return scriptSource;
    }

    public static String resolveViewFormat(String viewName) {
        String format = GrailsConventionGroovyPageLocator.lookupRequestFormat();
        if (format == null) {
            return viewName;
        }
        return viewName + '.' + format;
    }

    public GroovyPageScriptSource findView(Object controller, String viewName) {
        String pathToView;
        String viewNameWithFormat;
        if (controller == null || viewName == null) {
            return null;
        }
        String controllerName = this.getNameForController(controller);
        GroovyPageScriptSource scriptSource = this.findPage(this.uriService.getViewURI(controllerName, viewNameWithFormat = GrailsConventionGroovyPageLocator.resolveViewFormat(viewName)));
        if (scriptSource == null) {
            scriptSource = this.findPage(this.uriService.getViewURI(controllerName, viewName));
        }
        if (scriptSource == null && this.pluginManager != null && (pathToView = this.pluginManager.getPluginViewsPathForInstance(controller)) != null) {
            scriptSource = this.findViewByPath(GrailsResourceUtils.appendPiecesForUri((String[])new String[]{pathToView, viewName}));
        }
        if (scriptSource == null) {
            scriptSource = this.findView(controllerName, viewName);
        }
        return scriptSource;
    }

    public GroovyPageScriptSource findTemplate(String controllerName, String templateName) {
        return this.findPage(this.uriService.getTemplateURI(controllerName, templateName));
    }

    public GroovyPageScriptSource findTemplate(Object controller, String templateName) {
        String controllerName = this.getNameForController(controller);
        return this.findPage(this.uriService.getTemplateURI(controllerName, templateName));
    }

    public GroovyPageScriptSource findView(String viewName) {
        GrailsWebRequest webRequest = GrailsWebRequest.lookup();
        if (webRequest == null) {
            return this.findViewByPath(viewName);
        }
        return this.findView(webRequest.getControllerName(), viewName);
    }

    public GroovyPageScriptSource findTemplate(String templateName) {
        GrailsWebRequest webRequest = GrailsWebRequest.lookup();
        if (webRequest == null) {
            return this.findTemplateByPath(templateName);
        }
        return this.findTemplate(webRequest.getControllerName(), templateName);
    }

    public GroovyPageScriptSource findTemplateInBinding(String templateName, GroovyPageBinding binding) {
        GrailsWebRequest webRequest = GrailsWebRequest.lookup();
        if (webRequest == null) {
            return this.findPageInBinding(this.uriService.getAbsoluteTemplateURI(templateName), binding);
        }
        return this.findPageInBinding(this.uriService.getTemplateURI(webRequest.getControllerName(), templateName), binding);
    }

    public GroovyPageScriptSource findTemplateInBinding(String pluginName, String templateName, GroovyPageBinding binding) {
        GrailsWebRequest webRequest = GrailsWebRequest.lookup();
        if (webRequest == null) {
            return this.findPageInBinding(pluginName, this.uriService.getAbsoluteTemplateURI(templateName), binding);
        }
        return this.findPageInBinding(pluginName, this.uriService.getTemplateURI(webRequest.getControllerName(), templateName), binding);
    }

    public GroovyPageScriptSource findTemplateByPath(String uri) {
        return this.findPage(this.uriService.getAbsoluteTemplateURI(uri));
    }

    static String lookupRequestFormat() {
        GrailsWebRequest webRequest = GrailsWebRequest.lookup();
        if (webRequest == null) {
            return null;
        }
        HttpServletRequest request = webRequest.getCurrentRequest();
        return request.getAttribute("org.codehaus.groovy.grails.RESPONSE_FORMAT") == null ? null : request.getAttribute("org.codehaus.groovy.grails.RESPONSE_FORMAT").toString();
    }

    protected String getNameForController(Object controller) {
        return GrailsNameUtils.getLogicalPropertyName((String)controller.getClass().getName(), (String)"Controller");
    }
}

