/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.pages;

import java.io.Writer;
import java.util.Stack;
import org.apache.commons.io.output.NullWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsWebRequest;
import org.codehaus.groovy.grails.web.util.GrailsPrintWriter;
import org.codehaus.groovy.grails.web.util.GrailsWrappedWriter;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

public final class GroovyPageOutputStack {
    public static final Log log = LogFactory.getLog(GroovyPageOutputStack.class);
    private static final String ATTRIBUTE_NAME_OUTPUT_STACK = "org.codehaus.groovy.grails.GSP_OUTPUT_STACK";
    private Stack<WriterPair> stack = new Stack();
    private GroovyPageProxyWriter proxyWriter = new GroovyPageProxyWriter();
    private boolean autoSync;

    public static GroovyPageOutputStack currentStack() {
        return GroovyPageOutputStack.currentStack(true);
    }

    public static GroovyPageOutputStack currentStack(RequestAttributes request) {
        return GroovyPageOutputStack.currentStack(request, true);
    }

    public static GroovyPageOutputStack currentStack(boolean allowCreate) {
        return GroovyPageOutputStack.currentStack(allowCreate, null, allowCreate, false);
    }

    public static GroovyPageOutputStack currentStack(RequestAttributes request, boolean allowCreate) {
        return GroovyPageOutputStack.currentStack(request, allowCreate, null, allowCreate, false);
    }

    public static GroovyPageOutputStack currentStack(boolean allowCreate, Writer topWriter, boolean autoSync, boolean pushTop) {
        RequestAttributes request = RequestContextHolder.currentRequestAttributes();
        return GroovyPageOutputStack.currentStack(request, allowCreate, topWriter, autoSync, pushTop);
    }

    public static GroovyPageOutputStack currentStack(RequestAttributes request, boolean allowCreate, Writer topWriter, boolean autoSync, boolean pushTop) {
        GroovyPageOutputStack outputStack = (GroovyPageOutputStack)request.getAttribute(ATTRIBUTE_NAME_OUTPUT_STACK, 0);
        if (outputStack != null) {
            if (pushTop && topWriter != null) {
                outputStack.push(topWriter);
            }
            return outputStack;
        }
        if (allowCreate) {
            if (topWriter == null && request instanceof GrailsWebRequest) {
                topWriter = GroovyPageOutputStack.defaultRequest((GrailsWebRequest)request);
            }
            return GroovyPageOutputStack.createNew(topWriter, autoSync);
        }
        return null;
    }

    private static GrailsWebRequest getGrailsWebRequest() {
        RequestAttributes requestAttributes = RequestContextHolder.currentRequestAttributes();
        if (requestAttributes instanceof GrailsWebRequest) {
            return (GrailsWebRequest)requestAttributes;
        }
        return null;
    }

    private static Writer defaultRequest() {
        GrailsWebRequest webRequest = GroovyPageOutputStack.getGrailsWebRequest();
        return GroovyPageOutputStack.defaultRequest(webRequest);
    }

    private static Writer defaultRequest(GrailsWebRequest webRequest) {
        if (webRequest != null) {
            return webRequest.getOut();
        }
        return null;
    }

    public static final GroovyPageOutputStack createNew(Writer topWriter) {
        return GroovyPageOutputStack.createNew(topWriter, false);
    }

    private static final GroovyPageOutputStack createNew(Writer topWriter, boolean autoSync) {
        GroovyPageOutputStack instance = new GroovyPageOutputStack(topWriter, autoSync);
        RequestAttributes requestAttributes = RequestContextHolder.currentRequestAttributes();
        requestAttributes.setAttribute(ATTRIBUTE_NAME_OUTPUT_STACK, (Object)instance, 0);
        requestAttributes.setAttribute("org.codehaus.groovy.grails.RESPONSE_OUT", (Object)topWriter, 0);
        return instance;
    }

    public static final void removeCurrentInstance() {
        RequestContextHolder.currentRequestAttributes().removeAttribute(ATTRIBUTE_NAME_OUTPUT_STACK, 0);
    }

    public static final Writer currentWriter() {
        GroovyPageOutputStack outputStack = GroovyPageOutputStack.currentStack(false);
        if (outputStack != null) {
            return outputStack.getProxyWriter();
        }
        return GroovyPageOutputStack.defaultRequest();
    }

    private GroovyPageOutputStack(Writer topWriter, boolean autoSync) {
        this.autoSync = autoSync;
        this.push(topWriter);
        if (!autoSync) {
            this.applyWriterThreadLocals(this.proxyWriter);
        }
    }

    private Writer unwrapTargetWriter(Writer targetWriter) {
        if (targetWriter instanceof GrailsWrappedWriter) {
            return ((GrailsWrappedWriter)((Object)targetWriter)).unwrap();
        }
        return targetWriter;
    }

    public void push(Writer newWriter) {
        this.push(newWriter, false);
    }

    public void push(Writer newWriter, boolean checkExisting) {
        Writer unwrappedWriter;
        if (newWriter == this.proxyWriter && this.stack.size() > 0) {
            this.stack.push(this.stack.peek());
            return;
        }
        if (checkExisting) {
            for (WriterPair item : this.stack) {
                if (item.originalTarget != newWriter) continue;
                log.warn((Object)("Pushed a writer to stack a second time. Writer type " + newWriter.getClass().getName()), (Throwable)new Exception());
            }
        }
        if ((unwrappedWriter = this.unwrapTargetWriter(newWriter)) == this.proxyWriter && this.stack.size() > 0) {
            this.stack.push(this.stack.peek());
            return;
        }
        this.stack.push(new WriterPair(newWriter, unwrappedWriter));
        this.proxyWriter.setOut(newWriter);
        if (this.autoSync) {
            this.applyWriterThreadLocals(newWriter);
        }
    }

    public void pop() {
        this.pop(this.autoSync);
    }

    public void pop(boolean forceSync) {
        this.stack.pop();
        if (this.stack.size() > 0) {
            WriterPair pair = this.stack.peek();
            this.proxyWriter.setOut(pair.unwrappedTarget);
            if (forceSync) {
                this.applyWriterThreadLocals(pair.originalTarget);
            }
        }
    }

    public GroovyPageProxyWriter getProxyWriter() {
        return this.proxyWriter;
    }

    public Writer getCurrentOriginalWriter() {
        return this.stack.peek().originalTarget;
    }

    public void restoreThreadLocalsToOriginals() {
        Writer originalTopWriter = ((WriterPair)this.stack.firstElement()).originalTarget;
        this.applyWriterThreadLocals(originalTopWriter);
    }

    private void applyWriterThreadLocals(Writer writer) {
        GrailsWebRequest webRequest = GroovyPageOutputStack.getGrailsWebRequest();
        if (webRequest != null) {
            webRequest.setOut(writer);
        }
    }

    private class GroovyPageProxyWriter
    extends GrailsPrintWriter {
        public GroovyPageProxyWriter() {
            super((Writer)new NullWriter());
        }

        public GroovyPageOutputStack getOutputStack() {
            return GroovyPageOutputStack.this;
        }
    }

    private class WriterPair {
        Writer originalTarget;
        Writer unwrappedTarget;

        WriterPair(Writer originalTarget, Writer unwrappedTarget) {
            this.originalTarget = originalTarget;
            this.unwrappedTarget = unwrappedTarget;
        }
    }
}

