/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.servlet.mvc;

import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsControllerClass;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsRequestStateLookupStrategy;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsWebRequest;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultRequestStateLookupStrategy
implements GrailsRequestStateLookupStrategy {
    public static final String DEFAULT_REQUEST_ENCODING = "UTF-8";
    private GrailsApplication grailsApplication;
    private GrailsWebRequest webRequest;

    public DefaultRequestStateLookupStrategy() {
    }

    public DefaultRequestStateLookupStrategy(GrailsWebRequest webRequest) {
        this.webRequest = webRequest;
    }

    @Autowired
    public void setGrailsApplication(GrailsApplication grailsApplication) {
        this.grailsApplication = grailsApplication;
    }

    public String getContextPath() {
        GrailsWebRequest req = this.getWebRequest();
        if (req != null) {
            return req.getContextPath();
        }
        return null;
    }

    public String getCharacterEncoding() {
        GrailsWebRequest req = this.getWebRequest();
        if (req != null) {
            return req.getCurrentRequest().getCharacterEncoding();
        }
        return DEFAULT_REQUEST_ENCODING;
    }

    public String getControllerName() {
        GrailsWebRequest req = this.getWebRequest();
        return this.getControllerNameInternal(req);
    }

    private String getControllerNameInternal(GrailsWebRequest req) {
        if (req != null) {
            return req.getControllerName();
        }
        return null;
    }

    public String getActionName() {
        String actionName;
        GrailsWebRequest req = this.getWebRequest();
        if (req != null && (actionName = req.getActionName()) == null) {
            if (this.grailsApplication == null) {
                this.grailsApplication = req.getAttributes().getGrailsApplication();
            }
            if (this.grailsApplication != null) {
                String controllerName = this.getControllerNameInternal(req);
                return this.getActionName(this.grailsApplication, controllerName);
            }
        }
        return null;
    }

    private String getActionName(GrailsApplication application, String controllerName) {
        GrailsControllerClass controllerClass;
        if (application != null && (controllerClass = (GrailsControllerClass)application.getArtefactByLogicalPropertyName("Controller", controllerName)) != null) {
            return controllerClass.getDefaultAction();
        }
        return null;
    }

    public String getActionName(String controllerName) {
        if (controllerName != null) {
            GrailsWebRequest grailsWebRequest;
            if (this.grailsApplication == null && (grailsWebRequest = this.getWebRequest()) != null) {
                this.grailsApplication = grailsWebRequest.getAttributes().getGrailsApplication();
            }
            return this.getActionName(this.grailsApplication, controllerName);
        }
        return null;
    }

    private GrailsWebRequest getWebRequest() {
        return this.webRequest != null ? this.webRequest : GrailsWebRequest.lookup();
    }
}

