/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.taglib;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.grails.web.pages.GroovyPageParser;
import org.codehaus.groovy.grails.web.taglib.GrailsTag;
import org.codehaus.groovy.grails.web.taglib.exceptions.GrailsTagException;

public abstract class GroovySyntaxTag
implements GrailsTag {
    private static final String METHOD_EACH_WITH_INDEX = "eachWithIndex";
    private static final String METHOD_EACH = "each";
    private static final String ERROR_NO_VAR_WITH_STATUS = "When using <g:each> with a [status] attribute, you must also define a [var]. eg. <g:each var=\"myVar\">";
    protected static final String ATTRIBUTE_IN = "in";
    protected static final String ATTRIBUTE_VAR = "var";
    protected static final String ATTRIBUTES_STATUS = "status";
    protected Map tagContext;
    protected PrintWriter out;
    protected Map<String, String> attributes = new HashMap<String, String>();
    protected GroovyPageParser parser;

    public void init(Map context) {
        this.tagContext = context;
        this.parser = (GroovyPageParser)context.get(GroovyPageParser.class);
        Object outObj = context.get("out");
        if (outObj instanceof PrintWriter) {
            this.out = (PrintWriter)context.get("out");
        }
    }

    public void setWriter(Writer w) {
        if (!(w instanceof PrintWriter)) {
            throw new IllegalArgumentException("A GroovySynax tag requires a java.io.PrintWriter instance");
        }
        this.out = (PrintWriter)w;
    }

    public void setAttributes(Map attributes) {
        for (String attrName : attributes.keySet()) {
            this.setAttribute(attrName, attributes.get(attrName));
        }
    }

    public void setAttribute(String name, Object value) {
        if (!(value instanceof String)) {
            throw new IllegalArgumentException("A GroovySynax tag requires only string valued attributes");
        }
        String stringValue = (String)value;
        if (stringValue.startsWith("${") && stringValue.endsWith("}")) {
            stringValue = stringValue.substring(2, stringValue.length() - 1);
        }
        this.attributes.put(name.substring(1, name.length() - 1), stringValue);
    }

    public abstract boolean isKeepPrecedingWhiteSpace();

    public abstract boolean isAllowPrecedingContent();

    protected String calculateExpression(String expr) {
        if (StringUtils.isBlank((String)expr)) {
            throw new IllegalArgumentException("Argument [expr] cannot be null or blank");
        }
        if ((expr = expr.trim()).startsWith("\"") && expr.endsWith("\"")) {
            expr = expr.substring(1, expr.length() - 1);
            expr = expr.trim();
        }
        if (expr.startsWith("${") && expr.endsWith("}")) {
            expr = expr.substring(2, expr.length() - 1);
            expr = expr.trim();
        }
        return expr;
    }

    protected void doEachMethod(String in) {
        String methodName;
        boolean hasVar;
        String var = this.attributes.get(ATTRIBUTE_VAR);
        String status = this.attributes.get(ATTRIBUTES_STATUS);
        var = this.extractAttributeValue(var);
        boolean hasStatus = !StringUtils.isBlank((String)(status = this.extractAttributeValue(status)));
        boolean bl = hasVar = !StringUtils.isBlank((String)var);
        if (hasStatus && !hasVar) {
            throw new GrailsTagException(ERROR_NO_VAR_WITH_STATUS);
        }
        String string = methodName = hasStatus ? METHOD_EACH_WITH_INDEX : METHOD_EACH;
        if (var.equals(status) && hasStatus) {
            throw new GrailsTagException("Attribute [var] cannot have the same value as attribute [status]");
        }
        this.out.print(this.parser != null ? this.parser.getExpressionText(in) : in);
        this.out.print('.');
        this.out.print(methodName);
        this.out.print(" { ");
        if (hasVar || hasStatus) {
            this.out.print(hasVar ? var : "it");
        }
        if (hasStatus) {
            this.out.print(",");
            this.out.print(status);
        }
        if (hasVar || hasStatus) {
            this.out.print(" ->");
        }
        this.out.println();
    }

    private String extractAttributeValue(String attr) {
        if (StringUtils.isBlank((String)attr)) {
            return "";
        }
        if (attr.startsWith("\"") && attr.endsWith("\"") && attr.length() > 1) {
            attr = attr.substring(1, attr.length() - 1);
        }
        return attr;
    }
}

