/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.pages;

import grails.util.Environment;
import grails.util.PluginBuildSettings;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.ConfigurationHolder;
import org.codehaus.groovy.grails.plugins.GrailsPluginInfo;
import org.codehaus.groovy.grails.plugins.GrailsPluginUtils;
import org.codehaus.groovy.grails.web.pages.FastStringWriter;
import org.codehaus.groovy.grails.web.pages.GSPWriter;
import org.codehaus.groovy.grails.web.pages.GroovyPageScanner;
import org.codehaus.groovy.grails.web.pages.SitemeshPreprocessor;
import org.codehaus.groovy.grails.web.pages.Tokens;
import org.codehaus.groovy.grails.web.taglib.GrailsTagRegistry;
import org.codehaus.groovy.grails.web.taglib.GroovySyntaxTag;
import org.codehaus.groovy.grails.web.taglib.exceptions.GrailsTagException;
import org.codehaus.groovy.grails.web.util.StreamByteBuffer;
import org.codehaus.groovy.grails.web.util.StreamCharBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyPageParser
implements Tokens {
    public static final Log LOG = LogFactory.getLog(GroovyPageParser.class);
    private static final Pattern PARA_BREAK = Pattern.compile("/p>\\s*<p[^>]*>", 2);
    private static final Pattern ROW_BREAK = Pattern.compile("((/td>\\s*</tr>\\s*<)?tr[^>]*>\\s*<)?td[^>]*>", 2);
    private static final Pattern PARSE_TAG_FIRST_PASS = Pattern.compile("(\\s*(\\S+)\\s*=\\s*[\"]([^\"]*)[\"][\\s|>]{1}){1}");
    private static final Pattern PARSE_TAG_SECOND_PASS = Pattern.compile("(\\s*(\\S+)\\s*=\\s*[']([^']*)['][\\s|>]{1}){1}");
    private static final Pattern PAGE_DIRECTIVE_PATTERN = Pattern.compile("(\\w+)\\s*=\\s*\"([^\"]*)\"");
    private static final Pattern PRESCAN_PAGE_DIRECTIVE_PATTERN = Pattern.compile("<%@\\s*page\\s+(.*?)\\s*%>", 32);
    private static final Pattern PRESCAN_COMMENT_PATTERN = Pattern.compile("<%--.*?%>", 32);
    public static final String CONSTANT_NAME_JSP_TAGS = "JSP_TAGS";
    public static final String CONSTANT_NAME_CONTENT_TYPE = "CONTENT_TYPE";
    public static final String CONSTANT_NAME_LAST_MODIFIED = "LAST_MODIFIED";
    public static final String CONSTANT_NAME_DEFAULT_CODEC = "DEFAULT_CODEC";
    private GroovyPageScanner scan;
    private GSPWriter out;
    private String className;
    private String packageName;
    private boolean finalPass = false;
    private int tagIndex;
    private Map tagContext;
    private Stack<TagMeta> tagMetaStack = new Stack();
    private GrailsTagRegistry tagRegistry = GrailsTagRegistry.getInstance();
    private Environment environment;
    private List<String> htmlParts = new ArrayList<String>();
    private static SitemeshPreprocessor sitemeshPreprocessor = new SitemeshPreprocessor();
    Set<Integer> bodyVarsDefined = new HashSet<Integer>();
    Map<Integer, String> attrsVarsMapDefinition = new HashMap<Integer, String>();
    int closureLevel = 0;
    private boolean currentlyBufferingWhitespace;
    private boolean previousContentWasNonWhitespace;
    private StringBuffer whitespaceBuffer = new StringBuffer();
    private String contentType = "text/html;charset=UTF-8";
    private boolean doNextScan = true;
    private int state;
    private static final String DEFAULT_CONTENT_TYPE = "text/html;charset=UTF-8";
    private int constantCount = 0;
    private Map<String, Integer> constantsToNumbers = new HashMap<String, Integer>();
    private final String pageName;
    public static final String[] DEFAULT_IMPORTS = new String[]{"org.codehaus.groovy.grails.plugins.metadata.GrailsPlugin", "org.codehaus.groovy.grails.web.pages.GroovyPage", "org.codehaus.groovy.grails.web.taglib.*", "org.codehaus.groovy.grails.web.taglib.exceptions.GrailsTagException", "org.springframework.web.util.*", "grails.util.GrailsUtil"};
    public static final String CONFIG_PROPERTY_DEFAULT_CODEC = "grails.views.default.codec";
    private static final String CONFIG_PROPERTY_GSP_ENCODING = "grails.views.gsp.encoding";
    private static final String CONFIG_PROPERTY_GSP_KEEPGENERATED_DIR = "grails.views.gsp.keepgenerateddir";
    private static final String CONFIG_PROPERTY_GSP_SITEMESH_PREPROCESS = "grails.views.gsp.sitemesh.preprocess";
    private static final String IMPORT_DIRECTIVE = "import";
    private static final String CONTENT_TYPE_DIRECTIVE = "contentType";
    private static final String DEFAULT_CODEC_DIRECTIVE = "defaultCodec";
    private static final String SITEMESH_PREPROCESS_DIRECTIVE = "sitemeshPreprocess";
    private static final String PAGE_DIRECTIVE = "page";
    private static final String TAGLIB_DIRECTIVE = "taglib";
    private String gspEncoding;
    private String pluginAnnotation;
    public static final String GROOVY_SOURCE_CHAR_ENCODING = "UTF-8";
    private Map jspTags = new HashMap();
    private long lastModified;
    private boolean precompileMode;
    private boolean sitemeshPreprocessMode = false;
    private PluginBuildSettings pluginBuildSettings = GrailsPluginUtils.getPluginBuildSettings();
    private String defaultCodecDirectiveValue;

    public String getContentType() {
        return this.contentType;
    }

    public int getCurrentOutputLineNumber() {
        return this.scan.getLineNumberForToken();
    }

    public Map getJspTags() {
        return this.jspTags;
    }

    public GroovyPageParser(String name, String uri, String filename, InputStream in) throws IOException {
        String gspSource;
        Map<String, String> directives;
        Object gspEnc;
        Map config = ConfigurationHolder.getFlatConfig();
        GrailsPluginInfo info = this.pluginBuildSettings.getPluginInfoForSource(filename);
        if (info != null) {
            this.pluginAnnotation = "@GrailsPlugin(name='" + info.getName() + "', version='" + info.getVersion() + "')";
        }
        this.gspEncoding = (gspEnc = config.get(CONFIG_PROPERTY_GSP_ENCODING)) != null && gspEnc.toString().trim().length() > 0 ? gspEnc.toString() : System.getProperty("file.encoding", "us-ascii");
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("GSP file encoding set to: " + this.gspEncoding));
        }
        if (this.isSitemeshPreprocessingEnabled(config, (directives = this.parseDirectives(gspSource = this.readStream(in))).get(SITEMESH_PREPROCESS_DIRECTIVE))) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Preprocessing " + uri + " for sitemesh. Replacing head, title, meta and body elements with sitemesh:capture*."));
            }
            gspSource = sitemeshPreprocessor.addGspSitemeshCapturing(gspSource);
            this.sitemeshPreprocessMode = true;
        }
        this.scan = new GroovyPageScanner(gspSource);
        this.pageName = uri;
        this.environment = Environment.getCurrent();
        this.makeName(name);
    }

    private Map<String, String> parseDirectives(String gspSource) {
        HashMap<String, String> result = new HashMap<String, String>();
        String input = PRESCAN_COMMENT_PATTERN.matcher(gspSource).replaceAll("");
        Matcher m = PRESCAN_PAGE_DIRECTIVE_PATTERN.matcher(input);
        if (m.find()) {
            Matcher mat = PAGE_DIRECTIVE_PATTERN.matcher(m.group(1));
            while (mat.find()) {
                String name = mat.group(1);
                String value = mat.group(2);
                result.put(name, value);
            }
        }
        return result;
    }

    private boolean isSitemeshPreprocessingEnabled(Map config, String gspFilePreprocessDirective) {
        Object sitemeshPreprocessEnabled = config.get(CONFIG_PROPERTY_GSP_SITEMESH_PREPROCESS);
        if (gspFilePreprocessDirective != null) {
            sitemeshPreprocessEnabled = gspFilePreprocessDirective;
        }
        if (sitemeshPreprocessEnabled == null || sitemeshPreprocessEnabled instanceof Boolean && ((Boolean)sitemeshPreprocessEnabled).booleanValue()) {
            return true;
        }
        if (sitemeshPreprocessEnabled instanceof Number && ((Number)sitemeshPreprocessEnabled).intValue() != 0) {
            return true;
        }
        return BooleanUtils.toBoolean((String)String.valueOf(sitemeshPreprocessEnabled).trim());
    }

    public int[] getLineNumberMatrix() {
        return this.out.getLineNumbers();
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream parse() {
        InputStream inputStream;
        File keepGeneratedDirectory = this.resolveKeepGeneratedDirectory();
        StreamCharBuffer streamBuffer = new StreamCharBuffer(1024);
        StreamByteBuffer byteOutputBuffer = new StreamByteBuffer(1024, StreamByteBuffer.ReadMode.RETAIN_AFTER_READING);
        try {
            streamBuffer.connectTo(new OutputStreamWriter(byteOutputBuffer.getOutputStream(), GROOVY_SOURCE_CHAR_ENCODING), true);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Grails cannot run unless your environment supports UTF-8!");
        }
        File keepGeneratedFile = null;
        OutputStreamWriter keepGeneratedWriter = null;
        if (keepGeneratedDirectory != null) {
            keepGeneratedFile = new File(keepGeneratedDirectory, this.className);
            try {
                keepGeneratedWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(keepGeneratedFile), GROOVY_SOURCE_CHAR_ENCODING);
            }
            catch (IOException e) {
                LOG.warn((Object)("Cannot open keepgenerated file for writing. File's absolute path is '" + keepGeneratedFile.getAbsolutePath() + "'"));
                keepGeneratedFile = null;
            }
            streamBuffer.connectTo(keepGeneratedWriter, true);
        }
        Writer target = streamBuffer.getWriter();
        try {
            InputStream in;
            this.generateGsp(target, false);
            if (LOG.isDebugEnabled()) {
                if (keepGeneratedFile != null) {
                    LOG.debug((Object)("Compiled GSP into Groovy code. Source is in " + keepGeneratedFile));
                } else {
                    LOG.debug((Object)"Configure grails.views.gsp.keepgenerateddir property to view generated source.");
                }
            }
            inputStream = in = byteOutputBuffer.getInputStream();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(keepGeneratedWriter);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)keepGeneratedWriter);
        return inputStream;
    }

    private File resolveKeepGeneratedDirectory() {
        File keepGeneratedDirectory = null;
        Object keepDirObj = ConfigurationHolder.getFlatConfig().get(CONFIG_PROPERTY_GSP_KEEPGENERATED_DIR);
        if (keepDirObj instanceof File) {
            keepGeneratedDirectory = (File)keepDirObj;
        } else if (keepDirObj != null) {
            keepGeneratedDirectory = new File(String.valueOf(keepDirObj));
        }
        if (keepGeneratedDirectory != null && !keepGeneratedDirectory.isDirectory()) {
            LOG.warn((Object)("The directory specified with grails.views.gsp.keepgenerateddir config parameter doesn't exist or isn't a readable directory. Absolute path: '" + keepGeneratedDirectory.getAbsolutePath() + "' Keepgenerated will be disabled."));
            keepGeneratedDirectory = null;
        }
        return keepGeneratedDirectory;
    }

    public void generateGsp(Writer target) {
        this.generateGsp(target, true);
    }

    public void generateGsp(Writer target, boolean precompileMode) {
        this.precompileMode = precompileMode;
        this.out = new GSPWriter(target, this);
        if (this.packageName != null && this.packageName.length() > 0) {
            this.out.println("package " + this.packageName);
            this.out.println();
        }
        this.page();
        this.finalPass = true;
        this.scan.reset();
        this.previousContentWasNonWhitespace = false;
        this.currentlyBufferingWhitespace = false;
        this.page();
        this.out.flush();
        this.scan = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeHtmlParts(File filename) throws IOException {
        DataOutputStream dataOut = null;
        try {
            dataOut = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(filename)));
            dataOut.writeInt(this.htmlParts.size());
            Iterator<String> i = this.htmlParts.iterator();
            while (i.hasNext()) {
                dataOut.writeUTF(i.next());
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(dataOut);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)dataOut);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeLineNumbers(File filename) throws IOException {
        DataOutputStream dataOut = null;
        try {
            dataOut = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(filename)));
            int lineNumbersCount = this.out.getCurrentLineNumber() - 1;
            int[] lineNumbers = this.out.getLineNumbers();
            dataOut.writeInt(lineNumbersCount);
            for (int i = 0; i < lineNumbersCount; ++i) {
                dataOut.writeInt(lineNumbers[i]);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(dataOut);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)dataOut);
    }

    private void declare(boolean gsp) {
        if (this.finalPass) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"parse: declare");
        }
        this.out.println();
        this.write(this.scan.getToken().trim(), gsp);
        this.out.println();
        this.out.println();
    }

    private void direct() {
        if (this.finalPass) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"parse: direct");
        }
        String text = this.scan.getToken();
        if ((text = text.trim()).startsWith(PAGE_DIRECTIVE)) {
            this.directPage(text);
        } else if (text.startsWith(TAGLIB_DIRECTIVE)) {
            this.directJspTagLib(text);
        }
    }

    private void directPage(String text) {
        text = text.trim();
        Matcher mat = PAGE_DIRECTIVE_PATTERN.matcher(text);
        int ix = 0;
        while (mat.find(ix)) {
            String name = mat.group(1);
            String value = mat.group(2);
            if (name.equals(IMPORT_DIRECTIVE)) {
                this.pageImport(value);
            }
            if (name.equals(CONTENT_TYPE_DIRECTIVE)) {
                this.contentType(value);
            }
            if (name.equals(DEFAULT_CODEC_DIRECTIVE)) {
                this.defaultCodecDirectiveValue = value.trim();
            }
            ix = mat.end();
        }
        return;
    }

    private void directJspTagLib(String text) {
        text = text.substring(TAGLIB_DIRECTIVE.length() + 1, text.length());
        LinkedHashMap attrs = new LinkedHashMap();
        this.populateMapWithAttributes(attrs, text + '>');
        String prefix = (String)attrs.get("\"prefix\"");
        String uri = (String)attrs.get("\"uri\"");
        if (uri != null && prefix != null) {
            String namespace = prefix.substring(1, prefix.length() - 1);
            if (!"g".equals(namespace)) {
                this.jspTags.put(namespace, uri.substring(1, uri.length() - 1));
            } else {
                LOG.error((Object)"You cannot override the default 'g' namespace with the directive <%@ taglib prefix=\"g\" %>. Please select another namespace.");
            }
        }
    }

    private void contentType(String value) {
        this.contentType = value;
    }

    private void scriptletExpr() {
        if (!this.finalPass) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"parse: expr");
        }
        String text = this.scan.getToken().trim();
        this.out.printlnToResponse(text);
    }

    private void expr() {
        if (!this.finalPass) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"parse: expr");
        }
        String text = this.scan.getToken().trim();
        if ((text = this.getExpressionText(text)).startsWith("(") && text.endsWith(")")) {
            this.out.printlnToResponse("Codec.encode" + text);
        } else {
            this.out.printlnToResponse("Codec.encode(" + text + ")");
        }
    }

    public String getExpressionText(String text) {
        boolean safeDereference = false;
        if (text.endsWith("?")) {
            text = text.substring(0, text.length() - 1);
            safeDereference = true;
        }
        if (!(this.precompileMode || this.environment != Environment.DEVELOPMENT && this.environment != Environment.TEST)) {
            String escaped = this.escapeGroovy(text);
            text = "evaluate('" + escaped + "', " + this.getCurrentOutputLineNumber() + ", it) { return " + text + " }" + (safeDereference ? "?" : "");
        } else {
            text = "(" + text + ")" + (safeDereference ? "?" : "");
        }
        return text;
    }

    private String escapeGroovy(String text) {
        return text.replace("\\", "\\\\").replace("'", "\\'").replace("\n", "\\n").replace("\r", "\\r");
    }

    private void bufferedPrintlnToResponse(String s) {
        if (this.currentlyBufferingWhitespace) {
            this.whitespaceBuffer.append(s);
        } else {
            this.flushTagBuffering();
            this.out.printlnToResponse(s);
        }
    }

    private void htmlPartPrintlnToResponse(int partNumber) {
        if (!this.tagMetaStack.isEmpty()) {
            TagMeta tm = this.tagMetaStack.peek();
            if (tm.bufferMode && tm.bufferPartNumber == -1) {
                tm.bufferPartNumber = partNumber;
                return;
            }
        }
        this.flushTagBuffering();
        this.htmlPartPrintlnRaw(partNumber);
    }

    private void htmlPartPrintlnRaw(int partNumber) {
        this.out.print("printHtmlPart(");
        this.out.print(String.valueOf(partNumber));
        this.out.print(")");
        this.out.println();
    }

    public void flushTagBuffering() {
        if (!this.tagMetaStack.isEmpty()) {
            TagMeta tm = this.tagMetaStack.peek();
            if (tm.bufferMode) {
                this.writeTagBodyStart(tm);
                if (tm.bufferPartNumber != -1) {
                    this.htmlPartPrintlnRaw(tm.bufferPartNumber);
                }
                tm.bufferMode = false;
            }
        }
    }

    private void html() {
        boolean contentIsWhitespace;
        String text;
        if (!this.finalPass) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"parse: html");
        }
        if ((text = this.scan.getToken()).length() == 0) {
            return;
        }
        boolean bl = contentIsWhitespace = !Pattern.compile("\\S").matcher(text).find();
        if (!contentIsWhitespace && this.currentlyBufferingWhitespace) {
            this.flushBufferedWhiteSpace();
        } else {
            this.currentlyBufferingWhitespace = contentIsWhitespace;
        }
        boolean bl2 = this.previousContentWasNonWhitespace = !contentIsWhitespace;
        if (this.currentlyBufferingWhitespace) {
            this.whitespaceBuffer.append(text);
        } else {
            this.appendHtmlPart(text);
        }
    }

    private void appendHtmlPart(String text) {
        Integer constantNumber;
        if (this.whitespaceBuffer.length() > 0) {
            if (text != null) {
                this.whitespaceBuffer.append(text);
            }
            text = this.whitespaceBuffer.toString();
            this.clearBufferedWhiteSpace();
        }
        if ((constantNumber = this.constantsToNumbers.get(text)) == null) {
            constantNumber = new Integer(this.constantCount++);
            this.constantsToNumbers.put(text, constantNumber);
            this.htmlParts.add(text);
        }
        this.htmlPartPrintlnToResponse(constantNumber);
    }

    private void makeName(String uri) {
        String name;
        int slash = uri.lastIndexOf(47);
        if (slash > -1) {
            name = uri.substring(slash + 1);
            uri = uri.substring(0, uri.length() - 1 - name.length());
            while (uri.endsWith("/")) {
                uri = uri.substring(0, uri.length() - 1);
            }
            slash = uri.lastIndexOf(47);
            if (slash > -1) {
                name = uri.substring(slash + 1) + '_' + name;
            }
        } else {
            name = uri;
        }
        StringBuffer buf = new StringBuffer(name.length());
        int ixz = name.length();
        for (int ix = 0; ix < ixz; ++ix) {
            int c = name.charAt(ix);
            if (c < 48 || c > 57 && c < 64 || c > 90 && c < 95 || c > 95 && c < 97 || c > 122) {
                c = 95;
            } else if (ix == 0 && c >= 48 && c <= 57) {
                c = 95;
            }
            buf.append((char)c);
        }
        this.className = buf.toString();
    }

    private static boolean match(CharSequence pat, CharSequence text, int start) {
        int ixy;
        int ix = start;
        int ixz = text.length();
        if (ixz > (ixy = start + pat.length())) {
            ixz = ixy;
        }
        if (pat.length() > ixz - start) {
            return false;
        }
        while (ix < ixz) {
            if (Character.toLowerCase(text.charAt(ix)) != Character.toLowerCase(pat.charAt(ix - start))) {
                return false;
            }
            ++ix;
        }
        return true;
    }

    private static int match(Pattern pat, CharSequence text, int start) {
        Matcher mat = pat.matcher(text);
        if (mat.find(start) && mat.start() == start) {
            return mat.end();
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void page() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"parse: page");
        }
        if (this.finalPass) {
            this.out.println();
            if (this.pluginAnnotation != null) {
                this.out.println(this.pluginAnnotation);
            }
            this.out.print("class ");
            this.out.print(this.className);
            this.out.println(" extends GroovyPage {");
            this.out.println("public String getGroovyPageFileName() { \"" + this.pageName.replaceAll("\\\\", "/") + "\" }");
            this.out.println("public Object run() {");
            this.out.println("def params = binding.params");
            this.out.println("def request = binding.request");
            this.out.println("def flash = binding.flash");
            this.out.println("def response = binding.response");
            this.out.println("def out = binding.out");
            if (this.sitemeshPreprocessMode) {
                this.out.println("registerSitemeshPreprocessMode(request)");
            }
        }
        block14: while (true) {
            if (this.doNextScan) {
                this.state = this.scan.nextToken();
            } else {
                this.doNextScan = true;
            }
            if (this.state != 15 && this.state != 0) {
                this.flushBufferedWhiteSpace();
                this.previousContentWasNonWhitespace = false;
            }
            switch (this.state) {
                case -1: {
                    break block14;
                }
                case 0: {
                    this.html();
                    break;
                }
                case 1: {
                    this.scriptletExpr();
                    break;
                }
                case 2: {
                    this.script(false);
                    break;
                }
                case 3: {
                    this.direct();
                    break;
                }
                case 4: {
                    this.declare(false);
                    break;
                }
                case 11: {
                    this.expr();
                    break;
                }
                case 12: {
                    this.script(true);
                    break;
                }
                case 13: {
                    this.direct();
                    break;
                }
                case 14: {
                    this.declare(true);
                    break;
                }
                case 15: {
                    this.startTag();
                    break;
                }
                case 16: 
                case 18: {
                    this.endTag();
                }
            }
        }
        if (this.finalPass) {
            if (!this.tagMetaStack.isEmpty()) {
                throw new GrailsTagException("Grails tags were not closed! [" + this.tagMetaStack + "] in GSP " + this.pageName + "", this.pageName, this.out.getCurrentLineNumber());
            }
            this.out.println("}");
            this.out.println("public static final Map JSP_TAGS = new HashMap()");
            if (this.jspTags != null && this.jspTags.size() > 0) {
                this.out.println("static {");
                for (Map.Entry entry : this.jspTags.entrySet()) {
                    this.out.print("\tJSP_TAGS.put('");
                    this.out.print(this.escapeGroovy(String.valueOf(entry.getKey())));
                    this.out.print("','");
                    this.out.print(this.escapeGroovy(String.valueOf(entry.getValue())));
                    this.out.println("')");
                }
                this.out.println("}");
            }
            this.out.println("protected void init() {");
            this.out.println("\tthis.jspTags = JSP_TAGS");
            this.out.println("}");
            this.out.println("public static final String CONTENT_TYPE = '" + this.escapeGroovy(this.contentType) + "'");
            this.out.println("public static final long LAST_MODIFIED = " + this.lastModified + "L");
            this.out.print("public static final String DEFAULT_CODEC = ");
            if (this.defaultCodecDirectiveValue != null && this.defaultCodecDirectiveValue.length() > 0) {
                this.out.println("'" + this.escapeGroovy(this.defaultCodecDirectiveValue) + "'");
            } else {
                this.out.println("null");
            }
            this.out.println("}");
            return;
        }
        int i = 0;
        while (i < DEFAULT_IMPORTS.length) {
            this.out.print("import ");
            this.out.println(DEFAULT_IMPORTS[i]);
            ++i;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void endTag() {
        if (!this.finalPass) {
            return;
        }
        String tagName = this.scan.getToken().trim();
        String ns = this.scan.getNamespace();
        if (this.tagMetaStack.isEmpty()) {
            throw new GrailsTagException("Found closing Grails tag with no opening [" + tagName + "]", this.pageName, this.out.getCurrentLineNumber());
        }
        TagMeta tm = this.tagMetaStack.pop();
        String lastInStack = tm.name;
        String lastNamespaceInStack = tm.namespace;
        if (StringUtils.isBlank((String)tagName)) {
            tagName = lastInStack;
        }
        if (!lastInStack.equals(tagName) || !lastNamespaceInStack.equals(ns)) {
            throw new GrailsTagException("Grails tag [" + lastNamespaceInStack + ":" + lastInStack + "] was not closed", this.pageName, this.out.getCurrentLineNumber());
        }
        if ("g".equals(ns) && this.tagRegistry.isSyntaxTag(tagName)) {
            if (!(tm.instance instanceof GroovySyntaxTag)) throw new GrailsTagException("Grails tag [" + tagName + "] was not closed", this.pageName, this.out.getCurrentLineNumber());
            GroovySyntaxTag tag = (GroovySyntaxTag)tm.instance;
            tag.doEndTag();
        } else {
            String bodyTagClosureName = "null";
            if (!tm.emptyTag && !tm.bufferMode) {
                bodyTagClosureName = "body" + this.tagIndex;
                this.out.println("})");
                --this.closureLevel;
            }
            if (tm.bufferMode && tm.bufferPartNumber != -1) {
                if (!this.bodyVarsDefined.contains(tm.tagIndex)) {
                    this.bodyVarsDefined.add(tm.tagIndex);
                }
                this.out.println("body" + tm.tagIndex + " = createClosureForHtmlPart(" + tm.bufferPartNumber + ")");
                bodyTagClosureName = "body" + tm.tagIndex;
                tm.bufferMode = false;
            }
            if (this.jspTags.containsKey(ns)) {
                String uri = (String)this.jspTags.get(ns);
                this.out.println("jspTag = tagLibraryResolver?.resolveTagLibrary('" + uri + "')?.getTag('" + tagName + "')");
                this.out.println("if(!jspTag) throw new GrailsTagException('Unknown JSP tag " + ns + ":" + tagName + "')");
                this.out.println("jspTag.doTag(out," + this.attrsVarsMapDefinition.get(this.tagIndex) + ", " + bodyTagClosureName + ")");
            } else if (tm.hasAttributes) {
                this.out.println("invokeTag('" + tagName + "','" + ns + "'," + this.getCurrentOutputLineNumber() + "," + this.attrsVarsMapDefinition.get(this.tagIndex) + "," + bodyTagClosureName + ")");
            } else {
                this.out.println("invokeTag('" + tagName + "','" + ns + "'," + this.getCurrentOutputLineNumber() + ",[:]," + bodyTagClosureName + ")");
            }
        }
        tm.bufferMode = false;
        --this.tagIndex;
    }

    private void startTag() {
        String tagName;
        if (!this.finalPass) {
            return;
        }
        ++this.tagIndex;
        StringBuffer buf = new StringBuffer(this.scan.getToken());
        String ns = this.scan.getNamespace();
        boolean emptyTag = false;
        this.state = this.scan.nextToken();
        while (this.state != 0 && this.state != 16 && this.state != 18 && this.state != -1) {
            if (this.state == 17) {
                buf.append("${");
                buf.append(this.scan.getToken().trim());
                buf.append("}");
            } else {
                buf.append(this.scan.getToken());
            }
            this.state = this.scan.nextToken();
        }
        if (this.state == 18) {
            emptyTag = true;
        }
        this.doNextScan = false;
        String text = buf.toString();
        LinkedHashMap attrs = new LinkedHashMap();
        if ((text = text.replaceAll("[\r\n\t]", " ")).indexOf(32) > -1) {
            int i = text.indexOf(32);
            tagName = text.substring(0, i);
            String attrTokens = text.substring(i, text.length());
            attrTokens = attrTokens + '>';
            this.populateMapWithAttributes(attrs, attrTokens);
        } else {
            tagName = text;
        }
        if (this.state == -1) {
            throw new GrailsTagException("Unexpected end of file encountered parsing Tag [" + tagName + "] for " + this.className + ". Are you missing a closing brace '}'?", this.pageName, this.out.getCurrentLineNumber());
        }
        this.flushTagBuffering();
        TagMeta tm = new TagMeta();
        tm.name = tagName;
        tm.namespace = ns;
        tm.hasAttributes = !attrs.isEmpty();
        tm.lineNumber = this.getCurrentOutputLineNumber();
        tm.emptyTag = emptyTag;
        tm.tagIndex = this.tagIndex;
        this.tagMetaStack.push(tm);
        if ("g".equals(ns) && this.tagRegistry.isSyntaxTag(tagName)) {
            if (this.tagContext == null) {
                this.tagContext = new HashMap();
                this.tagContext.put("out", this.out);
                this.tagContext.put(GroovyPageParser.class, this);
            }
            GroovySyntaxTag tag = (GroovySyntaxTag)this.tagRegistry.newTag(tagName);
            tag.init(this.tagContext);
            tag.setAttributes(attrs);
            if (tag.isKeepPrecedingWhiteSpace() && this.currentlyBufferingWhitespace) {
                this.flushBufferedWhiteSpace();
            } else {
                if (!tag.isAllowPrecedingContent() && this.previousContentWasNonWhitespace) {
                    throw new GrailsTagException("Tag [" + tag.getName() + "] cannot have non-whitespace characters directly preceding it.", this.pageName, this.out.getCurrentLineNumber());
                }
                this.clearBufferedWhiteSpace();
            }
            tag.doStartTag();
            tm.instance = tag;
        } else {
            this.flushBufferedWhiteSpace();
            if (attrs.size() > 0) {
                FastStringWriter buffer = new FastStringWriter();
                buffer.print('[');
                Iterator i = attrs.keySet().iterator();
                while (i.hasNext()) {
                    String name;
                    String cleanedName = name = (String)i.next();
                    if (name.startsWith("\"") && name.endsWith("\"")) {
                        cleanedName = "'" + name.substring(1, name.length() - 1) + "'";
                    }
                    buffer.print(cleanedName);
                    buffer.print(':');
                    buffer.print(this.getExpressionText(attrs.get(name).toString()));
                    if (i.hasNext()) {
                        buffer.print(',');
                        continue;
                    }
                    buffer.print("] as GroovyPageAttributes");
                }
                this.attrsVarsMapDefinition.put(this.tagIndex, buffer.toString());
            }
            if (!emptyTag) {
                tm.bufferMode = true;
            }
        }
    }

    private void writeTagBodyStart(TagMeta tm) {
        if (tm.bufferMode) {
            tm.bufferMode = false;
            if (!this.bodyVarsDefined.contains(tm.tagIndex)) {
                this.bodyVarsDefined.add(tm.tagIndex);
            }
            this.out.println("body" + tm.tagIndex + " = new GroovyPageTagBody(this,binding.webRequest, {");
            ++this.closureLevel;
        }
    }

    private void clearBufferedWhiteSpace() {
        this.whitespaceBuffer.delete(0, this.whitespaceBuffer.length());
        this.currentlyBufferingWhitespace = false;
    }

    private void flushBufferedWhiteSpace() {
        if (this.currentlyBufferingWhitespace) {
            this.appendHtmlPart(null);
        }
        this.currentlyBufferingWhitespace = false;
    }

    private void populateMapWithAttributes(Map attrs, String attrTokens) {
        Matcher m = PARSE_TAG_FIRST_PASS.matcher(attrTokens);
        this.populateAttributesFromMatcher(m, attrs);
        m = PARSE_TAG_SECOND_PASS.matcher(attrTokens);
        this.populateAttributesFromMatcher(m, attrs);
    }

    private void populateAttributesFromMatcher(Matcher m, Map attrs) {
        while (m.find()) {
            String name = m.group(2);
            String val = m.group(3);
            name = '\"' + name + '\"';
            if (val.startsWith("${") && val.endsWith("}") && val.indexOf("${", 2) == -1) {
                val = val.substring(2, val.length() - 1);
            } else if (!val.startsWith("[") || !val.endsWith("]")) {
                val = '\"' + val + '\"';
            }
            attrs.put(name, val);
        }
    }

    private void pageImport(String value) {
        String[] imports = Pattern.compile(";").split(value.subSequence(0, value.length()));
        for (int ix = 0; ix < imports.length; ++ix) {
            this.out.print("import ");
            this.out.print(imports[ix]);
            this.out.println();
        }
    }

    private String readStream(InputStream in) throws IOException {
        return IOUtils.toString((InputStream)in, (String)this.gspEncoding);
    }

    private void script(boolean gsp) {
        this.flushTagBuffering();
        if (!this.finalPass) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"parse: script");
        }
        this.out.println();
        this.write(this.scan.getToken().trim(), gsp);
        this.out.println();
        this.out.println();
    }

    private void write(CharSequence text, boolean gsp) {
        if (!gsp) {
            this.out.print(text);
            return;
        }
        int ixz = text.length();
        for (int ix = 0; ix < ixz; ++ix) {
            char c = text.charAt(ix);
            String rep = null;
            if (Character.isWhitespace(c)) {
                ++ix;
                while (ix < ixz) {
                    if (!Character.isWhitespace(text.charAt(ix))) {
                        --ix;
                        rep = " ";
                        break;
                    }
                    ++ix;
                }
            } else if (c == '&') {
                if (GroovyPageParser.match("&semi;", text, ix)) {
                    rep = ";";
                    ix += 5;
                } else if (GroovyPageParser.match("&amp;", text, ix)) {
                    rep = "&";
                    ix += 4;
                } else if (GroovyPageParser.match("&lt;", text, ix)) {
                    rep = "<";
                    ix += 3;
                } else if (GroovyPageParser.match("&gt;", text, ix)) {
                    rep = ">";
                    ix += 3;
                }
            } else if (c == '<') {
                if (GroovyPageParser.match("<br>", text, ix) || GroovyPageParser.match("<hr>", text, ix)) {
                    rep = "\n";
                    ix += 3;
                } else {
                    int end = GroovyPageParser.match(PARA_BREAK, text, ix);
                    if (end <= 0) {
                        end = GroovyPageParser.match(ROW_BREAK, text, ix);
                    }
                    if (end > 0) {
                        rep = "\n";
                        ix = end;
                    }
                }
            }
            if (rep != null) {
                this.out.print(rep);
                continue;
            }
            this.out.print(c);
        }
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public List<String> getHtmlParts() {
        return this.htmlParts;
    }

    public String[] getHtmlPartsArray() {
        return this.htmlParts.toArray(new String[this.htmlParts.size()]);
    }

    public boolean isInClosure() {
        return this.closureLevel > 0;
    }

    public String getDefaultCodecDirectiveValue() {
        return this.defaultCodecDirectiveValue;
    }

    class TagMeta {
        String name;
        String namespace;
        Object instance;
        boolean isDynamic;
        boolean hasAttributes;
        int lineNumber;
        boolean emptyTag;
        int tagIndex;
        boolean bufferMode = false;
        int bufferPartNumber = -1;

        TagMeta() {
        }

        public String toString() {
            return "<" + this.namespace + ":" + this.name + ">";
        }
    }
}

