/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.servlet;

import grails.util.Environment;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsControllerClass;
import org.codehaus.groovy.grails.plugins.support.aware.GrailsApplicationAware;
import org.codehaus.groovy.grails.web.servlet.GrailsUrlPathHelper;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.request.WebRequestInterceptor;
import org.springframework.web.servlet.HandlerExecutionChain;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.handler.AbstractHandlerMapping;
import org.springframework.web.servlet.handler.WebRequestHandlerInterceptorAdapter;
import org.springframework.web.servlet.mvc.Controller;
import org.springframework.web.util.UrlPathHelper;

public class GrailsControllerHandlerMapping
extends AbstractHandlerMapping
implements GrailsApplicationAware {
    public static final String MAIN_CONTROLLER_BEAN = "mainSimpleController";
    private GrailsApplication grailsApplication;
    private UrlPathHelper urlHelper = new GrailsUrlPathHelper();

    protected Object getHandlerInternal(HttpServletRequest request) throws Exception {
        String uri = this.urlHelper.getPathWithinApplication(request);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Looking up Grails controller for URI [" + uri + "]"));
        }
        GrailsControllerClass controllerClass = (GrailsControllerClass)this.grailsApplication.getArtefactForFeature("Controller", (Object)uri);
        return this.getHandlerForControllerClass(controllerClass, request);
    }

    protected Object getHandlerForControllerClass(GrailsControllerClass controllerClass, HttpServletRequest request) {
        if (controllerClass != null) {
            try {
                return this.getWebApplicationContext().getBean(MAIN_CONTROLLER_BEAN, Controller.class);
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                // empty catch block
            }
        }
        return null;
    }

    protected final HandlerExecutionChain getHandlerExecutionChain(Object handler, HttpServletRequest request) {
        if (handler instanceof HandlerExecutionChain) {
            HandlerExecutionChain chain = (HandlerExecutionChain)handler;
            chain.addInterceptors(this.lookupInterceptors(this.getWebApplicationContext()));
            return chain;
        }
        return new HandlerExecutionChain(handler, this.lookupInterceptors(this.getWebApplicationContext()));
    }

    protected void extendInterceptors(List interceptors) {
        this.setInterceptors(this.establishInterceptors(this.getWebApplicationContext()));
    }

    protected HandlerInterceptor[] lookupInterceptors(WebApplicationContext applicationContext) {
        HandlerInterceptor[] interceptors = Environment.getCurrent() == Environment.DEVELOPMENT ? this.establishInterceptors(applicationContext) : this.getAdaptedInterceptors();
        return interceptors;
    }

    protected HandlerInterceptor[] establishInterceptors(WebApplicationContext webContext) {
        String[] interceptorNames = webContext.getBeanNamesForType(HandlerInterceptor.class);
        String[] webRequestInterceptors = webContext.getBeanNamesForType(WebRequestInterceptor.class);
        HandlerInterceptor[] interceptors = new HandlerInterceptor[interceptorNames.length + webRequestInterceptors.length];
        int j = 0;
        for (String webRequestInterceptor : webRequestInterceptors) {
            interceptors[j++] = new WebRequestHandlerInterceptorAdapter((WebRequestInterceptor)webContext.getBean(webRequestInterceptor));
        }
        for (String interceptorName : interceptorNames) {
            interceptors[j++] = (HandlerInterceptor)webContext.getBean(interceptorName);
        }
        return interceptors;
    }

    public void setGrailsApplication(GrailsApplication grailsApplication) {
        this.grailsApplication = grailsApplication;
    }
}

