/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.pages;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.grails.web.pages.Strip;
import org.codehaus.groovy.grails.web.pages.Tokens;

class GroovyPageScanner
implements Tokens {
    private String text;
    private int end1;
    private int begin1;
    private int end2;
    private int begin2;
    private int state = 0;
    private int len;
    private int level;
    private boolean str1;
    private boolean str2;
    private String lastNamespace;
    private int exprBracketCount = 0;
    private List<Integer> lineNumberPositions;
    private int lastLineNumberIndex = -1;

    GroovyPageScanner(String text) {
        Strip strip = new Strip(text);
        strip.strip(0);
        this.text = strip.toString();
        this.len = this.text.length();
        this.lastNamespace = null;
        this.resolveLineNumberPositions();
    }

    private void resolveLineNumberPositions() {
        this.lineNumberPositions = new ArrayList<Integer>();
        this.lineNumberPositions.add(0);
        for (int i = 0; i < this.len; ++i) {
            if (this.text.charAt(i) != '\n') continue;
            this.lineNumberPositions.add(i + 1);
        }
    }

    private int found(int newState, int skip) {
        this.begin2 = this.begin1;
        this.end2 = --this.end1;
        this.begin1 = this.end1 += skip;
        int lastState = this.state;
        this.state = newState;
        return lastState;
    }

    private int foundStartOrEndTag(int newState, int skip, String namespace) {
        this.begin2 = this.begin1;
        this.end2 = --this.end1;
        this.begin1 = this.end1 += skip;
        int lastState = this.state;
        this.state = newState;
        this.lastNamespace = namespace;
        return lastState;
    }

    String getToken() {
        return this.text.substring(this.begin2, this.end2);
    }

    int getLineNumberForToken() {
        for (int i = this.lastLineNumberIndex + 1; i < this.lineNumberPositions.size(); ++i) {
            if (this.lineNumberPositions.get(i) <= this.begin2) continue;
            this.lastLineNumberIndex = i - 1;
            return i;
        }
        return 1;
    }

    String getNamespace() {
        return this.lastNamespace;
    }

    int nextToken() {
        while (true) {
            int left;
            if ((left = this.len - this.end1) == 0) {
                ++this.end1;
                return this.found(-1, 0);
            }
            char c = this.text.charAt(this.end1++);
            char c1 = left > 1 ? this.text.charAt(this.end1) : (char)'\u0000';
            char c2 = left > 2 ? this.text.charAt(this.end1 + 1) : (char)'\u0000';
            char c3 = left > 3 ? this.text.charAt(this.end1 + 2) : (char)'\u0000';
            StringBuffer chars = new StringBuffer().append(c).append(c1).append(c2);
            String startTag = chars.toString();
            String endTag = chars.append(c3).toString();
            if (this.str1) {
                if (c == '\\') {
                    ++this.end1;
                    continue;
                }
                if (c != '\'') continue;
                this.str1 = false;
                continue;
            }
            if (this.str2) {
                if (c == '\\') {
                    ++this.end1;
                    continue;
                }
                if (c != '\"') continue;
                this.str2 = false;
                continue;
            }
            if (this.level > 0 && (c == ')' || c == '}' || c == ']')) {
                --this.level;
                continue;
            }
            switch (this.state) {
                case 0: {
                    if (c == '<' && left > 3) {
                        String tagNameSpace;
                        int foundColonIdx;
                        if (c1 == '%') {
                            if (c2 == '=') {
                                return this.found(1, 3);
                            }
                            if (c2 == '@') {
                                return this.found(3, 3);
                            }
                            if (c2 == '!') {
                                return this.found(4, 3);
                            }
                            if (c2 == '-' && left > 3 && this.text.charAt(this.end1 + 2) == '-' && this.skipJComment()) break;
                            return this.found(2, 2);
                        }
                        boolean bStartTag = true;
                        int fromIndex = this.end1;
                        if (c1 == '/') {
                            bStartTag = false;
                            fromIndex = this.end1 + 1;
                        }
                        if ((foundColonIdx = this.text.indexOf(":", fromIndex)) <= -1 || !(tagNameSpace = this.text.substring(fromIndex, foundColonIdx)).matches("^\\p{Alpha}\\w*$")) break;
                        if (bStartTag) {
                            return this.foundStartOrEndTag(15, tagNameSpace.length() + 2, tagNameSpace);
                        }
                        return this.foundStartOrEndTag(16, tagNameSpace.length() + 3, tagNameSpace);
                    }
                    if (c == '$' && c1 == '{') {
                        return this.found(11, 2);
                    }
                    if (c == '%' && c1 == '{') {
                        if (c2 == '-' && left > 3 && this.text.charAt(this.end1 + 2) == '-' && this.skipGComment()) break;
                        return this.found(12, 2);
                    }
                    if (c == '!' && c1 == '{') {
                        return this.found(14, 2);
                    }
                    if (c != '@' || c1 != '{') break;
                    return this.found(13, 2);
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    if (c != '%' || c1 != '>') break;
                    return this.found(0, 2);
                }
                case 15: {
                    if (c == '$' && c1 == '{') {
                        return this.found(17, 2);
                    }
                    if (c == '>') {
                        return this.found(0, 1);
                    }
                    if (c != '/' || c1 != '>') break;
                    return this.found(18, 1);
                }
                case 16: 
                case 18: {
                    if (c != '>') break;
                    return this.found(0, 1);
                }
                case 17: {
                    if (c == '{') {
                        ++this.exprBracketCount;
                        break;
                    }
                    if (c != '}') break;
                    if (this.exprBracketCount > 0) {
                        --this.exprBracketCount;
                        break;
                    }
                    return this.found(15, 1);
                }
                case 11: 
                case 13: {
                    if (c != '}' || this.str1 || this.str2 || this.level != 0) break;
                    return this.found(0, 1);
                }
                case 12: {
                    if (c != '}' || c1 != '%' || this.str1 || this.str2 || this.level != 0) break;
                    return this.found(0, 2);
                }
                case 14: {
                    if (c != '}' || c1 != '!' && c1 != '%' || this.str1 || this.str2 || this.level != 0) break;
                    return this.found(0, 2);
                }
            }
        }
    }

    private boolean skipComment(char c3, char c4) {
        int ix = this.end1 + 3;
        int ixz = this.len - 4;
        while (true) {
            if (ix >= ixz) {
                return false;
            }
            if (this.text.charAt(ix) == '-' && this.text.charAt(ix + 1) == '-' && this.text.charAt(ix + 2) == c3 && this.text.charAt(ix + 3) == c4) break;
            ++ix;
        }
        this.text = this.text.substring(0, --this.end1) + this.text.substring(ix + 4);
        this.len = this.text.length();
        return true;
    }

    private boolean skipGComment() {
        return this.skipComment('}', '%');
    }

    private boolean skipJComment() {
        return this.skipComment('%', '>');
    }

    void reset() {
        this.level = 0;
        this.begin2 = 0;
        this.end2 = 0;
        this.begin1 = 0;
        this.end1 = 0;
        this.state = 0;
        this.lastNamespace = null;
        this.lastLineNumberIndex = -1;
    }
}

