/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.mapping;

import grails.util.GrailsNameUtils;
import groovy.util.ConfigObject;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.web.mapping.AbstractUrlMappingInfo;
import org.codehaus.groovy.grails.web.mapping.UrlMappingData;
import org.codehaus.groovy.grails.web.mapping.UrlMappingInfo;
import org.codehaus.groovy.grails.web.mapping.exceptions.UrlMappingException;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsWebRequest;
import org.codehaus.groovy.grails.web.util.WebUtils;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.MultipartResolver;

public class DefaultUrlMappingInfo
extends AbstractUrlMappingInfo
implements UrlMappingInfo {
    private Object controllerName;
    private Object actionName;
    private Object id;
    private static final String ID_PARAM = "id";
    private UrlMappingData urlData;
    private Object viewName;
    private ServletContext servletContext;
    private static final String SETTING_GRAILS_WEB_DISABLE_MULTIPART = "grails.web.disable.multipart";
    private boolean parsingRequest;
    private Object uri;

    private DefaultUrlMappingInfo(Map params, UrlMappingData urlData, ServletContext servletContext) {
        this.params = Collections.unmodifiableMap(params);
        this.id = params.get(ID_PARAM);
        this.urlData = urlData;
        this.servletContext = servletContext;
    }

    public DefaultUrlMappingInfo(Object controllerName, Object actionName, Object viewName, Map params, UrlMappingData urlData, ServletContext servletContext) {
        this(params, urlData, servletContext);
        if (controllerName == null && viewName == null) {
            throw new IllegalArgumentException("URL mapping must either provide a controller or view name to map to!");
        }
        if (params == null) {
            throw new IllegalArgumentException("Argument [params] cannot be null");
        }
        this.controllerName = controllerName;
        this.actionName = actionName;
        if (actionName == null) {
            this.viewName = viewName;
        }
    }

    public DefaultUrlMappingInfo(Object viewName, Map params, UrlMappingData urlData, ServletContext servletContext) {
        this(params, urlData, servletContext);
        this.viewName = viewName;
        if (viewName == null) {
            throw new IllegalArgumentException("Argument [viewName] cannot be null or blank");
        }
    }

    public DefaultUrlMappingInfo(Object uri, UrlMappingData data, ServletContext servletContext) {
        this(Collections.EMPTY_MAP, data, servletContext);
        this.uri = uri;
        if (uri == null) {
            throw new IllegalArgumentException("Argument [uri] cannot be null or blank");
        }
    }

    public String toString() {
        return this.urlData.getUrlPattern();
    }

    public Map getParameters() {
        return this.params;
    }

    public boolean isParsingRequest() {
        return this.parsingRequest;
    }

    public void setParsingRequest(boolean parsingRequest) {
        this.parsingRequest = parsingRequest;
    }

    public String getControllerName() {
        String controllerName = this.evaluateNameForValue(this.controllerName);
        if (controllerName == null && this.getViewName() == null) {
            throw new UrlMappingException("Unable to establish controller name to dispatch for [" + this.controllerName + "]. Dynamic closure invocation returned null. Check your mapping file is correct, when assigning the controller name as a request parameter it cannot be an optional token!");
        }
        return controllerName;
    }

    public String getActionName() {
        String name;
        GrailsWebRequest webRequest = (GrailsWebRequest)RequestContextHolder.getRequestAttributes();
        String string = name = webRequest != null ? this.checkDispatchAction(webRequest.getCurrentRequest(), null) : null;
        if (name == null) {
            name = this.evaluateNameForValue(this.actionName, webRequest);
        }
        return name;
    }

    public String getViewName() {
        return this.evaluateNameForValue(this.viewName);
    }

    public String getId() {
        return this.evaluateNameForValue(this.id);
    }

    private String checkDispatchAction(HttpServletRequest request, String actionName) {
        Enumeration paramNames = this.tryMultipartParams(request, request.getParameterNames());
        while (paramNames.hasMoreElements()) {
            String name = (String)paramNames.nextElement();
            if (!name.startsWith("_action_")) continue;
            if (name.endsWith(".x") || name.endsWith(".y")) {
                name = name.substring(0, name.length() - 2);
            }
            actionName = GrailsNameUtils.getPropertyNameRepresentation(name.substring("_action_".length()));
            break;
        }
        return actionName;
    }

    private Enumeration tryMultipartParams(HttpServletRequest request, Enumeration originalParams) {
        MultipartResolver resolver;
        Enumeration paramNames = originalParams;
        boolean disabled = this.getMultipartDisabled();
        if (!disabled && (resolver = this.getResolver()).isMultipart(request)) {
            MultipartHttpServletRequest resolvedMultipartRequest = this.getResolvedRequest(request, resolver);
            paramNames = resolvedMultipartRequest.getParameterNames();
        }
        return paramNames;
    }

    private MultipartHttpServletRequest getResolvedRequest(HttpServletRequest request, MultipartResolver resolver) {
        MultipartHttpServletRequest resolvedMultipartRequest = (MultipartHttpServletRequest)request.getAttribute(MultipartHttpServletRequest.class.getName());
        if (resolvedMultipartRequest == null) {
            resolvedMultipartRequest = resolver.resolveMultipart(request);
            request.setAttribute(MultipartHttpServletRequest.class.getName(), (Object)resolvedMultipartRequest);
        }
        return resolvedMultipartRequest;
    }

    private boolean getMultipartDisabled() {
        GrailsApplication app = WebUtils.lookupApplication(this.servletContext);
        ConfigObject config = app.getConfig();
        boolean disabled = false;
        Object disableMultipart = config.get((Object)SETTING_GRAILS_WEB_DISABLE_MULTIPART);
        if (disableMultipart instanceof Boolean) {
            disabled = (Boolean)disableMultipart;
        } else if (disableMultipart instanceof String) {
            disabled = Boolean.valueOf((String)disableMultipart);
        }
        return disabled;
    }

    private MultipartResolver getResolver() {
        WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.servletContext);
        MultipartResolver resolver = (MultipartResolver)ctx.getBean("multipartResolver");
        return resolver;
    }

    public String getURI() {
        return this.evaluateNameForValue(this.uri);
    }
}

