/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.json;

import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.web.json.JSONWriter;

public class PathCapturingJSONWriterWrapper
extends JSONWriter {
    private final Log log = LogFactory.getLog(this.getClass());
    private final boolean debugCurrentStack = true;
    private JSONWriter delegate;
    private Stack<PathElement> pathStack = new Stack();

    public PathCapturingJSONWriterWrapper(JSONWriter delegate) {
        super(null);
        this.delegate = delegate;
    }

    public JSONWriter append(String s) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(this.delegate.mode.name() + " > " + String.format(">> " + this.getCurrentStrackReference(), new Object[0])));
            this.log.debug((Object)(this.delegate.mode.name() + " > " + String.format("append(%s)", s)));
        }
        this.delegate.append(s);
        return this;
    }

    public void comma() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(this.delegate.mode.name() + " > " + String.format(">> " + this.getCurrentStrackReference(), new Object[0])));
            this.log.debug((Object)"comma()");
        }
        this.delegate.comma();
    }

    public JSONWriter array() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(this.delegate.mode.name() + " > " + String.format(">> " + this.getCurrentStrackReference(), new Object[0])));
            this.log.debug((Object)(this.delegate.mode.name() + " > " + String.format("array()", new Object[0])));
        }
        this.pathStack.push(new IndexElement(-1));
        this.delegate.array();
        return this;
    }

    public JSONWriter end(JSONWriter.Mode m, char c) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(this.delegate.mode.name() + " > " + String.format(">> " + this.getCurrentStrackReference(), new Object[0])));
            this.log.debug((Object)(this.delegate.mode.name() + " > " + String.format("end(%s, %s)", new Object[]{m, Character.valueOf(c)})));
        }
        this.delegate.end(m, c);
        return this;
    }

    public JSONWriter endArray() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(this.delegate.mode.name() + " > " + String.format(">> " + this.getCurrentStrackReference(), new Object[0])));
            this.log.debug((Object)(this.delegate.mode.name() + " > " + String.format("endArray()", new Object[0])));
        }
        this.pathStack.pop();
        this.delegate.endArray();
        if (this.delegate.mode == JSONWriter.Mode.KEY) {
            this.pathStack.pop();
        }
        return this;
    }

    public JSONWriter endObject() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(this.delegate.mode.name() + " > " + String.format(">> " + this.getCurrentStrackReference(), new Object[0])));
            this.log.debug((Object)(this.delegate.mode.name() + " > " + String.format("endObject()", new Object[0])));
        }
        this.delegate.endObject();
        if (this.delegate.mode != JSONWriter.Mode.ARRAY && this.pathStack.size() > 0) {
            this.pathStack.pop();
        }
        return this;
    }

    public JSONWriter key(String s) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(this.delegate.mode.name() + " > " + String.format(">> " + this.getCurrentStrackReference(), new Object[0])));
            this.log.debug((Object)(this.delegate.mode.name() + " > " + String.format("key(%s)", s)));
        }
        this.pathStack.push(new PropertyElement(s));
        this.delegate.key(s);
        return this;
    }

    public JSONWriter object() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(this.delegate.mode.name() + " > " + String.format(">> " + this.getCurrentStrackReference(), new Object[0])));
            this.log.debug((Object)(this.delegate.mode.name() + " > " + String.format("object()", new Object[0])));
        }
        if (this.delegate.mode == JSONWriter.Mode.ARRAY) {
            this.pushNextIndex();
        }
        this.delegate.object();
        return this;
    }

    public void pop(JSONWriter.Mode c) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(this.delegate.mode.name() + " > " + String.format(">> " + this.getCurrentStrackReference(), new Object[0])));
            this.log.debug((Object)(this.delegate.mode.name() + " > " + String.format("pop(%s)", new Object[]{c})));
        }
        this.delegate.pop(c);
    }

    public void push(JSONWriter.Mode c) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(this.delegate.mode.name() + " > " + String.format(">> " + this.getCurrentStrackReference(), new Object[0])));
            this.log.debug((Object)(this.delegate.mode.name() + " > " + String.format("push(%s)", new Object[]{c})));
        }
        this.delegate.push(c);
    }

    private void pushNextIndex() {
        int x = this.nextIndex();
        this.pathStack.pop();
        this.pathStack.push(new IndexElement(x));
    }

    private int nextIndex() {
        int x = ((IndexElement)this.pathStack.peek()).index + 1;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(this.delegate.mode.name() + " > " + String.format(">> " + this.getCurrentStrackReference(), new Object[0])));
            this.log.debug((Object)(this.delegate.mode.name() + " > " + String.format("Next index: " + x, new Object[0])));
        }
        return x;
    }

    public JSONWriter value(boolean b) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(this.delegate.mode.name() + " > " + String.format(">> " + this.getCurrentStrackReference(), new Object[0])));
            this.log.debug((Object)(this.delegate.mode.name() + " > " + String.format("value(boolean %b)", b)));
        }
        if (this.delegate.mode == JSONWriter.Mode.ARRAY) {
            this.pushNextIndex();
        } else {
            this.pathStack.pop();
        }
        this.delegate.value(b);
        return this;
    }

    public JSONWriter value(double d) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(this.delegate.mode.name() + " > " + String.format(">> " + this.getCurrentStrackReference(), new Object[0])));
            this.log.debug((Object)(this.delegate.mode.name() + " > " + String.format("value(double %s)", d)));
        }
        if (this.delegate.mode == JSONWriter.Mode.ARRAY) {
            this.pushNextIndex();
        } else {
            this.pathStack.pop();
        }
        this.delegate.value(d);
        return this;
    }

    public JSONWriter value(long l) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(this.delegate.mode.name() + " > " + String.format(">> " + this.getCurrentStrackReference(), new Object[0])));
            this.log.debug((Object)(this.delegate.mode.name() + " > " + String.format("value(long %s)", l)));
        }
        if (this.delegate.mode == JSONWriter.Mode.ARRAY) {
            this.pushNextIndex();
        } else {
            this.pathStack.pop();
        }
        this.delegate.value(l);
        return this;
    }

    public JSONWriter value(Object o) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(this.delegate.mode.name() + " > " + String.format(">> " + this.getCurrentStrackReference(), new Object[0])));
            this.log.debug((Object)(this.delegate.mode.name() + " > " + String.format("value(Object %s)", o)));
        }
        if (this.delegate.mode == JSONWriter.Mode.ARRAY) {
            this.pushNextIndex();
        } else {
            this.pathStack.pop();
        }
        this.delegate.value(o);
        return this;
    }

    public String getStackReference(int depth) {
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < depth; ++i) {
            PathElement el = (PathElement)this.pathStack.get(i);
            out.append(el.toString());
        }
        return out.toString();
    }

    public String getCurrentStrackReference() {
        StringBuilder out = new StringBuilder();
        for (PathElement el : this.pathStack) {
            out.append(el.toString());
        }
        return out.toString();
    }

    private class IndexElement
    extends PathElement {
        private int index;

        private IndexElement(int index) {
            this.index = index;
        }

        public String toString() {
            return "[" + this.index + "]";
        }
    }

    private class PropertyElement
    extends PathElement {
        private String property;

        private PropertyElement(String property) {
            this.property = property;
        }

        public String toString() {
            return "." + this.property;
        }
    }

    private class PathElement {
        private PathElement() {
        }
    }
}

