/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.pages;

import java.io.Writer;
import java.util.Stack;
import org.apache.commons.io.output.NullWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsWebRequest;
import org.codehaus.groovy.grails.web.util.GrailsPrintWriter;
import org.springframework.web.context.request.RequestContextHolder;

public final class GroovyPageOutputStack {
    public static final Log log = LogFactory.getLog(GroovyPageOutputStack.class);
    private static final ThreadLocal<GroovyPageOutputStack> instances = new ThreadLocal();
    private Stack<WriterPair> stack = new Stack();
    private GroovyPageProxyWriter proxyWriter = new GroovyPageProxyWriter();
    private boolean autoSync;

    public static final GroovyPageOutputStack currentStack() {
        return GroovyPageOutputStack.currentStack(true);
    }

    public static final GroovyPageOutputStack currentStack(boolean allowCreate) {
        return GroovyPageOutputStack.currentStack(allowCreate, null, allowCreate, false);
    }

    public static final GroovyPageOutputStack currentStack(boolean allowCreate, Writer topWriter, boolean autoSync, boolean pushTop) {
        GroovyPageOutputStack outputStack = instances.get();
        if (outputStack != null) {
            if (pushTop && topWriter != null) {
                outputStack.push(topWriter);
            }
            return outputStack;
        }
        if (allowCreate) {
            if (topWriter == null) {
                topWriter = GroovyPageOutputStack.defaultRequest();
            }
            return GroovyPageOutputStack.createNew(topWriter, autoSync);
        }
        return null;
    }

    private static Writer defaultRequest() {
        return (Writer)RequestContextHolder.currentRequestAttributes().getAttribute("org.codehaus.groovy.grails.RESPONSE_OUT", 0);
    }

    public static final GroovyPageOutputStack createNew(Writer topWriter) {
        return GroovyPageOutputStack.createNew(topWriter, false);
    }

    private static final GroovyPageOutputStack createNew(Writer topWriter, boolean autoSync) {
        GroovyPageOutputStack instance = new GroovyPageOutputStack(topWriter, autoSync);
        RequestContextHolder.currentRequestAttributes().registerDestructionCallback(GroovyPageOutputStack.class.getName(), new Runnable(){

            public void run() {
                GroovyPageOutputStack.removeCurrentInstance();
            }
        }, 0);
        instances.set(instance);
        return instance;
    }

    public static final void removeCurrentInstance() {
        instances.remove();
    }

    public static final Writer currentWriter() {
        GroovyPageOutputStack outputStack = GroovyPageOutputStack.currentStack(false);
        if (outputStack != null) {
            return outputStack.getProxyWriter();
        }
        return GroovyPageOutputStack.defaultRequest();
    }

    private GroovyPageOutputStack(Writer topWriter, boolean autoSync) {
        this.autoSync = autoSync;
        this.push(topWriter);
        if (!autoSync) {
            this.applyWriterThreadLocals(this.proxyWriter);
        }
    }

    private Writer unwrapTargetWriter(Writer targetWriter) {
        if (targetWriter instanceof GrailsPrintWriter) {
            return ((GrailsPrintWriter)targetWriter).getOut();
        }
        return targetWriter;
    }

    public void push(Writer newWriter) {
        this.push(newWriter, false);
    }

    public void push(Writer newWriter, boolean checkExisting) {
        Writer unwrappedWriter;
        if (newWriter == this.proxyWriter && this.stack.size() > 0) {
            this.stack.push(this.stack.peek());
            return;
        }
        if (checkExisting) {
            for (WriterPair item : this.stack) {
                if (item.originalTarget != newWriter) continue;
                log.warn((Object)("Pushed a writer to stack a second time. Writer type " + newWriter.getClass().getName()), (Throwable)new Exception());
            }
        }
        if ((unwrappedWriter = this.unwrapTargetWriter(newWriter)) == this.proxyWriter && this.stack.size() > 0) {
            this.stack.push(this.stack.peek());
            return;
        }
        this.stack.push(new WriterPair(newWriter, unwrappedWriter));
        this.proxyWriter.setOut(newWriter);
        if (this.autoSync) {
            this.applyWriterThreadLocals(newWriter);
        }
    }

    public void pop() {
        this.pop(this.autoSync);
    }

    public void pop(boolean forceSync) {
        this.stack.pop();
        if (this.stack.size() > 0) {
            WriterPair pair = this.stack.peek();
            this.proxyWriter.setOut(pair.unwrappedTarget);
            if (forceSync) {
                this.applyWriterThreadLocals(pair.originalTarget);
            }
        }
    }

    public GroovyPageProxyWriter getProxyWriter() {
        return this.proxyWriter;
    }

    public Writer getCurrentOriginalWriter() {
        return this.stack.peek().originalTarget;
    }

    public void restoreThreadLocalsToOriginals() {
        Writer originalTopWriter = ((WriterPair)this.stack.firstElement()).originalTarget;
        this.applyWriterThreadLocals(originalTopWriter);
    }

    private void applyWriterThreadLocals(Writer writer) {
        GrailsWebRequest webRequest = (GrailsWebRequest)RequestContextHolder.currentRequestAttributes();
        if (webRequest != null) {
            webRequest.setOut(writer);
        }
    }

    private class GroovyPageProxyWriter
    extends GrailsPrintWriter {
        public GroovyPageProxyWriter() {
            super((Writer)new NullWriter());
        }

        public void setOut(Writer newOut) {
            this.out = newOut;
        }

        public GroovyPageOutputStack getOutputStack() {
            return GroovyPageOutputStack.this;
        }
    }

    private class WriterPair {
        Writer originalTarget;
        Writer unwrappedTarget;

        WriterPair(Writer originalTarget, Writer unwrappedTarget) {
            this.originalTarget = originalTarget;
            this.unwrappedTarget = unwrappedTarget;
        }
    }
}

