/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.pages;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.web.pages.TagLibraryLookup;
import org.codehaus.groovy.grails.web.pages.exceptions.GroovyPagesException;
import org.codehaus.groovy.grails.web.pages.ext.jsp.TagLibraryResolver;
import org.springframework.util.ReflectionUtils;

class GroovyPageMetaInfo {
    private static final Log LOG = LogFactory.getLog(GroovyPageMetaInfo.class);
    private TagLibraryLookup tagLibraryLookup;
    private TagLibraryResolver jspTagLibraryResolver;
    private boolean precompiledMode = false;
    private Class pageClass;
    private long lastModified;
    private InputStream groovySource;
    private String contentType;
    private int[] lineNumbers;
    private String[] htmlParts;
    private Map jspTags = Collections.EMPTY_MAP;
    private GroovyPagesException compilationException;
    public static final String HTML_DATA_POSTFIX = "_html.data";
    public static final String LINENUMBERS_DATA_POSTFIX = "_linenumbers.data";

    public GroovyPageMetaInfo() {
    }

    public GroovyPageMetaInfo(Class pageClass) {
        this.precompiledMode = true;
        this.pageClass = pageClass;
        this.contentType = (String)ReflectionUtils.getField((Field)ReflectionUtils.findField((Class)pageClass, (String)"CONTENT_TYPE"), null);
        this.jspTags = (Map)ReflectionUtils.getField((Field)ReflectionUtils.findField((Class)pageClass, (String)"JSP_TAGS"), null);
        this.lastModified = (Long)ReflectionUtils.getField((Field)ReflectionUtils.findField((Class)pageClass, (String)"LAST_MODIFIED"), null);
        try {
            this.readHtmlData();
        }
        catch (IOException e) {
            throw new RuntimeException("Problem reading html data for page class " + pageClass, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readHtmlData() throws IOException {
        String dataResourceName = this.resolveDataResourceName(HTML_DATA_POSTFIX);
        DataInputStream input = null;
        try {
            input = new DataInputStream(this.pageClass.getResourceAsStream(dataResourceName));
            int arrayLen = input.readInt();
            this.htmlParts = new String[arrayLen];
            for (int i = 0; i < arrayLen; ++i) {
                this.htmlParts[i] = input.readUTF();
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(input);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)input);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readLineNumbers() throws IOException {
        String dataResourceName = this.resolveDataResourceName(LINENUMBERS_DATA_POSTFIX);
        DataInputStream input = null;
        try {
            input = new DataInputStream(this.pageClass.getResourceAsStream(dataResourceName));
            int arrayLen = input.readInt();
            this.lineNumbers = new int[arrayLen];
            for (int i = 0; i < arrayLen; ++i) {
                this.lineNumbers[i] = input.readInt();
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(input);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)input);
    }

    private String resolveDataResourceName(String postfix) {
        String dataResourceName = this.pageClass.getName();
        int pos = dataResourceName.lastIndexOf(46);
        if (pos > -1) {
            dataResourceName = dataResourceName.substring(pos + 1);
        }
        dataResourceName = dataResourceName + postfix;
        return dataResourceName;
    }

    public TagLibraryLookup getTagLibraryLookup() {
        return this.tagLibraryLookup;
    }

    public void setTagLibraryLookup(TagLibraryLookup tagLibraryLookup) {
        this.tagLibraryLookup = tagLibraryLookup;
    }

    public TagLibraryResolver getJspTagLibraryResolver() {
        return this.jspTagLibraryResolver;
    }

    public void setJspTagLibraryResolver(TagLibraryResolver jspTagLibraryResolver) {
        this.jspTagLibraryResolver = jspTagLibraryResolver;
    }

    public Class getPageClass() {
        return this.pageClass;
    }

    public void setPageClass(Class pageClass) {
        this.pageClass = pageClass;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public InputStream getGroovySource() {
        return this.groovySource;
    }

    public void setGroovySource(InputStream groovySource) {
        this.groovySource = groovySource;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public int[] getLineNumbers() {
        if (this.precompiledMode) {
            return this.getPrecompiledLineNumbers();
        }
        return this.lineNumbers;
    }

    private synchronized int[] getPrecompiledLineNumbers() {
        if (this.lineNumbers == null) {
            try {
                this.readLineNumbers();
            }
            catch (IOException e) {
                LOG.warn((Object)"Problem reading precompiled linenumbers", (Throwable)e);
            }
        }
        return this.lineNumbers;
    }

    public void setLineNumbers(int[] lineNumbers) {
        this.lineNumbers = lineNumbers;
    }

    public void setJspTags(Map jspTags) {
        this.jspTags = jspTags != null ? jspTags : Collections.EMPTY_MAP;
    }

    public Map getJspTags() {
        return this.jspTags;
    }

    public void setCompilationException(GroovyPagesException e) {
        this.compilationException = e;
    }

    public GroovyPagesException getCompilationException() {
        return this.compilationException;
    }

    public String[] getHtmlParts() {
        return this.htmlParts;
    }

    public void setHtmlParts(String[] htmlParts) {
        this.htmlParts = htmlParts;
    }
}

