/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.converters.configuration;

import grails.converters.JSON;
import grails.converters.XML;
import grails.util.GrailsConfig;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.web.converters.Converter;
import org.codehaus.groovy.grails.web.converters.configuration.ChainedConverterConfiguration;
import org.codehaus.groovy.grails.web.converters.configuration.ConvertersConfigurationHolder;
import org.codehaus.groovy.grails.web.converters.configuration.DefaultConverterConfiguration;
import org.codehaus.groovy.grails.web.converters.configuration.ObjectMarshallerRegisterer;
import org.codehaus.groovy.grails.web.converters.marshaller.ProxyUnwrappingMarshaller;
import org.codehaus.groovy.grails.web.converters.marshaller.json.ByteArrayMarshaller;
import org.codehaus.groovy.grails.web.converters.marshaller.json.DateMarshaller;
import org.codehaus.groovy.grails.web.converters.marshaller.json.DeepDomainClassMarshaller;
import org.codehaus.groovy.grails.web.converters.marshaller.json.DomainClassMarshaller;
import org.codehaus.groovy.grails.web.converters.marshaller.json.GroovyBeanMarshaller;
import org.codehaus.groovy.grails.web.converters.marshaller.json.JavascriptDateMarshaller;
import org.codehaus.groovy.grails.web.converters.marshaller.json.MapMarshaller;
import org.codehaus.groovy.grails.web.converters.marshaller.json.ToStringBeanMarshaller;
import org.codehaus.groovy.grails.web.converters.marshaller.xml.ArrayMarshaller;
import org.codehaus.groovy.grails.web.converters.marshaller.xml.CollectionMarshaller;
import org.codehaus.groovy.grails.web.converters.marshaller.xml.EnumMarshaller;
import org.codehaus.groovy.grails.web.converters.marshaller.xml.GenericJavaBeanMarshaller;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConvertersConfigurationInitializer
implements ApplicationContextAware {
    private ApplicationContext applicationContext;
    public final Log LOG = LogFactory.getLog(ConvertersConfigurationInitializer.class);

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void initialize() {
        this.LOG.debug((Object)"Initializing Converters Default Configurations...");
        this.initJSONConfiguration();
        this.initXMLConfiguration();
        this.initDeepJSONConfiguration();
        this.initDeepXMLConfiguration();
    }

    private void initJSONConfiguration() {
        this.LOG.debug((Object)"Initializing default JSON Converters Configuration...");
        ArrayList marshallers = new ArrayList();
        marshallers.add(new org.codehaus.groovy.grails.web.converters.marshaller.json.ArrayMarshaller());
        marshallers.add(new ByteArrayMarshaller());
        marshallers.add(new org.codehaus.groovy.grails.web.converters.marshaller.json.CollectionMarshaller());
        marshallers.add(new MapMarshaller());
        marshallers.add(new org.codehaus.groovy.grails.web.converters.marshaller.json.EnumMarshaller());
        marshallers.add(new ProxyUnwrappingMarshaller());
        if ("javascript".equals(GrailsConfig.get("grails.converters.json.date", "default", Arrays.asList("javascript", "default")))) {
            this.LOG.debug((Object)"Using Javascript JSON Date Marshaller.");
            marshallers.add(new JavascriptDateMarshaller());
        } else {
            this.LOG.debug((Object)"Using default JSON Date Marshaller");
            marshallers.add(new DateMarshaller());
        }
        marshallers.add(new ToStringBeanMarshaller());
        boolean includeDomainVersion = this.includeDomainVersionProperty("json");
        if (GrailsConfig.get("grails.converters.json.default.deep", false).booleanValue()) {
            this.LOG.debug((Object)"Using DeepDomainClassMarshaller as default.");
            marshallers.add(new DeepDomainClassMarshaller(includeDomainVersion));
        } else {
            marshallers.add(new DomainClassMarshaller(includeDomainVersion));
        }
        marshallers.add(new GroovyBeanMarshaller());
        marshallers.add(new org.codehaus.groovy.grails.web.converters.marshaller.json.GenericJavaBeanMarshaller());
        DefaultConverterConfiguration cfg = new DefaultConverterConfiguration(marshallers);
        cfg.setEncoding(GrailsConfig.get("grails.converters.encoding", "UTF-8"));
        String defaultCirRefBehaviour = GrailsConfig.get("grails.converters.default.circular.reference.behaviour", "DEFAULT");
        cfg.setCircularReferenceBehaviour(Converter.CircularReferenceBehaviour.valueOf(GrailsConfig.get("grails.converters.json.circular.reference.behaviour", defaultCirRefBehaviour, Converter.CircularReferenceBehaviour.allowedValues())));
        Boolean defaultPrettyPrint = GrailsConfig.get("grails.converters.default.pretty.print", false);
        Boolean prettyPrint = GrailsConfig.get("grails.converters.json.pretty.print", defaultPrettyPrint);
        cfg.setPrettyPrint(prettyPrint);
        this.registerObjectMarshallersFromApplicationContext(cfg, JSON.class);
        ConvertersConfigurationHolder.setDefaultConfiguration(JSON.class, new ChainedConverterConfiguration(cfg));
    }

    private void initDeepJSONConfiguration() {
        DefaultConverterConfiguration<JSON> deepConfig = new DefaultConverterConfiguration<JSON>(ConvertersConfigurationHolder.getConverterConfiguration(JSON.class));
        deepConfig.registerObjectMarshaller(new DeepDomainClassMarshaller(this.includeDomainVersionProperty("json")));
        ConvertersConfigurationHolder.setNamedConverterConfiguration(JSON.class, "deep", deepConfig);
    }

    private void initXMLConfiguration() {
        this.LOG.debug((Object)"Initializing default XML Converters Configuration...");
        ArrayList marshallers = new ArrayList();
        marshallers.add(new ArrayMarshaller());
        marshallers.add(new CollectionMarshaller());
        marshallers.add(new org.codehaus.groovy.grails.web.converters.marshaller.xml.MapMarshaller());
        marshallers.add(new EnumMarshaller());
        marshallers.add(new org.codehaus.groovy.grails.web.converters.marshaller.xml.DateMarshaller());
        marshallers.add(new ProxyUnwrappingMarshaller());
        marshallers.add(new org.codehaus.groovy.grails.web.converters.marshaller.xml.ToStringBeanMarshaller());
        boolean includeDomainVersion = this.includeDomainVersionProperty("xml");
        if (GrailsConfig.get("grails.converters.xml.default.deep", false).booleanValue()) {
            marshallers.add(new org.codehaus.groovy.grails.web.converters.marshaller.xml.DeepDomainClassMarshaller(includeDomainVersion));
        } else {
            marshallers.add(new org.codehaus.groovy.grails.web.converters.marshaller.xml.DomainClassMarshaller(includeDomainVersion));
        }
        marshallers.add(new org.codehaus.groovy.grails.web.converters.marshaller.xml.GroovyBeanMarshaller());
        marshallers.add(new GenericJavaBeanMarshaller());
        DefaultConverterConfiguration cfg = new DefaultConverterConfiguration(marshallers);
        cfg.setEncoding(GrailsConfig.get("grails.converters.encoding", "UTF-8"));
        String defaultCirRefBehaviour = GrailsConfig.get("grails.converters.default.circular.reference.behaviour", "DEFAULT");
        cfg.setCircularReferenceBehaviour(Converter.CircularReferenceBehaviour.valueOf(GrailsConfig.get("grails.converters.xml.circular.reference.behaviour", defaultCirRefBehaviour, Converter.CircularReferenceBehaviour.allowedValues())));
        Boolean defaultPrettyPrint = GrailsConfig.get("grails.converters.default.pretty.print", false);
        Boolean prettyPrint = GrailsConfig.get("grails.converters.xml.pretty.print", defaultPrettyPrint);
        cfg.setPrettyPrint(prettyPrint);
        this.registerObjectMarshallersFromApplicationContext(cfg, XML.class);
        ConvertersConfigurationHolder.setDefaultConfiguration(XML.class, new ChainedConverterConfiguration(cfg));
    }

    private void initDeepXMLConfiguration() {
        DefaultConverterConfiguration<XML> deepConfig = new DefaultConverterConfiguration<XML>(ConvertersConfigurationHolder.getConverterConfiguration(XML.class));
        deepConfig.registerObjectMarshaller(new org.codehaus.groovy.grails.web.converters.marshaller.xml.DeepDomainClassMarshaller(this.includeDomainVersionProperty("xml")));
        ConvertersConfigurationHolder.setNamedConverterConfiguration(XML.class, "deep", deepConfig);
    }

    private boolean includeDomainVersionProperty(String converterType) {
        return GrailsConfig.get(String.format("grails.converters.%s.domain.include.version", converterType), GrailsConfig.get("grails.converters.domain.include.version", false));
    }

    private <C extends Converter> void registerObjectMarshallersFromApplicationContext(DefaultConverterConfiguration<C> cfg, Class<C> converterClass) {
        if (this.applicationContext != null) {
            for (ObjectMarshallerRegisterer o : this.applicationContext.getBeansOfType(ObjectMarshallerRegisterer.class).values()) {
                ObjectMarshallerRegisterer omr = o;
                if (omr.getConverterClass() != converterClass) continue;
                cfg.registerObjectMarshaller(omr.getMarshaller(), omr.getPriority());
            }
        }
    }
}

