/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.util;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.ConfigurationHolder;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.web.mapping.UrlMappingInfo;
import org.codehaus.groovy.grails.web.mapping.UrlMappingsHolder;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsWebRequest;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.util.UrlPathHelper;

public class WebUtils
extends org.springframework.web.util.WebUtils {
    public static final char SLASH = '/';
    private static final Log LOG = LogFactory.getLog(WebUtils.class);
    public static final String ENABLE_FILE_EXTENSIONS = "grails.mime.file.extensions";
    public static final String DISPATCH_ACTION_PARAMETER = "_action_";
    private static final String DISPATCH_URI_SUFFIX = ".dispatch";
    private static final String GRAILS_DISPATCH_SERVLET_NAME = "/grails";

    public static ViewResolver lookupViewResolver(ServletContext servletContext) {
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)servletContext);
        String[] beanNames = wac.getBeanNamesForType(ViewResolver.class);
        if (beanNames.length > 0) {
            String beanName = beanNames[0];
            return (ViewResolver)wac.getBean(beanName);
        }
        return null;
    }

    public static UrlMappingsHolder lookupUrlMappings(ServletContext servletContext) {
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)servletContext);
        return (UrlMappingsHolder)wac.getBean("grailsUrlMappingsHolder");
    }

    public static String getRequestURIForGrailsDispatchURI(HttpServletRequest request) {
        UrlPathHelper pathHelper = new UrlPathHelper();
        if (request.getRequestURI().endsWith(DISPATCH_URI_SUFFIX)) {
            String path = pathHelper.getPathWithinApplication(request);
            if (path.startsWith(GRAILS_DISPATCH_SERVLET_NAME)) {
                path = path.substring(GRAILS_DISPATCH_SERVLET_NAME.length(), path.length());
            }
            return path.substring(0, path.length() - DISPATCH_URI_SUFFIX.length());
        }
        return pathHelper.getPathWithinApplication(request);
    }

    public static GrailsApplication lookupApplication(ServletContext servletContext) {
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)servletContext);
        return (GrailsApplication)wac.getBean("grailsApplication");
    }

    public static View resolveView(HttpServletRequest request, UrlMappingInfo info, String viewName, ViewResolver viewResolver) throws Exception {
        String controllerName = info.getControllerName();
        return WebUtils.resolveView(request, viewName, controllerName, viewResolver);
    }

    public static View resolveView(HttpServletRequest request, String viewName, String controllerName, ViewResolver viewResolver) throws Exception {
        View v;
        GrailsWebRequest webRequest = (GrailsWebRequest)request.getAttribute("org.codehaus.groovy.grails.WEB_REQUEST");
        if (viewName.startsWith(String.valueOf('/'))) {
            v = viewResolver.resolveViewName(viewName, webRequest.getLocale());
        } else {
            StringBuffer buf = new StringBuffer();
            buf.append('/');
            if (controllerName != null) {
                buf.append(controllerName).append('/');
            }
            buf.append(viewName);
            v = viewResolver.resolveViewName(buf.toString(), webRequest.getLocale());
        }
        return v;
    }

    public static String buildDispatchUrlForMapping(UrlMappingInfo info) {
        StringBuffer forwardUrl = new StringBuffer();
        if (info.getViewName() != null) {
            String viewName = info.getViewName();
            forwardUrl.append('/').append(viewName);
        } else {
            forwardUrl.append(GRAILS_DISPATCH_SERVLET_NAME);
            forwardUrl.append('/').append(info.getControllerName());
            if (!StringUtils.isBlank((String)info.getActionName())) {
                forwardUrl.append('/').append(info.getActionName());
            }
            forwardUrl.append(DISPATCH_URI_SUFFIX);
        }
        return forwardUrl.toString();
    }

    public static String forwardRequestForUrlMappingInfo(HttpServletRequest request, HttpServletResponse response, UrlMappingInfo info) throws ServletException, IOException {
        return WebUtils.forwardRequestForUrlMappingInfo(request, response, info, Collections.EMPTY_MAP);
    }

    public static String forwardRequestForUrlMappingInfo(HttpServletRequest request, HttpServletResponse response, UrlMappingInfo info, Map model) throws ServletException, IOException {
        String forwardUrl = WebUtils.buildDispatchUrlForMapping(info);
        RequestDispatcher dispatcher = request.getRequestDispatcher(forwardUrl);
        WebUtils.exposeForwardRequestAttributes((HttpServletRequest)request);
        WebUtils.exposeRequestAttributes((ServletRequest)request, (Map)model);
        dispatcher.forward((ServletRequest)request, (ServletResponse)response);
        return forwardUrl;
    }

    public static String getFormatFromURI(String uri) {
        String lastToken;
        if (uri.endsWith("/")) {
            return null;
        }
        int idx = uri.lastIndexOf(47);
        if (idx > -1 && (idx = (lastToken = uri.substring(idx + 1, uri.length())).lastIndexOf(46)) > -1) {
            return lastToken.substring(idx + 1, lastToken.length());
        }
        return null;
    }

    public static boolean areFileExtensionsEnabled() {
        Map config = ConfigurationHolder.getFlatConfig();
        Object o = config.get(ENABLE_FILE_EXTENSIONS);
        return o == null || !(o instanceof Boolean) || (Boolean)o != false;
    }

    public static GrailsWebRequest retrieveGrailsWebRequest() {
        return (GrailsWebRequest)RequestContextHolder.currentRequestAttributes();
    }

    public static void storeGrailsWebRequest(GrailsWebRequest webRequest) {
        RequestContextHolder.setRequestAttributes((RequestAttributes)webRequest);
        webRequest.getRequest().setAttribute("org.codehaus.groovy.grails.WEB_REQUEST", (Object)webRequest);
    }

    public static void clearGrailsWebRequest() {
        RequestAttributes reqAttrs = RequestContextHolder.getRequestAttributes();
        if (reqAttrs != null) {
            GrailsWebRequest webRequest = (GrailsWebRequest)reqAttrs;
            webRequest.getRequest().removeAttribute("org.codehaus.groovy.grails.WEB_REQUEST");
            RequestContextHolder.setRequestAttributes(null);
        }
    }
}

