/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.pages;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaProperty;
import groovy.lang.Script;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsClass;
import org.codehaus.groovy.grails.web.pages.ext.jsp.TagLibraryResolver;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsWebRequest;
import org.codehaus.groovy.grails.web.taglib.GroovyPageTagWriter;
import org.codehaus.groovy.grails.web.taglib.exceptions.GrailsTagException;
import org.springframework.beans.BeanWrapper;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public abstract class GroovyPage
extends Script {
    private static final Log LOG = LogFactory.getLog(GroovyPage.class);
    public static final String REQUEST = "request";
    public static final String SERVLET_CONTEXT = "application";
    public static final String RESPONSE = "response";
    public static final String OUT = "out";
    public static final String ATTRIBUTES = "attributes";
    public static final String APPLICATION_CONTEXT = "applicationContext";
    public static final String SESSION = "session";
    public static final String PARAMS = "params";
    public static final String FLASH = "flash";
    public static final String PLUGIN_CONTEXT_PATH = "pluginContextPath";
    public static final String EXTENSION = ".gsp";
    public static final String WEB_REQUEST = "webRequest";
    public static final String DEFAULT_NAMESPACE = "g";
    public static final String PAGE_SCOPE = "pageScope";
    public static final Collection RESERVED_NAMES = new ArrayList(){
        {
            this.add(GroovyPage.REQUEST);
            this.add(GroovyPage.SERVLET_CONTEXT);
            this.add(GroovyPage.RESPONSE);
            this.add(GroovyPage.OUT);
            this.add(GroovyPage.ATTRIBUTES);
            this.add(GroovyPage.APPLICATION_CONTEXT);
            this.add(GroovyPage.SESSION);
            this.add(GroovyPage.PARAMS);
            this.add(GroovyPage.FLASH);
            this.add(GroovyPage.PLUGIN_CONTEXT_PATH);
            this.add(GroovyPage.PAGE_SCOPE);
        }
    };
    private static final String BINDING = "binding";
    private GrailsApplication application;
    private static final String BLANK_STRING = "";
    private ApplicationContext applicationContext;
    private static final String JSP_TAG_LIBRARY_RESOLVER_BEAN = "jspTagLibraryResolver";
    private Map jspTags = Collections.EMPTY_MAP;
    private TagLibraryResolver jspTagLibraryResolver;

    TagLibraryResolver getTagLibraryResolver() {
        if (this.application == null) {
            this.initPageState();
        }
        return this.jspTagLibraryResolver;
    }

    public Object getProperty(String property) {
        if (BINDING.equals(property)) {
            return this.getBinding();
        }
        MetaProperty mp = this.getMetaClass().getMetaProperty(property);
        if (mp != null) {
            return mp.getProperty((Object)this);
        }
        Object value = this.getBinding().getVariables().get(property);
        if (value == null) {
            value = this.getTagLibForNamespace(property);
        }
        if (value == null && this.jspTags.containsKey(property)) {
            TagLibraryResolver tagResolver = this.getTagLibraryResolver();
            String uri = (String)this.jspTags.get(property);
            if (uri != null) {
                value = tagResolver.resolveTagLibrary(uri);
            }
        }
        return value;
    }

    public void invokeTag(String tagName, Map attrs, Closure body) {
        this.invokeTag(tagName, DEFAULT_NAMESPACE, attrs, body);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeTag(String tagName, String tagNamespace, Map attrs, Closure body) {
        block15: {
            GrailsWebRequest webRequest = (GrailsWebRequest)this.getBinding().getVariable(WEB_REQUEST);
            Writer out = webRequest.getOut();
            try {
                if (this.application == null) {
                    this.initPageState();
                }
                if (this.getTagLibForNamespace(tagNamespace) != null) {
                    GroovyObject tagLib = this.getTagLib(tagName, tagNamespace);
                    if (tagLib != null) {
                        BeanWrapper bean = this.getTagLibraryBean(tagLib, webRequest);
                        if (!bean.isReadableProperty(tagName)) {
                            throw new GrailsTagException("Tag [" + tagName + "] does not exist in tag library [" + tagLib.getClass().getName() + "]");
                        }
                        Object tagLibProp = tagLib.getProperty(tagName);
                        if (tagLibProp instanceof Closure) {
                            Closure tag = GroovyPage.setupTagClosure(tagLibProp);
                            if (tag.getParameterTypes().length == 1) {
                                tag.call(new Object[]{attrs});
                                if (body != null) {
                                    body.call();
                                }
                            }
                            if (tag.getParameterTypes().length == 2) {
                                tag.call(new Object[]{attrs, body});
                            }
                            break block15;
                        }
                        throw new GrailsTagException("Tag [" + tagName + "] does not exist in tag library [" + tagLib.getClass().getName() + "]");
                    }
                    throw new GrailsTagException("Tag [" + tagName + "] does not exist. No tag library found for namespace: " + tagNamespace);
                }
                StringBuffer plainTag = new StringBuffer();
                String fullTagName = tagNamespace + ":" + tagName;
                plainTag.append("<").append(fullTagName);
                for (Map.Entry entry : attrs.entrySet()) {
                    plainTag.append(" ").append(entry.getKey()).append("=\"").append(entry.getValue()).append("\"");
                }
                plainTag.append(">");
                try {
                    Object bodyOutput;
                    out.write(plainTag.toString());
                    if (body != null && (bodyOutput = body.call()) != null) {
                        out.write(bodyOutput.toString());
                    }
                    out.write("</" + fullTagName + ">");
                }
                catch (IOException e) {
                    throw new GrailsTagException("I/O error invoking tag library closure as method");
                }
            }
            finally {
                this.getBinding().setVariable(OUT, (Object)out);
                webRequest.setOut(out);
            }
        }
    }

    private void initPageState() {
        if (this.application == null) {
            ServletContext context = (ServletContext)this.getBinding().getVariable(SERVLET_CONTEXT);
            this.applicationContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)context);
            this.application = (GrailsApplication)this.applicationContext.getBean("grailsApplication");
            if (this.applicationContext != null && this.applicationContext.containsBean(JSP_TAG_LIBRARY_RESOLVER_BEAN)) {
                this.jspTagLibraryResolver = (TagLibraryResolver)this.applicationContext.getBean(JSP_TAG_LIBRARY_RESOLVER_BEAN);
            }
        }
    }

    private GroovyObject getTagLibForNamespace(String namespace) {
        GrailsClass tagLibClass;
        if (this.application == null) {
            this.initPageState();
        }
        if ((tagLibClass = this.application.getArtefactForFeature("TagLib", (Object)namespace)) != null) {
            return (GroovyObject)this.applicationContext.getBean(tagLibClass.getFullName());
        }
        return null;
    }

    private GroovyObject getTagLib(String tagName) {
        return this.getTagLib(tagName, DEFAULT_NAMESPACE);
    }

    private GroovyObject getTagLib(String tagName, String namespace) {
        GrailsClass tagLibClass;
        if (this.application == null) {
            this.initPageState();
        }
        if ((tagLibClass = this.application.getArtefactForFeature("TagLib", (Object)(namespace + ':' + tagName))) != null) {
            return (GroovyObject)this.applicationContext.getBean(tagLibClass.getFullName());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeMethod(String methodName, Object args) {
        if (methodName.equals("invokeTag")) {
            return super.invokeMethod(methodName, args);
        }
        Map attrs = null;
        Object body = null;
        GroovyObject tagLib = this.getTagLib(methodName);
        GrailsWebRequest webRequest = (GrailsWebRequest)this.getBinding().getVariable(WEB_REQUEST);
        Writer originalOut = webRequest.getOut();
        try {
            if (tagLib != null) {
                if (args instanceof Object[]) {
                    Object[] argArray = (Object[])args;
                    if (argArray.length > 0 && argArray[0] instanceof Map) {
                        attrs = (Map)argArray[0];
                    }
                    if (argArray.length > 1) {
                        body = argArray[1];
                    }
                } else if (args instanceof Map) {
                    attrs = (HashMap)args;
                }
                if (attrs == null) {
                    attrs = new HashMap();
                }
                BeanWrapper bean = this.getTagLibraryBean(tagLib, webRequest);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Attempting to invoke [" + methodName + "] on tag library [" + tagLib.getClass() + "] with MetaClass [" + tagLib.getMetaClass() + "]"));
                }
                if (bean.isReadableProperty(methodName)) {
                    String string = GroovyPage.captureTagOutput(tagLib, methodName, attrs, body, webRequest, bean);
                    return string;
                }
                if (args instanceof Object[]) {
                    Object object = super.invokeMethod(methodName, args);
                    return object;
                }
                Object object = super.invokeMethod(methodName, args);
                return object;
            }
        }
        finally {
            this.getBinding().setVariable(OUT, (Object)originalOut);
            webRequest.setOut(originalOut);
        }
        return super.invokeMethod(methodName, args);
    }

    private BeanWrapper getTagLibraryBean(GroovyObject tagLib, GrailsWebRequest webRequest) {
        GrailsApplication application = webRequest.getAttributes().getGrailsApplication();
        GrailsClass grailsClass = application.getArtefact("TagLib", tagLib.getClass().getName());
        return grailsClass.getReference();
    }

    public static String captureTagOutput(GroovyObject tagLib, String methodName, Map attrs, Object body, GrailsWebRequest webRequest, BeanWrapper bean) {
        Writer originalOut = webRequest.getOut();
        try {
            GroovyPageTagWriter out = new GroovyPageTagWriter(new StringWriter());
            webRequest.setOut(out);
            Closure actualBody = GroovyPage.createTagOutputCapturingClosure(tagLib, methodName, out, body);
            Object tagLibProp = tagLib.getProperty(methodName);
            if (tagLibProp instanceof Closure) {
                Closure tag = GroovyPage.setupTagClosure(tagLibProp);
                if (tag.getParameterTypes().length == 1) {
                    tag.call(new Object[]{attrs});
                    if (actualBody != null) {
                        actualBody.call();
                    }
                } else if (tag.getParameterTypes().length == 2) {
                    tag.call(new Object[]{attrs, actualBody});
                } else {
                    throw new GrailsTagException("Tag [" + methodName + "] does not specify expected number of params in tag library [" + bean.getWrappedClass().getName() + "]");
                }
                String string = out.getValue();
                return string;
            }
            throw new GrailsTagException("Tag [" + methodName + "] does not exist in tag library [" + bean.getWrappedClass().getName() + "]");
        }
        finally {
            webRequest.setOut(originalOut);
        }
    }

    private static Closure setupTagClosure(Object tagLibProp) {
        Closure original = (Closure)tagLibProp;
        return (Closure)original.clone();
    }

    private static Closure createTagOutputCapturingClosure(Object wrappedInstance, final String methodName, final Writer out, final Object body1) {
        return new Closure(wrappedInstance){

            public Object doCall(Object obj) {
                return this.call(new Object[]{obj});
            }

            public Object doCall() {
                return this.call(new Object[0]);
            }

            public Object doCall(Object[] args) {
                return this.call(args);
            }

            public Object call(Object[] args) {
                if (body1 != null) {
                    Object bodyResponse = body1 instanceof Closure ? (args != null && args.length > 0 ? ((Closure)body1).call(args) : ((Closure)body1).call()) : body1;
                    if (bodyResponse != null && !(bodyResponse instanceof Writer)) {
                        try {
                            out.write(bodyResponse.toString());
                        }
                        catch (IOException e) {
                            throw new GrailsTagException("I/O error invoking tag library closure [" + methodName + "] as method");
                        }
                    }
                }
                return GroovyPage.BLANK_STRING;
            }
        };
    }

    public static boolean isReservedName(String name) {
        return RESERVED_NAMES.contains(name);
    }

    public void setJspTags(Map jspTags) {
        this.jspTags = jspTags;
    }
}

