/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.converters.xtream;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.codehaus.groovy.grails.commons.GrailsClassUtils;
import org.codehaus.groovy.grails.commons.GrailsDomainClass;
import org.codehaus.groovy.grails.commons.GrailsDomainClassProperty;
import org.codehaus.groovy.grails.web.converters.ConverterUtil;
import org.hibernate.collection.AbstractPersistentCollection;
import org.springframework.beans.BeanWrapperImpl;

public class DomainClassConverter
implements Converter {
    private boolean renderDomainClassRelations = false;

    public boolean isRenderDomainClassRelations() {
        return this.renderDomainClassRelations;
    }

    public void setRenderDomainClassRelations(boolean renderDomainClassRelations) {
        this.renderDomainClassRelations = renderDomainClassRelations;
    }

    public void marshal(Object value, HierarchicalStreamWriter writer, MarshallingContext context) {
        Class<?> clazz = value.getClass();
        GrailsDomainClass domainClass = ConverterUtil.getDomainClass(clazz.getName());
        BeanWrapperImpl beanWrapper = new BeanWrapperImpl(value);
        GrailsDomainClassProperty id = domainClass.getIdentifier();
        Object idValue = this.extractIdValue(value, id);
        if (idValue != null) {
            writer.addAttribute("id", String.valueOf(idValue));
        }
        GrailsDomainClassProperty[] properties = domainClass.getPersistentProperties();
        for (int i = 0; i < properties.length; ++i) {
            GrailsDomainClassProperty property = properties[i];
            writer.startNode(property.getName());
            if (!property.isAssociation()) {
                Object val = beanWrapper.getPropertyValue(property.getName());
                if (val == null) {
                    writer.startNode("null");
                    writer.endNode();
                } else {
                    context.convertAnother(val);
                }
            } else {
                Cloneable referenceObject = beanWrapper.getPropertyValue(property.getName());
                if (this.isRenderDomainClassRelations()) {
                    if (referenceObject == null) {
                        writer.startNode("null");
                        writer.endNode();
                    } else {
                        if (referenceObject instanceof AbstractPersistentCollection) {
                            AbstractPersistentCollection acol = (AbstractPersistentCollection)referenceObject;
                            acol.forceInitialization();
                            referenceObject = referenceObject instanceof SortedMap ? new TreeMap(referenceObject) : (referenceObject instanceof SortedSet ? new TreeSet((SortedSet)((Object)referenceObject)) : (referenceObject instanceof Set ? new HashSet((Set)((Object)referenceObject)) : (referenceObject instanceof Map ? new HashMap(referenceObject) : new ArrayList((Collection)((Object)referenceObject)))));
                        }
                        context.convertAnother((Object)referenceObject);
                    }
                } else if (referenceObject == null) {
                    writer.startNode("null");
                    writer.endNode();
                } else {
                    GrailsDomainClass referencedDomainClass = property.getReferencedDomainClass();
                    if (GrailsClassUtils.isJdk5Enum((Class)property.getType())) {
                        context.convertAnother((Object)referenceObject);
                    } else {
                        GrailsDomainClassProperty referencedIdProperty = referencedDomainClass.getIdentifier();
                        if (property.isOneToOne() || property.isManyToOne() || property.isEmbedded()) {
                            writer.addAttribute("id", String.valueOf(this.extractIdValue(referenceObject, referencedIdProperty)));
                        } else {
                            String refPropertyName = referencedDomainClass.getPropertyName();
                            if (referenceObject instanceof Collection) {
                                Collection o = (Collection)((Object)referenceObject);
                                for (Object el : o) {
                                    writer.startNode(refPropertyName);
                                    writer.addAttribute("id", String.valueOf(this.extractIdValue(el, referencedIdProperty)));
                                    writer.endNode();
                                }
                            } else if (referenceObject instanceof Map) {
                                Map map = referenceObject;
                                Iterator iterator = map.keySet().iterator();
                                while (iterator.hasNext()) {
                                    String key = String.valueOf(iterator.next());
                                    Object o = map.get(key);
                                    writer.startNode("entry");
                                    writer.startNode("string");
                                    writer.setValue(key);
                                    writer.endNode();
                                    writer.startNode(refPropertyName);
                                    writer.addAttribute("id", String.valueOf(this.extractIdValue(o, referencedIdProperty)));
                                    writer.endNode();
                                    writer.endNode();
                                }
                            }
                        }
                    }
                }
            }
            writer.endNode();
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        return null;
    }

    public boolean canConvert(Class clazz) {
        return ConverterUtil.isDomainClass(clazz);
    }

    private Object extractIdValue(Object domainObject, GrailsDomainClassProperty idProperty) {
        BeanWrapperImpl beanWrapper = new BeanWrapperImpl(domainObject);
        return beanWrapper.getPropertyValue(idProperty.getName());
    }
}

