/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.binding;

import grails.util.GrailsNameUtils;
import groovy.lang.GroovyObject;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import groovy.lang.MetaClassRegistry;
import groovy.lang.MissingMethodException;
import java.beans.PropertyEditor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Currency;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TimeZone;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.Factory;
import org.apache.commons.collections.list.LazyList;
import org.apache.commons.collections.set.ListOrderedSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.ApplicationHolder;
import org.codehaus.groovy.grails.commons.DomainClassArtefactHandler;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsClassUtils;
import org.codehaus.groovy.grails.commons.GrailsDomainClass;
import org.codehaus.groovy.grails.commons.GrailsDomainClassProperty;
import org.codehaus.groovy.grails.validation.ConstrainedProperty;
import org.codehaus.groovy.grails.web.binding.CurrencyEditor;
import org.codehaus.groovy.grails.web.binding.StructuredDateEditor;
import org.codehaus.groovy.grails.web.binding.StructuredPropertyEditor;
import org.codehaus.groovy.grails.web.binding.TimeZoneEditor;
import org.codehaus.groovy.grails.web.binding.UriEditor;
import org.codehaus.groovy.grails.web.context.ServletContextHolder;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsParameterMap;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.ConfigurablePropertyAccessor;
import org.springframework.beans.InvalidPropertyException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyAccessorUtils;
import org.springframework.beans.PropertyEditorRegistrar;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.beans.propertyeditors.CustomNumberEditor;
import org.springframework.beans.propertyeditors.LocaleEditor;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.bind.ServletRequestParameterPropertyValues;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.support.ByteArrayMultipartFileEditor;
import org.springframework.web.multipart.support.StringMultipartFileEditor;
import org.springframework.web.servlet.support.RequestContextUtils;

public class GrailsDataBinder
extends ServletRequestDataBinder {
    private static final Log LOG = LogFactory.getLog(GrailsDataBinder.class);
    protected BeanWrapper bean = (BeanWrapper)((BeanPropertyBindingResult)super.getBindingResult()).getPropertyAccessor();
    public static final String[] GROOVY_DISALLOWED = new String[]{"metaClass", "properties"};
    public static final String[] DOMAINCLASS_DISALLOWED = new String[]{"id", "version"};
    public static final String[] GROOVY_DOMAINCLASS_DISALLOWED = new String[]{"metaClass", "properties", "id", "version"};
    public static final String NULL_ASSOCIATION = "null";
    private static final String PREFIX_SEPERATOR = ".";
    private static final String[] ALL_OTHER_FIELDS_ALLOWED_BY_DEFAULT = new String[0];
    private static final String CONSTRAINTS_PROPERTY = "constraints";
    private static final String BLANK = "";
    private static final String STRUCTURED_PROPERTY_SEPERATOR = "_";
    private static final char PATH_SEPARATOR = '.';
    private static final String IDENTIFIER_SUFFIX = ".id";

    public GrailsDataBinder(Object target, String objectName) {
        super(target, objectName);
        String[] disallowed = new String[]{};
        GrailsApplication grailsApplication = ApplicationHolder.getApplication();
        if (grailsApplication != null && grailsApplication.isArtefactOfType("Domain", target.getClass())) {
            disallowed = target instanceof GroovyObject ? GROOVY_DOMAINCLASS_DISALLOWED : DOMAINCLASS_DISALLOWED;
        } else if (target instanceof GroovyObject) {
            disallowed = GROOVY_DISALLOWED;
        }
        this.setDisallowedFields(disallowed);
        this.setAllowedFields(ALL_OTHER_FIELDS_ALLOWED_BY_DEFAULT);
        this.registerCustomEditors();
    }

    private void registerCustomEditors() {
        WebApplicationContext context;
        ServletContext servletContext = ServletContextHolder.getServletContext();
        if (servletContext != null && (context = WebApplicationContextUtils.getWebApplicationContext((ServletContext)servletContext)) != null) {
            Map editors = context.getBeansOfType(PropertyEditorRegistrar.class);
            Iterator it = editors.entrySet().iterator();
            while (it.hasNext()) {
                PropertyEditorRegistrar editorRegistrar = (PropertyEditorRegistrar)it.next().getValue();
                editorRegistrar.registerCustomEditors(this.getPropertyEditorRegistry());
            }
        }
    }

    public static GrailsDataBinder createBinder(Object target, String objectName, HttpServletRequest request) {
        GrailsDataBinder binder = GrailsDataBinder.createBinder(target, objectName);
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        NumberFormat floatFormat = NumberFormat.getInstance(locale);
        NumberFormat integerFormat = NumberFormat.getIntegerInstance(locale);
        binder.registerCustomEditor(Date.class, (PropertyEditor)new CustomDateEditor(DateFormat.getDateInstance(3, locale), true));
        binder.registerCustomEditor(BigDecimal.class, (PropertyEditor)new CustomNumberEditor(BigDecimal.class, floatFormat, true));
        binder.registerCustomEditor(BigInteger.class, (PropertyEditor)new CustomNumberEditor(BigInteger.class, floatFormat, true));
        binder.registerCustomEditor(Double.class, (PropertyEditor)new CustomNumberEditor(Double.class, floatFormat, true));
        binder.registerCustomEditor(Double.TYPE, (PropertyEditor)new CustomNumberEditor(Double.class, floatFormat, true));
        binder.registerCustomEditor(Float.class, (PropertyEditor)new CustomNumberEditor(Float.class, floatFormat, true));
        binder.registerCustomEditor(Float.TYPE, (PropertyEditor)new CustomNumberEditor(Float.class, floatFormat, true));
        binder.registerCustomEditor(Long.class, (PropertyEditor)new CustomNumberEditor(Long.class, integerFormat, true));
        binder.registerCustomEditor(Long.TYPE, (PropertyEditor)new CustomNumberEditor(Long.class, integerFormat, true));
        binder.registerCustomEditor(Integer.class, (PropertyEditor)new CustomNumberEditor(Integer.class, integerFormat, true));
        binder.registerCustomEditor(Integer.TYPE, (PropertyEditor)new CustomNumberEditor(Integer.class, integerFormat, true));
        binder.registerCustomEditor(Short.class, (PropertyEditor)new CustomNumberEditor(Short.class, integerFormat, true));
        binder.registerCustomEditor(Short.TYPE, (PropertyEditor)new CustomNumberEditor(Short.class, integerFormat, true));
        binder.registerCustomEditor(Date.class, (PropertyEditor)((Object)new StructuredDateEditor(DateFormat.getDateInstance(3, locale), true)));
        binder.registerCustomEditor(Calendar.class, (PropertyEditor)((Object)new StructuredDateEditor(DateFormat.getDateInstance(3, locale), true)));
        return binder;
    }

    public static GrailsDataBinder createBinder(Object target, String objectName) {
        GrailsDataBinder binder = new GrailsDataBinder(target, objectName);
        binder.registerCustomEditor(byte[].class, (PropertyEditor)new ByteArrayMultipartFileEditor());
        binder.registerCustomEditor(String.class, (PropertyEditor)new StringMultipartFileEditor());
        binder.registerCustomEditor(Currency.class, new CurrencyEditor());
        binder.registerCustomEditor(Locale.class, (PropertyEditor)new LocaleEditor());
        binder.registerCustomEditor(TimeZone.class, new TimeZoneEditor());
        binder.registerCustomEditor(URI.class, new UriEditor());
        return binder;
    }

    public void bind(PropertyValues propertyValues) {
        this.bind(propertyValues, null);
    }

    public void bind(GrailsParameterMap params) {
        this.bindWithRequestAndPropertyValues((ServletRequest)params.getRequest(), new MutablePropertyValues((Map)params));
    }

    public void bind(PropertyValues propertyValues, String prefix) {
        PropertyValues values = this.filterPropertyValues(propertyValues, prefix);
        if (propertyValues instanceof MutablePropertyValues) {
            MutablePropertyValues mutablePropertyValues = (MutablePropertyValues)propertyValues;
            this.preProcessMutablePropertyValues(mutablePropertyValues);
        }
        super.bind(values);
    }

    public void bind(ServletRequest request) {
        this.bind(request, null);
    }

    public void bind(ServletRequest request, String prefix) {
        ServletRequestParameterPropertyValues mpvs = prefix != null ? new ServletRequestParameterPropertyValues(request, prefix, PREFIX_SEPERATOR) : new ServletRequestParameterPropertyValues(request);
        this.bindWithRequestAndPropertyValues(request, (MutablePropertyValues)mpvs);
    }

    private void bindWithRequestAndPropertyValues(ServletRequest request, MutablePropertyValues mpvs) {
        this.preProcessMutablePropertyValues(mpvs);
        if (request instanceof MultipartHttpServletRequest) {
            MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
            this.bindMultipartFiles(multipartRequest.getFileMap(), mpvs);
        }
        this.doBind(mpvs);
    }

    private void preProcessMutablePropertyValues(MutablePropertyValues mpvs) {
        this.checkStructuredProperties(mpvs);
        this.autoCreateIfPossible(mpvs);
        this.bindAssociations(mpvs);
    }

    protected void doBind(MutablePropertyValues mpvs) {
        this.filterNestedParameterMaps(mpvs);
        this.filterBlankValuesWhenTargetIsNullable(mpvs);
        super.doBind(mpvs);
    }

    private void filterBlankValuesWhenTargetIsNullable(MutablePropertyValues mpvs) {
        Object target = this.getTarget();
        MetaClass mc = GroovySystem.getMetaClassRegistry().getMetaClass(target.getClass());
        if (mc.hasProperty(target, CONSTRAINTS_PROPERTY) != null) {
            Map constrainedProperties = (Map)mc.getProperty(target, CONSTRAINTS_PROPERTY);
            PropertyValue[] valueArray = mpvs.getPropertyValues();
            for (int i = 0; i < valueArray.length; ++i) {
                PropertyValue propertyValue = valueArray[i];
                ConstrainedProperty cp = this.getConstrainedPropertyForPropertyValue(constrainedProperties, propertyValue);
                if (!this.shouldNullifyBlankString(propertyValue, cp)) continue;
                propertyValue.setConvertedValue(null);
            }
        }
    }

    private ConstrainedProperty getConstrainedPropertyForPropertyValue(Map constrainedProperties, PropertyValue propertyValue) {
        String propertyName = propertyValue.getName();
        if (propertyName.indexOf(46) > -1) {
            MetaClass mc;
            String[] propertyNames = propertyName.split("\\.");
            Object target = this.getTarget();
            Object value = this.getPropertyValueForPath(target, propertyNames);
            if (value != null && (mc = GroovySystem.getMetaClassRegistry().getMetaClass(value.getClass())).hasProperty(value, CONSTRAINTS_PROPERTY) != null) {
                Map nestedConstrainedProperties = (Map)mc.getProperty(value, CONSTRAINTS_PROPERTY);
                return (ConstrainedProperty)nestedConstrainedProperties.get(propertyNames[propertyNames.length - 1]);
            }
        } else {
            return (ConstrainedProperty)constrainedProperties.get(propertyName);
        }
        return null;
    }

    private Object getPropertyValueForPath(Object target, String[] propertyNames) {
        BeanWrapperImpl bean = new BeanWrapperImpl(target);
        Object obj = target;
        for (int i = 0; i < propertyNames.length - 1; ++i) {
            String propertyName = propertyNames[i];
            if (!bean.isReadableProperty(propertyName)) continue;
            obj = bean.getPropertyValue(propertyName);
            if (obj == null) break;
            bean = new BeanWrapperImpl(obj);
        }
        return obj;
    }

    private boolean shouldNullifyBlankString(PropertyValue propertyValue, ConstrainedProperty cp) {
        return cp != null && cp.isNullable() && BLANK.equals(propertyValue.getValue());
    }

    private void filterNestedParameterMaps(MutablePropertyValues mpvs) {
        PropertyValue[] values = mpvs.getPropertyValues();
        for (int i = 0; i < values.length; ++i) {
            PropertyValue pv = values[i];
            if (!(pv.getValue() instanceof GrailsParameterMap)) continue;
            mpvs.removePropertyValue(pv);
        }
    }

    private PropertyValues filterPropertyValues(PropertyValues propertyValues, String prefix) {
        if (prefix == null || prefix.length() == 0) {
            return propertyValues;
        }
        PropertyValue[] valueArray = propertyValues.getPropertyValues();
        MutablePropertyValues newValues = new MutablePropertyValues();
        for (int i = 0; i < valueArray.length; ++i) {
            PropertyValue propertyValue = valueArray[i];
            if (!propertyValue.getName().startsWith(prefix + PREFIX_SEPERATOR)) continue;
            newValues.addPropertyValue(propertyValue.getName().replaceFirst(prefix + PREFIX_SEPERATOR, BLANK), propertyValue.getValue());
        }
        return newValues;
    }

    protected void autoCreateIfPossible(MutablePropertyValues mpvs) {
        PropertyValue[] pvs = mpvs.getPropertyValues();
        for (int i = 0; i < pvs.length; ++i) {
            PropertyValue pv = pvs[i];
            String propertyName = pv.getName();
            if (propertyName.indexOf(46) > -1) {
                String name;
                Object created;
                String[] propertyNames = propertyName.split("\\.");
                BeanWrapper currentBean = this.bean;
                for (int j = 0; j < propertyNames.length && (created = this.autoCreatePropertyIfPossible(currentBean, name = propertyNames[j])) != null; ++j) {
                    currentBean = new BeanWrapperImpl(created);
                }
                continue;
            }
            this.autoCreatePropertyIfPossible(this.bean, propertyName);
        }
    }

    private Object autoCreatePropertyIfPossible(BeanWrapper bean, String propertyName) {
        propertyName = PropertyAccessorUtils.canonicalPropertyName((String)propertyName);
        int currentKeyStart = propertyName.indexOf(91);
        int currentKeyEnd = propertyName.indexOf(93);
        String propertyNameWithIndex = propertyName;
        if (currentKeyStart > -1) {
            propertyName = propertyName.substring(0, currentKeyStart);
        }
        Class type = bean.getPropertyType(propertyName);
        Object val = bean.isReadableProperty(propertyName) ? bean.getPropertyValue(propertyName) : null;
        LOG.debug((Object)("Checking if auto-create is possible for property [" + propertyName + "] and type [" + type + "]"));
        if (type != null && val == null && GroovyObject.class.isAssignableFrom(type)) {
            Object created;
            if (this.isNullAndWritableProperty((ConfigurablePropertyAccessor)bean, propertyName) && (created = this.autoInstantiateDomainInstance(type)) != null) {
                val = created;
                bean.setPropertyValue(propertyName, created);
            }
        } else {
            Object beanInstance = bean.getWrappedInstance();
            if (type != null && Collection.class.isAssignableFrom(type)) {
                Class referencedType = this.getReferencedTypeForCollection(propertyName, beanInstance);
                Collection c = this.isNullAndWritableProperty((ConfigurablePropertyAccessor)bean, propertyName) ? this.decorateCollectionForDomainAssociation(GrailsClassUtils.createConcreteCollection((Class)type), referencedType) : this.decorateCollectionForDomainAssociation((Collection)bean.getPropertyValue(propertyName), referencedType);
                bean.setPropertyValue(propertyName, (Object)c);
                val = c;
                if (c != null && currentKeyStart > -1 && currentKeyEnd > -1) {
                    String indexString = propertyNameWithIndex.substring(currentKeyStart + 1, currentKeyEnd);
                    int index = Integer.parseInt(indexString);
                    if (DomainClassArtefactHandler.isDomainClass((Class)referencedType)) {
                        Object instance = this.findIndexedValue(c, index);
                        if (instance != null) {
                            val = instance;
                        } else {
                            instance = this.autoInstantiateDomainInstance(referencedType);
                            if (instance != null) {
                                val = instance;
                                if (index == c.size()) {
                                    this.addAssociationToTarget(propertyName, beanInstance, instance);
                                } else if (index > c.size()) {
                                    while (index > c.size()) {
                                        this.addAssociationToTarget(propertyName, beanInstance, this.autoInstantiateDomainInstance(referencedType));
                                    }
                                    this.addAssociationToTarget(propertyName, beanInstance, instance);
                                }
                            }
                        }
                    }
                }
            } else if (type != null && Map.class.isAssignableFrom(type)) {
                Map<String, Object> map = null;
                if (this.isNullAndWritableProperty((ConfigurablePropertyAccessor)bean, propertyName)) {
                    map = new HashMap();
                    bean.setPropertyValue(propertyName, map);
                } else {
                    map = (Map)bean.getPropertyValue(propertyName);
                }
                val = map;
                bean.setPropertyValue(propertyName, val);
                if (currentKeyStart > -1 && currentKeyEnd > -1) {
                    String indexString = propertyNameWithIndex.substring(currentKeyStart + 1, currentKeyEnd);
                    Class referencedType = this.getReferencedTypeForCollection(propertyName, beanInstance);
                    if (DomainClassArtefactHandler.isDomainClass((Class)referencedType)) {
                        Object domainInstance;
                        val = domainInstance = this.autoInstantiateDomainInstance(referencedType);
                        map.put(indexString, domainInstance);
                    }
                }
            }
        }
        return val;
    }

    private Collection decorateCollectionForDomainAssociation(Collection c, final Class referencedType) {
        if (this.canDecorateWithLazyList(c, referencedType)) {
            c = LazyList.decorate((List)((List)c), (Factory)new Factory(){

                public Object create() {
                    Object created = GrailsDataBinder.this.autoInstantiateDomainInstance(referencedType);
                    return created;
                }
            });
        } else if (this.canDecorateWithListOrderedSet(c, referencedType)) {
            c = ListOrderedSet.decorate((Set)((Set)c));
        }
        return c;
    }

    private boolean canDecorateWithListOrderedSet(Collection c, Class referencedType) {
        return c instanceof Set && !(c instanceof ListOrderedSet) && !(c instanceof SortedSet) && DomainClassArtefactHandler.isDomainClass((Class)referencedType);
    }

    private boolean canDecorateWithLazyList(Collection c, Class referencedType) {
        return c instanceof List && !(c instanceof LazyList) && DomainClassArtefactHandler.isDomainClass((Class)referencedType);
    }

    private Object findIndexedValue(Collection c, int index) {
        if (index < c.size()) {
            if (c instanceof List) {
                return ((List)c).get(index);
            }
            int j = 0;
            for (Object o : c) {
                if (j == index) {
                    return o;
                }
                ++j;
            }
        }
        return null;
    }

    private Object autoInstantiateDomainInstance(Class type) {
        Object created = null;
        try {
            MetaClass mc = GroovySystem.getMetaClassRegistry().getMetaClass(type);
            if (mc != null) {
                created = mc.invokeStaticMethod((Object)type, "create", new Object[0]);
            }
        }
        catch (MissingMethodException mme) {
            LOG.warn((Object)"Unable to auto-create type, 'create' method not found");
        }
        catch (GroovyRuntimeException gre) {
            LOG.warn((Object)("Unable to auto-create type, Groovy Runtime error: " + gre.getMessage()), (Throwable)gre);
        }
        return created;
    }

    private boolean isNullAndWritableProperty(ConfigurablePropertyAccessor bean, String propertyName) {
        return bean.getPropertyValue(propertyName) == null && bean.isWritableProperty(propertyName);
    }

    protected void bindAssociations(MutablePropertyValues mpvs) {
        PropertyValue[] pvs = mpvs.getPropertyValues();
        for (int i = 0; i < pvs.length; ++i) {
            Class type;
            PropertyValue pv = pvs[i];
            String propertyName = pv.getName();
            if (propertyName.endsWith(IDENTIFIER_SUFFIX)) {
                if (!this.bean.isReadableProperty(propertyName = propertyName.substring(0, propertyName.length() - 3)) || !this.bean.isWritableProperty(propertyName)) continue;
                if (NULL_ASSOCIATION.equals(pv.getValue())) {
                    this.bean.setPropertyValue(propertyName, null);
                    mpvs.removePropertyValue(pv);
                    continue;
                }
                type = this.bean.getPropertyType(propertyName);
                Object persisted = this.getPersistentInstance(type, pv.getValue());
                if (persisted == null) continue;
                this.bean.setPropertyValue(propertyName, persisted);
                continue;
            }
            if (!this.bean.isReadableProperty(propertyName) || !Collection.class.isAssignableFrom(type = this.bean.getPropertyType(propertyName))) continue;
            this.bindCollectionAssociation(mpvs, pv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getPersistentInstance(Class type, Object id) {
        Object persisted;
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader grailsClassLoader = this.getTarget().getClass().getClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(grailsClassLoader);
            try {
                persisted = InvokerHelper.invokeStaticMethod((Class)type, (String)"get", (Object)id);
            }
            catch (MissingMethodException e) {
                Object var7_7 = null;
                Thread.currentThread().setContextClassLoader(currentClassLoader);
                return var7_7;
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
        return persisted;
    }

    private void bindCollectionAssociation(MutablePropertyValues mpvs, PropertyValue pv) {
        Object v = pv.getValue();
        Collection collection = (Collection)this.bean.getPropertyValue(pv.getName());
        collection.clear();
        if (v != null && v.getClass().isArray()) {
            Object[] identifiers = (Object[])v;
            for (int j = 0; j < identifiers.length; ++j) {
                Object id = identifiers[j];
                if (id == null) continue;
                this.associateObjectForId(pv, id);
            }
            mpvs.removePropertyValue(pv);
        } else if (v != null && v instanceof String) {
            this.associateObjectForId(pv, v);
            mpvs.removePropertyValue(pv);
        }
    }

    private void associateObjectForId(PropertyValue pv, Object id) {
        Object target = this.getTarget();
        Class associatedType = this.getReferencedTypeForCollection(pv.getName(), target);
        if (this.isDomainAssociation(associatedType)) {
            Object obj = this.getPersistentInstance(associatedType, id);
            this.addAssociationToTarget(pv.getName(), target, obj);
        }
    }

    private boolean isDomainAssociation(Class associatedType) {
        return associatedType != null && DomainClassArtefactHandler.isDomainClass((Class)associatedType);
    }

    private void addAssociationToTarget(String name, Object target, Object obj) {
        if (obj != null) {
            MetaClassRegistry reg = GroovySystem.getMetaClassRegistry();
            MetaClass mc = reg.getMetaClass(target.getClass());
            String addMethodName = "addTo" + GrailsNameUtils.getClassNameRepresentation(name);
            mc.invokeMethod(target, addMethodName, obj);
        }
    }

    private Class getReferencedTypeForCollection(String name, Object target) {
        GrailsDomainClassProperty domainProperty;
        GrailsDomainClass domainClass = (GrailsDomainClass)ApplicationHolder.getApplication().getArtefact("Domain", target.getClass().getName());
        if (domainClass != null && (domainProperty = domainClass.getPropertyByName(name)) != null && (domainProperty.isOneToMany() || domainProperty.isManyToMany())) {
            return domainProperty.getReferencedPropertyType();
        }
        return null;
    }

    private String getNameOf(PropertyValue propertyValue) {
        String name = propertyValue.getName();
        if (name.indexOf(STRUCTURED_PROPERTY_SEPERATOR) == -1) {
            return name;
        }
        return name.substring(0, name.indexOf(STRUCTURED_PROPERTY_SEPERATOR));
    }

    private boolean isStructured(PropertyValue propertyValue) {
        String name = propertyValue.getName();
        return name.indexOf(STRUCTURED_PROPERTY_SEPERATOR) != -1;
    }

    private void checkStructuredProperties(MutablePropertyValues propertyValues) {
        PropertyValue[] pvs = propertyValues.getPropertyValues();
        for (int i = 0; i < pvs.length; ++i) {
            PropertyEditor editor;
            String propertyName;
            Class type;
            PropertyValue propertyValue = pvs[i];
            if (!this.isStructured(propertyValue) || (type = this.bean.getPropertyType(propertyName = this.getNameOf(propertyValue))) == null || null == (editor = this.findCustomEditor(type, propertyName)) || !StructuredPropertyEditor.class.isAssignableFrom(editor.getClass())) continue;
            StructuredPropertyEditor structuredEditor = (StructuredPropertyEditor)((Object)editor);
            ArrayList fields = new ArrayList();
            fields.addAll(structuredEditor.getRequiredFields());
            fields.addAll(structuredEditor.getOptionalFields());
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            try {
                for (int j = 0; j < fields.size(); ++j) {
                    String field = (String)fields.get(j);
                    PropertyValue requiredProperty = propertyValues.getPropertyValue(propertyName + STRUCTURED_PROPERTY_SEPERATOR + field);
                    if (requiredProperty == null && structuredEditor.getRequiredFields().contains(field)) break;
                    if (requiredProperty == null) continue;
                    fieldValues.put(field, this.getStringValue(requiredProperty));
                }
                try {
                    Object value = structuredEditor.assemble(type, fieldValues);
                    if (null == value) continue;
                    for (int j = 0; j < fields.size(); ++j) {
                        String requiredField = (String)fields.get(j);
                        PropertyValue requiredProperty = propertyValues.getPropertyValue(propertyName + STRUCTURED_PROPERTY_SEPERATOR + requiredField);
                        if (null == requiredProperty) continue;
                        requiredProperty.setConvertedValue((Object)this.getStringValue(requiredProperty));
                    }
                    propertyValues.addPropertyValue(new PropertyValue(propertyName, value));
                }
                catch (IllegalArgumentException iae) {
                    LOG.warn((Object)("Unable to parse structured date from request for date [" + propertyName + "]"), (Throwable)iae);
                }
                continue;
            }
            catch (InvalidPropertyException ipe) {
                // empty catch block
            }
        }
    }

    private String getStringValue(PropertyValue yearProperty) {
        Object value = yearProperty.getValue();
        if (value == null) {
            return null;
        }
        if (value.getClass().isArray()) {
            return ((String[])value)[0];
        }
        return (String)value;
    }
}

