/*
 * Decompiled with CFR 0.152.
 */
package grails.util;

import grails.util.GrailsUtil;
import java.lang.reflect.Modifier;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.support.GrailsTestSuite;
import org.codehaus.groovy.grails.support.PersistenceContextInterceptor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public class RunTests {
    private static Log log = LogFactory.getLog(RunTests.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        int exitCode = 0;
        try {
            log.info((Object)"Bootstrapping Grails from classpath");
            ConfigurableApplicationContext appCtx = (ConfigurableApplicationContext)GrailsUtil.bootstrapGrailsFromClassPath();
            GrailsApplication application = (GrailsApplication)appCtx.getBean("grailsApplication");
            Class[] allClasses = application.getAllClasses();
            log.debug((Object)("Going through [" + allClasses.length + "] classes"));
            TestSuite s = new TestSuite();
            for (int i = 0; i < allClasses.length; ++i) {
                Class clazz = allClasses[i];
                if (TestCase.class.isAssignableFrom(clazz) && !Modifier.isAbstract(clazz.getModifiers())) {
                    log.debug((Object)("Adding test [" + clazz.getName() + "]"));
                    s.addTest((Test)new GrailsTestSuite((ApplicationContext)appCtx, clazz));
                    continue;
                }
                log.debug((Object)("[" + clazz.getName() + "] is not a test case."));
            }
            String[] beanNames = appCtx.getBeanNamesForType(PersistenceContextInterceptor.class);
            PersistenceContextInterceptor interceptor = null;
            if (beanNames.length > 0) {
                interceptor = (PersistenceContextInterceptor)appCtx.getBean(beanNames[0]);
            }
            try {
                TestResult r;
                if (interceptor != null) {
                    interceptor.init();
                }
                if ((exitCode = (r = TestRunner.run((Test)s)).errorCount() + r.failureCount()) > 0) {
                    System.err.println("Tests failed!");
                }
                if (interceptor != null) {
                    interceptor.flush();
                }
            }
            finally {
                if (interceptor != null) {
                    interceptor.destroy();
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("Error executing tests: " + e.getMessage()), (Throwable)e);
            exitCode = 1;
        }
        finally {
            System.exit(exitCode);
        }
    }
}

