/*
 * Decompiled with CFR 0.152.
 */
package grails.converters;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import grails.util.GrailsWebUtil;
import groovy.util.XmlSlurper;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.ConfigurationHolder;
import org.codehaus.groovy.grails.web.converters.AbstractConverter;
import org.codehaus.groovy.grails.web.converters.ConverterUtil;
import org.codehaus.groovy.grails.web.converters.exceptions.ConverterException;
import org.codehaus.groovy.grails.web.converters.xtream.DomainClassConverter;
import org.codehaus.groovy.grails.web.converters.xtream.ErrorsConverter;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.MessageSource;

public class XML
extends AbstractConverter
implements org.codehaus.groovy.grails.web.converters.Converter,
ApplicationContextAware {
    public static final Log log = LogFactory.getLog(XML.class);
    private Object target;
    private String encoding;
    private static final String CACHED_XML = "org.codehaus.groovy.grails.CACHED_XML_REQUEST_CONTENT";
    private static final String DEFAULT_ENCODING = "utf-8";
    private ApplicationContext applicationContext;

    public void configureXStream(XStream xs) {
        DomainClassConverter dcConverter = new DomainClassConverter();
        dcConverter.setRenderDomainClassRelations(false);
        xs.registerConverter((Converter)dcConverter, 1);
        ErrorsConverter errorsConverter = new ErrorsConverter();
        errorsConverter.setMessageSource((MessageSource)this.applicationContext);
        xs.registerConverter((Converter)errorsConverter, 1);
    }

    public XML() {
        Map config = ConfigurationHolder.getFlatConfig();
        Object enc = config.get("grails.converters.encoding");
        this.encoding = enc != null && enc.toString().trim().length() > 0 ? enc.toString() : DEFAULT_ENCODING;
    }

    public XML(Object target) {
        this();
        this.target = target;
    }

    public void render(Writer out) throws ConverterException {
        ConverterUtil.getXStream(this.getClass()).toXML(this.target, out);
    }

    public void render(HttpServletResponse response) throws ConverterException {
        response.setContentType(GrailsWebUtil.getContentType("text/xml", this.encoding));
        try {
            PrintWriter writer = response.getWriter();
            String encoding = response.getCharacterEncoding();
            ((Writer)writer).write("<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>");
            this.render(writer);
        }
        catch (IOException e) {
            throw new ConverterException(e);
        }
    }

    public static Object parse(String source) throws ConverterException {
        try {
            return new XmlSlurper().parseText(source);
        }
        catch (Exception e) {
            throw new ConverterException("Error parsing XML", e);
        }
    }

    public static Object parse(InputStream is, String encoding) throws ConverterException {
        try {
            InputStreamReader reader = new InputStreamReader(is, encoding);
            return new XmlSlurper().parse((Reader)reader);
        }
        catch (Exception e) {
            throw new ConverterException("Error parsing XML", e);
        }
    }

    public static Object parse(HttpServletRequest request) throws ConverterException {
        Object xml = request.getAttribute(CACHED_XML);
        if (xml != null) {
            return xml;
        }
        String encoding = request.getCharacterEncoding();
        if (encoding == null) {
            encoding = "UTF-8";
        }
        try {
            if (!request.getMethod().equalsIgnoreCase("GET")) {
                xml = XML.parse((InputStream)request.getInputStream(), encoding);
                request.setAttribute(CACHED_XML, xml);
            }
            return xml;
        }
        catch (IOException e) {
            throw new ConverterException("Error parsing XML", e);
        }
    }

    public void setTarget(Object target) {
        this.target = target;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

