/*
 * Decompiled with CFR 0.152.
 */
package grails.converters;

import grails.util.GrailsWebUtil;
import groovy.lang.GString;
import groovy.lang.GroovyObject;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Calendar;
import java.util.Collection;
import java.util.Currency;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.ConfigurationHolder;
import org.codehaus.groovy.grails.commons.GrailsClassUtils;
import org.codehaus.groovy.grails.commons.GrailsDomainClass;
import org.codehaus.groovy.grails.commons.GrailsDomainClassProperty;
import org.codehaus.groovy.grails.web.converters.AbstractConverter;
import org.codehaus.groovy.grails.web.converters.Converter;
import org.codehaus.groovy.grails.web.converters.ConverterUtil;
import org.codehaus.groovy.grails.web.converters.exceptions.ConverterException;
import org.codehaus.groovy.grails.web.json.JSONArray;
import org.codehaus.groovy.grails.web.json.JSONException;
import org.codehaus.groovy.grails.web.json.JSONObject;
import org.codehaus.groovy.grails.web.json.JSONTokener;
import org.codehaus.groovy.grails.web.json.JSONWriter;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;

public class JSON
extends AbstractConverter
implements Converter,
ApplicationContextAware {
    private static final Log log = LogFactory.getLog(JSON.class);
    private Object target;
    private String encoding;
    protected JSONWriter writer;
    private boolean renderDomainClassRelations = false;
    private static final String CACHED_JSON = "org.codehaus.groovy.grails.CACHED_JSON_REQUEST_CONTENT";
    private static final String DEFAULT_ENCODING = "utf-8";
    private ApplicationContext applicationContext;

    public boolean isRenderDomainClassRelations() {
        return this.renderDomainClassRelations;
    }

    public JSON setRenderDomainClassRelations(boolean renderDomainClassRelations) {
        this.renderDomainClassRelations = renderDomainClassRelations;
        return this;
    }

    public JSON() {
        Map config = ConfigurationHolder.getFlatConfig();
        Object enc = config.get("grails.converters.encoding");
        this.encoding = enc != null && enc.toString().trim().length() > 0 ? enc.toString() : DEFAULT_ENCODING;
        this.target = null;
    }

    public JSON(Object target) {
        this();
        this.target = target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(Writer out) throws ConverterException {
        this.writer = new JSONWriter(out);
        try {
            this.value(this.target);
        }
        finally {
            try {
                out.flush();
                out.close();
            }
            catch (Exception e) {
                log.warn((Object)("Unexpected exception while closing a writer: " + e.getMessage()));
            }
        }
    }

    public void render(HttpServletResponse response) throws ConverterException {
        response.setContentType(GrailsWebUtil.getContentType("application/json", this.encoding));
        try {
            this.render(response.getWriter());
        }
        catch (IOException e) {
            throw new ConverterException(e);
        }
    }

    protected Object extractIdValue(Object domainObject, GrailsDomainClassProperty idProperty) {
        BeanWrapperImpl beanWrapper = new BeanWrapperImpl(domainObject);
        return beanWrapper.getPropertyValue(idProperty.getName());
    }

    protected void bean(Object o) throws ConverterException {
        try {
            this.writer.object();
            BeanInfo info = Introspector.getBeanInfo(o.getClass());
            PropertyDescriptor[] properties = info.getPropertyDescriptors();
            for (int i = 0; i < properties.length; ++i) {
                PropertyDescriptor property = properties[i];
                String name = property.getName();
                Method readMethod = property.getReadMethod();
                Class<?> propType = property.getPropertyType();
                if (readMethod == null || o instanceof GroovyObject && name.equals("metaClass")) continue;
                Object value = readMethod.invoke(o, (Object[])null);
                this.property(name, value);
            }
            Field[] fields = o.getClass().getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                int modifiers = field.getModifiers();
                if (!Modifier.isPublic(modifiers) || Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers)) continue;
                this.property(field.getName(), field.get(o));
            }
            this.writer.endObject();
        }
        catch (ConverterException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new ConverterException("Error converting Bean with class " + o.getClass().getName(), e);
        }
    }

    protected void domain(Object o) throws ConverterException {
        try {
            BeanWrapper beanWrapper = this.createBeanWrapper(o);
            GrailsDomainClass domainClass = ConverterUtil.getDomainClass(o.getClass().getName());
            if (domainClass != null) {
                this.writer.object();
                GrailsDomainClassProperty id = domainClass.getIdentifier();
                this.property(id.getName(), beanWrapper.getPropertyValue(id.getName()));
                this.property("class", domainClass.getName());
                GrailsDomainClassProperty[] properties = domainClass.getPersistentProperties();
                for (int i = 0; i < properties.length; ++i) {
                    GrailsDomainClassProperty prop = properties[i];
                    if (!prop.isAssociation() || this.isRenderDomainClassRelations()) {
                        this.property(prop.getName(), beanWrapper.getPropertyValue(prop.getName()));
                        continue;
                    }
                    this.writer.key(prop.getName());
                    Object refValue = beanWrapper.getPropertyValue(prop.getName());
                    if (refValue == null) {
                        Class propClass = prop.getType();
                        if (Collection.class.isAssignableFrom(propClass)) {
                            this.writer.array();
                            this.writer.endArray();
                            continue;
                        }
                        if (Map.class.isAssignableFrom(propClass)) {
                            this.writer.object();
                            this.writer.endObject();
                            continue;
                        }
                        this.writer.value(null);
                        continue;
                    }
                    if (prop.isOneToOne() || prop.isManyToOne() || prop.isEmbedded()) {
                        if (GrailsClassUtils.isJdk5Enum((Class)prop.getType())) {
                            this.enumeration(refValue);
                            continue;
                        }
                        this.value(this.extractIdValue(refValue, prop.getReferencedDomainClass().getIdentifier()));
                        continue;
                    }
                    GrailsDomainClassProperty refIdProperty = prop.getReferencedDomainClass().getIdentifier();
                    if (Collection.class.isAssignableFrom(prop.getType())) {
                        this.writer.array();
                        Collection col = (Collection)refValue;
                        for (Object val : col) {
                            this.value(this.extractIdValue(val, refIdProperty));
                        }
                        this.writer.endArray();
                        continue;
                    }
                    if (Map.class.isAssignableFrom(prop.getType())) {
                        this.writer.object();
                        Map map = (Map)refValue;
                        for (String key : map.keySet()) {
                            this.property(key, this.extractIdValue(map.get(key), refIdProperty));
                        }
                        this.writer.endObject();
                        continue;
                    }
                    throw new ConverterException("Unable to convert property \"" + prop.getName() + "\" of Domain Class \"" + domainClass.getName() + "\": The association class [" + prop.getType().getName() + "] is not a Collection or a Map!");
                }
                this.writer.endObject();
            }
        }
        catch (ConverterException ce) {
            throw ce;
        }
        catch (JSONException e) {
            throw new ConverterException(e);
        }
    }

    public void array(Object o) throws ConverterException {
        try {
            int len = Array.getLength(o);
            this.writer.array();
            for (int i = 0; i < len; ++i) {
                this.value(Array.get(o, i));
            }
            this.writer.endArray();
        }
        catch (JSONException e) {
            throw new ConverterException(e);
        }
    }

    public void value(Object o) throws ConverterException {
        try {
            if (o == null) {
                this.writer.value(null);
            } else if (o instanceof GroovyObject && ConverterUtil.isDomainClass(o.getClass())) {
                this.domain(o);
            } else if (GrailsClassUtils.isJdk5Enum(o.getClass())) {
                this.enumeration(o);
            } else if (o instanceof Class) {
                this.writer.value(((Class)o).getName());
            } else if (o instanceof Map) {
                this.writer.object();
                Map map = (Map)o;
                for (Object key : map.keySet()) {
                    this.property(key.toString(), map.get(key));
                }
                this.writer.endObject();
            } else if (o instanceof Collection) {
                this.writer.array();
                Iterator it = ((Collection)o).iterator();
                while (it.hasNext()) {
                    this.value(it.next());
                }
                this.writer.endArray();
            } else if (o.getClass().isArray()) {
                this.array(o);
            } else if (o instanceof String) {
                this.writer.value(o);
            } else if (o instanceof GString) {
                this.value(o.toString());
            } else if (o instanceof Date) {
                Date d = (Date)o;
                this.writer.value(d);
            } else if (o instanceof Calendar) {
                this.value(((Calendar)o).getTime());
            } else if (o.getClass().equals(byte[].class)) {
                this.value(((byte[])o).length + " Bytes");
            } else if (o.getClass().isPrimitive() && !o.getClass().equals(byte[].class) || o instanceof Number || o instanceof Boolean) {
                this.writer.value(o);
            } else if (o instanceof Currency || o instanceof TimeZone || o instanceof Locale || o instanceof URL) {
                this.value(o.toString());
            } else if (o instanceof Errors) {
                this.errors((Errors)o);
            } else {
                this.bean(o);
            }
        }
        catch (ConverterException ce) {
            throw ce;
        }
        catch (JSONException e) {
            throw new ConverterException(e);
        }
    }

    protected void errors(Errors errors) throws JSONException {
        this.writer.object();
        this.writer.key("errors");
        this.writer.array();
        for (Object o : errors.getAllErrors()) {
            if (!(o instanceof FieldError)) continue;
            FieldError fe = (FieldError)o;
            this.writer.object();
            this.property("object", fe.getObjectName());
            this.property("field", fe.getField());
            this.property("rejected-value", fe.getRejectedValue());
            Locale locale = LocaleContextHolder.getLocale();
            if (this.applicationContext != null) {
                this.property("message", this.applicationContext.getMessage((MessageSourceResolvable)fe, locale));
            } else {
                this.property("message", fe.getDefaultMessage());
            }
            this.writer.endObject();
        }
        this.writer.endArray();
        this.writer.endObject();
    }

    protected void enumeration(Object en) throws JSONException {
        this.writer.object();
        Class<?> enumClass = en.getClass();
        this.property("enumType", enumClass.getName());
        Method nameMethod = BeanUtils.findDeclaredMethod(enumClass, (String)"name", null);
        try {
            this.property("name", nameMethod.invoke(en, null));
        }
        catch (Exception e) {
            this.property("name", "");
        }
        this.writer.endObject();
    }

    protected void property(String key, Object value) throws JSONException, ConverterException {
        this.writer.key(key);
        this.value(value);
    }

    public String toString(boolean prettyPrint) throws JSONException {
        String json = super.toString();
        if (prettyPrint) {
            Object jsonObject = new JSONTokener(json).nextValue();
            if (jsonObject instanceof JSONObject) {
                return ((JSONObject)jsonObject).toString(3);
            }
            if (jsonObject instanceof JSONArray) {
                return ((JSONArray)jsonObject).toString(3);
            }
        }
        return json;
    }

    public static Object parse(String source) throws ConverterException {
        try {
            return new JSONTokener(source).nextValue();
        }
        catch (JSONException e) {
            throw new ConverterException("Error parsing JSON", e);
        }
    }

    public static Object parse(InputStream is, String encoding) throws ConverterException {
        try {
            return JSON.parse(IOUtils.toString((InputStream)is, (String)encoding));
        }
        catch (IOException e) {
            throw new ConverterException("Error parsing JSON", e);
        }
    }

    public static Object parse(HttpServletRequest request) throws ConverterException {
        Object json = request.getAttribute(CACHED_JSON);
        if (json != null) {
            return json;
        }
        String encoding = request.getCharacterEncoding();
        if (encoding == null) {
            encoding = "UTF-8";
        }
        try {
            json = JSON.parse((InputStream)request.getInputStream(), encoding);
            request.setAttribute(CACHED_JSON, json);
            return json;
        }
        catch (IOException e) {
            throw new ConverterException("Error parsing JSON", e);
        }
    }

    public void setTarget(Object target) {
        this.target = target;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

