/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.metaclass;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MissingMethodException;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsClassUtils;
import org.codehaus.groovy.grails.commons.metaclass.AbstractDynamicMethodInvocation;
import org.codehaus.groovy.grails.web.mapping.UrlCreator;
import org.codehaus.groovy.grails.web.mapping.UrlMappingsHolder;
import org.codehaus.groovy.grails.web.servlet.GrailsApplicationAttributes;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsWebRequest;
import org.codehaus.groovy.grails.web.servlet.mvc.exceptions.ControllerExecutionException;
import org.springframework.context.ApplicationContext;
import org.springframework.validation.Errors;
import org.springframework.web.context.request.RequestContextHolder;

public class RedirectDynamicMethod
extends AbstractDynamicMethodInvocation {
    public static final String METHOD_SIGNATURE = "redirect";
    public static final Pattern METHOD_PATTERN = Pattern.compile("^redirect$");
    public static final String ARGUMENT_URI = "uri";
    public static final String ARGUMENT_URL = "url";
    public static final String ARGUMENT_CONTROLLER = "controller";
    public static final String ARGUMENT_ACTION = "action";
    public static final String ARGUMENT_ID = "id";
    public static final String ARGUMENT_PARAMS = "params";
    private static final String ARGUMENT_FRAGMENT = "fragment";
    public static final String ARGUMENT_ERRORS = "errors";
    private static final Log LOG = LogFactory.getLog(RedirectDynamicMethod.class);
    private UrlMappingsHolder urlMappingsHolder;
    private boolean useJessionId = false;
    private static final String GRAILS_VIEWS_ENABLE_JSESSIONID = "grails.views.enable.jsessionid";

    public RedirectDynamicMethod(ApplicationContext applicationContext) {
        super(METHOD_PATTERN);
        GrailsApplication application;
        Object o;
        if (applicationContext.containsBean("grailsUrlMappingsHolder")) {
            this.urlMappingsHolder = (UrlMappingsHolder)applicationContext.getBean("grailsUrlMappingsHolder");
        }
        if ((o = (application = (GrailsApplication)applicationContext.getBean("grailsApplication")).getFlatConfig().get(GRAILS_VIEWS_ENABLE_JSESSIONID)) instanceof Boolean) {
            this.useJessionId = (Boolean)o;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object target, String methodName, Object[] arguments) {
        String actualUri;
        Map argMap;
        if (arguments.length == 0) {
            throw new MissingMethodException(METHOD_SIGNATURE, target.getClass(), arguments);
        }
        Map map = argMap = arguments[0] instanceof Map ? (Map)arguments[0] : Collections.EMPTY_MAP;
        if (argMap.size() == 0) {
            throw new MissingMethodException(METHOD_SIGNATURE, target.getClass(), arguments);
        }
        Object actionRef = argMap.get(ARGUMENT_ACTION);
        String controllerName = argMap.containsKey(ARGUMENT_CONTROLLER) ? argMap.get(ARGUMENT_CONTROLLER).toString() : null;
        Object id = argMap.get(ARGUMENT_ID);
        String frag = argMap.get(ARGUMENT_FRAGMENT) != null ? argMap.get(ARGUMENT_FRAGMENT).toString() : null;
        Object uri = argMap.get(ARGUMENT_URI);
        String url = argMap.containsKey(ARGUMENT_URL) ? argMap.get(ARGUMENT_URL).toString() : null;
        HashMap params = (HashMap)argMap.get(ARGUMENT_PARAMS);
        if (params == null) {
            params = new HashMap();
        }
        Errors errors = (Errors)argMap.get(ARGUMENT_ERRORS);
        GroovyObject controller = (GroovyObject)target;
        Errors controllerErrors = (Errors)controller.getProperty(ARGUMENT_ERRORS);
        if (controllerErrors != null) {
            controllerErrors.addAllErrors(errors);
        } else {
            controller.setProperty(ARGUMENT_ERRORS, (Object)errors);
        }
        GrailsWebRequest webRequest = (GrailsWebRequest)RequestContextHolder.currentRequestAttributes();
        GrailsApplicationAttributes attrs = webRequest.getAttributes();
        HttpServletRequest request = webRequest.getCurrentRequest();
        HttpServletResponse response = webRequest.getCurrentResponse();
        if (uri != null) {
            actualUri = attrs.getApplicationUri((ServletRequest)request) + uri.toString();
        } else if (url != null) {
            actualUri = url;
        } else {
            String actionName = this.establishActionName(actionRef, target, webRequest);
            String string = controllerName = controllerName != null ? controllerName : webRequest.getControllerName();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Dynamic method [redirect] looking up URL mapping for controller [" + controllerName + "] and action [" + actionName + "] and params [" + params + "] with [" + this.urlMappingsHolder + "]"));
            }
            try {
                if (id != null) {
                    params.put(ARGUMENT_ID, id);
                }
                UrlCreator urlMapping = this.urlMappingsHolder.getReverseMapping(controllerName, actionName, params);
                if (LOG.isDebugEnabled() && urlMapping == null) {
                    LOG.debug((Object)("Dynamic method [redirect] no URL mapping found for params [" + params + "]"));
                }
                String action = actionName != null ? actionName : webRequest.getActionName();
                actualUri = urlMapping.createURL(controllerName, action, params, request.getCharacterEncoding(), frag);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Dynamic method [redirect] mapped to URL [" + actualUri + "]"));
                }
            }
            finally {
                if (id != null) {
                    params.remove(ARGUMENT_ID);
                }
            }
        }
        return this.redirectResponse(actualUri, response);
    }

    private Object redirectResponse(String actualUri, HttpServletResponse response) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Dynamic method [redirect] forwarding request to [" + actualUri + "]"));
        }
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Executing redirect with response [" + response + "]"));
            }
            String redirectUrl = this.useJessionId ? response.encodeRedirectURL(actualUri) : actualUri;
            response.sendRedirect(redirectUrl);
        }
        catch (IOException e) {
            throw new ControllerExecutionException("Error redirecting request for url [" + actualUri + "]: " + e.getMessage(), e);
        }
        return null;
    }

    private String establishActionName(Object actionRef, Object target, GrailsWebRequest webRequest) {
        String actionName = "";
        if (actionRef instanceof String) {
            actionName = (String)actionRef;
        } else if (actionRef instanceof Closure) {
            Closure c = (Closure)actionRef;
            actionName = GrailsClassUtils.findPropertyNameForValue((Object)target, (Object)c);
        }
        return actionName;
    }
}

