/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.converters.marshaller.xml;

import grails.converters.XML;
import java.lang.reflect.Method;
import org.codehaus.groovy.grails.commons.GrailsClassUtils;
import org.codehaus.groovy.grails.web.converters.exceptions.ConverterException;
import org.codehaus.groovy.grails.web.converters.marshaller.ObjectMarshaller;
import org.springframework.beans.BeanUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumMarshaller
implements ObjectMarshaller<XML> {
    @Override
    public boolean supports(Object object) {
        return GrailsClassUtils.isJdk5Enum(object.getClass());
    }

    @Override
    public void marshalObject(Object en, XML xml) throws ConverterException {
        try {
            Class<?> enumClass = en.getClass();
            xml.attribute("enumType", enumClass.getName());
            Method nameMethod = BeanUtils.findDeclaredMethod(enumClass, (String)"name", null);
            try {
                xml.chars(nameMethod.invoke(en, new Object[0]).toString());
            }
            catch (Exception e) {}
        }
        catch (ConverterException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new ConverterException("Error converting Enum with class " + en.getClass().getName(), e);
        }
    }
}

