/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.converters.marshaller.json;

import grails.converters.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.GrailsClassUtils;
import org.codehaus.groovy.grails.commons.GrailsDomainClass;
import org.codehaus.groovy.grails.commons.GrailsDomainClassProperty;
import org.codehaus.groovy.grails.web.converters.ConverterUtil;
import org.codehaus.groovy.grails.web.converters.exceptions.ConverterException;
import org.codehaus.groovy.grails.web.converters.marshaller.ObjectMarshaller;
import org.codehaus.groovy.grails.web.json.JSONWriter;
import org.hibernate.Hibernate;
import org.hibernate.collection.AbstractPersistentCollection;
import org.springframework.beans.BeanWrapperImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomainClassMarshaller
implements ObjectMarshaller<JSON> {
    private final Log log = LogFactory.getLog(this.getClass());
    private boolean includeVersion = false;

    public boolean isIncludeVersion() {
        return this.includeVersion;
    }

    public void setIncludeVersion(boolean includeVersion) {
        this.includeVersion = includeVersion;
    }

    @Override
    public boolean supports(Object object) {
        return ConverterUtil.isDomainClass(object.getClass());
    }

    @Override
    public void marshalObject(Object value, JSON json) throws ConverterException {
        GrailsDomainClassProperty[] properties;
        JSONWriter writer = json.getWriter();
        Class<?> clazz = value.getClass();
        GrailsDomainClass domainClass = ConverterUtil.getDomainClass(clazz.getName());
        BeanWrapperImpl beanWrapper = new BeanWrapperImpl(value);
        writer.object();
        writer.key("class").value(domainClass.getName());
        GrailsDomainClassProperty id = domainClass.getIdentifier();
        Object idValue = this.extractValue(value, id);
        json.property("id", idValue != null ? String.valueOf(idValue) : null);
        if (this.isIncludeVersion()) {
            GrailsDomainClassProperty versionProperty = domainClass.getVersion();
            Object version = this.extractValue(value, versionProperty);
            json.property("version", version != null ? String.valueOf(version) : null);
        }
        for (GrailsDomainClassProperty property : properties = domainClass.getPersistentProperties()) {
            writer.key(property.getName());
            if (!property.isAssociation()) {
                Object val = beanWrapper.getPropertyValue(property.getName());
                json.convertAnother(val);
                continue;
            }
            Cloneable referenceObject = beanWrapper.getPropertyValue(property.getName());
            if (this.isRenderDomainClassRelations()) {
                if (referenceObject == null) {
                    writer.value(null);
                    continue;
                }
                if (referenceObject instanceof AbstractPersistentCollection) {
                    AbstractPersistentCollection acol = (AbstractPersistentCollection)referenceObject;
                    acol.forceInitialization();
                    referenceObject = referenceObject instanceof SortedMap ? new TreeMap(referenceObject) : (referenceObject instanceof SortedSet ? new TreeSet((SortedSet)((Object)referenceObject)) : (referenceObject instanceof Set ? new HashSet((Set)((Object)referenceObject)) : (referenceObject instanceof Map ? new HashMap(referenceObject) : new ArrayList((Collection)((Object)referenceObject)))));
                } else if (!Hibernate.isInitialized((Object)referenceObject)) {
                    Hibernate.initialize((Object)referenceObject);
                }
                json.convertAnother(referenceObject);
                continue;
            }
            if (referenceObject == null) {
                json.value(null);
                continue;
            }
            GrailsDomainClass referencedDomainClass = property.getReferencedDomainClass();
            if (property.isOneToOne() || property.isManyToOne() || property.isEmbedded()) {
                if (GrailsClassUtils.isJdk5Enum((Class)property.getType())) {
                    json.convertAnother(referenceObject);
                    continue;
                }
                this.asShortObject(referenceObject, json, referencedDomainClass.getIdentifier(), referencedDomainClass);
                continue;
            }
            GrailsDomainClassProperty referencedIdProperty = referencedDomainClass.getIdentifier();
            String refPropertyName = referencedDomainClass.getPropertyName();
            if (referenceObject instanceof Collection) {
                Collection o = (Collection)((Object)referenceObject);
                writer.array();
                for (Object object : o) {
                    this.asShortObject(object, json, referencedIdProperty, referencedDomainClass);
                }
                writer.endArray();
                continue;
            }
            if (!(referenceObject instanceof Map)) continue;
            Map map = referenceObject;
            for (Map.Entry entry : map.entrySet()) {
                String key = String.valueOf(entry.getKey());
                Object o = entry.getValue();
                writer.object();
                writer.key(key);
                this.asShortObject(o, json, referencedIdProperty, referencedDomainClass);
                writer.endObject();
            }
        }
        writer.endObject();
    }

    protected void asShortObject(Object refObj, JSON json, GrailsDomainClassProperty idProperty, GrailsDomainClass referencedDomainClass) throws ConverterException {
        JSONWriter writer = json.getWriter();
        writer.object();
        writer.key("class").value(referencedDomainClass.getName());
        writer.key("id").value(this.extractValue(refObj, idProperty));
        writer.endObject();
    }

    protected Object extractValue(Object domainObject, GrailsDomainClassProperty property) {
        BeanWrapperImpl beanWrapper = new BeanWrapperImpl(domainObject);
        return beanWrapper.getPropertyValue(property.getName());
    }

    protected boolean isRenderDomainClassRelations() {
        return false;
    }
}

