/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.servlet.view;

import java.util.Locale;
import javax.servlet.ServletContext;
import org.codehaus.groovy.grails.web.servlet.view.LayoutViewResolver;
import org.codehaus.groovy.grails.web.sitemesh.GrailsLayoutView;
import org.codehaus.groovy.grails.web.sitemesh.GroovyPageLayoutFinder;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.Ordered;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.servlet.SmartView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;

public class GrailsLayoutViewResolver
implements LayoutViewResolver,
Ordered,
ServletContextAware,
ApplicationContextAware {
    protected ViewResolver innerViewResolver;
    protected GroovyPageLayoutFinder groovyPageLayoutFinder;
    private int order = 2147483617;
    protected ServletContext servletContext;

    public GrailsLayoutViewResolver(ViewResolver innerViewResolver, GroovyPageLayoutFinder groovyPageLayoutFinder) {
        this.innerViewResolver = innerViewResolver;
        this.groovyPageLayoutFinder = groovyPageLayoutFinder;
    }

    public GrailsLayoutViewResolver() {
    }

    public View resolveViewName(String viewName, Locale locale) throws Exception {
        View innerView = this.innerViewResolver.resolveViewName(viewName, locale);
        if (innerView == null) {
            return null;
        }
        if (innerView instanceof SmartView && ((SmartView)innerView).isRedirectView()) {
            return innerView;
        }
        return this.createLayoutView(innerView);
    }

    protected View createLayoutView(View innerView) {
        return new GrailsLayoutView(this.groovyPageLayoutFinder, innerView);
    }

    public ViewResolver getInnerViewResolver() {
        return this.innerViewResolver;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
        if (this.innerViewResolver instanceof ServletContextAware) {
            ((ServletContextAware)this.innerViewResolver).setServletContext(servletContext);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (this.innerViewResolver instanceof ApplicationContextAware) {
            ((ApplicationContextAware)this.innerViewResolver).setApplicationContext(applicationContext);
        }
    }

    public void setInnerViewResolver(ViewResolver innerViewResolver) {
        this.innerViewResolver = innerViewResolver;
    }

    public void setGroovyPageLayoutFinder(GroovyPageLayoutFinder groovyPageLayoutFinder) {
        this.groovyPageLayoutFinder = groovyPageLayoutFinder;
    }
}

