/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.compiler.web.gsp;

import groovy.lang.Closure;
import java.util.List;
import java.util.Stack;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.CodeVisitorSupport;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.grails.web.pages.GroovyPage;
import org.codehaus.groovy.grails.web.util.GrailsPrintWriter;
import org.codehaus.groovy.syntax.Token;

class GroovyPageOptimizerVisitor
extends CodeVisitorSupport {
    private static final ClassNode groovyPageClassNode = new ClassNode(GroovyPage.class);
    private static final MethodNode writerMethodNode = new ClassNode(GrailsPrintWriter.class).getMethod("print", new Parameter[]{new Parameter(new ClassNode(Object.class), "obj")});
    private static final String THIS_RECEIVER = "this";
    private static final String THISOBJECT = "thisObject";
    private static final String OUT_RECEIVER = "out";
    private static final String PRINT_METHOD = "print";
    private static final String EXPRESSIONOUT_RECEIVER = "expressionOut";
    private Stack<ClosureExpression> innerClosures = new Stack();
    private ClassNode targetGroovyPageNode;
    private DeclarationExpression thisObjectDeclaration;
    private VariableExpression thisObjectVariable;

    public GroovyPageOptimizerVisitor(ClassNode targetGroovyPage) {
        this.targetGroovyPageNode = targetGroovyPage;
        MethodCallExpression thisObjectMethodCall = new MethodCallExpression((Expression)new VariableExpression(THIS_RECEIVER), "getThisObject", MethodCallExpression.NO_ARGUMENTS);
        thisObjectMethodCall.setMethodTarget((MethodNode)new ClassNode(Closure.class).getMethods("getThisObject").get(0));
        this.thisObjectVariable = new VariableExpression(THISOBJECT, this.targetGroovyPageNode);
        this.thisObjectDeclaration = new DeclarationExpression(this.thisObjectVariable, Token.newSymbol((int)100, (int)0, (int)0), (Expression)thisObjectMethodCall);
    }

    private void introduceThisObjectVariable(ClosureExpression closureExpression) {
        if (closureExpression.getCode() instanceof BlockStatement) {
            List oldBlock = ((BlockStatement)closureExpression.getCode()).getStatements();
            BlockStatement newBlock = new BlockStatement();
            newBlock.addStatement((Statement)new ExpressionStatement((Expression)this.thisObjectDeclaration));
            newBlock.addStatements(oldBlock);
            closureExpression.setCode((Statement)newBlock);
        }
    }

    public void visitMethodCallExpression(MethodCallExpression call) {
        if (!this.isCallFromGroovyPageClass(call) && this.isCallFromOutOrCodecOut(call)) {
            this.proceedCallFromOutOrCodecOut(call);
        }
        super.visitMethodCallExpression(call);
    }

    private void proceedCallFromOutOrCodecOut(MethodCallExpression call) {
        call.setMethodTarget(writerMethodNode);
    }

    private boolean isCallFromOutOrCodecOut(MethodCallExpression expression) {
        return (expression.getObjectExpression().getText().equals(OUT_RECEIVER) || expression.getObjectExpression().getText().equals(EXPRESSIONOUT_RECEIVER)) && expression.getMethodAsString().equals(PRINT_METHOD);
    }

    private void proceedCallFromGroovyPageClass(MethodCallExpression call) {
        List methodNodeList = groovyPageClassNode.getMethods(call.getMethodAsString());
        if (methodNodeList.size() == 1) {
            call.setMethodTarget((MethodNode)methodNodeList.get(0));
            this.changeThisObjectExpressionIfInnerClosure(call);
        } else if (methodNodeList.size() > 1 && call.getArguments() instanceof ArgumentListExpression) {
            ArgumentListExpression argsExpr = (ArgumentListExpression)call.getArguments();
            for (MethodNode methodNode : methodNodeList) {
                if (methodNode.getParameters().length != argsExpr.getExpressions().size()) continue;
                call.setMethodTarget(methodNode);
                this.changeThisObjectExpressionIfInnerClosure(call);
                break;
            }
        }
    }

    private void changeThisObjectExpressionIfInnerClosure(MethodCallExpression call) {
        if (!this.innerClosures.isEmpty()) {
            call.setObjectExpression((Expression)this.thisObjectVariable);
        }
    }

    private boolean isCallFromGroovyPageClass(MethodCallExpression expression) {
        return expression.getObjectExpression().getText().equals(THIS_RECEIVER) && !groovyPageClassNode.getMethods(expression.getMethodAsString()).isEmpty();
    }
}

