/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.util;

import groovy.lang.GroovyObjectSupport;
import groovy.lang.Writable;
import java.io.EOFException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.support.encoding.AbstractEncodedAppender;
import org.codehaus.groovy.grails.support.encoding.CharArrayAccessible;
import org.codehaus.groovy.grails.support.encoding.CodecIdentifier;
import org.codehaus.groovy.grails.support.encoding.DefaultCodecIdentifier;
import org.codehaus.groovy.grails.support.encoding.Encodeable;
import org.codehaus.groovy.grails.support.encoding.EncodedAppender;
import org.codehaus.groovy.grails.support.encoding.EncodedAppenderFactory;
import org.codehaus.groovy.grails.support.encoding.EncodedAppenderWriter;
import org.codehaus.groovy.grails.support.encoding.EncodedAppenderWriterFactory;
import org.codehaus.groovy.grails.support.encoding.Encoder;
import org.codehaus.groovy.grails.support.encoding.EncoderAware;
import org.codehaus.groovy.grails.support.encoding.EncodingState;
import org.codehaus.groovy.grails.support.encoding.EncodingStateImpl;
import org.codehaus.groovy.grails.support.encoding.EncodingStateRegistry;
import org.codehaus.groovy.grails.support.encoding.EncodingStateRegistryLookup;
import org.codehaus.groovy.grails.support.encoding.EncodingStateRegistryLookupHolder;
import org.codehaus.groovy.grails.support.encoding.StreamEncodeable;
import org.codehaus.groovy.grails.web.util.GrailsWrappedWriter;
import org.codehaus.groovy.grails.web.util.StringCharArrayAccessor;

public class StreamCharBuffer
extends GroovyObjectSupport
implements Writable,
CharSequence,
Externalizable,
Encodeable,
StreamEncodeable,
EncodedAppenderWriterFactory,
Cloneable {
    private static final int EXTERNALIZABLE_VERSION = 2;
    static final long serialVersionUID = 2L;
    private static final Log log = LogFactory.getLog(StreamCharBuffer.class);
    private static final int DEFAULT_CHUNK_SIZE = Integer.getInteger("streamcharbuffer.chunksize", 512);
    private static final int DEFAULT_MAX_CHUNK_SIZE = Integer.getInteger("streamcharbuffer.maxchunksize", 0x100000);
    private static final int DEFAULT_CHUNK_SIZE_GROW_PROCENT = Integer.getInteger("streamcharbuffer.growprocent", 100);
    private static final int SUB_BUFFERCHUNK_MIN_SIZE = Integer.getInteger("streamcharbuffer.subbufferchunkminsize", 512);
    private static final int SUB_STRINGCHUNK_MIN_SIZE = Integer.getInteger("streamcharbuffer.substringchunkminsize", 512);
    private static final int WRITE_DIRECT_MIN_SIZE = Integer.getInteger("streamcharbuffer.writedirectminsize", 1024);
    private static final int CHUNK_MIN_SIZE = Integer.getInteger("streamcharbuffer.chunkminsize", 256);
    private final int firstChunkSize;
    private final int growProcent;
    private final int maxChunkSize;
    private int subStringChunkMinSize = SUB_STRINGCHUNK_MIN_SIZE;
    private int subBufferChunkMinSize = SUB_BUFFERCHUNK_MIN_SIZE;
    private int writeDirectlyToConnectedMinSize = WRITE_DIRECT_MIN_SIZE;
    private int chunkMinSize = CHUNK_MIN_SIZE;
    private int chunkSize;
    private int totalChunkSize;
    private final StreamCharBufferWriter writer;
    private List<ConnectToWriter> connectToWriters;
    private ConnectedWritersWriter connectedWritersWriter;
    private Boolean notConnectedToEncodeAwareWriters = null;
    boolean preferSubChunkWhenWritingToOtherBuffer = false;
    private AllocatedBuffer allocBuffer;
    private AbstractChunk firstChunk;
    private AbstractChunk lastChunk;
    private int totalCharsInList;
    private int totalCharsInDynamicChunks;
    private int sizeAtLeast;
    private StreamCharBufferKey bufferKey = new StreamCharBufferKey();
    private Map<StreamCharBufferKey, StreamCharBufferSubChunk> dynamicChunkMap;
    private Set<SoftReference<StreamCharBufferKey>> parentBuffers;
    int allocatedBufferIdSequence = 0;
    int readerCount = 0;
    boolean hasReaders = false;
    boolean notifyParentBuffersEnabled = true;

    public StreamCharBuffer() {
        this(DEFAULT_CHUNK_SIZE, DEFAULT_CHUNK_SIZE_GROW_PROCENT, DEFAULT_MAX_CHUNK_SIZE);
    }

    public StreamCharBuffer(int chunkSize) {
        this(chunkSize, DEFAULT_CHUNK_SIZE_GROW_PROCENT, DEFAULT_MAX_CHUNK_SIZE);
    }

    public StreamCharBuffer(int chunkSize, int growProcent) {
        this(chunkSize, growProcent, DEFAULT_MAX_CHUNK_SIZE);
    }

    public StreamCharBuffer(int chunkSize, int growProcent, int maxChunkSize) {
        this.firstChunkSize = chunkSize;
        this.growProcent = growProcent;
        this.maxChunkSize = maxChunkSize;
        this.writer = new StreamCharBufferWriter();
        this.reset(true);
    }

    public boolean isPreferSubChunkWhenWritingToOtherBuffer() {
        return this.preferSubChunkWhenWritingToOtherBuffer;
    }

    public void setPreferSubChunkWhenWritingToOtherBuffer(boolean prefer) {
        this.preferSubChunkWhenWritingToOtherBuffer = prefer;
    }

    public final void reset() {
        this.reset(true);
    }

    public final void reset(boolean resetChunkSize) {
        this.firstChunk = null;
        this.lastChunk = null;
        this.totalCharsInList = 0;
        this.totalCharsInDynamicChunks = -1;
        this.sizeAtLeast = -1;
        if (resetChunkSize) {
            this.chunkSize = this.firstChunkSize;
            this.totalChunkSize = 0;
        }
        if (this.allocBuffer == null) {
            this.allocBuffer = new AllocatedBuffer(this.chunkSize);
        } else {
            this.allocBuffer.clear();
        }
        if (this.dynamicChunkMap == null) {
            this.dynamicChunkMap = new HashMap<StreamCharBufferKey, StreamCharBufferSubChunk>();
        } else {
            this.dynamicChunkMap.clear();
        }
    }

    public final void clear() {
        this.reset();
        this.notifyBufferChange();
    }

    public final void connectTo(Writer w) {
        this.connectTo(w, true);
    }

    public final void connectTo(Writer w, boolean autoFlush) {
        this.initConnected();
        this.connectToWriters.add(new ConnectToWriter(w, autoFlush));
        this.initConnectedWritersWriter();
    }

    public final void encodeInStreamingModeTo(EncoderAware encoderLookup, EncodingStateRegistryLookup encodingStateRegistryLookup, boolean autoFlush, final Writer w) {
        this.encodeInStreamingModeTo(encoderLookup, encodingStateRegistryLookup, autoFlush, new LazyInitializingWriter(){

            @Override
            public Writer getWriter() throws IOException {
                return w;
            }
        });
    }

    public final void encodeInStreamingModeTo(EncoderAware encoderLookup, EncodingStateRegistryLookup encodingStateRegistryLookup, boolean autoFlush, LazyInitializingWriter ... writers) {
        LazyInitializingWriter encodingWriterInitializer = this.createEncodingInitializer(encoderLookup, encodingStateRegistryLookup, writers);
        this.connectTo(encodingWriterInitializer, autoFlush);
    }

    public LazyInitializingWriter createEncodingInitializer(final EncoderAware encoderLookup, final EncodingStateRegistryLookup encodingStateRegistryLookup, final LazyInitializingWriter ... writers) {
        LazyInitializingMultipleWriter encodingWriterInitializer = new LazyInitializingMultipleWriter(){
            Writer lazyWriter;

            @Override
            public Writer getWriter() throws IOException {
                return this.lazyWriter;
            }

            @Override
            public LazyInitializingWriter[] initializeMultiple(StreamCharBuffer buffer, boolean autoFlushMode) throws IOException {
                Encoder encoder = encoderLookup.getEncoder();
                if (encoder != null) {
                    EncodingStateRegistry encodingStateRegistry = encodingStateRegistryLookup.lookup();
                    StreamCharBuffer encodeBuffer = new StreamCharBuffer(StreamCharBuffer.this.chunkSize, StreamCharBuffer.this.growProcent, StreamCharBuffer.this.maxChunkSize);
                    this.lazyWriter = encodeBuffer.getWriterForEncoder(encoder, encodingStateRegistry);
                    for (LazyInitializingWriter w : writers) {
                        encodeBuffer.connectTo(w, autoFlushMode);
                    }
                    return new LazyInitializingWriter[]{this};
                }
                return writers;
            }
        };
        return encodingWriterInitializer;
    }

    private void initConnectedWritersWriter() {
        this.notConnectedToEncodeAwareWriters = null;
        this.connectedWritersWriter = null;
        this.setNotifyParentBuffersEnabled(false);
    }

    private void startUsingConnectedWritersWriter() throws IOException {
        if (this.connectedWritersWriter == null) {
            ArrayList<ConnectedWriter> connectedWriters = new ArrayList<ConnectedWriter>();
            for (ConnectToWriter connectToWriter : this.connectToWriters) {
                for (Writer writer : connectToWriter.getWriters()) {
                    Writer target = writer;
                    if (target instanceof GrailsWrappedWriter) {
                        target = ((GrailsWrappedWriter)((Object)target)).unwrap();
                    }
                    if (target == null) {
                        throw new NullPointerException("target is null");
                    }
                    connectedWriters.add(new ConnectedWriter(target, connectToWriter.isAutoFlush()));
                }
            }
            this.connectedWritersWriter = connectedWriters.size() > 1 ? new MultiOutputWriter(connectedWriters) : new SingleOutputWriter((ConnectedWriter)connectedWriters.get(0));
        }
    }

    public final void connectTo(LazyInitializingWriter w) {
        this.connectTo(w, true);
    }

    public final void connectTo(LazyInitializingWriter w, boolean autoFlush) {
        this.initConnected();
        this.connectToWriters.add(new ConnectToWriter(w, autoFlush));
        this.initConnectedWritersWriter();
    }

    public final void removeConnections() {
        if (this.connectToWriters != null) {
            this.connectToWriters = null;
            this.connectedWritersWriter = null;
            this.notConnectedToEncodeAwareWriters = null;
        }
    }

    private void initConnected() {
        if (this.connectToWriters == null) {
            this.connectToWriters = new ArrayList<ConnectToWriter>(2);
        }
    }

    public int getSubStringChunkMinSize() {
        return this.subStringChunkMinSize;
    }

    public void setSubStringChunkMinSize(int size) {
        this.subStringChunkMinSize = size;
    }

    public int getSubBufferChunkMinSize() {
        return this.subBufferChunkMinSize;
    }

    public void setSubBufferChunkMinSize(int size) {
        this.subBufferChunkMinSize = size;
    }

    public int getWriteDirectlyToConnectedMinSize() {
        return this.writeDirectlyToConnectedMinSize;
    }

    public void setWriteDirectlyToConnectedMinSize(int size) {
        this.writeDirectlyToConnectedMinSize = size;
    }

    public int getChunkMinSize() {
        return this.chunkMinSize;
    }

    public void setChunkMinSize(int size) {
        this.chunkMinSize = size;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public Reader getReader() {
        return this.getReader(false);
    }

    public Reader getReader(boolean removeAfterReading) {
        ++this.readerCount;
        this.hasReaders = true;
        return new StreamCharBufferReader(removeAfterReading);
    }

    public Writer writeTo(Writer target) throws IOException {
        this.writeTo(target, false, false);
        return target;
    }

    public void writeTo(Writer target, boolean flushTarget, boolean emptyAfter) throws IOException {
        EncodedAppenderFactory eaw;
        EncodedAppender appender;
        GrailsWrappedWriter wrappedWriter;
        if (target instanceof GrailsWrappedWriter && (wrappedWriter = (GrailsWrappedWriter)((Object)target)).isAllowUnwrappingOut()) {
            target = wrappedWriter.unwrap();
        }
        if (target == this.writer) {
            throw new IllegalArgumentException("Cannot write buffer to itself.");
        }
        if (!emptyAfter && target instanceof StreamCharBufferWriter) {
            ((StreamCharBufferWriter)target).write(this);
            return;
        }
        if (target instanceof EncodedAppenderFactory && (appender = (eaw = (EncodedAppenderFactory)target).getEncodedAppender()) != null) {
            if (appender == this.writer.getEncodedAppender()) {
                throw new IllegalArgumentException("Cannot write buffer to itself.");
            }
            Encoder encoder = null;
            if (target instanceof EncoderAware) {
                encoder = ((EncoderAware)target).getEncoder();
            }
            if (encoder == null && appender instanceof EncoderAware) {
                encoder = ((EncoderAware)appender).getEncoder();
            }
            this.encodeTo(appender, encoder);
            appender.flush();
            if (emptyAfter) {
                this.emptyAfterReading();
            }
            if (flushTarget) {
                target.flush();
            }
            return;
        }
        this.writeToImpl(target, flushTarget, emptyAfter);
    }

    private void writeToImpl(Writer target, boolean flushTarget, boolean emptyAfter) throws IOException {
        AbstractChunk current = this.firstChunk;
        while (current != null) {
            current.writeTo(target);
            current = current.next;
        }
        this.allocBuffer.writeTo(target);
        if (emptyAfter) {
            this.emptyAfterReading();
        }
        if (flushTarget) {
            target.flush();
        }
    }

    protected void emptyAfterReading() {
        this.firstChunk = null;
        this.lastChunk = null;
        this.totalCharsInList = 0;
        this.totalCharsInDynamicChunks = -1;
        this.sizeAtLeast = -1;
        this.dynamicChunkMap.clear();
        this.allocBuffer.clear();
    }

    @Deprecated
    public char[] readAsCharArray() {
        return this.toCharArray();
    }

    @Deprecated
    public String readAsString() {
        return this.toString();
    }

    @Override
    public String toString() {
        StringChunk stringChunk = this.readToSingleStringChunk(true);
        if (stringChunk != null) {
            return stringChunk.str;
        }
        return "";
    }

    public StringChunk readToSingleStringChunk(boolean registerEncodingState) {
        MultipartStringChunk stringChunk;
        if (this.firstChunk == this.lastChunk && this.firstChunk instanceof StringChunk && this.allocBuffer.charsUsed() == 0 && ((StringChunk)this.firstChunk).isSingleBuffer()) {
            StringChunk chunk = (StringChunk)this.firstChunk;
            if (registerEncodingState) {
                this.markEncoded(chunk);
            }
            return chunk;
        }
        int initialReaderCount = this.readerCount;
        MultipartCharBufferChunk chunk = this.readToSingleChunk();
        MultipartStringChunk multipartStringChunk = stringChunk = chunk != null ? chunk.asStringChunk() : null;
        if (initialReaderCount == 0) {
            this.reset();
            if (stringChunk != null) {
                this.addChunk(stringChunk);
            }
        }
        if (registerEncodingState) {
            this.markEncoded(stringChunk);
        }
        return stringChunk;
    }

    public void markEncoded(StringChunk strChunk) {
        Encoder encoder;
        EncodingState encodingState;
        MultipartStringChunk stringChunk;
        if (strChunk instanceof MultipartStringChunk && (stringChunk = (MultipartStringChunk)strChunk).isSingleEncoding() && (encodingState = stringChunk.firstPart.encodingState) != null && encodingState.getEncoders() != null && encodingState.getEncoders().size() > 0 && (encoder = (Encoder)encodingState.getEncoders().iterator().next()) != null) {
            encoder.markEncoded((CharSequence)stringChunk.str);
        }
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CharSequence)) {
            return false;
        }
        CharSequence other = (CharSequence)o;
        return this.toString().equals(other.toString());
    }

    public String plus(String value) {
        return this.toString() + value;
    }

    public String plus(Object value) {
        return this.toString() + value;
    }

    public char[] toCharArray() {
        if (this.firstChunk == this.lastChunk && this.firstChunk instanceof CharBufferChunk && this.allocBuffer.charsUsed() == 0 && ((CharBufferChunk)this.firstChunk).isSingleBuffer()) {
            return ((CharBufferChunk)this.firstChunk).buffer;
        }
        int initialReaderCount = this.readerCount;
        MultipartCharBufferChunk chunk = this.readToSingleChunk();
        if (initialReaderCount == 0) {
            this.reset();
            if (chunk != null) {
                this.addChunk(chunk);
            }
        }
        if (chunk != null) {
            return chunk.buffer;
        }
        return new char[0];
    }

    public List<EncodedPart> dumpEncodedParts() {
        ArrayList<EncodedPart> encodedParts = new ArrayList<EncodedPart>();
        MultipartStringChunk mpStringChunk = this.readToSingleChunk().asStringChunk();
        if (mpStringChunk.firstPart != null) {
            EncodingStatePart current = mpStringChunk.firstPart;
            int offset = 0;
            char[] buf = StringCharArrayAccessor.getValue(mpStringChunk.str);
            while (current != null) {
                encodedParts.add(new EncodedPart(current.encodingState, new String(buf, offset, current.len)));
                offset += current.len;
                current = current.next;
            }
        }
        return encodedParts;
    }

    private MultipartCharBufferChunk readToSingleChunk() {
        int currentSize = this.size();
        if (currentSize == 0) {
            return null;
        }
        FixedCharArrayEncodedAppender appender = new FixedCharArrayEncodedAppender(currentSize);
        try {
            this.encodeTo((EncodedAppender)appender, null);
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected IOException", e);
        }
        appender.finish();
        return appender.chunk;
    }

    public int size() {
        int total = this.totalCharsInList;
        if (this.totalCharsInDynamicChunks == -1) {
            this.totalCharsInDynamicChunks = 0;
            for (StreamCharBufferSubChunk chunk : this.dynamicChunkMap.values()) {
                this.totalCharsInDynamicChunks += chunk.size();
            }
        }
        total += this.totalCharsInDynamicChunks;
        this.sizeAtLeast = total += this.allocBuffer.charsUsed();
        return total;
    }

    @Override
    public boolean isEmpty() {
        return !this.isNotEmpty();
    }

    boolean isNotEmpty() {
        if (this.totalCharsInList > 0) {
            return true;
        }
        if (this.totalCharsInDynamicChunks > 0) {
            return true;
        }
        if (this.allocBuffer.charsUsed() > 0) {
            return true;
        }
        if (this.totalCharsInDynamicChunks == -1) {
            for (StreamCharBufferSubChunk chunk : this.dynamicChunkMap.values()) {
                if (!chunk.getSubBuffer().isNotEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    boolean isSizeLarger(int minSize) {
        if (minSize <= this.sizeAtLeast) {
            return true;
        }
        boolean retval = this.calculateIsSizeLarger(minSize);
        if (retval && minSize > this.sizeAtLeast) {
            this.sizeAtLeast = minSize;
        }
        return retval;
    }

    private boolean calculateIsSizeLarger(int minSize) {
        int total = this.totalCharsInList;
        if ((total += this.allocBuffer.charsUsed()) > minSize) {
            return true;
        }
        if (this.totalCharsInDynamicChunks != -1) {
            if ((total += this.totalCharsInDynamicChunks) > minSize) {
                return true;
            }
        } else {
            for (StreamCharBufferSubChunk chunk : this.dynamicChunkMap.values()) {
                if (!chunk.hasCachedSize() && chunk.getSubBuffer().isSizeLarger(minSize - total)) {
                    return true;
                }
                if ((total += chunk.size()) <= minSize) continue;
                return true;
            }
        }
        return false;
    }

    int allocateSpace(EncodingState encodingState) throws IOException {
        int spaceLeft = this.allocBuffer.spaceLeft(encodingState);
        if (spaceLeft == 0) {
            spaceLeft = this.appendCharBufferChunk(encodingState, true, true);
        }
        return spaceLeft;
    }

    private int appendCharBufferChunk(EncodingState encodingState, boolean flushInConnected, boolean allocate) throws IOException {
        int spaceLeft = 0;
        if (flushInConnected && this.isConnectedMode()) {
            this.flushToConnected(false);
            if (!this.isChunkSizeResizeable()) {
                this.allocBuffer.reuseBuffer(encodingState);
            }
        } else if (this.allocBuffer.hasChunk()) {
            this.addChunk(this.allocBuffer.createChunk());
        }
        spaceLeft = this.allocBuffer.spaceLeft(encodingState);
        if (allocate && spaceLeft == 0) {
            this.totalChunkSize += this.allocBuffer.chunkSize();
            this.resizeChunkSizeAsProcentageOfTotalSize();
            this.allocBuffer = new AllocatedBuffer(this.chunkSize);
            spaceLeft = this.allocBuffer.spaceLeft(encodingState);
        }
        return spaceLeft;
    }

    void appendStringChunk(EncodingState encodingState, String str, int off, int len) throws IOException {
        this.appendCharBufferChunk(encodingState, false, false);
        this.addChunk(new StringChunk(str, off, len)).setEncodingState(encodingState);
    }

    public void appendStreamCharBufferChunk(StreamCharBuffer subBuffer) throws IOException {
        this.appendCharBufferChunk(null, false, false);
        this.addChunk(new StreamCharBufferSubChunk(subBuffer));
    }

    AbstractChunk addChunk(AbstractChunk newChunk) {
        if (this.lastChunk != null) {
            this.lastChunk.next = newChunk;
            if (this.hasReaders) {
                newChunk.prev = this.lastChunk;
            }
        }
        this.lastChunk = newChunk;
        if (this.firstChunk == null) {
            this.firstChunk = newChunk;
        }
        if (newChunk instanceof StreamCharBufferSubChunk) {
            StreamCharBufferSubChunk bufSubChunk = (StreamCharBufferSubChunk)newChunk;
            this.dynamicChunkMap.put(bufSubChunk.streamCharBuffer.bufferKey, bufSubChunk);
        } else {
            this.totalCharsInList += newChunk.size();
        }
        return newChunk;
    }

    public boolean isConnectedMode() {
        return this.connectToWriters != null && !this.connectToWriters.isEmpty();
    }

    private void flushToConnected(boolean forceFlush) throws IOException {
        this.startUsingConnectedWritersWriter();
        if (this.notConnectedToEncodeAwareWriters == null) {
            this.notConnectedToEncodeAwareWriters = !this.connectedWritersWriter.isEncoderAware();
        }
        this.writeTo(this.connectedWritersWriter, forceFlush, true);
        if (forceFlush) {
            this.connectedWritersWriter.forceFlush();
        }
    }

    protected boolean isChunkSizeResizeable() {
        return this.growProcent > 0 && this.chunkSize < this.maxChunkSize;
    }

    protected void resizeChunkSizeAsProcentageOfTotalSize() {
        if (this.growProcent == 0) {
            return;
        }
        if (this.growProcent == 100) {
            this.chunkSize = Math.min(this.totalChunkSize, this.maxChunkSize);
        } else if (this.growProcent == 200) {
            this.chunkSize = Math.min(this.totalChunkSize << 1, this.maxChunkSize);
        } else if (this.growProcent > 0) {
            this.chunkSize = Math.max(Math.min(this.totalChunkSize * this.growProcent / 100, this.maxChunkSize), this.firstChunkSize);
        }
    }

    protected static final void arrayCopy(char[] src, int srcPos, char[] dest, int destPos, int length) {
        if (length == 1) {
            dest[destPos] = src[srcPos];
        } else {
            System.arraycopy(src, srcPos, dest, destPos, length);
        }
    }

    private boolean isNotConnectedToEncoderAwareWriters() {
        return this.notConnectedToEncodeAwareWriters != null && this.notConnectedToEncodeAwareWriters != false;
    }

    @Override
    public char charAt(int index) {
        return this.toString().charAt(index);
    }

    @Override
    public int length() {
        return this.size();
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.toString().subSequence(start, end);
    }

    public boolean asBoolean() {
        return this.isNotEmpty();
    }

    void addParentBuffer(StreamCharBuffer parent) {
        if (!this.notifyParentBuffersEnabled) {
            return;
        }
        if (this.parentBuffers == null) {
            this.parentBuffers = new HashSet<SoftReference<StreamCharBufferKey>>();
        }
        this.parentBuffers.add(new SoftReference<StreamCharBufferKey>(parent.bufferKey));
    }

    boolean bufferChanged(StreamCharBuffer buffer) {
        StreamCharBufferSubChunk subChunk = this.dynamicChunkMap.get(buffer.bufferKey);
        if (subChunk == null) {
            return false;
        }
        if (subChunk.resetSize()) {
            this.totalCharsInDynamicChunks = -1;
            this.sizeAtLeast = -1;
            this.notifyBufferChange();
        }
        return true;
    }

    void notifyBufferChange() {
        if (!this.notifyParentBuffersEnabled) {
            return;
        }
        if (this.parentBuffers == null) {
            return;
        }
        Iterator<SoftReference<StreamCharBufferKey>> i = this.parentBuffers.iterator();
        while (i.hasNext()) {
            SoftReference<StreamCharBufferKey> ref = i.next();
            StreamCharBufferKey parentKey = ref.get();
            boolean removeIt = true;
            if (parentKey != null) {
                StreamCharBuffer parent = parentKey.getBuffer();
                boolean bl = removeIt = !parent.bufferChanged(this);
            }
            if (!removeIt) continue;
            i.remove();
        }
    }

    public StreamCharBuffer clone() {
        StreamCharBuffer cloned = new StreamCharBuffer();
        cloned.setNotifyParentBuffersEnabled(false);
        if (this.size() > 0) {
            cloned.addChunk(this.readToSingleChunk());
        }
        return cloned;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        if (version != 2) {
            throw new IOException("Uncompatible version in serialization stream.");
        }
        this.reset();
        int len = in.readInt();
        if (len > 0) {
            char[] buf = new char[len];
            InputStreamReader reader = new InputStreamReader((InputStream)((Object)in), "UTF-8");
            reader.read(buf);
            String str = StringCharArrayAccessor.createString(buf);
            MultipartStringChunk mpStringChunk = new MultipartStringChunk(str);
            int partCount = in.readInt();
            for (int i = 0; i < partCount; ++i) {
                EncodingStatePart current = new EncodingStatePart();
                mpStringChunk.appendEncodingStatePart(current);
                current.len = in.readInt();
                int encodersSize = in.readInt();
                LinkedHashSet<SavedEncoder> encoders = null;
                if (encodersSize > 0) {
                    encoders = new LinkedHashSet<SavedEncoder>();
                    for (int j = 0; j < encodersSize; ++j) {
                        String codecName = in.readUTF();
                        boolean safe = in.readBoolean();
                        encoders.add(new SavedEncoder(codecName, safe));
                    }
                }
                current.encodingState = new EncodingStateImpl(encoders);
            }
            this.addChunk(mpStringChunk);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(2);
        StringChunk stringChunk = this.readToSingleStringChunk(false);
        if (stringChunk != null && stringChunk.str.length() > 0) {
            char[] buf = StringCharArrayAccessor.getValue(stringChunk.str);
            out.writeInt(buf.length);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)((Object)out), "UTF-8");
            writer.write(buf);
            ((Writer)writer).flush();
            if (stringChunk instanceof MultipartStringChunk) {
                MultipartStringChunk mpStringChunk = (MultipartStringChunk)stringChunk;
                out.writeInt(mpStringChunk.partCount());
                EncodingStatePart current = mpStringChunk.firstPart;
                while (current != null) {
                    out.writeInt(current.len);
                    if (current.encodingState != null && current.encodingState.getEncoders() != null && current.encodingState.getEncoders().size() > 0) {
                        out.writeInt(current.encodingState.getEncoders().size());
                        for (Encoder encoder : current.encodingState.getEncoders()) {
                            out.writeUTF(encoder.getCodecIdentifier().getCodecName());
                            out.writeBoolean(encoder.isSafe());
                        }
                    } else {
                        out.writeInt(0);
                    }
                    current = current.next;
                }
            } else {
                out.writeInt(0);
            }
        } else {
            out.writeInt(0);
        }
    }

    public StreamCharBuffer encodeToBuffer(Encoder encoder) {
        StreamCharBuffer coded = new StreamCharBuffer(Math.min(Math.max(this.totalChunkSize, this.chunkSize) * 12 / 10, this.maxChunkSize));
        coded.setNotifyParentBuffersEnabled(false);
        EncodedAppender codedWriter = coded.writer.getEncodedAppender();
        try {
            this.encodeTo(codedWriter, encoder);
        }
        catch (IOException e) {
            log.error((Object)"IOException in StreamCharBuffer.encodeToBuffer", (Throwable)e);
        }
        return coded;
    }

    public void encodeTo(EncodedAppender appender, Encoder encoder) throws IOException {
        AbstractChunk current = this.firstChunk;
        while (current != null) {
            current.encodeTo(appender, encoder);
            current = current.next;
        }
        this.allocBuffer.encodeTo(appender, encoder);
    }

    public CharSequence encode(Encoder encoder) {
        return this.encodeToBuffer(encoder);
    }

    public Writer getWriterForEncoder() {
        return this.getWriterForEncoder(null);
    }

    public Writer getWriterForEncoder(Encoder encoder) {
        EncodingStateRegistryLookup encodingStateRegistryLookup = EncodingStateRegistryLookupHolder.getEncodingStateRegistryLookup();
        EncodingStateRegistry encodingStateRegistry = encodingStateRegistryLookup != null ? encodingStateRegistryLookup.lookup() : null;
        return this.getWriterForEncoder(encoder, encodingStateRegistry);
    }

    public Writer getWriterForEncoder(Encoder encoder, EncodingStateRegistry encodingStateRegistry) {
        return new EncodedAppenderWriter(this.writer.getEncodedAppender(), encoder, encodingStateRegistry);
    }

    public boolean isNotifyParentBuffersEnabled() {
        return this.notifyParentBuffersEnabled;
    }

    public void setNotifyParentBuffersEnabled(boolean notifyParentBuffersEnabled) {
        this.notifyParentBuffersEnabled = notifyParentBuffersEnabled;
        if (!notifyParentBuffersEnabled && this.parentBuffers != null) {
            this.parentBuffers.clear();
        }
    }

    private static final class SavedEncoder
    implements Encoder {
        private CodecIdentifier codecIdentifier;
        private boolean safe;

        public SavedEncoder(String codecName, boolean safe) {
            this.codecIdentifier = new DefaultCodecIdentifier(codecName);
            this.safe = safe;
        }

        public CodecIdentifier getCodecIdentifier() {
            return this.codecIdentifier;
        }

        public boolean isSafe() {
            return this.safe;
        }

        public Object encode(Object o) {
            throw new UnsupportedOperationException("encode isn't supported for SavedEncoder");
        }

        public void markEncoded(CharSequence string) {
            throw new UnsupportedOperationException("markEncoded isn't supported for SavedEncoder");
        }

        public boolean isApplyToSafelyEncoded() {
            return false;
        }
    }

    static final class MultiOutputWriter
    extends ConnectedWritersWriter {
        final List<ConnectedWriter> connectedWriters;
        final List<Writer> writers;
        Boolean encoderAware;

        public MultiOutputWriter(List<ConnectedWriter> connectedWriters) {
            this.connectedWriters = connectedWriters;
            this.writers = new ArrayList<Writer>(connectedWriters.size());
            for (ConnectedWriter connectedWriter : connectedWriters) {
                this.writers.add(connectedWriter.getWriter());
            }
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public void flush() throws IOException {
            for (ConnectedWriter connectedWriter : this.connectedWriters) {
                connectedWriter.flush();
            }
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            for (Writer writer : this.writers) {
                writer.write(cbuf, off, len);
            }
        }

        @Override
        public Writer append(CharSequence csq, int start, int end) throws IOException {
            for (Writer writer : this.writers) {
                writer.append(csq, start, end);
            }
            return this;
        }

        @Override
        public void write(String str, int off, int len) throws IOException {
            if (this.isEncoderAware()) {
                for (ConnectedWriter connectedWriter : this.connectedWriters) {
                    if (!connectedWriter.isEncoderAware()) {
                        StringCharArrayAccessor.writeStringAsCharArray(connectedWriter.getWriter(), str, off, len);
                        continue;
                    }
                    connectedWriter.getWriter().write(str, off, len);
                }
            } else {
                for (Writer writer : this.writers) {
                    writer.write(str, off, len);
                }
            }
        }

        @Override
        public boolean isEncoderAware() throws IOException {
            if (this.encoderAware == null) {
                this.encoderAware = false;
                for (ConnectedWriter writer : this.connectedWriters) {
                    if (!writer.isEncoderAware()) continue;
                    this.encoderAware = true;
                    break;
                }
            }
            return this.encoderAware;
        }

        @Override
        public void forceFlush() throws IOException {
            for (Writer writer : this.writers) {
                writer.flush();
            }
        }
    }

    static abstract class ConnectedWritersWriter
    extends Writer {
        ConnectedWritersWriter() {
        }

        public abstract boolean isEncoderAware() throws IOException;

        public abstract void forceFlush() throws IOException;
    }

    static final class SingleOutputWriter
    extends ConnectedWritersWriter
    implements GrailsWrappedWriter {
        private final ConnectedWriter connectedWriter;
        private final Writer writer;
        private final boolean encoderAware;

        public SingleOutputWriter(ConnectedWriter connectedWriter) {
            this.connectedWriter = connectedWriter;
            this.writer = connectedWriter.getWriter();
            this.encoderAware = connectedWriter.isEncoderAware();
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public void flush() throws IOException {
            this.connectedWriter.flush();
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            this.writer.write(cbuf, off, len);
        }

        @Override
        public Writer append(CharSequence csq, int start, int end) throws IOException {
            this.writer.append(csq, start, end);
            return this;
        }

        @Override
        public void write(String str, int off, int len) throws IOException {
            if (!this.encoderAware) {
                StringCharArrayAccessor.writeStringAsCharArray(this.writer, str, off, len);
            } else {
                this.writer.write(str, off, len);
            }
        }

        @Override
        public boolean isEncoderAware() throws IOException {
            return this.encoderAware;
        }

        @Override
        public boolean isAllowUnwrappingOut() {
            return true;
        }

        @Override
        public Writer unwrap() {
            return this.writer;
        }

        @Override
        public void markUsed() {
        }

        @Override
        public void forceFlush() throws IOException {
            this.writer.flush();
        }
    }

    static final class ConnectedWriter {
        final Writer writer;
        final boolean autoFlush;
        final boolean encoderAware;

        ConnectedWriter(Writer writer, boolean autoFlush) {
            this.writer = writer;
            this.autoFlush = autoFlush;
            this.encoderAware = writer instanceof EncodedAppenderFactory || writer instanceof EncodedAppenderWriterFactory;
        }

        Writer getWriter() {
            return this.writer;
        }

        public void flush() throws IOException {
            if (this.autoFlush) {
                this.writer.flush();
            }
        }

        public boolean isEncoderAware() {
            return this.encoderAware;
        }
    }

    final class ConnectToWriter {
        final Writer writer;
        final LazyInitializingWriter lazyInitializingWriter;
        final boolean autoFlush;
        Boolean encoderAware;

        ConnectToWriter(Writer writer, boolean autoFlush) {
            this.writer = writer;
            this.lazyInitializingWriter = null;
            this.autoFlush = autoFlush;
        }

        ConnectToWriter(LazyInitializingWriter lazyInitializingWriter, boolean autoFlush) {
            this.lazyInitializingWriter = lazyInitializingWriter;
            this.writer = null;
            this.autoFlush = autoFlush;
        }

        Writer[] getWriters() throws IOException {
            if (this.writer != null) {
                return new Writer[]{this.writer};
            }
            Set<Writer> writerList = this.resolveLazyInitializers(new HashSet<Integer>(), this.lazyInitializingWriter);
            return writerList.toArray(new Writer[writerList.size()]);
        }

        private Set<Writer> resolveLazyInitializers(Set<Integer> resolved, LazyInitializingWriter lazyInitializingWriter) throws IOException {
            Set<Writer> writerList = Collections.emptySet();
            Integer identityHashCode = System.identityHashCode(lazyInitializingWriter);
            if (!resolved.contains(identityHashCode) && lazyInitializingWriter instanceof LazyInitializingMultipleWriter) {
                LazyInitializingWriter[] writers;
                resolved.add(identityHashCode);
                writerList = new LinkedHashSet();
                for (LazyInitializingWriter writer : writers = ((LazyInitializingMultipleWriter)lazyInitializingWriter).initializeMultiple(StreamCharBuffer.this, this.autoFlush)) {
                    writerList.addAll(this.resolveLazyInitializers(resolved, writer));
                }
            } else {
                writerList = Collections.singleton(lazyInitializingWriter.getWriter());
            }
            return writerList;
        }

        public boolean isAutoFlush() {
            return this.autoFlush;
        }
    }

    public static interface LazyInitializingMultipleWriter
    extends LazyInitializingWriter {
        public LazyInitializingWriter[] initializeMultiple(StreamCharBuffer var1, boolean var2) throws IOException;
    }

    public static interface LazyInitializingWriter {
        public Writer getWriter() throws IOException;
    }

    private final class FixedCharArrayEncodedAppender
    extends AbstractEncodedAppender {
        char[] buf;
        int count = 0;
        int currentStart = 0;
        EncodingState currentState;
        MultipartCharBufferChunk chunk;

        public FixedCharArrayEncodedAppender(int fixedSize) {
            this.buf = new char[fixedSize];
            this.chunk = new MultipartCharBufferChunk(this.buf);
        }

        private void checkEncodingChange(EncodingState encodingState) {
            if (!(this.currentState == null || encodingState != null && this.currentState.equals(encodingState))) {
                this.addPart();
            }
            if (this.currentState == null) {
                this.currentState = encodingState;
            }
        }

        public void finish() {
            this.addPart();
        }

        private void addPart() {
            if (this.count - this.currentStart > 0) {
                EncodingStatePart newPart = new EncodingStatePart();
                newPart.encodingState = this.currentState;
                newPart.len = this.count - this.currentStart;
                if (this.chunk.lastPart == null) {
                    this.chunk.firstPart = newPart;
                    this.chunk.lastPart = newPart;
                } else {
                    this.chunk.lastPart.next = newPart;
                    this.chunk.lastPart = newPart;
                }
                this.currentState = null;
                this.currentStart = this.count;
            }
        }

        protected void write(EncodingState encodingState, char[] b, int off, int len) throws IOException {
            this.checkEncodingChange(encodingState);
            StreamCharBuffer.arrayCopy(b, off, this.buf, this.count, len);
            this.count += len;
        }

        protected void write(EncodingState encodingState, String str, int off, int len) throws IOException {
            this.checkEncodingChange(encodingState);
            str.getChars(off, off + len, this.buf, this.count);
            this.count += len;
        }

        protected void appendCharSequence(EncodingState encodingState, CharSequence csq, int start, int end) throws IOException {
            this.checkEncodingChange(encodingState);
            if (csq instanceof String) {
                this.write(encodingState, (String)csq, start, end - start);
            } else if (csq instanceof StringBuffer) {
                ((StringBuffer)csq).getChars(start, end, this.buf, this.count);
                this.count += end - start;
            } else if (csq instanceof StringBuilder) {
                ((StringBuilder)csq).getChars(start, end, this.buf, this.count);
                this.count += end - start;
            } else {
                String str = csq.subSequence(start, end).toString();
                this.write(encodingState, str, 0, str.length());
            }
        }

        public void append(Encoder encoder, char character) throws IOException {
            EncodingStateImpl encodingState = new EncodingStateImpl(encoder != null ? Collections.singleton(encoder) : null);
            this.checkEncodingChange((EncodingState)encodingState);
            this.buf[this.count++] = character;
        }

        public void close() throws IOException {
            this.finish();
        }
    }

    final class AllocatedBufferReader
    extends ChunkReader {
        AllocatedBuffer parent;
        int position;
        int writerUsedCounter;
        boolean removeAfterReading;

        public AllocatedBufferReader(AllocatedBuffer parent, boolean removeAfterReading) {
            this.parent = parent;
            this.position = parent.chunkStart;
            this.writerUsedCounter = StreamCharBuffer.this.hasReaders ? ((StreamCharBuffer)StreamCharBuffer.this).writer.writerUsedCounter : 1;
            this.removeAfterReading = removeAfterReading;
        }

        @Override
        public int getReadLenLimit(int askedAmount) {
            return Math.min(this.parent.used - this.position, askedAmount);
        }

        @Override
        public int read(char[] ch, int off, int len) throws IOException {
            StreamCharBuffer.arrayCopy(this.parent.buffer, this.position, ch, off, len);
            this.position += len;
            if (this.removeAfterReading) {
                this.parent.chunkStart = this.position;
            }
            return len;
        }

        @Override
        public ChunkReader next() {
            return null;
        }

        @Override
        public int getWriterUsedCounter() {
            return this.writerUsedCounter;
        }

        @Override
        public boolean isValid() {
            return StreamCharBuffer.this.allocBuffer == this.parent && (StreamCharBuffer.this.lastChunk == null || ((StreamCharBuffer)StreamCharBuffer.this).lastChunk.writerUsedCounter < this.writerUsedCounter);
        }
    }

    final class StreamCharBufferSubChunkReader
    extends AbstractChunkReader {
        StreamCharBufferSubChunk parent;
        private StreamCharBufferReader reader;

        public StreamCharBufferSubChunkReader(StreamCharBufferSubChunk parent, boolean removeAfterReading) {
            super(parent, removeAfterReading);
            this.parent = parent;
            this.reader = (StreamCharBufferReader)parent.streamCharBuffer.getReader();
        }

        @Override
        public int getReadLenLimit(int askedAmount) {
            return this.reader.getReadLenLimit(askedAmount);
        }

        @Override
        public int read(char[] ch, int off, int len) throws IOException {
            return this.reader.read(ch, off, len);
        }
    }

    final class StreamCharBufferSubChunk
    extends AbstractChunk {
        StreamCharBuffer streamCharBuffer;
        int cachedSize;

        public StreamCharBufferSubChunk(StreamCharBuffer streamCharBuffer2) {
            this.streamCharBuffer = streamCharBuffer2;
            if (StreamCharBuffer.this.totalCharsInDynamicChunks != -1) {
                this.cachedSize = streamCharBuffer2.size();
                StreamCharBuffer.this.totalCharsInDynamicChunks += this.cachedSize;
            } else {
                this.cachedSize = -1;
            }
        }

        @Override
        public void writeTo(Writer target) throws IOException {
            this.streamCharBuffer.writeTo(target);
        }

        @Override
        public ChunkReader getChunkReader(boolean removeAfterReading) {
            return new StreamCharBufferSubChunkReader(this, removeAfterReading);
        }

        @Override
        public int size() {
            if (this.cachedSize == -1) {
                this.cachedSize = this.streamCharBuffer.size();
            }
            return this.cachedSize;
        }

        public boolean hasCachedSize() {
            return this.cachedSize != -1;
        }

        public StreamCharBuffer getSubBuffer() {
            return this.streamCharBuffer;
        }

        public boolean resetSize() {
            if (this.cachedSize != -1) {
                this.cachedSize = -1;
                return true;
            }
            return false;
        }

        @Override
        public void subtractFromTotalCount() {
            if (StreamCharBuffer.this.totalCharsInDynamicChunks != -1) {
                StreamCharBuffer.this.totalCharsInDynamicChunks -= this.size();
            }
            StreamCharBuffer.this.dynamicChunkMap.remove(this.streamCharBuffer.bufferKey);
        }

        @Override
        public void encodeTo(EncodedAppender appender, Encoder encoder) throws IOException {
            appender.append(encoder, (StreamEncodeable)this.getSubBuffer());
        }
    }

    final class StringChunkReader
    extends AbstractChunkReader {
        StringChunk parent;
        int position;

        public StringChunkReader(StringChunk parent, boolean removeAfterReading) {
            super(parent, removeAfterReading);
            this.parent = parent;
            this.position = parent.offset;
        }

        @Override
        public int read(char[] ch, int off, int len) {
            this.parent.str.getChars(this.position, this.position + len, ch, off);
            this.position += len;
            return len;
        }

        @Override
        public int getReadLenLimit(int askedAmount) {
            return Math.min(this.parent.lastposition - this.position, askedAmount);
        }
    }

    class StringChunk
    extends AbstractChunk {
        String str;
        int offset;
        int lastposition;
        int length;

        public StringChunk(String str, int offset, int length) {
            this.str = str;
            this.offset = offset;
            this.length = length;
            this.lastposition = offset + length;
        }

        @Override
        public ChunkReader getChunkReader(boolean removeAfterReading) {
            return new StringChunkReader(this, removeAfterReading);
        }

        @Override
        public void writeTo(Writer target) throws IOException {
            target.write(this.str, this.offset, this.length);
        }

        @Override
        public int size() {
            return this.length;
        }

        public boolean isSingleBuffer() {
            return this.offset == 0 && this.length == this.str.length();
        }

        @Override
        public void encodeTo(EncodedAppender appender, Encoder encoder) throws IOException {
            appender.append(encoder, this.getEncodingState(), (CharSequence)this.str, this.offset, this.length);
        }
    }

    final class CharBufferChunkReader
    extends AbstractChunkReader {
        CharBufferChunk parent;
        int pointer;

        public CharBufferChunkReader(CharBufferChunk parent, boolean removeAfterReading) {
            super(parent, removeAfterReading);
            this.parent = parent;
            this.pointer = parent.offset;
        }

        @Override
        public int read(char[] ch, int off, int len) throws IOException {
            StreamCharBuffer.arrayCopy(this.parent.buffer, this.pointer, ch, off, len);
            this.pointer += len;
            return len;
        }

        @Override
        public int getReadLenLimit(int askedAmount) {
            return Math.min(this.parent.lastposition - this.pointer, askedAmount);
        }
    }

    abstract class AbstractChunkReader
    extends ChunkReader {
        private AbstractChunk parentChunk;
        private boolean removeAfterReading;

        public AbstractChunkReader(AbstractChunk parentChunk, boolean removeAfterReading) {
            this.parentChunk = parentChunk;
            this.removeAfterReading = removeAfterReading;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public ChunkReader next() {
            AbstractChunk nextChunk;
            if (this.removeAfterReading) {
                if (StreamCharBuffer.this.firstChunk == this.parentChunk) {
                    StreamCharBuffer.this.firstChunk = null;
                }
                if (StreamCharBuffer.this.lastChunk == this.parentChunk) {
                    StreamCharBuffer.this.lastChunk = null;
                }
            }
            if ((nextChunk = this.parentChunk.next) != null) {
                if (this.removeAfterReading) {
                    if (StreamCharBuffer.this.firstChunk == null) {
                        StreamCharBuffer.this.firstChunk = nextChunk;
                    }
                    if (StreamCharBuffer.this.lastChunk == null) {
                        StreamCharBuffer.this.lastChunk = nextChunk;
                    }
                    nextChunk.prev = null;
                    nextChunk.subtractFromTotalCount();
                }
                return nextChunk.getChunkReader(this.removeAfterReading);
            }
            return new AllocatedBufferReader(StreamCharBuffer.this.allocBuffer, this.removeAfterReading);
        }

        @Override
        public int getWriterUsedCounter() {
            return this.parentChunk.getWriterUsedCounter();
        }
    }

    static final class EncodingStatePart {
        EncodingStatePart next;
        EncodingState encodingState;
        int len = -1;

        EncodingStatePart() {
        }
    }

    class MultipartCharBufferChunk
    extends CharBufferChunk {
        EncodingStatePart firstPart;
        EncodingStatePart lastPart;

        public MultipartCharBufferChunk(char[] buffer) {
            super(-1, buffer, 0, buffer.length);
            this.firstPart = null;
            this.lastPart = null;
        }

        @Override
        public void encodeTo(EncodedAppender appender, Encoder encoder) throws IOException {
            if (this.firstPart != null) {
                EncodingStatePart current = this.firstPart;
                int offset = 0;
                while (current != null) {
                    appender.append(encoder, current.encodingState, this.buffer, offset, current.len);
                    offset += current.len;
                    current = current.next;
                }
            } else {
                super.encodeTo(appender, encoder);
            }
        }

        public MultipartStringChunk asStringChunk() {
            String str = StringCharArrayAccessor.createString(this.buffer);
            MultipartStringChunk chunk = new MultipartStringChunk(str);
            chunk.firstPart = this.firstPart;
            chunk.lastPart = this.lastPart;
            return chunk;
        }
    }

    class MultipartStringChunk
    extends StringChunk {
        EncodingStatePart firstPart;
        EncodingStatePart lastPart;

        public MultipartStringChunk(String str) {
            super(str, 0, str.length());
            this.firstPart = null;
            this.lastPart = null;
        }

        @Override
        public void encodeTo(EncodedAppender appender, Encoder encoder) throws IOException {
            if (this.firstPart != null) {
                EncodingStatePart current = this.firstPart;
                int offset = 0;
                char[] buf = StringCharArrayAccessor.getValue(this.str);
                while (current != null) {
                    appender.append(encoder, current.encodingState, buf, offset, current.len);
                    offset += current.len;
                    current = current.next;
                }
            } else {
                super.encodeTo(appender, encoder);
            }
        }

        public boolean isSingleEncoding() {
            return this.firstPart == this.lastPart;
        }

        public int partCount() {
            int partCount = 0;
            EncodingStatePart current = this.firstPart;
            while (current != null) {
                ++partCount;
                current = current.next;
            }
            return partCount;
        }

        public void appendEncodingStatePart(EncodingStatePart current) {
            if (this.firstPart == null) {
                this.firstPart = current;
                this.lastPart = current;
            } else {
                this.lastPart.next = current;
                this.lastPart = current;
            }
        }
    }

    class CharBufferChunk
    extends AbstractChunk {
        int allocatedBufferId;
        char[] buffer;
        int offset;
        int lastposition;
        int length;

        public CharBufferChunk(int allocatedBufferId, char[] buffer, int offset, int len) {
            this.allocatedBufferId = allocatedBufferId;
            this.buffer = buffer;
            this.offset = offset;
            this.lastposition = offset + len;
            this.length = len;
        }

        @Override
        public void writeTo(Writer target) throws IOException {
            target.write(this.buffer, this.offset, this.length);
        }

        @Override
        public ChunkReader getChunkReader(boolean removeAfterReading) {
            return new CharBufferChunkReader(this, removeAfterReading);
        }

        @Override
        public int size() {
            return this.length;
        }

        public boolean isSingleBuffer() {
            return this.offset == 0 && this.length == this.buffer.length;
        }

        @Override
        public void encodeTo(EncodedAppender appender, Encoder encoder) throws IOException {
            appender.append(encoder, this.getEncodingState(), this.buffer, this.offset, this.length);
        }
    }

    final class AllocatedBuffer {
        private int id;
        private int size;
        private char[] buffer;
        private int used;
        private int chunkStart;
        private EncodingState encodingState;
        private EncodingState nextEncoders;

        public AllocatedBuffer(int size) {
            this.id = StreamCharBuffer.this.allocatedBufferIdSequence++;
            this.used = 0;
            this.chunkStart = 0;
            this.size = size;
            this.buffer = new char[size];
        }

        public void clear() {
            this.reuseBuffer(null);
        }

        public int charsUsed() {
            return this.used - this.chunkStart;
        }

        public void writeTo(Writer target) throws IOException {
            if (this.used - this.chunkStart > 0) {
                target.write(this.buffer, this.chunkStart, this.used - this.chunkStart);
            }
        }

        public void reuseBuffer(EncodingState encodingState) {
            this.used = 0;
            this.chunkStart = 0;
            this.encodingState = null;
            this.nextEncoders = encodingState;
        }

        public int chunkSize() {
            return this.buffer.length;
        }

        public int spaceLeft(EncodingState encodingState) {
            if (!(this.encodingState == null || encodingState != null && this.encodingState.equals(encodingState) || !this.hasChunk() || StreamCharBuffer.this.isNotConnectedToEncoderAwareWriters())) {
                StreamCharBuffer.this.addChunk(StreamCharBuffer.this.allocBuffer.createChunk());
                this.encodingState = null;
            }
            this.nextEncoders = encodingState;
            return this.size - this.used;
        }

        private final void applyEncoders() throws IOException {
            if (this.encodingState == this.nextEncoders) {
                return;
            }
            if (!(this.encodingState == null || StreamCharBuffer.this.isNotConnectedToEncoderAwareWriters() || this.nextEncoders != null && this.encodingState.equals(this.nextEncoders))) {
                throw new IOException("Illegal operation in AllocatedBuffer");
            }
            this.encodingState = this.nextEncoders;
        }

        public boolean write(char ch) throws IOException {
            if (this.used < this.size) {
                this.applyEncoders();
                this.buffer[this.used++] = ch;
                return true;
            }
            return false;
        }

        public final void write(char[] ch, int off, int len) throws IOException {
            this.applyEncoders();
            StreamCharBuffer.arrayCopy(ch, off, this.buffer, this.used, len);
            this.used += len;
        }

        public final void writeString(String str, int off, int len) throws IOException {
            this.applyEncoders();
            str.getChars(off, off + len, this.buffer, this.used);
            this.used += len;
        }

        public final void writeStringBuilder(StringBuilder stringBuilder, int off, int len) throws IOException {
            this.applyEncoders();
            stringBuilder.getChars(off, off + len, this.buffer, this.used);
            this.used += len;
        }

        public final void writeStringBuffer(StringBuffer stringBuffer, int off, int len) throws IOException {
            this.applyEncoders();
            stringBuffer.getChars(off, off + len, this.buffer, this.used);
            this.used += len;
        }

        public final void writeCharArrayAccessible(CharArrayAccessible charArrayAccessible, int off, int len) throws IOException {
            this.applyEncoders();
            charArrayAccessible.getChars(off, off + len, this.buffer, this.used);
            this.used += len;
        }

        public CharBufferChunk createChunk() {
            CharBufferChunk chunk = new CharBufferChunk(this.id, this.buffer, this.chunkStart, this.used - this.chunkStart);
            chunk.setEncodingState(this.encodingState);
            this.chunkStart = this.used;
            return chunk;
        }

        public boolean hasChunk() {
            return this.used > this.chunkStart;
        }

        public void encodeTo(EncodedAppender appender, Encoder encoder) throws IOException {
            if (this.used - this.chunkStart > 0) {
                appender.append(encoder, this.encodingState, this.buffer, this.chunkStart, this.used - this.chunkStart);
            }
        }

        public EncodingState getEncodingState() {
            return this.encodingState;
        }
    }

    static abstract class ChunkReader {
        ChunkReader() {
        }

        public abstract int read(char[] var1, int var2, int var3) throws IOException;

        public abstract int getReadLenLimit(int var1);

        public abstract ChunkReader next();

        public abstract int getWriterUsedCounter();

        public abstract boolean isValid();
    }

    abstract class AbstractChunk
    implements StreamEncodeable {
        AbstractChunk next;
        AbstractChunk prev;
        int writerUsedCounter;
        EncodingState encodingState;

        public AbstractChunk() {
            this.writerUsedCounter = StreamCharBuffer.this.hasReaders ? ((StreamCharBuffer)StreamCharBuffer.this).writer.writerUsedCounter : 1;
        }

        public abstract void writeTo(Writer var1) throws IOException;

        public abstract ChunkReader getChunkReader(boolean var1);

        public abstract int size();

        public int getWriterUsedCounter() {
            return this.writerUsedCounter;
        }

        public void subtractFromTotalCount() {
            StreamCharBuffer.this.totalCharsInList -= this.size();
        }

        public abstract void encodeTo(EncodedAppender var1, Encoder var2) throws IOException;

        public EncodingState getEncodingState() {
            return this.encodingState;
        }

        public void setEncodingState(EncodingState encodingState) {
            this.encodingState = encodingState;
        }
    }

    public final class StreamCharBufferReader
    extends Reader {
        boolean eofException = false;
        int eofReachedCounter = 0;
        ChunkReader chunkReader;
        ChunkReader lastChunkReader;
        boolean removeAfterReading;

        public StreamCharBufferReader(boolean remove) {
            this.removeAfterReading = remove;
        }

        private int prepareRead(int len) {
            if (StreamCharBuffer.this.hasReaders && this.eofReachedCounter != 0 && this.eofReachedCounter != ((StreamCharBuffer)StreamCharBuffer.this).writer.writerUsedCounter) {
                this.eofReachedCounter = 0;
                this.eofException = false;
                this.repositionChunkReader();
            }
            if (this.chunkReader == null && this.eofReachedCounter == 0) {
                if (StreamCharBuffer.this.firstChunk != null) {
                    this.chunkReader = StreamCharBuffer.this.firstChunk.getChunkReader(this.removeAfterReading);
                    if (this.removeAfterReading) {
                        StreamCharBuffer.this.firstChunk.subtractFromTotalCount();
                    }
                } else {
                    this.chunkReader = new AllocatedBufferReader(StreamCharBuffer.this.allocBuffer, this.removeAfterReading);
                }
            }
            int available = 0;
            if (this.chunkReader != null) {
                available = this.chunkReader.getReadLenLimit(len);
                while (available == 0 && this.chunkReader != null) {
                    this.chunkReader = this.chunkReader.next();
                    if (this.chunkReader != null) {
                        available = this.chunkReader.getReadLenLimit(len);
                        continue;
                    }
                    available = 0;
                }
            }
            if (this.chunkReader == null) {
                this.eofReachedCounter = StreamCharBuffer.this.hasReaders ? ((StreamCharBuffer)StreamCharBuffer.this).writer.writerUsedCounter : 1;
            } else if (StreamCharBuffer.this.hasReaders) {
                this.lastChunkReader = this.chunkReader;
            }
            return available;
        }

        private void repositionChunkReader() {
            if (this.lastChunkReader instanceof AllocatedBufferReader) {
                if (this.lastChunkReader.isValid()) {
                    this.chunkReader = this.lastChunkReader;
                } else {
                    AllocatedBufferReader allocBufferReader = (AllocatedBufferReader)this.lastChunkReader;
                    int currentPosition = allocBufferReader.position;
                    AbstractChunk chunk = StreamCharBuffer.this.lastChunk;
                    while (chunk != null && chunk.writerUsedCounter >= this.lastChunkReader.getWriterUsedCounter()) {
                        if (chunk instanceof CharBufferChunk) {
                            CharBufferChunk charBufChunk = (CharBufferChunk)chunk;
                            if (charBufChunk.allocatedBufferId == allocBufferReader.parent.id && currentPosition >= charBufChunk.offset && currentPosition <= charBufChunk.lastposition) {
                                CharBufferChunkReader charBufChunkReader = (CharBufferChunkReader)charBufChunk.getChunkReader(this.removeAfterReading);
                                int oldpointer = charBufChunkReader.pointer;
                                charBufChunkReader.pointer = currentPosition;
                                if (this.removeAfterReading) {
                                    int diff = charBufChunkReader.pointer - oldpointer;
                                    StreamCharBuffer.this.totalCharsInList -= diff;
                                    charBufChunk.subtractFromTotalCount();
                                }
                                this.chunkReader = charBufChunkReader;
                                break;
                            }
                        }
                        chunk = chunk.prev;
                    }
                }
            }
        }

        @Override
        public boolean ready() throws IOException {
            return true;
        }

        @Override
        public final int read(char[] b, int off, int len) throws IOException {
            return this.readImpl(b, off, len);
        }

        final int readImpl(char[] b, int off, int len) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            int charsLeft = len;
            int currentOffset = off;
            int readChars = this.prepareRead(charsLeft);
            if (this.eofException) {
                throw new EOFException();
            }
            int totalCharsRead = 0;
            while (charsLeft > 0 && readChars > 0) {
                this.chunkReader.read(b, currentOffset, readChars);
                currentOffset += readChars;
                totalCharsRead += readChars;
                if ((charsLeft -= readChars) <= 0) continue;
                readChars = this.prepareRead(charsLeft);
            }
            if (totalCharsRead > 0) {
                return totalCharsRead;
            }
            this.eofException = true;
            return -1;
        }

        @Override
        public void close() throws IOException {
        }

        public final StreamCharBuffer getBuffer() {
            return StreamCharBuffer.this;
        }

        public int getReadLenLimit(int askedAmount) {
            return this.prepareRead(askedAmount);
        }
    }

    private static final class StreamCharBufferEncodedAppender
    extends AbstractEncodedAppender {
        StreamCharBufferWriter writer;

        StreamCharBufferEncodedAppender(StreamCharBufferWriter writer) {
            this.writer = writer;
        }

        public StreamCharBufferWriter getWriter() {
            return this.writer;
        }

        public void flush() throws IOException {
            this.writer.flush();
        }

        protected void write(EncodingState encodingState, char[] b, int off, int len) throws IOException {
            this.writer.write(encodingState, b, off, len);
        }

        protected void write(EncodingState encodingState, String str, int off, int len) throws IOException {
            this.writer.write(encodingState, str, off, len);
        }

        protected void appendCharSequence(EncodingState encodingState, CharSequence str, int start, int end) throws IOException {
            this.writer.appendCharSequence(encodingState, str, start, end);
        }

        public void append(Encoder encoder, char character) throws IOException {
            this.writer.append(encoder, character);
        }

        public void close() throws IOException {
            this.writer.close();
        }
    }

    public final class StreamCharBufferWriter
    extends Writer
    implements EncodedAppenderFactory,
    EncodedAppenderWriterFactory {
        boolean closed = false;
        int writerUsedCounter = 0;
        boolean increaseCounter = true;
        EncodedAppender encodedAppender;

        @Override
        public final void write(char[] b, int off, int len) throws IOException {
            this.write(null, b, off, len);
        }

        private final void write(EncodingState encodingState, char[] b, int off, int len) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return;
            }
            this.markUsed();
            if (this.shouldWriteDirectly(len)) {
                StreamCharBuffer.this.appendCharBufferChunk(encodingState, true, true);
                StreamCharBuffer.this.startUsingConnectedWritersWriter();
                StreamCharBuffer.this.connectedWritersWriter.write(b, off, len);
            } else {
                int charsLeft = len;
                int currentOffset = off;
                while (charsLeft > 0) {
                    int spaceLeft = StreamCharBuffer.this.allocateSpace(encodingState);
                    int writeChars = Math.min(spaceLeft, charsLeft);
                    StreamCharBuffer.this.allocBuffer.write(b, currentOffset, writeChars);
                    charsLeft -= writeChars;
                    currentOffset += writeChars;
                }
            }
        }

        private final boolean shouldWriteDirectly(int len) {
            if (!StreamCharBuffer.this.isConnectedMode()) {
                return false;
            }
            if (StreamCharBuffer.this.writeDirectlyToConnectedMinSize < 0 || len < StreamCharBuffer.this.writeDirectlyToConnectedMinSize) {
                return false;
            }
            return this.isNextChunkBigEnough(len);
        }

        private final boolean isNextChunkBigEnough(int len) {
            return len > this.getNewChunkMinSize();
        }

        private final int getDirectChunkMinSize() {
            if (!StreamCharBuffer.this.isConnectedMode()) {
                return -1;
            }
            if (StreamCharBuffer.this.writeDirectlyToConnectedMinSize >= 0) {
                return StreamCharBuffer.this.writeDirectlyToConnectedMinSize;
            }
            return this.getNewChunkMinSize();
        }

        private final int getNewChunkMinSize() {
            if (StreamCharBuffer.this.chunkMinSize <= 0 || StreamCharBuffer.this.allocBuffer.charsUsed() == 0 || StreamCharBuffer.this.allocBuffer.charsUsed() >= StreamCharBuffer.this.chunkMinSize) {
                return 0;
            }
            return StreamCharBuffer.this.allocBuffer.spaceLeft(null);
        }

        @Override
        public final void write(String str) throws IOException {
            this.write(null, str, 0, str.length());
        }

        @Override
        public final void write(String str, int off, int len) throws IOException {
            this.write(null, str, off, len);
        }

        private final void write(EncodingState encodingState, String str, int off, int len) throws IOException {
            if (len == 0) {
                return;
            }
            this.markUsed();
            if (this.shouldWriteDirectly(len)) {
                StreamCharBuffer.this.appendCharBufferChunk(encodingState, true, false);
                StreamCharBuffer.this.startUsingConnectedWritersWriter();
                StreamCharBuffer.this.connectedWritersWriter.write(str, off, len);
            } else if (len >= StreamCharBuffer.this.subStringChunkMinSize && this.isNextChunkBigEnough(len)) {
                StreamCharBuffer.this.appendStringChunk(encodingState, str, off, len);
            } else {
                int charsLeft = len;
                int currentOffset = off;
                while (charsLeft > 0) {
                    int spaceLeft = StreamCharBuffer.this.allocateSpace(encodingState);
                    int writeChars = Math.min(spaceLeft, charsLeft);
                    StreamCharBuffer.this.allocBuffer.writeString(str, currentOffset, writeChars);
                    charsLeft -= writeChars;
                    currentOffset += writeChars;
                }
            }
        }

        public final void write(StreamCharBuffer subBuffer) throws IOException {
            this.markUsed();
            int directChunkMinSize = this.getDirectChunkMinSize();
            if (directChunkMinSize == 0 || directChunkMinSize != -1 && subBuffer.isSizeLarger(directChunkMinSize)) {
                StreamCharBuffer.this.appendCharBufferChunk(null, true, false);
                StreamCharBuffer.this.startUsingConnectedWritersWriter();
                subBuffer.writeToImpl(StreamCharBuffer.this.connectedWritersWriter, false, false);
            } else if (subBuffer.preferSubChunkWhenWritingToOtherBuffer || subBuffer.isSizeLarger(Math.max(StreamCharBuffer.this.subBufferChunkMinSize, this.getNewChunkMinSize()))) {
                if (subBuffer.preferSubChunkWhenWritingToOtherBuffer) {
                    StreamCharBuffer.this.preferSubChunkWhenWritingToOtherBuffer = true;
                }
                StreamCharBuffer.this.appendStreamCharBufferChunk(subBuffer);
                subBuffer.addParentBuffer(StreamCharBuffer.this);
            } else {
                subBuffer.encodeTo(this.getEncodedAppender(), null);
            }
        }

        @Override
        public final Writer append(CharSequence csq, int start, int end) throws IOException {
            this.markUsed();
            if (csq == null) {
                this.write("null");
            } else {
                this.appendCharSequence(null, csq, start, end);
            }
            return this;
        }

        protected void appendCharSequence(EncodingState encodingState, CharSequence csq, int start, int end) throws IOException {
            if (csq instanceof String || csq instanceof StringBuffer || csq instanceof StringBuilder || csq instanceof CharArrayAccessible) {
                int len;
                int charsLeft = len = end - start;
                int currentOffset = start;
                while (charsLeft > 0) {
                    int spaceLeft = StreamCharBuffer.this.allocateSpace(encodingState);
                    int writeChars = Math.min(spaceLeft, charsLeft);
                    if (csq instanceof String) {
                        StreamCharBuffer.this.allocBuffer.writeString((String)csq, currentOffset, writeChars);
                    } else if (csq instanceof StringBuffer) {
                        StreamCharBuffer.this.allocBuffer.writeStringBuffer((StringBuffer)csq, currentOffset, writeChars);
                    } else if (csq instanceof StringBuilder) {
                        StreamCharBuffer.this.allocBuffer.writeStringBuilder((StringBuilder)csq, currentOffset, writeChars);
                    } else if (csq instanceof CharArrayAccessible) {
                        StreamCharBuffer.this.allocBuffer.writeCharArrayAccessible((CharArrayAccessible)csq, currentOffset, writeChars);
                    }
                    charsLeft -= writeChars;
                    currentOffset += writeChars;
                }
            } else {
                String str = csq.subSequence(start, end).toString();
                this.write(encodingState, str, 0, str.length());
            }
        }

        @Override
        public final Writer append(CharSequence csq) throws IOException {
            this.markUsed();
            if (csq == null) {
                this.write("null");
            } else {
                this.append(csq, 0, csq.length());
            }
            return this;
        }

        @Override
        public void close() throws IOException {
            this.closed = true;
            this.flushWriter(true);
        }

        public boolean isClosed() {
            return this.closed;
        }

        public boolean isUsed() {
            return this.writerUsedCounter > 0;
        }

        public final void markUsed() {
            if (this.increaseCounter) {
                ++this.writerUsedCounter;
                if (!StreamCharBuffer.this.hasReaders) {
                    this.increaseCounter = false;
                }
            }
        }

        public int resetUsed() {
            int prevUsed = this.writerUsedCounter;
            this.writerUsedCounter = 0;
            this.increaseCounter = true;
            return prevUsed;
        }

        @Override
        public void write(int b) throws IOException {
            this.markUsed();
            StreamCharBuffer.this.allocateSpace(null);
            StreamCharBuffer.this.allocBuffer.write((char)b);
        }

        void flushWriter(boolean forceFlush) throws IOException {
            if (StreamCharBuffer.this.isConnectedMode()) {
                StreamCharBuffer.this.flushToConnected(forceFlush);
            }
            StreamCharBuffer.this.notifyBufferChange();
        }

        public final StreamCharBuffer getBuffer() {
            return StreamCharBuffer.this;
        }

        public void append(Encoder encoder, char character) throws IOException {
            this.markUsed();
            StreamCharBuffer.this.allocateSpace((EncodingState)(StreamCharBuffer.this.isNotConnectedToEncoderAwareWriters() ? EncodingStateImpl.UNDEFINED_ENCODING_STATE : new EncodingStateImpl(Collections.singleton(encoder))));
            StreamCharBuffer.this.allocBuffer.write(character);
        }

        public Writer getWriterForEncoder(Encoder encoder, EncodingStateRegistry encodingStateRegistry) {
            return StreamCharBuffer.this.getWriterForEncoder(encoder, encodingStateRegistry);
        }

        public EncodedAppender getEncodedAppender() {
            if (this.encodedAppender == null) {
                this.encodedAppender = new StreamCharBufferEncodedAppender(this);
            }
            return this.encodedAppender;
        }

        @Override
        public void flush() throws IOException {
            this.flushWriter(false);
        }
    }

    public static final class EncodedPart {
        private final EncodingState encodingState;
        private final String part;

        public EncodedPart(EncodingState encodingState, String part) {
            this.encodingState = encodingState;
            this.part = part;
        }

        public EncodingState getEncodingState() {
            return this.encodingState;
        }

        public String getPart() {
            return this.part;
        }

        public String toString() {
            return "EncodedPart [encodingState='" + this.encodingState + "', part='" + this.part + "']";
        }
    }

    private class StreamCharBufferKey {
        private StreamCharBufferKey() {
        }

        StreamCharBuffer getBuffer() {
            return StreamCharBuffer.this;
        }
    }
}

