/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.pages;

import java.io.Reader;
import org.codehaus.groovy.grails.web.util.GrailsPrintWriterAdapter;
import org.codehaus.groovy.grails.web.util.StreamCharBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.objenesis.ObjenesisStd;
import org.springframework.objenesis.instantiator.ObjectInstantiator;

public class FastStringPrintWriter
extends GrailsPrintWriterAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(FastStringPrintWriter.class);
    private static ObjectInstantiator instantiator;
    private StreamCharBuffer streamBuffer = ((StreamCharBuffer.StreamCharBufferWriter)this.getOut()).getBuffer();

    public FastStringPrintWriter() {
        super(new StreamCharBuffer().getWriter());
    }

    public FastStringPrintWriter(int initialChunkSize) {
        super(new StreamCharBuffer(initialChunkSize).getWriter());
    }

    public static FastStringPrintWriter newInstance() {
        return FastStringPrintWriter.newInstance(0);
    }

    public static FastStringPrintWriter newInstance(int initialChunkSize) {
        if (instantiator == null) {
            if (initialChunkSize > 0) {
                return new FastStringPrintWriter(initialChunkSize);
            }
            return new FastStringPrintWriter();
        }
        FastStringPrintWriter instance = (FastStringPrintWriter)instantiator.newInstance();
        instance.streamBuffer = initialChunkSize > 0 ? new StreamCharBuffer(initialChunkSize) : new StreamCharBuffer();
        instance.setTarget(instance.streamBuffer.getWriter());
        return instance;
    }

    protected FastStringPrintWriter(Object o) {
        this();
        this.print(o);
    }

    public StreamCharBuffer getBuffer() {
        return this.streamBuffer;
    }

    public String toString() {
        return this.getValue();
    }

    public String getValue() {
        return this.streamBuffer.toString();
    }

    public Reader getReader() {
        return this.streamBuffer.getReader();
    }

    static {
        try {
            instantiator = new ObjenesisStd(false).getInstantiatorOf(FastStringPrintWriter.class);
        }
        catch (Exception e) {
            LOG.debug("Couldn't get direct performance optimized instantiator for FastStringPrintWriter. Using default instantiation.", (Throwable)e);
        }
    }
}

