/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.mapping;

import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyObject;
import groovy.lang.GroovyObjectSupport;
import groovy.lang.MetaClass;
import groovy.lang.Script;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsMetaClassUtils;
import org.codehaus.groovy.grails.plugins.GrailsPluginManager;
import org.codehaus.groovy.grails.plugins.PluginManagerAware;
import org.codehaus.groovy.grails.plugins.support.aware.ClassLoaderAware;
import org.codehaus.groovy.grails.validation.ConstrainedProperty;
import org.codehaus.groovy.grails.validation.ConstrainedPropertyBuilder;
import org.codehaus.groovy.grails.web.mapping.DefaultUrlMappingParser;
import org.codehaus.groovy.grails.web.mapping.RegexUrlMapping;
import org.codehaus.groovy.grails.web.mapping.ResponseCodeMappingData;
import org.codehaus.groovy.grails.web.mapping.ResponseCodeUrlMapping;
import org.codehaus.groovy.grails.web.mapping.UrlMapping;
import org.codehaus.groovy.grails.web.mapping.UrlMappingData;
import org.codehaus.groovy.grails.web.mapping.UrlMappingEvaluator;
import org.codehaus.groovy.grails.web.mapping.UrlMappingParser;
import org.codehaus.groovy.grails.web.mapping.exceptions.UrlMappingException;
import org.codehaus.groovy.grails.web.plugins.support.WebMetaUtils;
import org.codehaus.groovy.runtime.IOGroovyMethods;
import org.springframework.beans.BeanUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpMethod;
import org.springframework.util.Assert;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class DefaultUrlMappingEvaluator
implements UrlMappingEvaluator,
ClassLoaderAware,
PluginManagerAware {
    public static final String ACTION_CREATE = "create";
    public static final String ACTION_INDEX = "index";
    public static final String ACTION_SHOW = "show";
    public static final String ACTION_EDIT = "edit";
    public static final String ACTION_UPDATE = "update";
    public static final String ACTION_DELETE = "delete";
    public static final String ACTION_SAVE = "save";
    public static final List<String> DEFAULT_RESOURCES_INCLUDES = Arrays.asList("index", "create", "save", "show", "edit", "update", "delete");
    public static final List<String> DEFAULT_RESOURCE_INCLUDES = Arrays.asList("create", "save", "show", "edit", "update", "delete");
    private static final Log LOG = LogFactory.getLog(UrlMappingBuilder.class);
    private GroovyClassLoader classLoader = new GroovyClassLoader();
    private UrlMappingParser urlParser = new DefaultUrlMappingParser();
    private ServletContext servletContext;
    private static final String EXCEPTION = "exception";
    private static final String PARSE_REQUEST = "parseRequest";
    private static final String RESOURCE = "resource";
    private static final String RESOURCES = "resources";
    private GrailsPluginManager pluginManager;
    private WebApplicationContext applicationContext;

    @Deprecated
    public DefaultUrlMappingEvaluator(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public DefaultUrlMappingEvaluator(WebApplicationContext applicationContext) {
        if (applicationContext != null) {
            this.servletContext = applicationContext.getServletContext();
        }
        this.applicationContext = applicationContext;
    }

    public List evaluateMappings(Resource resource) {
        InputStream inputStream = null;
        try {
            inputStream = resource.getInputStream();
            List<UrlMapping> list = this.evaluateMappings(this.classLoader.parseClass(IOGroovyMethods.getText((InputStream)inputStream)));
            return list;
        }
        catch (IOException e) {
            throw new UrlMappingException("Unable to read mapping file [" + resource.getFilename() + "]: " + e.getMessage(), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    public List<UrlMapping> evaluateMappings(Class theClass) {
        GroovyObject obj = (GroovyObject)BeanUtils.instantiateClass((Class)theClass);
        if (obj instanceof Script) {
            Script script = (Script)obj;
            Binding b = new Binding();
            MappingCapturingClosure closure = new MappingCapturingClosure(script);
            b.setVariable("mappings", (Object)closure);
            script.setBinding(b);
            script.run();
            Closure<?> mappings = closure.getMappings();
            Binding binding = script.getBinding();
            return this.evaluateMappings((GroovyObject)script, mappings, binding);
        }
        throw new UrlMappingException("Unable to configure URL mappings for class [" + theClass + "]. A URL mapping must be an instance of groovy.lang.Script.");
    }

    private List<UrlMapping> evaluateMappings(GroovyObject go, Closure<?> mappings, Binding binding) {
        UrlMappingBuilder builder = new UrlMappingBuilder(binding, this.servletContext);
        mappings.setDelegate((Object)builder);
        mappings.call();
        builder.urlDefiningMode = false;
        this.configureUrlMappingDynamicObjects(go);
        return builder.getUrlMappings();
    }

    public List<UrlMapping> evaluateMappings(Closure closure) {
        UrlMappingBuilder builder = new UrlMappingBuilder(null, this.servletContext);
        closure.setDelegate((Object)builder);
        closure.setResolveStrategy(1);
        if (closure.getParameterTypes().length == 0) {
            closure.call();
        } else {
            closure.call((Object)this.applicationContext);
        }
        builder.urlDefiningMode = false;
        this.configureUrlMappingDynamicObjects(closure);
        return builder.getUrlMappings();
    }

    private void configureUrlMappingDynamicObjects(Object object) {
        if (this.pluginManager != null) {
            WebMetaUtils.registerCommonWebProperties((MetaClass)GrailsMetaClassUtils.getExpandoMetaClass(object.getClass()), null);
        }
    }

    public void setClassLoader(ClassLoader classLoader) {
        Assert.isInstanceOf(GroovyClassLoader.class, (Object)classLoader, (String)"Property [classLoader] must be an instance of GroovyClassLoader");
        this.classLoader = (GroovyClassLoader)classLoader;
    }

    public void setPluginManager(GrailsPluginManager pluginManager) {
        this.pluginManager = pluginManager;
    }

    class UrlMappingBuilder
    extends GroovyObjectSupport {
        private static final String CAPTURING_WILD_CARD = "(*)";
        private static final String SLASH = "/";
        private static final String CONSTRAINTS = "constraints";
        private boolean urlDefiningMode = true;
        private List<ConstrainedProperty> previousConstraints = new ArrayList<ConstrainedProperty>();
        private List<UrlMapping> urlMappings = new ArrayList<UrlMapping>();
        private Map<String, Object> parameterValues = new HashMap<String, Object>();
        private Binding binding;
        private Object actionName = null;
        private Object pluginName = null;
        private Object namespace = null;
        private Object controllerName = null;
        private Object viewName = null;
        private String httpMethod;
        private ServletContext sc;
        private Object exception;
        private Object parseRequest;
        private Object uri;
        private Object redirectInfo;
        private Deque<ParentResource> parentResources = new ArrayDeque<ParentResource>();

        public UrlMappingBuilder(Binding binding, ServletContext servletContext) {
            this.binding = binding;
            this.sc = servletContext;
        }

        public List<UrlMapping> getUrlMappings() {
            return this.urlMappings;
        }

        public ServletContext getServletContext() {
            return this.sc;
        }

        public ApplicationContext getApplicationContext() {
            return WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.sc);
        }

        public GrailsApplication getGrailsApplication() {
            return (GrailsApplication)this.getApplicationContext().getBean("grailsApplication", GrailsApplication.class);
        }

        public Object getProperty(String name) {
            if (this.urlDefiningMode) {
                this.getCurrentConstraints().add(new ConstrainedProperty(UrlMapping.class, name, String.class));
                return CAPTURING_WILD_CARD;
            }
            return super.getProperty(name);
        }

        public Object getException() {
            return this.exception;
        }

        public void setException(Object exception) {
            this.exception = exception;
        }

        public Object getUri() {
            return this.uri;
        }

        public void setUri(Object uri) {
            this.uri = uri;
        }

        public void setAction(Object action) {
            this.actionName = action;
        }

        public Object getAction() {
            return this.actionName;
        }

        public void setController(Object controller) {
            this.controllerName = controller;
        }

        public Object getController() {
            return this.controllerName;
        }

        public void setRedirectInfo(Object redirectInfo) {
            this.redirectInfo = redirectInfo;
        }

        public Object getRedirectInfo() {
            return this.redirectInfo;
        }

        public void setPlugin(Object plugin) {
            this.pluginName = plugin;
        }

        public Object getPlugin() {
            return this.pluginName;
        }

        public void setNamespace(Object namespace) {
            this.namespace = namespace;
        }

        public Object getNamespace() {
            return this.namespace;
        }

        public Object getView() {
            return this.viewName;
        }

        public void setView(String viewName) {
            this.viewName = viewName;
        }

        public void name(Map<String, UrlMapping> m) {
            for (Map.Entry<String, UrlMapping> entry : m.entrySet()) {
                entry.getValue().setMappingName(entry.getKey());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void group(String uri, Closure mappings) {
            try {
                this.parentResources.push(new ParentResource(null, uri, this.previousConstraints, true));
                mappings.call();
            }
            finally {
                this.parentResources.pop();
            }
        }

        public Object invokeMethod(String methodName, Object arg) {
            if (this.binding == null) {
                return this.invokeMethodClosure(methodName, arg);
            }
            return this.invokeMethodScript(methodName, arg);
        }

        private Object invokeMethodScript(String methodName, Object arg) {
            return this._invoke(methodName, arg, null);
        }

        private Object invokeMethodClosure(String methodName, Object arg) {
            return this._invoke(methodName, arg, (Object)this);
        }

        void propertyMissing(String name, Object value) {
            this.parameterValues.put(name, value);
        }

        Object propertyMissing(String name) {
            return this.parameterValues.get(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object _invoke(String methodName, Object arg, Object delegate) {
            Object[] args = (Object[])arg;
            String mappedURI = this.establishFullURI(methodName);
            boolean isResponseCode = this.isResponseCode(mappedURI);
            if (mappedURI.startsWith(SLASH) || isResponseCode) {
                this.parameterValues = new HashMap<String, Object>();
                Map variables = this.binding != null ? this.binding.getVariables() : null;
                try {
                    Map namedArguments;
                    Object[] objectArray;
                    this.urlDefiningMode = false;
                    if (args != null && args.length > 0) {
                        objectArray = args;
                    } else {
                        Object[] objectArray2 = new Object[1];
                        objectArray = objectArray2;
                        objectArray2[0] = Collections.EMPTY_MAP;
                    }
                    args = objectArray;
                    if (args[0] instanceof Closure) {
                        Map bindingVariables;
                        Object parse;
                        RegexUrlMapping urlMapping;
                        Object namespace;
                        Object pluginName;
                        Object uri;
                        Object viewName;
                        Object actionName;
                        Object controllerName;
                        UrlMappingData urlData = this.createUrlMappingData(mappedURI, isResponseCode);
                        Closure callable = (Closure)args[0];
                        if (delegate != null) {
                            callable.setDelegate(delegate);
                        }
                        callable.call();
                        String httpMethod = null;
                        String version = null;
                        Object redirectInfo = null;
                        if (this.binding != null) {
                            controllerName = variables.get("controller");
                            actionName = variables.get("action");
                            viewName = variables.get("view");
                            uri = variables.get("uri");
                            pluginName = variables.get("plugin");
                            namespace = variables.get("namespace");
                            if (variables.containsKey("method")) {
                                httpMethod = variables.get("method").toString();
                            }
                        } else {
                            controllerName = this.controllerName;
                            redirectInfo = this.redirectInfo;
                            actionName = this.actionName;
                            pluginName = this.pluginName;
                            namespace = this.namespace;
                            viewName = this.viewName;
                            uri = this.uri;
                            httpMethod = this.httpMethod;
                        }
                        ConstrainedProperty[] constraints = this.getCurrentConstraints().toArray(new ConstrainedProperty[this.getCurrentConstraints().size()]);
                        if (uri != null) {
                            try {
                                urlMapping = new RegexUrlMapping(urlData, new URI(uri.toString()), constraints, this.sc);
                            }
                            catch (URISyntaxException e) {
                                throw new UrlMappingException("Cannot map to invalid URI: " + e.getMessage(), (Throwable)e);
                            }
                        } else {
                            urlMapping = this.createURLMapping(urlData, isResponseCode, redirectInfo, controllerName, actionName, namespace, pluginName, viewName, httpMethod, version, constraints);
                        }
                        if (this.binding != null && (parse = this.getParseRequest(Collections.EMPTY_MAP, bindingVariables = variables)) instanceof Boolean) {
                            urlMapping.setParseRequest((Boolean)parse);
                        }
                        this.configureUrlMapping((UrlMapping)urlMapping);
                        RegexUrlMapping regexUrlMapping = urlMapping;
                        return regexUrlMapping;
                    }
                    if (args[0] instanceof Map) {
                        namedArguments = (Map)args[0];
                        String uri = mappedURI;
                        String version = null;
                        if (namedArguments.containsKey("version")) {
                            version = namedArguments.get("version").toString();
                        }
                        if (namedArguments.containsKey("namespace")) {
                            this.namespace = namedArguments.get("namespace").toString();
                        }
                        UrlMappingData urlData = this.createUrlMappingData(uri, isResponseCode);
                        if (namedArguments.containsKey(DefaultUrlMappingEvaluator.RESOURCE)) {
                            Object controller = namedArguments.get(DefaultUrlMappingEvaluator.RESOURCE);
                            String controllerName = controller.toString();
                            this.parentResources.push(new ParentResource(controllerName, uri, this.getCurrentConstraints(), true));
                            try {
                                this.invokeLastArgumentIfClosure(args);
                            }
                            finally {
                                this.parentResources.pop();
                            }
                            if (controller != null) {
                                this.createSingleResourceRestfulMappings(controllerName, this.pluginName, this.namespace, version, urlData, this.getCurrentConstraints(), this.calculateIncludes(namedArguments, DEFAULT_RESOURCE_INCLUDES));
                            }
                        } else if (namedArguments.containsKey(DefaultUrlMappingEvaluator.RESOURCES)) {
                            Object controller = namedArguments.get(DefaultUrlMappingEvaluator.RESOURCES);
                            String controllerName = controller.toString();
                            this.parentResources.push(new ParentResource(controllerName, uri, this.getCurrentConstraints(), false));
                            try {
                                this.invokeLastArgumentIfClosure(args);
                            }
                            finally {
                                this.parentResources.pop();
                            }
                            if (controller != null) {
                                this.createResourceRestfulMappings(controllerName, this.pluginName, this.namespace, version, urlData, this.getCurrentConstraints(), this.calculateIncludes(namedArguments, DEFAULT_RESOURCES_INCLUDES));
                            }
                        } else {
                            this.invokeLastArgumentIfClosure(args);
                            UrlMapping urlMapping = this.getURLMappingForNamedArgs(namedArguments, urlData, mappedURI, isResponseCode);
                            this.configureUrlMapping(urlMapping);
                            UrlMapping urlMapping2 = urlMapping;
                            return urlMapping2;
                        }
                    }
                    namedArguments = null;
                    return namedArguments;
                }
                finally {
                    if (this.binding != null) {
                        variables.clear();
                    } else {
                        this.controllerName = null;
                        this.redirectInfo = null;
                        this.actionName = null;
                        this.viewName = null;
                        this.pluginName = null;
                        this.namespace = null;
                    }
                    if (this.parentResources.isEmpty()) {
                        this.previousConstraints.clear();
                        this.urlDefiningMode = true;
                    }
                }
            }
            if (!this.urlDefiningMode && CONSTRAINTS.equals(mappedURI)) {
                ConstrainedPropertyBuilder builder = new ConstrainedPropertyBuilder((Object)this);
                if (args.length > 0 && args[0] instanceof Closure) {
                    Closure callable = (Closure)args[0];
                    callable.setDelegate((Object)builder);
                    for (ConstrainedProperty constrainedProperty : this.getCurrentConstraints()) {
                        builder.getConstrainedProperties().put(constrainedProperty.getPropertyName(), constrainedProperty);
                    }
                    callable.call();
                }
                return builder.getConstrainedProperties();
            }
            return super.invokeMethod(mappedURI, arg);
        }

        private List<String> calculateIncludes(Map namedArguments, List<String> defaultResourcesIncludes) {
            Object includesObject;
            ArrayList<String> includes = new ArrayList<String>(defaultResourcesIncludes);
            Object excludesObject = namedArguments.get("excludes");
            if (excludesObject != null) {
                if (excludesObject instanceof List) {
                    List excludeList = (List)excludesObject;
                    for (Object exc : excludeList) {
                        if (exc == null) continue;
                        String excStr = exc.toString().toLowerCase();
                        includes.remove(excStr);
                    }
                } else {
                    includes.remove(excludesObject.toString());
                }
            }
            if ((includesObject = namedArguments.get("includes")) != null) {
                if (includesObject instanceof List) {
                    List includeList = (List)includesObject;
                    includes.clear();
                    for (Object inc : includeList) {
                        if (inc == null) continue;
                        String incStr = inc.toString().toLowerCase();
                        includes.add(incStr);
                    }
                } else {
                    includes.clear();
                    includes.add(includesObject.toString());
                }
            }
            return includes;
        }

        private String establishFullURI(String uri) {
            if (this.parentResources.isEmpty()) {
                return uri;
            }
            StringBuilder uriBuilder = new StringBuilder();
            ParentResource parentResource = this.parentResources.peek();
            if (parentResource.isSingle) {
                uriBuilder.append(parentResource.uri);
            } else if (parentResource.controllerName != null) {
                uriBuilder.append(parentResource.uri).append(SLASH).append(CAPTURING_WILD_CARD);
                this.getCurrentConstraints().add(new ConstrainedProperty(UrlMapping.class, parentResource.controllerName + "Id", String.class));
            }
            uriBuilder.append(uri);
            return uriBuilder.toString();
        }

        private void invokeLastArgumentIfClosure(Object[] args) {
            if (args.length > 1 && args[1] instanceof Closure) {
                ((Closure)args[1]).call();
            }
        }

        protected void createResourceRestfulMappings(String controllerName, Object pluginName, Object namespace, String version, UrlMappingData urlData, List<ConstrainedProperty> previousConstraints, List<String> includes) {
            ConstrainedProperty[] constraintArray = previousConstraints.toArray(new ConstrainedProperty[previousConstraints.size()]);
            if (includes.contains(DefaultUrlMappingEvaluator.ACTION_INDEX)) {
                UrlMapping listUrlMapping = this.createIndexActionResourcesRestfulMapping(controllerName, pluginName, namespace, version, urlData, previousConstraints);
                this.configureUrlMapping(listUrlMapping);
            }
            if (includes.contains(DefaultUrlMappingEvaluator.ACTION_CREATE)) {
                UrlMapping createUrlMapping = this.createCreateActionResourcesRestfulMapping(controllerName, pluginName, namespace, version, urlData, constraintArray);
                this.configureUrlMapping(createUrlMapping);
            }
            if (includes.contains(DefaultUrlMappingEvaluator.ACTION_SAVE)) {
                UrlMapping saveUrlMapping = this.createSaveActionResourcesRestfulMapping(controllerName, pluginName, namespace, version, urlData, previousConstraints);
                this.configureUrlMapping(saveUrlMapping);
            }
            if (includes.contains(DefaultUrlMappingEvaluator.ACTION_SHOW)) {
                UrlMapping showUrlMapping = this.createShowActionResourcesRestfulMapping(controllerName, pluginName, namespace, version, urlData, previousConstraints);
                this.configureUrlMapping(showUrlMapping);
            }
            if (includes.contains(DefaultUrlMappingEvaluator.ACTION_EDIT)) {
                UrlMapping editUrlMapping = this.createEditActionResourcesRestfulMapping(controllerName, pluginName, namespace, version, urlData, previousConstraints);
                this.configureUrlMapping(editUrlMapping);
            }
            if (includes.contains(DefaultUrlMappingEvaluator.ACTION_UPDATE)) {
                UrlMapping updateUrlMapping = this.createUpdateActionResourcesRestfulMapping(controllerName, pluginName, namespace, version, urlData, previousConstraints);
                this.configureUrlMapping(updateUrlMapping);
            }
            if (includes.contains(DefaultUrlMappingEvaluator.ACTION_DELETE)) {
                UrlMapping deleteUrlMapping = this.createDeleteActionResourcesRestfulMapping(controllerName, pluginName, namespace, version, urlData, previousConstraints);
                this.configureUrlMapping(deleteUrlMapping);
            }
        }

        protected UrlMapping createDeleteActionResourcesRestfulMapping(String controllerName, Object pluginName, Object namespace, String version, UrlMappingData urlData, List<ConstrainedProperty> previousConstraints) {
            UrlMappingData deleteUrlMappingData = this.createRelativeUrlDataWithIdAndFormat(urlData);
            List<ConstrainedProperty> deleteUrlMappingConstraints = this.createConstraintsWithIdAndFormat(previousConstraints);
            return new RegexUrlMapping(deleteUrlMappingData, controllerName, DefaultUrlMappingEvaluator.ACTION_DELETE, namespace, pluginName, null, HttpMethod.DELETE.toString(), version, deleteUrlMappingConstraints.toArray(new ConstrainedProperty[deleteUrlMappingConstraints.size()]), DefaultUrlMappingEvaluator.this.servletContext);
        }

        protected UrlMapping createUpdateActionResourcesRestfulMapping(String controllerName, Object pluginName, Object namespace, String version, UrlMappingData urlData, List<ConstrainedProperty> previousConstraints) {
            UrlMappingData updateUrlMappingData = this.createRelativeUrlDataWithIdAndFormat(urlData);
            List<ConstrainedProperty> updateUrlMappingConstraints = this.createConstraintsWithIdAndFormat(previousConstraints);
            return new RegexUrlMapping(updateUrlMappingData, controllerName, DefaultUrlMappingEvaluator.ACTION_UPDATE, namespace, pluginName, null, HttpMethod.PUT.toString(), version, updateUrlMappingConstraints.toArray(new ConstrainedProperty[updateUrlMappingConstraints.size()]), DefaultUrlMappingEvaluator.this.servletContext);
        }

        protected UrlMapping createEditActionResourcesRestfulMapping(String controllerName, Object pluginName, Object namespace, String version, UrlMappingData urlData, List<ConstrainedProperty> previousConstraints) {
            UrlMappingData editUrlMappingData = urlData.createRelative("/(*)/edit");
            ArrayList<ConstrainedProperty> editUrlMappingConstraints = new ArrayList<ConstrainedProperty>(previousConstraints);
            editUrlMappingConstraints.add(new ConstrainedProperty(UrlMapping.class, "id", String.class));
            return new RegexUrlMapping(editUrlMappingData, controllerName, DefaultUrlMappingEvaluator.ACTION_EDIT, namespace, pluginName, null, HttpMethod.GET.toString(), version, editUrlMappingConstraints.toArray(new ConstrainedProperty[editUrlMappingConstraints.size()]), DefaultUrlMappingEvaluator.this.servletContext);
        }

        protected UrlMapping createShowActionResourcesRestfulMapping(String controllerName, Object pluginName, Object namespace, String version, UrlMappingData urlData, List<ConstrainedProperty> previousConstraints) {
            UrlMappingData showUrlMappingData = this.createRelativeUrlDataWithIdAndFormat(urlData);
            List<ConstrainedProperty> showUrlMappingConstraints = this.createConstraintsWithIdAndFormat(previousConstraints);
            return new RegexUrlMapping(showUrlMappingData, controllerName, DefaultUrlMappingEvaluator.ACTION_SHOW, namespace, pluginName, null, HttpMethod.GET.toString(), version, showUrlMappingConstraints.toArray(new ConstrainedProperty[showUrlMappingConstraints.size()]), DefaultUrlMappingEvaluator.this.servletContext);
        }

        private List<ConstrainedProperty> createConstraintsWithIdAndFormat(List<ConstrainedProperty> previousConstraints) {
            ArrayList<ConstrainedProperty> showUrlMappingConstraints = new ArrayList<ConstrainedProperty>(previousConstraints);
            showUrlMappingConstraints.add(new ConstrainedProperty(UrlMapping.class, "id", String.class));
            ConstrainedProperty cp = new ConstrainedProperty(UrlMapping.class, "format", String.class);
            cp.setNullable(true);
            showUrlMappingConstraints.add(cp);
            return showUrlMappingConstraints;
        }

        private UrlMappingData createRelativeUrlDataWithIdAndFormat(UrlMappingData urlData) {
            return urlData.createRelative("/(*)(.(*))?");
        }

        private UrlMappingData createFormatOnlyUrlMappingData(UrlMappingData urlData) {
            return urlData.createRelative("(.(*))?");
        }

        protected UrlMapping createSaveActionResourcesRestfulMapping(String controllerName, Object pluginName, Object namespace, String version, UrlMappingData urlData, List<ConstrainedProperty> constraints) {
            UrlMappingData saveActionUrlMappingData = urlData.createRelative("(.(*))?");
            List<ConstrainedProperty> saveUrlMappingConstraints = this.createFormatOnlyConstraints(constraints);
            return new RegexUrlMapping(saveActionUrlMappingData, controllerName, DefaultUrlMappingEvaluator.ACTION_SAVE, namespace, pluginName, null, HttpMethod.POST.toString(), version, saveUrlMappingConstraints.toArray(new ConstrainedProperty[saveUrlMappingConstraints.size()]), DefaultUrlMappingEvaluator.this.servletContext);
        }

        protected UrlMapping createCreateActionResourcesRestfulMapping(String controllerName, Object pluginName, Object namespace, String version, UrlMappingData urlData, ConstrainedProperty[] constraintArray) {
            UrlMappingData createMappingData = urlData.createRelative("/create");
            return new RegexUrlMapping(createMappingData, controllerName, DefaultUrlMappingEvaluator.ACTION_CREATE, namespace, pluginName, null, HttpMethod.GET.toString(), version, constraintArray, DefaultUrlMappingEvaluator.this.servletContext);
        }

        protected UrlMapping createIndexActionResourcesRestfulMapping(String controllerName, Object pluginName, Object namespace, String version, UrlMappingData urlData, List<ConstrainedProperty> constraints) {
            UrlMappingData indexActionUrlMappingData = urlData.createRelative("(.(*))?");
            List<ConstrainedProperty> indexUrlMappingConstraints = this.createFormatOnlyConstraints(constraints);
            return new RegexUrlMapping(indexActionUrlMappingData, controllerName, DefaultUrlMappingEvaluator.ACTION_INDEX, namespace, pluginName, null, HttpMethod.GET.toString(), version, indexUrlMappingConstraints.toArray(new ConstrainedProperty[indexUrlMappingConstraints.size()]), DefaultUrlMappingEvaluator.this.servletContext);
        }

        private List<ConstrainedProperty> createFormatOnlyConstraints(List<ConstrainedProperty> constraints) {
            ArrayList<ConstrainedProperty> indexUrlMappingConstraints = new ArrayList<ConstrainedProperty>(constraints);
            ConstrainedProperty cp = new ConstrainedProperty(UrlMapping.class, "format", String.class);
            cp.setNullable(true);
            indexUrlMappingConstraints.add(cp);
            return indexUrlMappingConstraints;
        }

        protected void createSingleResourceRestfulMappings(String controllerName, Object pluginName, Object namespace, String version, UrlMappingData urlData, List<ConstrainedProperty> previousConstraints, List<String> includes) {
            ConstrainedProperty[] constraintArray = previousConstraints.toArray(new ConstrainedProperty[previousConstraints.size()]);
            if (includes.contains(DefaultUrlMappingEvaluator.ACTION_CREATE)) {
                UrlMapping createUrlMapping = this.createCreateActionResourcesRestfulMapping(controllerName, pluginName, namespace, version, urlData, constraintArray);
                this.configureUrlMapping(createUrlMapping);
            }
            if (includes.contains(DefaultUrlMappingEvaluator.ACTION_SAVE)) {
                UrlMapping saveUrlMapping = this.createSaveActionResourcesRestfulMapping(controllerName, pluginName, namespace, version, urlData, previousConstraints);
                this.configureUrlMapping(saveUrlMapping);
            }
            if (includes.contains(DefaultUrlMappingEvaluator.ACTION_SHOW)) {
                UrlMapping showUrlMapping = this.createShowActionResourceRestfulMapping(controllerName, pluginName, namespace, version, urlData, previousConstraints);
                this.configureUrlMapping(showUrlMapping);
            }
            if (includes.contains(DefaultUrlMappingEvaluator.ACTION_EDIT)) {
                UrlMapping editUrlMapping = this.createEditctionResourceRestfulMapping(controllerName, pluginName, namespace, version, urlData, constraintArray);
                this.configureUrlMapping(editUrlMapping);
            }
            if (includes.contains(DefaultUrlMappingEvaluator.ACTION_UPDATE)) {
                UrlMapping updateUrlMapping = this.createUpdateActionResourceRestfulMapping(controllerName, pluginName, namespace, version, urlData, previousConstraints);
                this.configureUrlMapping(updateUrlMapping);
            }
            if (includes.contains(DefaultUrlMappingEvaluator.ACTION_DELETE)) {
                UrlMapping deleteUrlMapping = this.createDeleteActionResourceRestfulMapping(controllerName, pluginName, namespace, version, urlData, previousConstraints);
                this.configureUrlMapping(deleteUrlMapping);
            }
        }

        protected UrlMapping createDeleteActionResourceRestfulMapping(String controllerName, Object pluginName, Object namespace, String version, UrlMappingData urlData, List<ConstrainedProperty> previousConstraints) {
            UrlMappingData deleteUrlMappingData = this.createFormatOnlyUrlMappingData(urlData);
            List<ConstrainedProperty> deleteUrlMappingConstraints = this.createFormatOnlyConstraints(previousConstraints);
            return new RegexUrlMapping(deleteUrlMappingData, controllerName, DefaultUrlMappingEvaluator.ACTION_DELETE, null, pluginName, null, HttpMethod.DELETE.toString(), version, deleteUrlMappingConstraints.toArray(new ConstrainedProperty[deleteUrlMappingConstraints.size()]), DefaultUrlMappingEvaluator.this.servletContext);
        }

        protected UrlMapping createUpdateActionResourceRestfulMapping(String controllerName, Object pluginName, Object namespace, String version, UrlMappingData urlData, List<ConstrainedProperty> previousConstraints) {
            UrlMappingData updateUrlMappingData = this.createFormatOnlyUrlMappingData(urlData);
            List<ConstrainedProperty> updateUrlMappingConstraints = this.createFormatOnlyConstraints(previousConstraints);
            return new RegexUrlMapping(updateUrlMappingData, controllerName, DefaultUrlMappingEvaluator.ACTION_UPDATE, null, pluginName, null, HttpMethod.PUT.toString(), version, updateUrlMappingConstraints.toArray(new ConstrainedProperty[updateUrlMappingConstraints.size()]), DefaultUrlMappingEvaluator.this.servletContext);
        }

        protected UrlMapping createEditctionResourceRestfulMapping(String controllerName, Object pluginName, Object namespace, String version, UrlMappingData urlData, ConstrainedProperty[] constraintArray) {
            UrlMappingData editMappingData = urlData.createRelative("/edit");
            return new RegexUrlMapping(editMappingData, controllerName, DefaultUrlMappingEvaluator.ACTION_EDIT, null, pluginName, null, HttpMethod.GET.toString(), version, constraintArray, DefaultUrlMappingEvaluator.this.servletContext);
        }

        protected UrlMapping createShowActionResourceRestfulMapping(String controllerName, Object pluginName, Object namespace, String version, UrlMappingData urlData, List<ConstrainedProperty> previousConstraints) {
            UrlMappingData showUrlMappingData = this.createFormatOnlyUrlMappingData(urlData);
            List<ConstrainedProperty> showUrlMappingConstraints = this.createFormatOnlyConstraints(previousConstraints);
            return new RegexUrlMapping(showUrlMappingData, controllerName, DefaultUrlMappingEvaluator.ACTION_SHOW, null, pluginName, null, HttpMethod.GET.toString(), version, showUrlMappingConstraints.toArray(new ConstrainedProperty[showUrlMappingConstraints.size()]), DefaultUrlMappingEvaluator.this.servletContext);
        }

        private void configureUrlMapping(UrlMapping urlMapping) {
            if (this.binding != null) {
                Map vars = this.binding.getVariables();
                for (String key : vars.keySet()) {
                    if (!this.isNotCoreMappingKey(key)) continue;
                    this.parameterValues.put(key, vars.get(key));
                }
                this.binding.getVariables().clear();
            }
            if (urlMapping.getControllerName() != null) {
                this.parameterValues.put("controller", urlMapping.getControllerName());
            }
            if (urlMapping.getActionName() != null) {
                this.parameterValues.put("action", urlMapping.getActionName());
            }
            urlMapping.setParameterValues(this.parameterValues);
            this.urlMappings.add(urlMapping);
        }

        private boolean isNotCoreMappingKey(Object key) {
            return !"action".equals(key) && !"controller".equals(key) && !"view".equals(key);
        }

        private UrlMappingData createUrlMappingData(String methodName, boolean responseCode) {
            if (!responseCode) {
                return DefaultUrlMappingEvaluator.this.urlParser.parse(methodName);
            }
            return new ResponseCodeMappingData(methodName);
        }

        private boolean isResponseCode(String s) {
            int count = s.length();
            for (int i = 0; i < count; ++i) {
                if (Character.isDigit(s.charAt(i))) continue;
                return false;
            }
            return true;
        }

        private UrlMapping getURLMappingForNamedArgs(Map namedArguments, UrlMappingData urlData, String mapping, boolean isResponseCode) {
            Object parseRequest;
            RegexUrlMapping urlMapping;
            Map bindingVariables = this.binding != null ? this.binding.getVariables() : null;
            Object controllerName = this.getControllerName(namedArguments, bindingVariables);
            Object actionName = this.getActionName(namedArguments, bindingVariables);
            Object pluginName = this.getPluginName(namedArguments, bindingVariables);
            Object httpMethod = this.getHttpMethod(namedArguments, bindingVariables);
            Object version = this.getVersion(namedArguments, bindingVariables);
            Object namespace = this.getNamespace(namedArguments, bindingVariables);
            Object redirectInfo = this.getRedirectInfo(namedArguments, bindingVariables);
            Object viewName = this.getViewName(namedArguments, bindingVariables);
            if (actionName != null && viewName != null) {
                viewName = null;
                LOG.warn((Object)("Both [action] and [view] specified in URL mapping [" + mapping + "]. The action takes precendence!"));
            }
            Object uri = this.getURI(namedArguments, bindingVariables);
            ConstrainedProperty[] constraints = this.getCurrentConstraints().toArray(new ConstrainedProperty[this.getCurrentConstraints().size()]);
            if (uri != null) {
                try {
                    urlMapping = new RegexUrlMapping(urlData, new URI(uri.toString()), constraints, this.sc);
                }
                catch (URISyntaxException e) {
                    throw new UrlMappingException("Cannot map to invalid URI: " + e.getMessage(), (Throwable)e);
                }
            } else {
                urlMapping = this.createURLMapping(urlData, isResponseCode, redirectInfo, controllerName, actionName, namespace, pluginName, viewName, httpMethod != null ? httpMethod.toString() : null, version != null ? version.toString() : null, constraints);
            }
            Object exceptionArg = this.getException(namedArguments, bindingVariables);
            if (isResponseCode && exceptionArg != null) {
                if (exceptionArg instanceof Class) {
                    Class exClass = (Class)exceptionArg;
                    if (Throwable.class.isAssignableFrom(exClass)) {
                        ((ResponseCodeUrlMapping)((Object)urlMapping)).setExceptionType(exClass);
                    } else {
                        LOG.error((Object)("URL mapping argument [exception] with value [" + exceptionArg + "] must be a subclass of java.lang.Throwable"));
                    }
                } else {
                    LOG.error((Object)("URL mapping argument [exception] with value [" + exceptionArg + "] must be a valid class"));
                }
            }
            if ((parseRequest = this.getParseRequest(namedArguments, bindingVariables)) instanceof Boolean) {
                urlMapping.setParseRequest((Boolean)parseRequest);
            }
            return urlMapping;
        }

        private Object getVariableFromNamedArgsOrBinding(Map namedArguments, Map bindingVariables, String variableName, Object defaultValue) {
            Object returnValue = namedArguments.get(variableName);
            if (returnValue == null) {
                returnValue = this.binding != null ? bindingVariables.get(variableName) : defaultValue;
            }
            return returnValue;
        }

        private Object getActionName(Map namedArguments, Map bindingVariables) {
            return this.getVariableFromNamedArgsOrBinding(namedArguments, bindingVariables, "action", this.actionName);
        }

        private Object getParseRequest(Map namedArguments, Map bindingVariables) {
            return this.getVariableFromNamedArgsOrBinding(namedArguments, bindingVariables, DefaultUrlMappingEvaluator.PARSE_REQUEST, this.parseRequest);
        }

        private Object getControllerName(Map namedArguments, Map bindingVariables) {
            return this.getVariableFromNamedArgsOrBinding(namedArguments, bindingVariables, "controller", this.controllerName);
        }

        private Object getPluginName(Map namedArguments, Map bindingVariables) {
            return this.getVariableFromNamedArgsOrBinding(namedArguments, bindingVariables, "plugin", this.pluginName);
        }

        private Object getHttpMethod(Map namedArguments, Map bindingVariables) {
            return this.getVariableFromNamedArgsOrBinding(namedArguments, bindingVariables, "method", this.pluginName);
        }

        private Object getRedirectInfo(Map namedArguments, Map bindingVariables) {
            return this.getVariableFromNamedArgsOrBinding(namedArguments, bindingVariables, "redirect", this.redirectInfo);
        }

        private Object getVersion(Map namedArguments, Map bindingVariables) {
            return this.getVariableFromNamedArgsOrBinding(namedArguments, bindingVariables, "version", this.pluginName);
        }

        private Object getNamespace(Map namedArguments, Map bindingVariables) {
            return this.getVariableFromNamedArgsOrBinding(namedArguments, bindingVariables, "namespace", this.namespace);
        }

        private Object getViewName(Map namedArguments, Map bindingVariables) {
            return this.getVariableFromNamedArgsOrBinding(namedArguments, bindingVariables, "view", this.viewName);
        }

        private Object getURI(Map namedArguments, Map bindingVariables) {
            return this.getVariableFromNamedArgsOrBinding(namedArguments, bindingVariables, "uri", this.uri);
        }

        private Object getException(Map namedArguments, Map bindingVariables) {
            return this.getVariableFromNamedArgsOrBinding(namedArguments, bindingVariables, DefaultUrlMappingEvaluator.EXCEPTION, this.exception);
        }

        private UrlMapping createURLMapping(UrlMappingData urlData, boolean isResponseCode, Object redirectInfo, Object controllerName, Object actionName, Object namespace, Object pluginName, Object viewName, String httpMethod, String version, ConstrainedProperty[] constraints) {
            if (!isResponseCode) {
                return new RegexUrlMapping(redirectInfo, urlData, controllerName, actionName, namespace, pluginName, viewName, httpMethod, version, constraints, this.sc);
            }
            return new ResponseCodeUrlMapping(urlData, controllerName, actionName, namespace, pluginName, viewName, null, this.sc);
        }

        public List<ConstrainedProperty> getCurrentConstraints() {
            ParentResource parentResource = this.parentResources.peek();
            return parentResource == null ? this.previousConstraints : parentResource.constraints;
        }

        class ParentResource {
            String controllerName;
            String uri;
            List<ConstrainedProperty> constraints;
            boolean isSingle;

            ParentResource(String controllerName, String uri, List<ConstrainedProperty> constraints, boolean single) {
                this.controllerName = controllerName;
                this.uri = uri;
                this.constraints = new ArrayList<ConstrainedProperty>(constraints);
                this.isSingle = single;
            }
        }
    }

    class MappingCapturingClosure
    extends Closure {
        private static final long serialVersionUID = 2108155626252742722L;
        private Closure<?> mappings;

        public Closure<?> getMappings() {
            return this.mappings;
        }

        public MappingCapturingClosure(Object o) {
            super(o);
        }

        public Object call(Object ... args) {
            if (args.length > 0 && args[0] instanceof Closure) {
                this.mappings = (Closure)args[0];
            }
            return null;
        }
    }
}

