/*
 * Decompiled with CFR 0.152.
 */
package grails.test.mixin.support;

import grails.test.mixin.TestRuntimeAwareMixin;
import grails.test.runtime.TestRuntime;
import grails.test.runtime.TestRuntimeFactory;
import groovy.lang.ExpandoMetaClass;
import groovy.lang.GroovyObjectSupport;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public abstract class TestMixinRuntimeSupport
extends GroovyObjectSupport
implements TestRuntimeAwareMixin {
    private TestRuntime currentRuntime;
    private Set<String> features;
    private Class<?> testClass;

    public TestMixinRuntimeSupport(Set<String> features) {
        this.features = Collections.unmodifiableSet(new LinkedHashSet<String>(features));
    }

    @Override
    public Set<String> getFeatures() {
        return this.features;
    }

    public TestRuntime getRuntime() {
        if (this.currentRuntime == null && this.testClass != null) {
            TestRuntimeFactory.getRuntimeForTestClass(this.testClass);
        }
        if (this.currentRuntime == null) {
            throw new IllegalStateException("Current TestRuntime instance is null.");
        }
        if (this.currentRuntime.isClosed()) {
            throw new IllegalStateException("Current TestRuntime instance is closed.");
        }
        return this.currentRuntime;
    }

    @Override
    public void setRuntime(TestRuntime runtime) {
        this.currentRuntime = runtime;
    }

    @Override
    public void setTestClass(Class<?> testClass) {
        this.testClass = testClass;
    }

    static {
        ExpandoMetaClass.enableGlobally();
    }
}

