/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.compiler.web.taglib;

import groovy.lang.Closure;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.grails.compiler.injection.AbstractGrailsArtefactTransformer;
import org.codehaus.groovy.grails.compiler.injection.AstTransformer;
import org.codehaus.groovy.grails.plugins.web.api.TagLibraryApi;
import org.codehaus.groovy.grails.web.pages.GroovyPage;
import org.springframework.web.context.request.RequestContextHolder;

@AstTransformer
public class TagLibraryTransformer
extends AbstractGrailsArtefactTransformer {
    public static Pattern TAGLIB_PATTERN = Pattern.compile(".+/grails-app/taglib/(.+)TagLib\\.groovy");
    private static final String ATTRS_ARGUMENT = "attrs";
    private static final String BODY_ARGUMENT = "body";
    private static final Parameter[] MAP_CLOSURE_PARAMETERS = new Parameter[]{new Parameter(new ClassNode(Map.class), "attrs"), new Parameter(new ClassNode(Closure.class), "body")};
    private static final Parameter[] CLOSURE_PARAMETERS = new Parameter[]{new Parameter(new ClassNode(Closure.class), "body")};
    private static final Parameter[] MAP_PARAMETERS = new Parameter[]{new Parameter(new ClassNode(Map.class), "attrs")};
    private static final Parameter[] MAP_CHARSEQUENCE_PARAMETERS = new Parameter[]{new Parameter(new ClassNode(Map.class), "attrs"), new Parameter(new ClassNode(CharSequence.class), "body")};
    private static final ClassNode GROOVY_PAGE_CLASS_NODE = new ClassNode(GroovyPage.class);
    private static final VariableExpression ATTRS_EXPRESSION = new VariableExpression("attrs");
    private static final VariableExpression BODY_EXPRESSION = new VariableExpression("body");
    private static final MethodCallExpression CURRENT_REQUEST_ATTRIBUTES_METHOD_CALL = new MethodCallExpression((Expression)new ClassExpression(new ClassNode(RequestContextHolder.class)), "currentRequestAttributes", (Expression)ZERO_ARGS);
    private static final Expression NULL_EXPRESSION = new ConstantExpression(null);
    private static final String NAMESPACE_PROPERTY = "namespace";
    private static final ClassNode CLOSURE_CLASS_NODE = new ClassNode(Closure.class);

    public Class<?> getInstanceImplementation() {
        return TagLibraryApi.class;
    }

    public Class<?> getStaticImplementation() {
        return null;
    }

    public String[] getArtefactTypes() {
        return new String[]{this.getArtefactType(), "TagLibrary"};
    }

    protected String getArtefactType() {
        return "TagLib";
    }

    protected void performInjectionInternal(String apiInstanceProperty, SourceUnit source, ClassNode classNode) {
        Expression initialExpression;
        List<PropertyNode> tags = this.findTags(classNode);
        PropertyNode namespaceProperty = classNode.getProperty(NAMESPACE_PROPERTY);
        String namespace = "g";
        if (namespaceProperty != null && namespaceProperty.isStatic() && (initialExpression = namespaceProperty.getInitialExpression()) instanceof ConstantExpression) {
            namespace = initialExpression.getText();
        }
        MethodCallExpression tagLibraryLookupMethodCall = new MethodCallExpression((Expression)new VariableExpression(apiInstanceProperty), "getTagLibraryLookup", (Expression)ZERO_ARGS);
        for (PropertyNode tag : tags) {
            String tagName = tag.getName();
            this.addAttributesAndBodyMethod(classNode, tagLibraryLookupMethodCall, namespace, tagName);
            this.addAttributesAndStringBodyMethod(classNode, tagName);
            this.addAttributesAndBodyMethod(classNode, tagLibraryLookupMethodCall, namespace, tagName, false);
            this.addAttributesAndBodyMethod(classNode, tagLibraryLookupMethodCall, namespace, tagName, true, false);
            this.addAttributesAndBodyMethod(classNode, tagLibraryLookupMethodCall, namespace, tagName, false, false);
        }
    }

    private void addAttributesAndStringBodyMethod(ClassNode classNode, String tagName) {
        BlockStatement methodBody = new BlockStatement();
        ArgumentListExpression arguments = new ArgumentListExpression();
        ArgumentListExpression constructorArgs = new ArgumentListExpression();
        constructorArgs.addExpression((Expression)BODY_EXPRESSION);
        arguments.addExpression((Expression)ATTRS_EXPRESSION).addExpression((Expression)new ConstructorCallExpression(new ClassNode(GroovyPage.ConstantClosure.class), (Expression)constructorArgs));
        methodBody.addStatement((Statement)new ExpressionStatement((Expression)new MethodCallExpression((Expression)new VariableExpression("this"), tagName, (Expression)arguments)));
        classNode.addMethod(new MethodNode(tagName, 1, OBJECT_CLASS, MAP_CHARSEQUENCE_PARAMETERS, null, (Statement)methodBody));
    }

    private void addAttributesAndBodyMethod(ClassNode classNode, MethodCallExpression tagLibraryLookupMethodCall, String namespace, String tagName) {
        this.addAttributesAndBodyMethod(classNode, tagLibraryLookupMethodCall, namespace, tagName, true);
    }

    private void addAttributesAndBodyMethod(ClassNode classNode, MethodCallExpression tagLibraryLookupMethodCall, String namespace, String tagName, boolean includeBody) {
        this.addAttributesAndBodyMethod(classNode, tagLibraryLookupMethodCall, namespace, tagName, includeBody, true);
    }

    private void addAttributesAndBodyMethod(ClassNode classNode, MethodCallExpression tagLibraryLookupMethodCall, String namespace, String tagName, boolean includeBody, boolean includeAttrs) {
        BlockStatement methodBody = new BlockStatement();
        ArgumentListExpression arguments = new ArgumentListExpression();
        arguments.addExpression((Expression)tagLibraryLookupMethodCall).addExpression((Expression)new ConstantExpression((Object)namespace)).addExpression((Expression)new ConstantExpression((Object)tagName)).addExpression((Expression)(includeAttrs ? ATTRS_EXPRESSION : new MapExpression())).addExpression((Expression)(includeBody ? BODY_EXPRESSION : NULL_EXPRESSION)).addExpression((Expression)CURRENT_REQUEST_ATTRIBUTES_METHOD_CALL);
        methodBody.addStatement((Statement)new ExpressionStatement((Expression)new MethodCallExpression((Expression)new ClassExpression(GROOVY_PAGE_CLASS_NODE), "captureTagOutput", (Expression)arguments)));
        if (includeBody && includeAttrs) {
            if (!this.methodExists(classNode, tagName, MAP_CLOSURE_PARAMETERS)) {
                classNode.addMethod(new MethodNode(tagName, 1, OBJECT_CLASS, MAP_CLOSURE_PARAMETERS, null, (Statement)methodBody));
            }
        } else if (includeAttrs && !includeBody) {
            if (!this.methodExists(classNode, tagName, MAP_PARAMETERS)) {
                classNode.addMethod(new MethodNode(tagName, 1, OBJECT_CLASS, MAP_PARAMETERS, null, (Statement)methodBody));
            }
        } else if (includeBody) {
            if (!this.methodExists(classNode, tagName, CLOSURE_PARAMETERS)) {
                classNode.addMethod(new MethodNode(tagName, 1, OBJECT_CLASS, CLOSURE_PARAMETERS, null, (Statement)methodBody));
            }
        } else if (!this.methodExists(classNode, tagName, Parameter.EMPTY_ARRAY)) {
            classNode.addMethod(new MethodNode(tagName, 1, OBJECT_CLASS, Parameter.EMPTY_ARRAY, null, (Statement)methodBody));
        }
    }

    private boolean methodExists(ClassNode classNode, String methodName, Parameter[] parameters) {
        return classNode.getMethod(methodName, parameters) != null;
    }

    private List<PropertyNode> findTags(ClassNode classNode) {
        ArrayList<PropertyNode> tags = new ArrayList<PropertyNode>();
        List properties = classNode.getProperties();
        ArrayList<PropertyNode> potentialAliases = new ArrayList<PropertyNode>();
        for (PropertyNode property : properties) {
            if (!property.isPublic()) continue;
            Expression initialExpression = property.getInitialExpression();
            if (initialExpression instanceof ClosureExpression) {
                ClosureExpression ce = (ClosureExpression)initialExpression;
                Parameter[] parameters = ce.getParameters();
                if (parameters.length > 2) continue;
                tags.add(property);
                property.setType(CLOSURE_CLASS_NODE);
                continue;
            }
            if (!(initialExpression instanceof VariableExpression)) continue;
            potentialAliases.add(property);
        }
        for (PropertyNode potentialAlias : potentialAliases) {
            VariableExpression pe = (VariableExpression)potentialAlias.getInitialExpression();
            String propertyName = pe.getName();
            PropertyNode property = classNode.getProperty(propertyName);
            if (property == null || !tags.contains(property)) continue;
            potentialAlias.setType(CLOSURE_CLASS_NODE);
            tags.add(potentialAlias);
        }
        return tags;
    }

    public boolean shouldInject(URL url) {
        return url != null && TAGLIB_PATTERN.matcher(url.getFile()).find();
    }
}

