/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.converters.marshaller.xml;

import grails.converters.XML;
import java.lang.reflect.Array;
import org.codehaus.groovy.grails.web.converters.exceptions.ConverterException;
import org.codehaus.groovy.grails.web.converters.marshaller.NameAwareMarshaller;
import org.codehaus.groovy.grails.web.converters.marshaller.ObjectMarshaller;

public class ArrayMarshaller
implements ObjectMarshaller<XML>,
NameAwareMarshaller {
    @Override
    public boolean supports(Object object) {
        return object != null && object.getClass().isArray();
    }

    @Override
    public void marshalObject(Object o, XML xml) throws ConverterException {
        int len = Array.getLength(o);
        for (int i = 0; i < len; ++i) {
            Object cur = Array.get(o, i);
            if (cur != null) {
                xml.startNode(xml.getElementName(cur));
                xml.convertAnother(cur);
                xml.end();
                continue;
            }
            xml.startNode("null");
            xml.end();
        }
    }

    @Override
    public String getElementName(Object o) {
        return "array";
    }
}

