/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.plugins.codecs;

import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.grails.plugins.codecs.AbstractCharReplacementEncoder;
import org.codehaus.groovy.grails.plugins.codecs.JavaScriptEncoder;
import org.codehaus.groovy.grails.support.encoding.CodecIdentifier;
import org.codehaus.groovy.grails.support.encoding.DefaultCodecIdentifier;

public class JSONEncoder
extends AbstractCharReplacementEncoder {
    public static final CodecIdentifier JSON_CODEC_IDENTIFIER = new DefaultCodecIdentifier("JSON", new String[]{"Json"}){

        public boolean isEquivalent(CodecIdentifier other) {
            return super.isEquivalent(other) || JavaScriptEncoder.JAVASCRIPT_CODEC_IDENTIFIER.getCodecName().equals(other.getCodecName());
        }
    };

    public JSONEncoder() {
        super(JSON_CODEC_IDENTIFIER);
    }

    @Override
    protected String escapeCharacter(char ch, char previousChar) {
        switch (ch) {
            case '\"': {
                return "\\\"";
            }
            case '\\': {
                return "\\\\";
            }
            case '\t': {
                return "\\t";
            }
            case '\n': {
                return "\\n";
            }
            case '\r': {
                return "\\r";
            }
            case '\f': {
                return "\\f";
            }
            case '\b': {
                return "\\b";
            }
            case '\u000b': {
                return "\\v";
            }
            case '\u2028': {
                return "\\u2028";
            }
            case '\u2029': {
                return "\\u2029";
            }
            case '/': {
                if (previousChar != '<') break;
                return "\\u002f";
            }
        }
        if (ch < ' ') {
            return "\\u" + StringUtils.leftPad((String)Integer.toHexString(ch), (int)4, (char)'0');
        }
        return null;
    }

    @Override
    public boolean isApplyToSafelyEncoded() {
        return true;
    }
}

